C
C
      SUBROUTINE PSSYMB$(ICOLOR, ITYPE, N,
     +                   X, Y)
C
C ACTION : Output PostScript symbols
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/94
C          28/11/2002 added %#2 escape sequences
C          09/07/2006 introduced allocatable arrays     
C          23/04/2007 added INTENTS  
C          15/06/2007 removed defngks.ins and added GETGKS_INT 
C          16/08/2008 added symbols 30 to 33 
C          18/06/2011 added upside-down triangles 
C
C          1=dot, 2=plus, 3=cross, 4=asterisk,
C          5=circle, 6=half, 7=full,
C          8=triangle, 9=half, 10=full,
C          11=square, 12=half, 13=full,
C          14=diamond, 15=half, 16=full
C          17=minus, 
C          18=male, 19=female (18/19 are composites),
C          .......
C          30=circle(outline), 31=triangle(outline),
C          32=square (outline), 33=diamond (outline), 
C          34=u_triangle,35=u_triangle(half filled), 36=u_triangle(filled), 37=u_triangle(outline) 
C         
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: ICOLOR, ITYPE, N 
      DOUBLE PRECISION, INTENT (IN) :: X(N), Y(N)
C
C Local allocatable arrays
C  
      INTEGER, ALLOCATABLE :: IX(:), IY(:)
C
C Locals
C                       
      INTEGER    N5
      PARAMETER (N5 = 5)
      INTEGER    ISEND, N72
      PARAMETER (ISEND = 4, N72 = 72)
      INTEGER    LEN200, NOUT_PS
      INTEGER    IDELTA, IERR
      DOUBLE PRECISION B(N72), G(N72), R(N72)
      CHARACTER  LINE*40
      EXTERNAL   GKSA2I$, PSTRIP$, PSCOLR$, LEN200 
      EXTERNAL   GETGKS_INT
C
C Check if the symbol is in the overall range
C
      IF (ITYPE.LT.1 .OR. ITYPE.GT.37) RETURN
C
C Male and female symbols are done separately
C        
      IF (ITYPE.EQ.18 .OR. ITYPE.EQ.19) RETURN 
C
C Bars are not drawn by this routine
C        
      IF (ITYPE.GE.20 .AND. ITYPE.LE.29) RETURN   
C
C Transform the coordinates
C                            
      IERR = 0
      IF (ALLOCATED(IX)) DEALLOCATE(IX, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(IY)) DEALLOCATE(IY, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(IX(N), STAT = IERR)
      IF (IERR.NE.0) RETURN     
      ALLOCATE(IY(N), STAT = IERR)
      IF (IERR.NE.0) RETURN
      CALL GKSA2I$(IX, IY, N, X, Y)
      IDELTA = IX(2) - IX(1)
C
C Check if the symbol is big enough
C
      IF (IDELTA.EQ.0) RETURN
C
C Set the colour scheme then write to the file
C                          
      CALL GETGKS_INT (N5, NOUT_PS)
      CALL PSCOLR$(ISEND, ICOLOR, NOUT_PS,
     +             B, G, R)
      IF (ITYPE.EQ.1) THEN
         WRITE (LINE,100) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.2) THEN
         WRITE (LINE,200) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.3) THEN
         WRITE (LINE,300) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.4) THEN
         WRITE (LINE,400) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.5) THEN
         WRITE (LINE,500) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.6) THEN
         WRITE (LINE,600) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.7) THEN
         WRITE (LINE,700) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.8) THEN
         WRITE (LINE,800) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.9) THEN
         WRITE (LINE,900) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.10) THEN
         WRITE (LINE,1000) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.11) THEN
         WRITE (LINE,1100) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.12) THEN
         WRITE (LINE,1200) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.13) THEN
         WRITE (LINE,1300) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.14) THEN
         WRITE (LINE,1400) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.15) THEN
         WRITE (LINE,1500) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.16) THEN
         WRITE (LINE,1600) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.17) THEN
         WRITE (LINE,1700) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.30) THEN
         WRITE (LINE,1800) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.31) THEN
         WRITE (LINE,1900) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.32) THEN
         WRITE (LINE,2000) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.33) THEN
         WRITE (LINE,2100) IX(1), IY(1), IDELTA  
      ELSEIF (ITYPE.EQ.34) THEN
         WRITE (LINE,2200) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.35) THEN
         WRITE (LINE,2300) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.36) THEN
         WRITE (LINE,2400) IX(1), IY(1), IDELTA
      ELSEIF (ITYPE.EQ.37) THEN
         WRITE (LINE,2500) IX(1), IY(1), IDELTA     
      ENDIF
      CALL PSTRIP$(LINE)
      WRITE (NOUT_PS,'(A)') LINE(1:LEN200(LINE))
      DEALLOCATE(IX, STAT = IERR)
      DEALLOCATE(IY, STAT = IERR)
C
C These format statements must NOT be translated
C      
  100 FORMAT (3I6,1X,'cf%#2')
  200 FORMAT (3I6,1X,'ad%#2')
  300 FORMAT (3I6,1X,'cr%#2')
  400 FORMAT (3I6,1X,'as%#2')
  500 FORMAT (3I6,1X,'ce%#2')
  600 FORMAT (3I6,1X,'ch%#2')
  700 FORMAT (3I6,1X,'cf%#2')
  800 FORMAT (3I6,1X,'te%#2')
  900 FORMAT (3I6,1X,'th%#2')
 1000 FORMAT (3I6,1X,'tf%#2')
 1100 FORMAT (3I6,1X,'se%#2')
 1200 FORMAT (3I6,1X,'sh%#2')
 1300 FORMAT (3I6,1X,'sf%#2')
 1400 FORMAT (3I6,1X,'de%#2')
 1500 FORMAT (3I6,1X,'dh%#2')
 1600 FORMAT (3I6,1X,'df%#2')
 1700 FORMAT (3I6,1X,'mi%#2')
 1800 FORMAT (3I6,1X,'co%#2')
 1900 FORMAT (3I6,1X,'to%#2')
 2000 FORMAT (3I6,1X,'so%#2')
 2100 FORMAT (3I6,1X,'dn%#2')
 2200 FORMAT (3I6,1X,'ue%#2')
 2300 FORMAT (3I6,1X,'uh%#2')
 2400 FORMAT (3I6,1X,'uf%#2')
 2500 FORMAT (3I6,1X,'uo%#2')
      END
C 
C