C
C
      SUBROUTINE PSTEXT$(ICOLOR,
     +                   X, Y, 
     +                   STRNG, TYPE1)
C
C ACTION : Output PostScript text
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/94
C ADVICE : String is trimmed unless TYPE is left, centre or right
C          07/08/1995 modified to correct effect with sp, sb etc.
C          11/09/1995 altered to handle escape sequences
C          20/12/1995 call to STRCHK$ and padding to the right with ?
C          09/09/1996 New option if TYPE is 'free'
C          28/11/2002 added %#()2
C          17/11/2003 modified to substitute isolatin1 if character > 127
C          23/04/2007 added INTENTS 
C          15/06/2007 removed defngks.ins and added GETGKS_INT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: ICOLOR 
      DOUBLE PRECISION,    INTENT (IN) :: X, Y 
      CHARACTER (LEN = *), INTENT (IN) :: STRNG, TYPE1 
C
C Locals
C      
      INTEGER    ISEND, N0, N1, N3, N5, N72
      PARAMETER (ISEND = 4, N0 = 0, N1 = 1, N3 = 3, N5 = 5, N72 = 72)
      INTEGER    I, K, L, LEN200, NOUT_PS, NSUB
      INTEGER    IX, IY
      DOUBLE PRECISION B(N72), G(N72), R(N72)
      CHARACTER  LETTER*1, LINE*100, L12*12, L100*100, SYMBOL*1
      CHARACTER  BLANK*1, QUEST*1
      PARAMETER (BLANK = ' ', QUEST = '?')
      CHARACTER  WORD5*5
      PARAMETER (WORD5 = '%#()2')
      EXTERNAL   TRIML1
      EXTERNAL   GKSR2I$, PSTRIP$, PSCOLR$, LEN200, STRCHK$ 
      EXTERNAL   GETGKS_INT
      INTRINSIC  ICHAR
C
C Check if string is blank
C
      IF (STRNG.EQ.BLANK) RETURN
C
C Set the colour scheme
C                          
      CALL GETGKS_INT (N5, NOUT_PS)
      CALL PSCOLR$(ISEND, ICOLOR, NOUT_PS, 
     +             B, G, R)
C
C Copy string then trim to remove leading blanks
C
      LINE = STRNG
      CALL STRCHK$(LINE)
      IF (TYPE1.EQ.'left' .OR. TYPE1.EQ.'centre' .OR. TYPE1.EQ.'right'
     +     .OR. TYPE1.EQ.'free') THEN
         I = 1!to silence ftn95
      ELSE
        CALL TRIML1 (LINE)
      ENDIF
C
C Define SYMBOL then construct L100
C
      IF (TYPE1.EQ.'sb') THEN
         SYMBOL = '1'
      ELSEIF (TYPE1.EQ.'sp') THEN
         SYMBOL = '2'
      ELSEIF (TYPE1.EQ.'gr') THEN
         SYMBOL = '3'
      ELSEIF (TYPE1.EQ.'grsb') THEN
         SYMBOL = '4'
      ELSEIF (TYPE1.EQ.'grsp') THEN
         SYMBOL = '5'
      ELSEIF (TYPE1.EQ.'gb') THEN
         SYMBOL = '6'
      ELSE
         SYMBOL = '0'
      ENDIF
      L = LEN200(LINE)
      DO I = N1, L
         LETTER = LINE(I:I)
         K = ICHAR(LETTER)
         IF (K.LE.127) THEN
            L100(I:I) = SYMBOL
         ELSE
            L100(I:I) = '8'
         ENDIF
      ENDDO
C
C Find the number of escape sequences for characters
C
      NSUB = N0
      DO I = N1, L - N1
         IF (LINE(I:I).EQ.'\') THEN
            IF (LINE(I + N1:I + N1).EQ. '0' .OR.
     +          LINE(I + N1:I + N1).EQ. '1' .OR.
     +          LINE(I + N1:I + N1).EQ. '2' .OR.
     +          LINE(I + N1:I + N1).EQ. '3' .OR.
     +          LINE(I + N1:I + N1).EQ. '4' .OR.
     +          LINE(I + N1:I + N1).EQ. '5' .OR.
     +          LINE(I + N1:I + N1).EQ. '6' .OR.
     +          LINE(I + N1:I + N1).EQ. '7' .OR.
     +          LINE(I + N1:I + N1).EQ. '8' .OR.
     +          LINE(I + N1:I + N1).EQ. '9') THEN
               NSUB = NSUB + N3
            ELSEIF (LINE(I + N1:I + N1).NE.'\') THEN
               NSUB = NSUB + N1
            ENDIF
         ENDIF
      ENDDO
C
C Transform coordinates then output data
C
      IF (TYPE1.NE.'free') THEN
         CALL GKSR2I$(IX, IY,
     +                X, Y)
         WRITE (L12,100) IX, IY
         CALL PSTRIP$(L12)
      ENDIF
      IF (TYPE1.EQ.'sp' .OR. TYPE1.EQ.'sb' .OR. TYPE1.EQ. 'gr' .OR.
     +    TYPE1.EQ.'grsp' .OR. TYPE1.EQ.'grsb' .OR.
     +    TYPE1.EQ.'left') THEN
         WRITE (NOUT_PS,200) LINE(N1:L), L12(N1:LEN200(L12)), 'tl',
     +                       WORD5
      ELSEIF (TYPE1.EQ.'centre') THEN
         WRITE (NOUT_PS,200) LINE(N1:L), L12(N1:LEN200(L12)), 'tc',
     +                       WORD5
      ELSEIF (TYPE1.EQ.'right') THEN
         WRITE (NOUT_PS,200) LINE(N1:L), L12(N1:LEN200(L12)), 'tr',
     +                       WORD5
      ELSEIF (TYPE1.EQ.'free') THEN
         WRITE (NOUT_PS,300) LINE(N1:L)
      ELSE
         WRITE (NOUT_PS,200) LINE(N1:L), L12(N1:LEN200(L12)), TYPE1,
     +                       WORD5
      ENDIF
C
C Pad out the key with ?
C
      IF (NSUB.GT.N0) THEN
         DO I = L - NSUB + N1, L
            L100(I:I) = QUEST
         ENDDO
      ENDIF
      WRITE (NOUT_PS,400) L100(N1:L)
C
C These format statements must NOT be edited
C      
  100 FORMAT (2I6)
  200 FORMAT ('(',A,')',1X,A,1X,A,A)
  300 FORMAT ('(',A,')')
  400 FORMAT ('(',A,')',1X,'fx')
      END
C
C