C
C
      SUBROUTINE PSWORD$(ICOLOR,
     +                   X, Y,
     +                   STRNG, SYMBOL, TYPE1)
C
C ACTION : Output PostScript text
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 20/11/94
C ADVICE : String is trimed unless TYPE is left, centre or right
C          08/08/1995 modified from PSTEXT$
C          11/09/1995 modified to allow different string lengths for STRING
C                     and SYMBOL. User must adjust input strings, e.g. for \264, etc.
C          20/12/1995 call to STRCHK$ and padded to the right with ?
C          09/09/1996 New options if TYPE is 'free'
C          28/11/2002 added %#()2
C          23/04/2007 added INTENTS
C          15/06/2007 removed defngks.ins and added GETGKS_INT
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: ICOLOR
      DOUBLE PRECISION,    INTENT (IN) :: X, Y 
      CHARACTER (LEN = *), INTENT (IN) :: STRNG, SYMBOL, TYPE1
C
C Locals
C      
      INTEGER    ISEND, N0, N1, N3, N5, N72
      PARAMETER (ISEND = 4, N0 = 0, N1 = 1, N3 = 3, N5 = 5, N72 = 72)
      INTEGER    I, LEN200, L1, L2, NOUT_PS, NSUB
      INTEGER    IX, IY
      DOUBLE PRECISION B(N72), G(N72), R(N72)
      CHARACTER  BLANK*1, LINE1*100, LINE2*100, L12*12, QUEST*1
      PARAMETER (BLANK = ' ', QUEST = '?')
      CHARACTER  WORD5*5
      PARAMETER (WORD5 = '%#()2')
      EXTERNAL   TRIML1
      EXTERNAL   GKSR2I$, PSTRIP$, PSCOLR$, LEN200, STRCHK$
      EXTERNAL   GETGKS_INT
C
C Check if string is blank then define LINE1 and call STRCHK$
C
      IF (STRNG.EQ.BLANK) RETURN
      LINE1 = STRNG
      CALL STRCHK$(LINE1)
C
C Set the colour scheme
C                          
      CALL GETGKS_INT (N5, NOUT_PS)
      CALL PSCOLR$(ISEND, ICOLOR, NOUT_PS,
     +             B, G, R)
C
C Check the string lengths
C
      L1 = LEN200(LINE1)
      NSUB = N0
      DO I = N1, L1 - N1
         IF (LINE1(I:I).EQ.'\') THEN
            IF (LINE1(I + N1:I + N1).EQ.'0' .OR.
     +          LINE1(I + N1:I + N1).EQ.'1' .OR.
     +          LINE1(I + N1:I + N1).EQ.'2' .OR.
     +          LINE1(I + N1:I + N1).EQ.'3' .OR.
     +          LINE1(I + N1:I + N1).EQ.'4' .OR.
     +          LINE1(I + N1:I + N1).EQ.'5' .OR.
     +          LINE1(I + N1:I + N1).EQ.'6' .OR.
     +          LINE1(I + N1:I + N1).EQ.'7' .OR.
     +          LINE1(I + N1:I + N1).EQ.'8' .OR.
     +          LINE1(I + N1:I + N1).EQ.'9')  THEN
               NSUB = NSUB + N3
            ELSEIF (LINE1(I + N1:I + N1).NE.'\') THEN
               NSUB = NSUB + N1
            ENDIF
         ENDIF
      ENDDO
C
C Define LINE2
C
      IF (TYPE1.EQ.'left' .OR. TYPE1.EQ.'centre' .OR. TYPE1.EQ.'right'
     +    .OR. TYPE1.EQ.'free') THEN
         LINE2 = SYMBOL
      ELSE
         IX = LEN200(LINE1)
         CALL TRIML1 (LINE1)
         IY = LEN200(LINE1)
         L2 = LEN200(SYMBOL)
         LINE2 = SYMBOL(IX - IY + N1:L2)
      ENDIF
      L1 = LEN200(LINE1)
      L2 = LEN200(LINE2)
      IF (L2.GT.L1) THEN
         DO I = L1 + N1, L2
            LINE2(I:I) = BLANK
         ENDDO
         L2 = L1
      ELSEIF (L2.LT.L1) THEN
         DO I = L2 + N1, L1
            LINE2(I:I) = QUEST
         ENDDO
         L2 = L1
      ENDIF
C
C Transform coordinates then output data
C
      IF (TYPE1.NE.'free') THEN
         CALL GKSR2I$(IX, IY,
     +                X, Y)
         WRITE (L12,100) IX, IY
         CALL PSTRIP$(L12)
      ENDIF
      IF (TYPE1.EQ.'left') THEN
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), 'tl',
     +                       WORD5
      ELSEIF (TYPE1.EQ.'centre') THEN
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), 'tc',
     +                       WORD5
      ELSEIF (TYPE1.EQ.'right') THEN
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), 'tr',
     +                       WORD5
      ELSEIF (TYPE1.EQ.'ti') THEN
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), 'ti',
     +                       '%#title'
      ELSEIF (TYPE1.EQ.'xl') THEN
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), 'xl',
     +                       '%#x legend'
      ELSEIF (TYPE1.EQ.'yl') THEN
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), 'yl',
     +                       '%#y legend'
      ELSEIF (TYPE1.EQ.'zl') THEN
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), 'zl',
     +                       '%#z legend'
      ELSEIF (TYPE1.EQ.'free') THEN
         WRITE (NOUT_PS,300) LINE1(N1:L1)
      ELSE
         WRITE (NOUT_PS,200) LINE1(N1:L1), L12(N1:LEN200(L12)), TYPE1,
     +                       WORD5
      ENDIF
      WRITE (NOUT_PS,400) LINE2(N1:L2)
C
C These format statements must NOT be edited
C      
  100 FORMAT (2I6)
  200 FORMAT ('(',A,')',1X,A,1X,A,A)
  300 FORMAT ('(',A,')')
  400 FORMAT ('(',A,')',1X,'fx')
      END
C
C
