C
C
      SUBROUTINE RPPLOT$(NOBS, NSET, NVEC,
     +                   XVEC,
     +                   TITLES)
C
C ACTION  : Supply a vector then create a range and percentiles plot
C           by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           Derived from BWPLOT$ 17/03/2011
C           06/07/2011 added WORDX and VECTORS in call to LABELS
C           12/07/2011 added WORDY to TXTKEY argument list
C
C            NOBS: (input/unchanged) observations per set(i), NOBS(i) >= 4
C            NSET: (input/unchanged) no. of sets of data
C            NVEC: (input/unchanged) total no. of items, NVEC >= sum NOBS(i)
C            XVEC: (input/unchanged) vector of values i = 1, NVEC
C          TITLES: (input/unchanged) as follows:
C                  title, x-legend, y-legend, z-legend(unused)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NSET, NVEC
      INTEGER,             INTENT (IN) :: NOBS(NSET)
      DOUBLE PRECISION,    INTENT (IN) :: XVEC(NVEC)
      CHARACTER (LEN = *), INTENT (IN) :: TITLES(4)    
C      
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4, NIN,
     +           NMAX, NWORDS, NXTRA
      PARAMETER (NIN = 3, NGRAFS = 300, NGRAF2 = 2*NGRAFS,
     +           NGRAF3 = 3*NGRAFS, NGRAF4 = 4*NGRAFS,
     +           NMAX = 2000, 
     +           NWORDS = 2000, KPANEL = NGRAFS, NXTRA = NWORDS)
      INTEGER    N0, N1, N2, N4, N5, N20, N40, N60
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N5 = 5, 
     +           N20 = 20, N40 = 40, N60 = 60)
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS), K(20), 
     +           L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    I, ICOUNT, IFAIL, IOS, J, KZ, MZ, NMAX1, NOUT(N5), NZ
      DOUBLE PRECISION FACTOR(NXTRA), SIZE(NGRAFS), WIDE(5*NGRAFS),
     +                 Z(5*NMAX), ZLH, ZMAX, ZMED, ZMIN, ZUH
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  FILEX(N5)*1024
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40,
     +           VECTORS(N60)*40
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ASKIF, STORE, THERE
      PARAMETER (ASKIF = .FALSE., STORE = .FALSE.)
      EXTERNAL   GKSGRF$, DELEET, GETTMP, GETNOU, NXSORT$
      EXTERNAL   DEFGKS$, PLTOBJ$, PUTFAT$
      EXTERNAL   LABELS, SYMBOL, TXTKEY
      INTRINSIC  MOD
C
C Check the data supplied
C
      IF (NSET.LT.N1 .OR. NVEC.LT.N4) THEN
         CALL PUTFAT$(
     +'Must have at least 1 item for a range and percentiles plot')
         RETURN
      ENDIF
      ICOUNT = N0
      DO I = N1, NSET
         ICOUNT = ICOUNT + NOBS(I)
         IF (NOBS(I).LT.N4) THEN
            CALL PUTFAT$(
     +'Need at least 4 items/sample for a range and percentiles plot')
            RETURN
         ENDIF
      ENDDO
      IF (ICOUNT.GT.NVEC) THEN
         CALL PUTFAT$(
     +'NSET, NOBS, and NVEC inconsistent in call to RPPLOT$')
         RETURN
      ENDIF
C
C Initialise gks and objects
C
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Initialise all the array variables even though they are not to be used
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N0
         M(I) = N0
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      DO I = N1, NWORDS
         IFILL(I) = N1
         IHUE(I) = N0
         FACTOR(I) = ONE
         LABEL1(I) = BLANK
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
      ENDDO
      CALL LABELS (N1, IHUE, IFILL,
     +             LABEL1, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO              
      CALL SYMBOL (N1, JCOLOR, K, L, M,
     +             SIZE, WIDE)
      CALL TXTKEY (LABVEC, PSYMB, WORDY,
     +             STORE)       
C
C Create a set of range and quartiles type files
C
      DO I = N1, N5
         CALL GETTMP (IFAIL,
     +                FILEX(I))
         IF (IFAIL.NE.N0) RETURN
         CALL GETNOU (NOUT(I))
         OPEN (UNIT = NOUT(I), FILE = FILEX(I), IOSTAT = IOS)
         IF (IOS.NE.N0) RETURN
         WRITE (NOUT(I),'(A)') TITLES(1)
         WRITE (NOUT(I),'(2I6)') NSET, N2
      ENDDO   
      ICOUNT = N0
      DO I = N1, NSET
         NZ = NOBS(I)
         DO J = N1, NZ
            ICOUNT = ICOUNT + N1
            Z(J) = XVEC(ICOUNT)
         ENDDO
         CALL NXSORT$(NZ,
     +                Z)
         ZMIN = Z(N1)
         ZMAX = Z(NZ)
         IF (MOD(NZ,N2).EQ.N0) THEN
            MZ = NZ/N2
            KZ = MZ/N2
            ZLH = (Z(KZ) + Z(KZ + N1))/TWO
            ZMED = (Z(MZ) + Z(MZ + N1))/TWO
            ZUH = (Z(NZ - KZ) + Z(NZ - KZ + N1))/TWO
         ELSE
            MZ = (NZ + N1)/N2
            KZ = (MZ + N1)/N2
            ZLH = Z(KZ)
            ZMED = Z(MZ)
            ZUH = Z(NZ - KZ + N1)
         ENDIF
         WRITE (NOUT(1),'(I4,1P,E13.5)') I, ZMIN
         WRITE (NOUT(2),'(I4,1P,E13.5)') I, ZLH
         WRITE (NOUT(3),'(I4,1P,E13.5)') I, ZMED
         WRITE (NOUT(4),'(I4,1P,E13.5)') I, ZUH
         WRITE (NOUT(5),'(I4,1P,E13.5)') I, ZMAX
      ENDDO
      NFILE1 = N5
      DO I = N1, N5
         CLOSE (UNIT = NOUT(I))
         L(I) = N1
         M(I) = N1
         FSAV(I) = FILEX(I)
         FSAV1(1) = FILEX(I)
      ENDDO
      BAR_CHART = .FALSE.
      LIB_FILE = .FALSE.
      PIE_CHART = .FALSE.
      SUPPLY_XY = .TRUE.
      TWO_PLOTS = .FALSE.
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.

      NMAX1 = NMAX

      CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +             NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +             FACTOR, SIZE, WIDE, 
     +             FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +             TSAV, TITLES, WORDX, WORDY,
     +             BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +             PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +             SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +             VECTOR_FIELD, YAXIS)
C
C Delete the temporary files used for plotting
C
      DO I = N1, N5
         CALL DELEET (FILEX(I),
     +                ASKIF, THERE)
         CALL DELEET (FSAV(I),
     +                ASKIF, THERE)
         CALL DELEET (FSAV1(I),
     +                ASKIF, THERE)  
      ENDDO     
      END
C
C
