c
c
      subroutine rtplot (n,
     +                   r, theta)
c
c action: plot r = r(theta)
c author: w.g.bardsley, university of manchester, u.k., 16/11/2005 
c         23/04/2007 added intents
c
c     n: (input/unchanged) must be > 2
c     r: (input/output) returned as y
c theta: (input/output) returned as x
c
      implicit   none
c
c arguments
c
      integer,          intent (in)    :: n
      double precision, intent (inout) :: r(n), theta(n)
c
c locals
c
      integer    i, l, m
      parameter (l = 1, m = 0)
      double precision pi, x, y
      double precision x01aafg
      double precision zero
      parameter (zero = 0.0d+00)
      character  ptitle*12, xtitle*1, ytitle*1
      parameter (ptitle = 'r = r(theta)', xtitle = 'x', ytitle = 'y')
      external   x01aafg
      external   gks001
      intrinsic  cos, sin
      if (n.lt.2) return
      pi = x01aafg(x)
      do i = 1, n
         if (r(i).lt.zero) then
            r(i) = - r(i)
            theta(i) = theta(i) + pi
         endif
         x = r(i)*cos(theta(i))
         y = r(i)*sin(theta(i))
         r(i) = y
         theta(i) = x
      enddo
      call gks001 (l, m, n,
     +             theta, r,
     +             ptitle, xtitle, ytitle)
      end
c
c
