C
C
      SUBROUTINE SBPLOT$(ISEND, NCOL, NRMAX, NROW,
     +                   A,
     +                   LABEL, TITLES)
C
C ACTION  : Supply a matrix then create a stacked bar chart by calling GKSGRF$
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           02/02/2008 derived from bcplot$
C           12/02/2008 different action if all columns are =< 0 for some row
C           02/11/2010 added SIZE and WIDE to argument list to SYMBOL
C           01/12/2010 added PLINE to argument list to LABELS 
C           31/12/2020 added call to TXTKEY
C           06/07/2011 added WORDX and VECTORS in call to LABELS
C           12/07/2011 added WORDY to TXTKEY argument list
C
C           ISEND: (input/unchanged) controls labels as follows:
C                  ISEND = 1: use SIMPLOT configuration labels
C                  ISEND = 2: use labels from argument list
C            NCOL: (input/unchanged) no. columns
C           NRMAX: (input/unchanged) leading dimension
C            NROW: (input/unchanged) no. rows
C            XMAT: (input/unchanged) matrix of values
C          LABELS: (input/unchanged) used aslabels if ISEND = 2
C          TITLES: (input/unchanged) as follows:
C                   title, x-legend, y-legend, z-legend(unused)
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: ISEND, NCOL, NRMAX, NROW
      DOUBLE PRECISION,    INTENT (IN) :: A(NRMAX,NCOL)
      CHARACTER (LEN = *), INTENT (IN) :: LABEL(NROW), TITLES(4)
C
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4,
     +           NIN, NMAX, NMAX1, NWORDS, NXTRA
      PARAMETER (NIN = 3, NGRAFS = 300, NGRAF2 = 2*NGRAFS,
     +           NGRAF3 = 3*NGRAFS, NGRAF4 = 4*NGRAFS, NMAX = 2000,
     +           NWORDS = 2000, KPANEL = NGRAFS, NXTRA = NWORDS)
      INTEGER    JSEND
      PARAMETER (JSEND = 1)
      INTEGER    N0, N1, N2, N9, N20, N40, N60
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N9 = 9, N20 = 20,
     +           N40 = 40, N60 = 60)
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS),
     +           KCOLOR(NGRAFS), L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    I, ICOUNT, IFAIL, IOS, J, NOUT
      DOUBLE PRECISION FACTOR(NXTRA), SIZE(NGRAFS),
     +                 WIDE(5*NGRAFS)
      DOUBLE PRECISION X, Y1, Y2, Y3, Y4, Y5
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      CHARACTER  FILEX*1024, WORD14*14
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40,
     +           VECTORS(N60)*40
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    ALLNEG, ALLPOS, ROWPOS(NMAX), TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ASKIF, STORE, THERE
      PARAMETER (ASKIF = .FALSE., STORE = .FALSE.)
      EXTERNAL   GKSGRF$, DELEET, GETTMP, GETNOU, SYMBOL, LABELS, TXTKEY
      EXTERNAL   DEFGKS$, PLTOBJ$, PUTFAT$
      INTRINSIC  DBLE
C
C Check the data supplied
C
      IF (ISEND.LT.N1 .OR. ISEND.GT.N2) THEN
         CALL PUTFAT$('ISEND out of range in call to SBPLOT$')
         RETURN
      ENDIF
      IF (NCOL.LT.N1 .OR. NROW.LT.1) THEN
         CALL PUTFAT$('Must have at least 1 item for a bar chart')
         RETURN
      ENDIF
      IF (NCOL.GT.20) THEN
         CALL PUTFAT$('Cannot create a bar chart from > 20 columns')
         RETURN
      ENDIF
      IF (NCOL*NROW.GT.NWORDS) THEN
         CALL PUTFAT$('Matrix too large for a bar chart (> 2000 items)')
         RETURN
      ENDIF
C
C Check that individual rows are all >= 0 or all =< 0
C      
      DO I = N1, NROW
         ALLNEG = .TRUE.
         ALLPOS = .TRUE.
         DO J = N1, NCOL
            IF (A(I,J).LT.ZERO) THEN
               ALLPOS = .FALSE.
            ELSEIF (A(I,J).GT.ZERO) THEN
               ALLNEG = .FALSE.
            ENDIF      
         ENDDO  
         IF (ALLPOS) THEN
            ROWPOS(I) = .TRUE.
         ELSEIF (ALLNEG) THEN
            ROWPOS(I) = .FALSE.   
         ELSE
            CALL PUTFAT$(
     +'Must have individual rows either >= 0 or =< 0 for stacking')
            RETURN
         ENDIF   
      ENDDO  
C
C Initialise gks and graphical objects
C
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Initialise all the array variables even though some are not to be used
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N0
         M(I) = N0
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      ICOUNT = 0
      DO I = N1, NWORDS
         ICOUNT = ICOUNT + 1
         IF (ICOUNT.GT.10) ICOUNT = 1
         IFILL(I) = ICOUNT
         IHUE(I) = N0
         FACTOR(I) = HALF
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
         WRITE (LABEL1(I),'(I4)') I         
      ENDDO
C
C Get the default values
C
      CALL SYMBOL (JSEND, JCOLOR, KCOLOR, L, M,
     +             SIZE, WIDE)
      CALL LABELS (JSEND, IHUE, IFILL,
     +             LABEL1, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO              
      CALL TXTKEY (LABVEC, PSYMB, WORDY,
     +             STORE)
          
C
C Create a temporary matrix file for GKSGRF$ to plot as a bar chart
C
      CALL GETTMP (IFAIL,
     +             FILEX)
      IF (IFAIL.NE.N0) RETURN
      CALL GETNOU (NOUT)
      OPEN (UNIT = NOUT, FILE = FILEX, IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NOUT)
         RETURN
      ENDIF
      WRITE (NOUT,'(A)') TITLES(1)
      WRITE (NOUT,'(2I6)') NROW*NCOL, N9
      DO I = N1, NROW
C
C First the row coordinate x
C        
         X = DBLE(I)
         IF (ROWPOS(I)) THEN
            DO J = N1, NCOL
C
C Now the column coordinates y1, y2, y3, y4, y5, f, w, c for a positive row
C           
               IF (J.EQ.N1) THEN 
                  Y1 = ZERO
                  Y2 = ZERO
                  Y3 = ZERO
                  Y4 = ZERO
                  Y5 = ZERO
               ELSE
                  Y1 = Y5
                  Y2 = Y5
                  Y3 = Y5
               ENDIF     
               Y4 = Y4 + A(I,J)
               y5 = y4
C
C Plot positive stacks upwards
C              
               WRITE (NOUT,'(1P,6E13.5,I3,0P,F8.4,I4)') X,
     +                                                  Y1, Y2, Y3, Y4,
     +                                                  Y5,
     +                                                  IFILL(J),
     +                                                  FACTOR(J),
     +                                                  IHUE(J)
            ENDDO
         ELSE
C
C Work out the lowest point for Y1 = Y2 = Y3 
C
            Y1 = ZERO
            DO J = N1, NCOL
               Y1 = Y1 + A(I,J)
            ENDDO   
            DO J = NCOL, N1, -N1
C
C Now the column coordinates y1, y2, y3, y4, y5, f, w, c for a negative row
C           
               IF (J.EQ.NCOL) THEN 
                  Y2 = Y1
                  Y3 = Y1
                  Y4 = Y1
                  Y5 = Y1
               ELSE
                  Y1 = Y5
                  Y2 = Y5
                  Y3 = Y5
               ENDIF  
               IF (J.EQ.N1) THEN
                  Y4 = ZERO
                  Y5 = ZERO
               ELSE      
                  Y4 = Y4 - A(I,J)
                  y5 = y4
               ENDIF    
C
C Plot negative stacks in reverse order
C     
               WRITE (NOUT,'(1P,6E13.5,I3,0P,F8.4,I4)') X,
     +                                                  Y1, Y2, Y3, Y4,
     +                                                  Y5,
     +                                                  IFILL(J),
     +                                                  FACTOR(J),
     +                                                  IHUE(J)
            ENDDO
         ENDIF     
      ENDDO
C
C Add labels to file if ISEND = 2 then close file
C

      WRITE (NOUT,'(I6)') NROW*NCOL + 2
      WRITE (NOUT,'(A)') 'begin{labels}'
      IF (ISEND.EQ.N1) THEN
         DO I = N1, NROW
            WRITE (NOUT,'(A)') LABEL1(I)
         ENDDO
      ELSE
         DO I = N1, NROW
            WRITE (NOUT,'(A)') LABEL(I)
         ENDDO
      ENDIF
      WRITE (WORD14,100) NCOL
      DO I = 1, NROW*(NCOL - 1)
         WRITE (NOUT,'(A)') WORD14 
      ENDDO  
      WRITE (NOUT,'(A)') 'end{labels}'
      CLOSE (UNIT = NOUT)
C
C Set the important scalars then call GKSGRF$
C
      NFILE1 = N1
      FSAV(1) = FILEX
      FSAV1(1) = FILEX
      BAR_CHART = .TRUE.
      LIB_FILE = .FALSE.
      PIE_CHART = .FALSE.
      SUPPLY_XY = .TRUE.
      TWO_PLOTS = .FALSE.
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.

       DO I = N1, NWORDS
         LABEL1(I) = BLANK
      ENDDO     
      
      NMAX1 = NMAX
      
      CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +             NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +             FACTOR, SIZE, WIDE,
     +             FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +             TSAV, TITLES, WORDX, WORDY,
     +             BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +             PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +             SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +             VECTOR_FIELD, YAXIS)
C
C Delete the temporary files used for plotting
C
      CALL DELEET (FSAV(N1),
     +             ASKIF, THERE)
      CALL DELEET (FSAV1(N1), 
     +             ASKIF, THERE)
  100 FORMAT (I3,'*bars/group')      
      END
C
C
