c
c
      subroutine sdplot (n,
     +                   a, b, x)
c
c action: plot a sample distribution as a bar chart
c author: w.g.bardsley, university of manchester, u.k., 12/09/2012
c         20/10/2012 added call to x2ybin$ 
c         31/05/2022 introduced formgr
c
c n: sample size >= 2
c a: lower limit
c b: upper limit
c x: sample
c
c Note: if a < b and these cover the data range then these are taken as
c       starting bin limits but otherwise the smallest and largest sample
c       values are used. 
c
      implicit none
c
c arguments
c          
      integer,          intent (in) :: n
      double precision, intent (in) :: a, b, x(n)  
c
c locals
c      
      integer    isend, nrmax, ncol, numopt, numsta, numtxt
      parameter (isend = 2, nrmax = 100, ncol = 1, numopt = 6,
     +           numsta = 8, numtxt = numsta + numopt - 1)   
      integer    i, icount(nrmax), k, nbars, numdec
      integer    numbld(30)
      double precision bot, top, xmid, xmat(nrmax,ncol)
      double precision xmax, xmin
      double precision two
      parameter (two = 2.0d+00)
      character (len = 3  ) labels(nrmax)
      character (len = 10 ) formgr, word10(2)
      character (len = 12 ) form12, word12(3)
      character (len = 40 ) titles(4)
      character (len = 100) text(30), line
      logical    abort, repeet
      external   form12, formgr, bcplot, lstbox, getjm1, getdlt,
     +           getdgt, patch2, x2ibin$
      intrinsic  dble
      save       nbars
      data       nbars / 10 /
      data       numbld / 30*0 /
c
c check for n > 2
c      
      if (n.lt.2) return
c
c decide whether to use a, b supplied
c
       bot = x(1)
       top = x(1)
       do i = 2, n
          if (x(i).lt.bot) then 
             bot = x(i)
          elseif (x(i).gt.top) then
             top = x(i)    
          endif   
      enddo
      if (bot.ge.top) return
      xmin = bot
      xmax = top
      xmid = (top - bot)/two
      if (a.le.bot .and. b.ge.top) then
         bot = a
         top = b
      endif   
c
c main loop
c      
      numdec = numopt - 2
      repeet = .true.  
      do while (repeet)
         word12(1) = form12(n)
         word12(2) = form12(nbars)
         word10(1) = formgr(bot)
         word10(2) = formgr(top)
         write (text,100) word12(1), word12(2), word10(1), word10(2)
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0                   
         if (numdec.eq.1) then
c
c numdec = 1: change nbars
c           
            i = 2
            call getjm1 (i, nbars, nrmax,
     +                  'Number of bars required')
            numdec = numopt - 2
         elseif (numdec.eq.2) then
c
c numdec = 2: change lower limit
c         
            word10(1) = formgr(xmin)
            write (line,200) word10(1)
            call getdlt (bot, xmid,
     +                   line)   
            numdec = numopt - 2
         elseif (numdec.eq.3) then
c
c numdec = 3: change upper limit
c         
            word10(1) = formgr(xmax)
            write (line,300) word10(1)
            call getdgt (top, xmid,
     +                   line)                    
            numdec = numopt - 2
         elseif (numdec.eq.numopt - 2) then 
c
c numdec = 4: plot
c         
            call x2ibin$(icount, nbars, n,
     +                   bot, top, x,
     +                   abort)           
            if (.not.abort) then
               k = 0
               do i = 1, nbars
                  k = k + icount(i)
                  xmat(i,ncol) = dble(icount(i))
                  if (i.lt.10) then
                     write (labels(i),'(1x,i1,1x)') i 
                  else 
                     write (labels(i),'(i3)') i
                  endif
               enddo  
       
               word12(3) = form12(k)
               write (titles(1),400) word12(3)
               word10(1) = formgr(bot)
               word10(2) = formgr(top)
               write (titles(2),500) trim(word10(1)), trim(word10(2))
               titles(3) = 'Number of x(i) per bin'
               titles(4) = ' '
               call bcplot (isend, ncol, nrmax, nbars,
     +                      xmat,
     +                      labels, titles)
            endif
            numdec = 1 
         elseif (numdec.eq.numopt - 1) then
c
c numdec = 5: help
c         
            write (text,600)
            i = 21
            numbld(1) = 1 
            call patch2 (numbld, i,
     +                   text)
            numbld(1) = 0
            numdec = numopt - 2   
         elseif (numdec.eq.numopt) then
c
c numdec = 6: quit
c         
            repeet = .false.
         endif
      enddo
c
c format statements
c      
  100 format (
     + 'Plotting a sample as a bar chart'
     +/
     +/'Sample size',2x,a
     +/'Number of bars',2x,a
     +/'Lower limit',2x,a
     +/'Upper limit',2x,a 
     +/
     +/'Change number of bars'
     +/'Change lower limit'
     +/'Change upper limit'
     +/'Plot'
     +/'Help'
     +/'Exit ... no further plotting required')
  200 format ('Lower limit required: smallest data value =',1x,a)   
  300 format ('Upper limit required: largest data value =',1x,a)   
  400 format ('Number of x(i) in range =',1x,a) 
  500 format ('Range (',a,',',1x,a,')') 
  600 format (
     + 'Plotting a sample as a bar chart'
     +/
     +/'This procedure requires the following data.'
     +/
     +/'1)`The sample x(i), for i = 1, 2, ..., n'   
     +/'2)`The lower limit, usually =< the smallest x(i)'   
     +/'3)`The upper limit, usually >= the largest x(i)'   
     +/'4)`A chosen number of bins, say =< 20'  
     +/
     +/'It is used in order to get an idea of the spread of sample'
     +/'values when some distribution is being considered, such as'
     +/'a bell-shaped curve for a normal distribution, or a horizontal'
     +/'line for a uniform distribution.'
     +/
     +/'You can alter the bin limits and number of bins but these'
     +/'points should be noted.'
     +/
     +/'a)`Data values outside the range are added to extreme bins'
     +/'b)`Each bin should have a reasonable number of points, say'
     +/'  `at least five or ten each on average, preferably much'
     +/'  `more, to get some idea of the underlying distribution.')
      end              
c
c      
