c
c
      subroutine siggks$(nfig, nsig,
     +                   xmax, xmin)
c
c action: given nfig, xmax, xmin, calculate nsig
c author: w.g.bardsley, university of manchester, u.k., 14/08/2009
c
c nfig: (input/unchanged) number of figures after the decimal point from doaxis$
c nsig: (output) significance type low(1), medium (2), or high (3)
c xmax: (input/unchanged) largest tick mark
c xmin: (input/unchanged) smallest tick mark
c
c Parameters from GKSBOX$:
c nmag  low    medium   high
c < -2  f5.1   f5.2     f8.4
c = -2  f6.3   f7.4     f8.6
c = -1  f6.2   f6.3     f8.5
c = 0   f6.1   f6.2     f8.4
c = 1   f6.1   f5.1     f8.3
c = 2   int    int      f8.2
c = 3   int    int      f8.1
c > 3   f5.1   f5.2     f8.4
c
c
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: nfig
      integer,          intent (out) :: nsig
      double precision, intent (in)  :: xmax, xmin
c
c locals
c     
      integer    nmag
      integer    n0, n1, n2, n3, n4, n5
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5)
      double precision xtemp, ytemp
      double precision one, ten
      parameter (one = 1.0d+00, ten = 10.0d+00)
      intrinsic  abs, log10, int
C
C Find magnitude of numbers on X-Axis. 
C
      xtemp = max(abs(xmax), abs(xmin))
      ytemp = log10(xtemp)
      nmag = int(ytemp)
      ytemp = xtemp/ten**nmag
C
C Make sure numbers will be of the form (1.234...)*10**NMAG
C
      if (ytemp.lt.one) then
         nmag = nmag - n1
      elseif (ytemp.gt.ten) then
         nmag = nmag + n1
      endif
c
c the individual cases
c      
      if (nmag.lt.-n2) then  
         if (nmag.eq.-n3) then
c
c special case for -n3 as doaxis$ does not allow for exponential notation
c           
           if (nfig.le.n4) then
               nsig = n1
            elseif (nfig.le.n5) then
               nsig = n2
            else
               nsig = n3
            endif
         else  
            if (nfig.le.n1) then
               nsig = n1
            elseif (nfig.eq.n2) then
               nsig = n2
            else
               nsig = n3
            endif
         endif
      elseif (nmag.eq.-n2) then  
         if (nfig.le.n3) then
            nsig = n1
         elseif (nfig.eq.n4) then
            nsig = n2
         else
            nsig = n3
         endif 
      elseif (nmag.eq.-n1) then  
         if (nfig.le.n2) then
            nsig = n1
         elseif (nfig.eq.n3) then
            nsig = n2
         else
            nsig = n3
         endif 
      elseif (nmag.eq.n0) then  
         if (nfig.le.n1) then
            nsig = n1
         elseif (nfig.eq.n2) then
            nsig = n2
         else
            nsig = n3
         endif 
      elseif (nmag.eq.n1) then  
         if (nfig.le.n1) then
            nsig = n1
         else
            nsig = n3
         endif
      elseif (nmag.eq.n2) then  
         if (nfig.le.n1) then
            nsig = n1
         else
            nsig = n3
         endif 
      elseif (nmag.eq.n3) then  
         if (nfig.le.n1) then
            nsig = n1
         else
            nsig = n3
         endif 
      else  
         if (nfig.le.n1) then
            nsig = n1
         elseif (nfig.eq.n2) then
            nsig = n2   
         else
            nsig = n3
         endif                                                        
      endif             
      end
c
c      
      