C
C metafile replay routines asa follows: 
C MFPLOT
C SIMPLOT_METAFILE
C SIMPLOT_METAFILE_1
C SIMPLOT_METAFILE_2
C SIMPLOT_METAFILE_3
C SIMPLOT_METAFILE_4
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE MFPLOT
      IMPLICIT   NONE
C
C 17/02/2016 added calls to DEFKEY in case the metafile changes keys
c 20/06/2016 added checks for begin{vfield} ... end{vfield} to intitialise IFIL, FACTOR, and IHUE 
C      
      INTEGER    ISEND, JSEND
      PARAMETER (ISEND = 1)
      CHARACTER (LEN = 80) KEYS(5)
      LOGICAL    STORE
      EXTERNAL   SIMPLOT_METAFILE, DEFKEY
      
      STORE = .FALSE.
      DO JSEND = 1, 5
         CALL DEFKEY (ISEND, JSEND, 
     +                KEYS(JSEND),
     +                STORE)
      ENDDO
      
      CALL SIMPLOT_METAFILE
      
      STORE = .TRUE.
      DO JSEND = 1, 5
         CALL DEFKEY (ISEND, JSEND, 
     +                KEYS(JSEND),
     +                STORE)
      ENDDO  
      END
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE SIMPLOT_METAFILE 
C
C ACTION: replay a SIMPLOT metafile
C AUTHOR: w.g.bardsley, university of manchester, u.k., 23/05/2013 
C   
C This is a stand-alone routine to take in a metafile created from SIMPLOT
C and replay it. It uses independent plotting arrays with the same dimension
C of those used by the SIMPLOT program so that no memory traces of the
C metafile remain in SIMPLOT after it has been played.  
C
      IMPLICIT NONE
C
C Locals
C  
      INTEGER    I, ISEND, IOS, J, K, NIN, NMAX1
      INTEGER    IFI, IHU
      INTEGER    KPANEL, NFILE1, NGRAFS, NWORDS, NXTRA
      PARAMETER (NGRAFS = 300, KPANEL = NGRAFS, 
     +           NWORDS = 2000, NXTRA = NWORDS)
      INTEGER    NGRAF2, NGRAF3, NGRAF4
      PARAMETER (NGRAF2 = 2*NGRAFS, NGRAF3 = 3*NGRAFS,
     +           NGRAF4 = 4*NGRAFS)
      INTEGER    IFILL(NXTRA), IHUE(NXTRA), JCOLOR(NGRAFS),
     +           L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      DOUBLE PRECISION FACTOR(NXTRA), SIZE(NGRAFS),
     +                 WIDE(5*NGRAFS)
      DOUBLE PRECISION FAC
      DOUBLE PRECISION X(9)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER (LEN = 1024) META_FNAME, FSAV(NGRAFS), FSAV1(NGRAFS)
      CHARACTER (LEN = 100 ) LINE
      CHARACTER (LEN = 80  ) TITLES(4), TSAV(NGRAFS)
      CHARACTER (LEN = 40  ) LABEL1(NWORDS), LABVEC(NWORDS),
     +                       PLINE(KPANEL), PSYMB(KPANEL),
     +                       WORDX(NWORDS), WORDY(NWORDS), ZERO40 
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
       LOGICAL   BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    ABORT, ACTION, STORE, TYPE_IN
      LOGICAL    ASKIF, THERE
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   GETNOU, GKSGRF$, NUMOBJ$, PLTOBJ$, DELEET
      EXTERNAL   SIMPLOT_METAFILE_1, SIMPLOT_METAFILE_2,
     +           SIMPLOT_METAFILE_3, SIMPLOT_METAFILE_4
      CALL GETNOU (NIN)
      CALL SIMPLOT_METAFILE_1 (META_FNAME,
     +                         ABORT)  
      IF (.NOT.ABORT) THEN
C
C
C Initialise objects
C
         CALL PLTOBJ$ (N1, N1)
C
C Initialise all the array variables (except for coordinates)
C
         BARCAP_1 = .TRUE.
         DO ISEND = N1, KPANEL
            PLINE(ISEND) = BLANK
            PSYMB(ISEND) = ZERO40
            PSHOW(ISEND) = .TRUE.
         ENDDO
         DO ISEND = N1, NGRAFS
            JCOLOR(ISEND) = N0
            L(ISEND) = N1
            M(ISEND) = N1
            NSAV(ISEND) = N1
            SIZE(ISEND) = ONE
            WIDE(ISEND) = ONE
            WIDE(ISEND + NGRAFS) = ONE
            WIDE(ISEND + NGRAF2) = ONE
            WIDE(ISEND + NGRAF3) = ONE
            WIDE(ISEND + NGRAF4) = ONE
            FSAV(ISEND) = BLANK
            FSAV1(ISEND) = BLANK
            TSAV(ISEND) = BLANK
            BARCAP(ISEND) = .TRUE.
            LOWER(ISEND) = .TRUE.
            UPPER(ISEND) = .TRUE.
            YAXIS(ISEND) = .TRUE.
         ENDDO
         DO ISEND = N1, NWORDS
            LABEL1(ISEND) = BLANK
            LABVEC(ISEND) = ZERO40
            WORDX(ISEND) = BLANK
            WORDY(ISEND) = BLANK
            PLOTX(ISEND) = .TRUE.
            PLOTY(ISEND) = .TRUE.
            PLOTZ(ISEND) = .TRUE.
         ENDDO
         DO ISEND = N1, NXTRA
            IFILL(ISEND) = N1
            IHUE(ISEND) = N0
            FACTOR(ISEND) = ONE
         ENDDO    
C
C Special action for metafiles
C              
         CALL SIMPLOT_METAFILE_2 (NFILE1, NGRAFS,
     +                            FSAV, META_FNAME,
     +                            ABORT,
     +                            BAR_CHART,
     +                            LIB_FILE,
     +                            PIE_CHART,  
     +                            SUPPLY_XY,  
     +                            TWO_PLOTS,  
     +                            TYPE_IN,
     +                            VECTOR_FIELD,
     +                            YAXIS)
               
         IF (.NOT.ABORT) THEN
            CALL SIMPLOT_METAFILE_4 (IFILL, IHUE, JCOLOR, KPANEL, 
     +                               L, M, NFILE1, NGRAFS, NWORDS,
     +                               NXTRA,                 
     +                               FACTOR, SIZE, WIDE, LABEL1,
     +                               LABVEC, META_FNAME, PLINE,
     +                               PSYMB, TITLES,
     +                               ABORT, BARCAP, LOWER, PLOTX, 
     +                               PLOTY, PLOTZ, UPPER)
         ENDIF                         
         IF (.NOT.ABORT) THEN
                  
            STORE = .TRUE.
            CALL SIMPLOT_METAFILE_3 (META_FNAME,
     +                               ACTION,
     +                               STORE)   
C
C Check if the user wants to re-plot stored objects
C
            
            CALL NUMOBJ$ (N1, I, J, K)   
            NMAX1 = NWORDS 
            IF (VECTOR_FIELD) THEN
C
C The special case of a vector field 
C              
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = FSAV(1))
               READ (NIN,'(A)',IOSTAT=IOS) TSAV(1)
               READ (NIN,*) J, K
               IF (K.EQ.9) THEN
                  DO I = 1, J
                     READ (NIN,*,IOSTAT=IOS) (X(K), K = 1, 9)
                     IFILL(I) = NINT(X(7))
                     FACTOR(I) = X(8)
                     IHUE(I) = NINT(X(9))
                   ENDDO
               ENDIF
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = META_FNAME, IOSTAT = IOS)
               DO WHILE (IOS.EQ.0)
                  READ (NIN,'(A)',IOSTAT=IOS) LINE
                  IF (INDEX(LINE,'begin{vfield}').GT.0) THEN
                     I = 0
                     DO WHILE (IOS.EQ.0)
                        READ (NIN,'(A)',IOSTAT=IOS) LINE
                        IF (IOS.EQ.0) THEN
                           IF (INDEX(LINE,'end{vfield}').GT.0) IOS = -1
                        ENDIF
                        IF (IOS.EQ.0) THEN
                           READ (LINE,*,IOSTAT=IOS) IFI, FAC, IHU
                           IF (IOS.EQ.0) THEN
                              I = I + 1
                              IFILL(I) = IFI
                              FACTOR(I) = FAC
                              IHUE(I) = IHU
                           ENDIF
                        ENDIF
                     ENDDO        
                  ENDIF  
               ENDDO   
               CLOSE (UNIT = NIN)
            ENDIF    
            CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M,
     +                   NFILE1,
     +                   NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +                   FACTOR, SIZE, WIDE, 
     +                   FSAV, FSAV1, LABEL1, LABVEC, PLINE,
     +                   PSYMB,
     +                   TSAV, TITLES, WORDX, WORDY,
     +                   BARCAP, BARCAP_1, BAR_CHART, LIB_FILE,
     +                   LOWER,
     +                   PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +                   SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +                   VECTOR_FIELD, YAXIS)
            CLOSE (UNIT = NIN)
C
C Delete the temporary files
C            
            DO I = 1, NFILE1
               CALL DELEET (FSAV(I),
     +                      ASKIF, THERE)
               CALL DELEET (FSAV1(I),
     +                      ASKIF, THERE) 
            ENDDO                             
         ENDIF  
      ENDIF    
      END    

C
C---------------------------------------------------------------------------------
C
      SUBROUTINE SIMPLOT_METAFILE_1 (FNAME,
     +                               ABORT) 
C
C ACTION: open then check for a valid simplot metafile
C AUTHOR: w.g.bardsley, university of manchester, u.k., 15/05/2013
C         27/08/2020 added call to simplot_tf 
C 
C This routine checks that the file located does have the four ciphers
c required for a metafile but does not do precise checking 
C
C Note that INDEX is not used in the configuration and metafile codes 
C as it proved unreliable with /f_stdcall and character variables
C      
      IMPLICIT    NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (OUT) :: FNAME  
      LOGICAL,             INTENT (OUT) :: ABORT
C
C Locals
C      
      INTEGER    I, IOS, ICOUNT, IFREQ(4), K(4), NIN, NUMOK 
      INTEGER    ISEND
      PARAMETER (ISEND = 3)
      CHARACTER (LEN = 200) LINE
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    OK(4), STORE, THERE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   GETNOU, OFILES, PUTFAT$, TRIML1, LCASE1
      EXTERNAL   SIMPLOT_TF
C
C Initialise then try to open a file or use the one from simplot_tf
C      
      ABORT = .TRUE.
      FNAME = BLANK
      CALL SIMPLOT_TF (FNAME,
     +                 STORE)
      CALL GETNOU (NIN)
      CLOSE (UNIT = NIN)
      IF (FNAME.EQ.BLANK) THEN  
C
C Get the user to provide a possible metafile
C
         CALL OFILES (ISEND, NIN,
     +                FNAME,
     +                ABORT)
         CLOSE (UNIT = NIN)
         IF (ABORT) RETURN
      ELSE
C
C Check that the file supplied does exist
C        
         INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS) 
         IF (IOS.EQ.0 .AND. .NOT.THERE) RETURN   
      ENDIF
C
C Check for the four ciphers
C        
      ABORT = .TRUE.
      OPEN (UNIT = NIN, FILE = FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) THEN
         CLOSE (UNIT = NIN)
         FNAME = BLANK
         RETURN
      ENDIF 
      ICOUNT = 0
      DO I = 1, 4
         IFREQ(I) = 0
         K(I) = 0
         OK(I) = .FALSE.
      ENDDO  
C
C Use TRIML1 and LCASE1 as we are only looking for the 4 ciphers
C          
      DO WHILE (IOS.EQ.0)
         READ (NIN,'(A)',IOSTAT=IOS) LINE
         IF (IOS.NE.0) EXIT
         CALL TRIML1 (LINE)
         CALL LCASE1 (LINE)
         ICOUNT = ICOUNT + 1  
         IF (LINE(1:27).EQ.
     +'%simplot configuration file') THEN
            OK(1) = .TRUE.   
            IFREQ(1) = IFREQ(1) + 1
            K(1) = ICOUNT
         ELSEIF (LINE(1:34).EQ.
     +'%end of simplot configuration file') THEN
            OK(2) = .TRUE. 
            IFREQ(2) = IFREQ(2) + 1
            K(2) = ICOUNT
          ELSEIF (LINE(1:31).EQ.
     +'%start of simplot metafile data') THEN
            OK(3) = .TRUE. 
            IFREQ(3) = IFREQ(3) + 1
            K(3) = ICOUNT
          ELSEIF (LINE(1:29).EQ.
     +'%end of simplot metafile data') THEN
            OK(4) = .TRUE. 
            IFREQ(4) = IFREQ(4) + 1
            K(4) = ICOUNT   
         ENDIF 
      ENDDO 
      CLOSE (UNIT = NIN)
C
C Final opinion
C
      NUMOK = 0
      IF (OK(1) .AND. K(1).GT.0 .AND. IFREQ(1).EQ.1) NUMOK = NUMOK + 1
      DO I = 2, 4
         IF (OK(I) .AND. IFREQ(I).EQ.1 
     +             .AND. K(I).GT.K(I - 1)) NUMOK = NUMOK + 1
      ENDDO      
      IF (NUMOK.NE.4) THEN
         ABORT = .TRUE.
         FNAME = BLANK
         WRITE (LINE,100) 4 - NUMOK 
         CALL PUTFAT$(LINE)
      ELSE
         ABORT = .FALSE.
      ENDIF   
  100 FORMAT (
     +'Not a valid SIMPLOT metafile: There are ',I1,' type 1 errors ')
      END
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE SIMPLOT_METAFILE_2 (NFILES, NGRAFS,
     +                               FILES, META_FNAME,
     +                               ABORT, 
     +                               BAR_CHART,
     +                               LIB_FILE,
     +                               PIE_CHART,  
     +                               SUPPLY_XY,  
     +                               TWO_PLOTS,  
     +                               TYPE_IN,
     +                               VECTOR_FIELD,
     +                               YAXIS)
C
C ACTION: extract logical variables from a simplot metafile
C AUTHOR: w.g.bardsley, university of manchester, u.k., 27/05/2013
C     
      IMPLICIT NONE
C
C Arguments
C  
      INTEGER,             INTENT (IN)    :: NGRAFS
      INTEGER,             INTENT (OUT)   :: NFILES
      CHARACTER (LEN = *), INTENT (INOUT) :: FILES(NGRAFS)        
      CHARACTER (LEN = *), INTENT (IN)    :: META_FNAME
      LOGICAL,             INTENT (OUT)   :: ABORT, BAR_CHART, LIB_FILE, 
     +                                       PIE_CHART, SUPPLY_XY,
     +                                       TWO_PLOTS, TYPE_IN,
     +                                       VECTOR_FIELD
      LOGICAL,             INTENT (INOUT) :: YAXIS(*)
C
C Locals
C     
      INTEGER    I, ICOUNT, IOS, J, K, N, NCOLS, NIN, NOUT, NROWS
      CHARACTER (LEN = 200) LINE
      CHARACTER (LEN = 12 ) WORD12
      CHARACTER (LEN = 11 ) WORD11
      CHARACTER (LEN = 10 ) WORD10
      CHARACTER (LEN = 9  ) WORD9
      CHARACTER (LEN = 7  ) WORD7
      CHARACTER (LEN = 6  ) WORD6
      CHARACTER (LEN = 5  ) WORD5
      CHARACTER (LEN = 4  ) WORD4
      CHARACTER (LEN = 1  ) BLANK, LETTER
      PARAMETER (BLANK = ' ') 
      EXTERNAL   GETNOU, GETTMP, PUTFAT$, PUTADV$, TRIML1, LCASE1
      INTRINSIC  TRIM
C
C initialise 
C      
      ABORT = .TRUE.
      ICOUNT = 0
      N = 0
      NIN = 0
      NOUT = 0
      
      NFILES = 0 
      BAR_CHART = .FALSE.
      LIB_FILE = .FALSE.
      PIE_CHART = .FALSE.  
      SUPPLY_XY = .TRUE.  
      TWO_PLOTS = .FALSE.  
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.
C
C open the supposed metafile
C      
      CALL GETNOU (NIN)
      CLOSE (UNIT = NIN)
      OPEN (UNIT = NIN, FILE = META_FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) GOTO 20
C
C Read until end of configuration/start of data
C        
      DO WHILE (IOS.EQ.0)
         ICOUNT = ICOUNT + 1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
         CALL TRIML1 (LINE)
         CALL LCASE1 (LINE)
         WORD4 = LINE(1:4)
         WORD5 = LINE(1:5)
         WORD6 = LINE(1:6)
         IF (WORD5.EQ.'%type') THEN
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
            WORD9 = LINE(1:9)
            WORD11 = LINE(1:11)
            WORD12 = LINE(1:12)
            IF (WORD9.EQ.'bar-chart') THEN
               BAR_CHART = .TRUE.
            ELSEIF (WORD9.EQ.'pie-chart') THEN
               PIE_CHART = .TRUE.
            ELSEIF (WORD11.EQ.'two-plots') THEN
               TWO_PLOTS = .TRUE.
            ELSEIF (WORD12.EQ.'vector-field') THEN
               VECTOR_FIELD = .TRUE.
            ENDIF
         ELSEIF (WORD6.EQ.'%yaxis') THEN
            ICOUNT = ICOUNT + 1 
            LINE = BLANK 
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
            DO I = 1, 100
               LETTER = LINE(I:I)
               IF (LETTER.EQ.'T') THEN
                  YAXIS(I) = .TRUE.
               ELSEIF (LETTER.EQ.'F') THEN
                  YAXIS(I) = .FALSE.
               ELSE   
                  EXIT 
               ENDIF      
            ENDDO  
         ELSEIF (WORD4.EQ.'%end') THEN
           IOS = -1
         ENDIF   
      ENDDO       
         
      ICOUNT = ICOUNT + 1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE 
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      WORD6 = LINE(1:6)
      
      IF (WORD6.NE.'%start') GOTO 20
 
      ICOUNT = ICOUNT + 1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE 
      CALL TRIML1 (LINE)
      CALL LCASE1 (LINE)
      WORD7 = LINE(1:7)

      IF (WORD7.NE.'%number') GOTO 20
        
      WORD10 = LINE(21:30)
      READ (WORD10,*,END=20,ERR=20,IOSTAT=IOS) N
      
      IF (N.LT.1) GOTO 20
        
      DO I = 1, N
         
         CALL GETTMP (IOS,
     +                FILES(I))
     
         CALL GETNOU (NOUT)
         CLOSE (UNIT = NOUT)
         OPEN (UNIT = NOUT, FILE = FILES(I), IOSTAT = IOS)
         IF (IOS.NE.0) GOTO 20
         ICOUNT = ICOUNT + 1  
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
         IF (IOS.NE.0) GOTO 20
         WRITE (NOUT,'(A)',IOSTAT=IOS) TRIM(LINE)
         ICOUNT = ICOUNT + 1
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NROWS, NCOLS
         IF (IOS.NE.0) GOTO 20
         WRITE (NOUT,'(2I6)',IOSTAT=IOS) NROWS, NCOLS
                  
         DO J = 1, NROWS
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
            IF (IOS.NE.0) GOTO 20
            WRITE (NOUT,'(A)',IOSTAT=IOS) TRIM(LINE)
         ENDDO  
         IF (I.EQ.1 .AND. VECTOR_FIELD .AND. NCOLS.EQ.4) THEN 
            READ (NIN,*,IOSTAT=IOS) K
            IF (IOS.EQ.0 .AND. K.EQ.3) THEN
               WRITE (NOUT,'(I4)',IOSTAT=IOS) K
               DO J = 1, K  
                  READ (NIN,'(A)',IOSTAT=IOS) LINE
                  WRITE (NOUT,'(A)',IOSTAT=IOS) LINE
               ENDDO
            ENDIF   
         ENDIF       

         CLOSE (UNIT = NOUT)
         NFILES = NFILES + 1
         
      ENDDO
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
      ABORT = .FALSE.
      RETURN
C
C Here only in the event of a crash
C      
   20 CONTINUE
      CLOSE (UNIT = NIN) 
      CLOSE (UNIT = NOUT)
      ABORT = .TRUE.
      WRITE (LINE,100)
      CALL PUTFAT$(LINE)
      WRITE (LINE,200) ICOUNT
      CALL PUTADV$(LINE)
C
C Format statements
C      
  100 FORMAT ('Not a valid SIMPLOT metafile: There are type 2 errors')     
  200 FORMAT ('Check the metafile at line', i6)      
      END
C
C---------------------------------------------------------------------------------
C
      SUBROUTINE SIMPLOT_METAFILE_3 (FNAME,
     +                               ACTION, STORE)
C
C ACTION: store/retrieve name of a metafile
C AUTHOR: w.g.bardsley, university of manchester, u.k., 15/05/2013
C    
C This subroutine can be called to initialise a metafile.
C If it has been called in this way then the next time it is called it
C will return ACTION = .TRUE. and the name of a metfile, but under all
C other circumstances it will return ACTION = .FALSE. 
C 
      IMPLICIT NONE
C
C Arguments
C      
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      LOGICAL,             INTENT (OUT)   :: ACTION
      LOGICAL,             INTENT (IN)    :: STORE
C
C Locals
C      
      INTEGER    ICOUNT, IOS
      CHARACTER (LEN = 1024) FNAME_SAV
      CHARACTER (LEN = 1   ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    THERE
      SAVE ICOUNT, FNAME_SAV
      DATA ICOUNT / 1 /
      DATA FNAME_SAV / BLANK /
      ICOUNT = ICOUNT + 1
      ACTION = .FALSE.
      IF (STORE) THEN
C
C Initialise the subroutine to read a metafile
C        
         INQUIRE (FILE = FNAME, EXIST = THERE, IOSTAT = IOS)
         IF (IOS.EQ.0 .AND. THERE) THEN 
            ICOUNT = 0
            FNAME_SAV = FNAME
         ENDIF      
      ELSE
C
C Check to see if reading is required
C        
         IF (ICOUNT.EQ.1) THEN
            INQUIRE (FILE = FNAME_SAV, EXIST = THERE, IOSTAT = IOS)
            IF (IOS.EQ.0 .AND. THERE) THEN
               ACTION = .TRUE.
               FNAME = FNAME_SAV
            ELSE
               ACTION = .FALSE.
            ENDIF      
         ELSE
            ACTION = .FALSE.
         ENDIF
         FNAME_SAV = BLANK
      ENDIF
      END
C
C-----------------------------------------------------------------
C                   
      SUBROUTINE SIMPLOT_METAFILE_4 (IFILL, IHUE, JCOLOR, KPANEL, L, M,
     +                               NFILES, NGRAFS, NWORDS, NXTRA,
     +                               FACTOR, SIZE, WIDE, 
     +                               LABEL1, LABVEC, META_FNAME, PLINE,
     +                               PSYMB, TITLES,
     +                               ABORT, BARCAP, LOWER, PLOTX, PLOTY,
     +                               PLOTZ, UPPER)
C
C ACTION: read parameters off a either a config file or a SIMPLOT metafile
C AUTHOR: w.g.bardsley, university of manchester, u.k., 18/05/2013
C     
      IMPLICIT NONE
C
C Arguments
C          
      INTEGER,             INTENT (IN)    :: KPANEL, NFILES, NGRAFS,
     +                                       NWORDS, NXTRA
      INTEGER,             INTENT (INOUT) :: IFILL(NXTRA), IHUE(NXTRA)
      INTEGER,             INTENT (INOUT) :: JCOLOR(NGRAFS), L(NGRAFS),
     +                                       M(NFILES)
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NXTRA)
      DOUBLE PRECISION,    INTENT (INOUT) :: SIZE(NGRAFS),
     +                                       WIDE(5*NGRAFS)
      CHARACTER (LEN = *), INTENT (IN)    :: META_FNAME
      CHARACTER (LEN = *), INTENT (INOUT) :: LABEL1(NWORDS),
     +                                       LABVEC(NWORDS)
      CHARACTER (LEN = *), INTENT (INOUT) :: PLINE(KPANEL),
     +                                       PSYMB(KPANEL)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLES(4)
      LOGICAL,             INTENT (INOUT) :: BARCAP(NGRAFS),
     +                                       LOWER(NGRAFS),
     +                                       UPPER(NGRAFS)
      LOGICAL,             INTENT (INOUT) :: PLOTX(NWORDS),
     +                                       PLOTY(NWORDS),
     +                                       PLOTZ(NWORDS)
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C       
      INTEGER    I, ICOUNT, IOS, J, JJ, KK, NIN, NOUT, LL, MM, NBARS
      DOUBLE PRECISION WW, SS
      CHARACTER (LEN = 1024) ADJLAB, LABFIL, SIM256, VFFILE
      CHARACTER (LEN = 200 ) LINE
      CHARACTER (LEN = 11  ) WORD11
      CHARACTER (LEN = 10  ) WORD10
      CHARACTER (LEN = 8   ) WORD8
      CHARACTER (LEN = 7   ) WORD7
      CHARACTER (LEN = 6   ) WORD6
      CHARACTER (LEN = 4   ) WORD4
      LOGICAL    THERE
      LOGICAL    ASKIF
      PARAMETER (ASKIF = .FALSE.)
      EXTERNAL   GETNOU, PUTFAT$, PUTADV$, SIM256, DELEET
      INTRINSIC  TRIM

      ADJLAB = SIM256('f$rotate.tmp')
      LABFIL = SIM256('f$labels.tmp')
      VFFILE = SIM256('f$vfield.tmp')
      CALL DELEET (ADJLAB,
     +             ASKIF, THERE) 
      CALL DELEET (LABFIL,
     +             ASKIF, THERE)
      CALL DELEET (VFFILE,
     +             ASKIF, THERE)      

      ABORT = .TRUE.
      ICOUNT = 0
      IF (NFILES.LT.1) GOTO 20
      INQUIRE (FILE = META_FNAME, EXIST = THERE, IOSTAT = IOS)
      IF (IOS.EQ.0 .AND. .NOT.THERE) GOTO 20
      CALL GETNOU (NIN)
      CLOSE (UNIT = NIN)
      OPEN (UNIT = NIN, FILE = META_FNAME, IOSTAT = IOS)
      IF (IOS.NE.0) GOTO 20
      ICOUNT = ICOUNT + 1 
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
      ICOUNT = ICOUNT + 1
      IF (IOS.EQ.0) READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE 
      IF (IOS.NE.0 .OR. LINE.NE.'%simplot configuration file') GOTO 20

      DO WHILE(IOS.EQ.0)
         ICOUNT = ICOUNT + 1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
         IF (IOS.NE.0) GOTO 20
         WORD4 = LINE(1:4)
         WORD6 = LINE(1:6)
         WORD7 = LINE(1:7)
         WORD8 = LINE(1:8)
         WORD10 = LINE(1:10)
         WORD11 = LINE(1:11) 
         IF (WORD4.EQ.'%end') THEN
            IOS = -1
         ELSEIF (WORD6.eq.'%title') THEN
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLES(1) 
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE 
         ELSEIF (WORD8.EQ.'%xlegend') THEN   
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLES(2) 
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE 
         ELSEIF (WORD8.EQ.'%ylegend') THEN   
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLES(3) 
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE 
         ELSEIF (WORD8.EQ.'%elegend') THEN   
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLES(4) 
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE  
         ELSEIF (WORD10.EQ.'%file line') THEN
            ICOUNT = ICOUNT + 1
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
            READ (LINE,*,END=20,ERR=20,IOSTAT=IOS) J, LL, WW, MM, SS, JJ
            JCOLOR(J) = JJ
            L(J) = LL
            M(J) = MM
            SIZE(J) = SS
            WIDE(J) = WW
         ELSEIF (WORD8.EQ.'%bar/pie') THEN
            ICOUNT = ICOUNT + 1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NBARS
            DO I = 1, NBARS
               ICOUNT = ICOUNT + 1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) IFILL(I), IHUE(I),
     +                                               FACTOR(I)
               ICOUNT = ICOUNT + 1
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LABEL1(I) 
               ICOUNT = ICOUNT + 1
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LABVEC(I) 
            ENDDO  
         ELSEIF (WORD4.EQ.'%key') THEN
            ICOUNT = ICOUNT + 1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) J
            IF (J.GT.0 .AND. J.LT.KPANEL) THEN
               ICOUNT = ICOUNT + 1
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) PLINE(J)
               ICOUNT = ICOUNT + 1     
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) PSYMB(J)
            ENDIF 
         ELSEIF (WORD11.EQ.'%error-bars') THEN
            ICOUNT = ICOUNT + 1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, JJ, KK, LL 
            BARCAP(I) = .FALSE.       
            LOWER(I) = .FALSE.       
            UPPER(I) = .FALSE. 
            IF (JJ.EQ.1) BARCAP(I) = .TRUE.      
            IF (KK.EQ.1) LOWER(I) = .TRUE.      
            IF (LL.EQ.1) UPPER(I) = .TRUE.  
         ELSEIF (WORD8.EQ.'%plotxyz') THEN
            ICOUNT = ICOUNT + 1
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) J
            DO I = 1, J
               ICOUNT = ICOUNT + 1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) JJ, KK, LL
               PLOTX(I) = .FALSE.         
               PLOTY(I) = .FALSE.         
               PLOTZ(I) = .FALSE.         
               IF (JJ.EQ.1) PLOTX(I) = .TRUE.
               IF (KK.EQ.1) PLOTY(I) = .TRUE.
               IF (LL.EQ.1) PLOTZ(I) = .TRUE.
            ENDDO  
         ELSEIF (WORD7.EQ.'%adjlab') THEN      
            CALL GETNOU (NOUT)
            OPEN (UNIT = NOUT, FILE = ADJLAB, IOSTAT = IOS)
            LOOP_1 : DO WHILE (IOS.EQ.0) 
               ICOUNT = ICOUNT + 1
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
               IF (LINE.EQ.'%donotreadanymorelines') THEN
                  EXIT LOOP_1
               ELSE
                  WRITE (NOUT,'(A)',IOSTAT=IOS) TRIM(LINE)
               ENDIF      
            ENDDO LOOP_1
            CLOSE (UNIT = NOUT)  
         ELSEIF (WORD7.EQ.'%labels') THEN      
            CALL GETNOU (NOUT)
            OPEN (UNIT = NOUT, FILE = LABFIL, IOSTAT = IOS)
            LOOP_2 : DO WHILE (IOS.EQ.0) 
               ICOUNT = ICOUNT + 1
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
               IF (LINE.EQ.'%donotreadanymorelines') THEN
                  EXIT LOOP_2
               ELSE
                  WRITE (NOUT,'(A)',IOSTAT=IOS) TRIM(LINE)
               ENDIF      
            ENDDO LOOP_2
            CLOSE (UNIT = NOUT)
         ELSEIF (WORD7.EQ.'%vffile') THEN      
            CALL GETNOU (NOUT)
            OPEN (UNIT = NOUT, FILE = VFFILE, IOSTAT = IOS)
            LOOP_3 : DO WHILE (IOS.EQ.0) 
               ICOUNT = ICOUNT + 1
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LINE
               IF (LINE.EQ.'%donotreadanymorelines') THEN
                  EXIT LOOP_3
               ELSE
                  WRITE (NOUT,'(A)',IOSTAT=IOS) TRIM(LINE)
               ENDIF      
            ENDDO LOOP_3
            CLOSE (UNIT = NOUT)     
         ENDIF 

      ENDDO
      
      CLOSE (UNIT = NIN)
      ABORT = .FALSE.
      RETURN
   20 CONTINUE  
      CLOSE (UNIT = NIN)
      ABORT = .TRUE. 
      WRITE (LINE,100)
      CALL PUTFAT$(LINE)
      WRITE (LINE,200) ICOUNT
      CALL PUTADV$(LINE)
C
C Format statements
C      
  100 FORMAT ('Not a valid SIMPLOT metafile: There are Type 4 errors')     
  200 FORMAT ('Check the metafile at line', i6) 
      END
C
C      