C
C
      SUBROUTINE SLASHB$(STRNG)
C
C ACTION: Correct a PS string for plotting on screen by transforming:
C         \\ --> \, \( --> (, \) --> )
C         Octal codes are replaced by ?
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 24/11/99
C
      IMPLICIT   NONE 
C
C Argument
C             
      CHARACTER (LEN = *), INTENT (INOUT) :: STRNG
C
C Locals
C      
      INTEGER    I, ICODE, J, K, L, LEN200, M, N
      CHARACTER  WORD1*1, WORD2*2
      CHARACTER  BLANK*1, BSLASH*1
      PARAMETER (BLANK = ' ', BSLASH = '\')
      LOGICAL    SEARCH, OCTAL
      EXTERNAL   LEN200
      INTRINSIC  INDEX, ICHAR, CHAR
C
C Check for possible \ characters
C
      J = INDEX(STRNG, BSLASH)
      IF (J.LE.0) RETURN
      L = LEN200(STRNG)
      IF (L.LE.1) RETURN
C
C Replace \\ by \, \) by ) and \( by ( and blank out trailing characters
C
      DO I = 1, 3
         IF (I.EQ.1) THEN
            WORD1 = BSLASH
         ELSEIF (I.EQ.2) THEN
            WORD1 = '('
         ELSE
            WORD1 = ')'
         ENDIF
         WORD2 = BSLASH//WORD1
         J = INDEX(STRNG, WORD2)
         DO WHILE (J.GT.0)
            DO K = J, L - 1
               M = K + 1
               STRNG(K:K) = STRNG(M:M)
            ENDDO
            STRNG(L:L) = BLANK
            L = L - 1
            J = INDEX(STRNG, WORD2)
         ENDDO
      ENDDO
C
C Check for any more \ characters in the current string
C
      J = INDEX(STRNG, BSLASH)
      IF (J.LE.0) RETURN
C
C Replace any \abc by ? where abc are integers, i.e. \abc is an octal code
C
      IF (J + 3.LE.L) THEN
         SEARCH = .TRUE.
      ELSE
         SEARCH = .FALSE.
      ENDIF
      DO WHILE (SEARCH)
C
C Search since there are enough characters for an octal code
C
         I = J + 1
         WORD1 = STRNG(I:I)
         K = ICHAR(WORD1)
         I = J + 2
         WORD1 = STRNG(I:I)
         M = ICHAR(WORD1)
         I = J + 3
         WORD1 = STRNG(I:I)
         N = ICHAR(WORD1)
         IF ((K.GE.48 .AND. K.LE.55) .AND.
     +       (M.GE.48 .AND. M.LE.55) .AND.
     +       (N.GE.48 .AND. N.LE.55)) THEN
            OCTAL = .TRUE.
         ELSE
            OCTAL = .FALSE.
         ENDIF
         IF (OCTAL) THEN
C
C An OCTAL has been encountered so contract and replace by a character
C
            ICODE = 64*(K - 48) + 8*(M - 48) + N - 48
            STRNG(J:J) = CHAR(ICODE)
            DO I = J + 1, L - 3
               K = I + 3
               STRNG(I:I) = STRNG(K:K)
            ENDDO
            DO I = L - 2, L
               STRNG(I:I) = BLANK
            ENDDO
            L = L - 3
         ENDIF
C
C Check if remaining string is long enough for another OCTAL
C
         M = J + 4
         IF (M.LE.L) THEN
            N = INDEX(STRNG(J + 1:L), BSLASH)
            IF (N.GT.0) THEN
C
C Repeat since another potential OCTAL has been encountered
C
               J = J + N
               SEARCH = .TRUE.
            ELSE
               SEARCH = .FALSE.
            ENDIF
         ELSE
            SEARCH = .FALSE.
         ENDIF
      ENDDO
      END
C
C
