c 
c---------------------------------------------------------------------------
c        
      subroutine smooth$ (n, nmax1,
     +                    x, y)
c
c action: input a polyline length n then a return it smoothed of length nsav
c author: w.g.bardsley, university of manchester, u.k.
c         29/04/2018 developed form contr1$
c     
     
      use module_j06sav, only : meth, nsav,
     +                          xmax, xmin, ymax, ymin, 
     +                          xsav, ysav,
     +                          zgxmin, zgxmax, zgymin, zgymax  
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: nmax1
      integer,          intent (inout) :: n
      double precision, intent (inout) :: x(nmax1), y(nmax1)
c
c locals
c      
      integer    i, ifail
      external   j06caf
      if (n.lt.2 .or. meth.eq.0) return
c
c initialise nsav to start a new smoothed polyline 
c        
      nsav = 0  
c
c calculate the range
c      
      xmax = x(1)
      xmin = x(1)
      ymax = y(1)
      ymin = y(1)
      do i = 2, n
         if (x(i).gt.xmax) xmax = x(i)
         if (x(i).lt.xmin) xmin = x(i)    
         if (y(i).gt.ymax) ymax = y(i)
         if (y(i).lt.ymin) ymin = y(i) 
      enddo
      zgxmin = xmin
      zgxmax = xmax
      zgymin = ymin
      zgymax = ymax
c
c call j06caf to calculate nsav, xsav, ysav
c      
      call j06caf (x, y, n, meth, ifail)
      if (ifail.ne.0) return
c
c overwrite the original n, x, y by nsav, xsav, ysav
c        
      n = min(nmax1,nsav)
      do i = 1, n
         x(i) = xsav(i)
         y(i) = ysav(i)
      enddo   
      end       
c
c------------------------------------------------------------------
c
      SUBROUTINE J06CAF(AX,AY,N,METHOD,IFAIL)
      use module_j06sav, only : icode1, icode2, ierror, kk, meth 
      
C     NAG GRAPHICAL SUPPLEMENT, MARK 1 RELEASE. NAG COPYRIGHT 1981.
C     NAG GRAPHICS LIBRARY, MARK 3 RE-ISSUE. NAG COPYRIGHT 1989.
C     NAG GRAPHICS LIBRARY, MARK 4 RE-ISSUE. NAG COPYRIGHT 1992.
C     Revised error handling - July 1988
C     Added SAVE statement
C     replaced J06VZF by J06VYF
C
C     DRAWS A SINGLE-VALUED CURVE THROUGH THE DATA POINTS
C     (AX(I),AY(I)), I=1,N.  THE TECHNIQUE USED IS TO ESTIMATE
C     THE SLOPE OF THE CURVE AT EACH DATA POINT.  THIS IS
C     SUFFICIENT TO DEFINE A CUBIC POLYNOMIAL IN EACH INTERVAL
C     BETWEEN DATA POINTS, GIVING IN ALL A PIECEWISE CUBIC
C     POLYNOMIAL WHICH PASSES THROUGH ALL THE DATA POINTS AND
C     HAS CONTINUOUS SLOPE (IE FIRST DERIVATIVE).  THIS
C     PIECEWISE CUBIC IS THEN APPROXIMATED BY STRAIGHT LINE
C     SEGMENTS WHICH ARE PASSED TO THE PLOTTING SOFTWARE.
C     THE USER IS GIVEN A CHOICE OF METHODS TO ESTIMATE
C     THE SLOPES AT THE DATA POINTS - SEE METHOD BELOW.
C
C     ROUTINE CREATED - MAY 1979
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C         AX,AY - ON ENTRY, AX(I),AY(I) HOLD X- AND Y-COORDS
C                 OF ITH DATA POINT.
C
C         N - ON ENTRY, N SPECIFIES NUMBER OF DATA POINTS.
C
C         METHOD - ON ENTRY, METHOD SPECIFIES METHOD TO BE USED
C                  TO ESTIMATE SLOPES AT DATA POINTS-
C                  METHOD = 1     MONOTONIC METHOD
C                  METHOD = 2     CUBIC BESSEL METHOD
C
C         IFAIL - NAG ERROR PARAMETER
C
C     NOTES -
C
C     IF TWO SUCCESSIVE X-COORDINATES ARE EQUAL, THE SECOND POINT
C     IS IGNORED.
C
C     .. Parameters ..
C     .. Scalar Arguments ..
      INTEGER           IFAIL, METHOD, N
C     .. Array Arguments ..
      DOUBLE PRECISION  AX(N), AY(N)
C     .. Scalars in Common ..
C      INTEGER           ICODE1, ICODE2, IERROR, KK
C     .. Local Scalars ..
      DOUBLE PRECISION  DELTAY, DUMMY, TOLX, XMAX, XMIN, YMAX, YMIN
      INTEGER           I, ICODE, ITOLF, MARGN
      LOGICAL           CHKERR
C     .. Local Arrays ..
C      CHARACTER*80      REC(2)
C     .. External Functions ..
      EXTERNAL          J06AAU, J06CBY
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, DBLE
C     .. Common blocks ..
C     COMMON            /CJ06CB/ICODE1, ICODE2, IERROR, KK
C     .. Save statement ..
C      SAVE              /CJ06CB/
C     .. Executable Statements ..
C
C     Validate input parameters
C
      IERROR = 0
      METHOD = METH
C
      IF (N.LT.2 .OR. METH.LT.1 .OR.METH.GT.2) THEN
         IFAIL = 1
         RETURN
      END IF
C
      IF (IERROR.EQ.0) THEN
C
C        COMPUTATION
C        -----------
C
C        SET ERROR TOLERANCE (DELTAY) AND GAP IN X-COORDS
C        CONSIDERED INSIGNIFICANT (TOLX).
C
         CALL J06AAU(XMIN,XMAX,YMIN,YMAX,ITOLF,MARGN)
         DELTAY = ABS(YMAX-YMIN)/DBLE(ITOLF)
         TOLX = 0.0D0
C
C        DRAW CURVE ONE POINT AT A TIME
C
         ICODE = METHOD
         CHKERR = .FALSE.
C
         DO 20 I = 1, N
C            IHOLD = I
            IF (I.EQ.N) ICODE = 9
            CALL J06CBY(AX(I),AY(I),ICODE,DUMMY,TOLX,DELTAY)
            IF (IERROR.NE.0) THEN
               CHKERR = .TRUE.
               GO TO 40
            END IF
            ICODE = 0
   20    CONTINUE
C
   40    CONTINUE
C
C        Report error if appropriate
C
         IF (CHKERR) THEN
            IERROR = 2
         END IF
      END IF
      IFAIL = IERROR
      RETURN
      END
c
c-------------------------------------------------------------------
c
      SUBROUTINE J06AAU(XMIN,XMAX,YMIN,YMAX,ITOLF,MARGN)
      use module_j06sav, only : intflg 
C     NAG GRAPHICS LIBRARY, MARK 4 RELEASE. NAG COPYRIGHT 1993.
C
C     NAG Graphical Interface - Generic Harness - double precision
C     ------------------------------------------------------------
C
C     Enquire the user data area limits and tolerance factor.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  XMAX, XMIN, YMAX, YMIN
      INTEGER           ITOLF, MARGN
C     .. Arrays in Common ..
C      LOGICAL           INTFLG(2)
C     .. External Subroutines ..
      EXTERNAL          J16AAU, J26AAU
C     .. Common blocks ..
C      COMMON            /ZJ06WA/INTFLG
C     .. Save statement ..
C      SAVE              /ZJ06WA/
C     .. Executable Statements ..
C
      IF (INTFLG(1)) THEN
         CALL J16AAU(XMIN,XMAX,YMIN,YMAX,ITOLF,MARGN)
      END IF
      IF (INTFLG(2)) THEN
         CALL J26AAU(XMIN,XMAX,YMIN,YMAX,ITOLF,MARGN)
      END IF
C
      RETURN
      END
c
c-----------------------------------------------------------------
c
      SUBROUTINE J06CBY(X,Y,ICODE,G,TOLX,DELTAY)
      use module_j06sav, only : icode1, icode2, ierror, kk, 
     +                          XA, XB, XC, YA, YB, YC, GA, GB, GC, 
     +                          SENSE,
     +                          MA, MB, MC, METH, NPT
      
C     NAG GRAPHICAL SUPPLEMENT, MARK 1 RELEASE. NAG COPYRIGHT 1981.
C     NAG GRAPHICS LIBRARY, MARK 3 RE-ISSUE. NAG COPYRIGHT 1989.
C     NAG GRAPHICS LIBRARY, MARK 4 RE-ISSUE. NAG COPYRIGHT 1992.
C     Added SAVE statement
C
C     DRAWS A SINGLE VALUED CURVE THROUGH A SET OF DATA POINTS,
C     THE ROUTINE BEING CALLED ONCE FOR EACH DATA POINT.
C     THE TECHNIQUE USED IS TO ESTIMATE THE SLOPE OF THE CURVE
C     AT EACH DATA POINT, THIS BEING DONE USING INFORMATION
C     FROM THE POINTS ON EITHER SIDE OF THE DATA POINT.  THUS
C     EACH CALL ESTIMATES THE SLOPE AT THE PREVIOUS POINT, AND
C     NOT THE POINT ITSELF (SPECIAL ACTION IS TAKEN AT THE
C     END-POINTS).  ONCE THE SLOPES AT TWO SUCCESSIVE DATA POINTS
C     ARE KNOWN, A CUBIC POLYNOMIAL IS FITTED IN THE INTERVAL
C     BETWEEN THE POINTS AND THEN PLOTTED.  A CHOICE OF TWO
C     METHODS IS AVAILABLE FOR ESTIMATING THE SLOPES, OR THE
C     USER CAN HIMSELF PRESCRIBE THE SLOPE AT (X,Y) (SEE ICODE
C     BELOW).
C
C     ROUTINE CREATED - MAY 1979
C     LATEST UPDATE   - JULY 1979
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C        X,Y     - ON ENTRY, X,Y SPECIFY COORDS OF NEXT DATA POINT.
C
C         ICODE - ON ENTRY, ICODE SPECIFIES INFORMATION CONCERNING
C                 THE POINT (X,Y).
C                 ASSUME FIRST THAT SLOPE AT (X,Y) IS TO BE ESTIMATED
C                 BY THE ROUTINE AND NOT SUPPLIED DIRECTLY BY USER.
C                 IF (X,Y) IS THE FIRST POINT, ICODE SHOULD BE SET TO
C                 1 OR 2, ACCORDING TO WHETHER THE MONOTONIC OR
C                 CUBIC BESSEL METHOD IS TO BE USED TO ESTIMATE SLOPES.
C                 IF (X,Y) IS AN INTERMEDIATE POINT, ICODE SHOULD BE
C                 SET TO 0.
C                 IF (X,Y) IS THE LAST POINT, ICODE SHOULD BE SET TO 9.
C                 FINALLY, IF THE USER HIMSELF IS SUPPLYING THE SLOPE
C                 AT (X,Y) IN G, THEN 10 SHOULD BE ADDED TO THE ABOVE
C                 VALUE OF ICODE.
C
C         G - ON ENTRY, G SPECIFIES THE SLOPE AT (X,Y) IF ICODE.GE.10.
C
C         TOLX - ON ENTRY, TOLX SPECIFIES THE DIFFERENCE IN
C                X-COORDINATES REGARDED AS INSIGNIFICANT.  IF X
C                DIFFERS BY LESS THAN TOLX FROM THE PREVIOUS
C                X-COORDINATE, (X,Y) IS IGNORED.  IF TOLX.LE.
C                100.0*X02ABF(T), THE LATTER VALUE IS USED INSTEAD.
C
C         DELTAY - ON ENTRY, DELTAY SPECIFIES ACCURACY OF STRAIGHT
C                  LINE APPROXIMATION TO PIECEWISE CUBIC.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  DELTAY, G, TOLX, X, Y
      INTEGER           ICODE
C     .. Scalars in Common ..
C      DOUBLE PRECISION  GA, GB, GC, SENSE, XA, XB, XC, YA, YB, YC
C      INTEGER           ICODE1, ICODE2, IERROR, KK, MA, MB, MC, METH,
C     *                  NPT
C     .. Local Scalars ..
      DOUBLE PRECISION  DX, DXSQ, DY
C     .. Local Arrays ..
      DOUBLE PRECISION  S(4)
C     .. External Subroutines ..
      EXTERNAL          J06CBZ, J06FAY, J06YAF, J06YCF
C     .. Common blocks ..
C      COMMON            /AJ06CB/XA, XB, XC, YA, YB, YC, GA, GB, GC,
C     *                  SENSE
C      COMMON            /BJ06CB/MA, MB, MC, METH, NPT
C      COMMON            /CJ06CB/ICODE1, ICODE2, IERROR, KK
C     .. Save statement ..
C      SAVE              /AJ06CB/, /BJ06CB/, /CJ06CB/
C     .. Executable Statements ..
C
C     DECIPHER ICODE
C
      ICODE1 = ICODE/10
      ICODE2 = ICODE - 10*ICODE1
C
C     INTERPOLATION
C     -------------
C
C     THE INTERPOLATION ROUTINE J06CBZ IS CALLED TO CALCULATE SLOPE
C     AT PREVIOUS POINT. IN THE SPECIAL CASE OF THE THIRD POINT OF
C     A CURVE, THE SLOPE AT THE FIRST POINT IS ADDITIONALLY CALCULATED
C     AND IN THE CASE OF THE LAST POINT, THE SLOPE AT THE LAST POINT
C     IS ALSO CALCULATED.
C
      CALL J06CBZ(X,Y,G,TOLX)
      IF (IERROR.NE.0) GO TO 60
C
C     GRAPHICAL OUTPUT STAGE
C     ----------------------
C
C     IF POINT IS FIRST POINT, NO DRAWING IS DONE
C
      IF (NPT.EQ.1) GO TO 60
C
C     FOR THIRD AND SUBSEQUENT POINTS, A CURVE IS DRAWN IN THE
C     PRECEDING INTERVAL, I.E. BETWEEN XA AND XB
C     NO CURVE IS DRAWN IF X-COORD IS NOT DISTINCT FROM
C     PREDECESSOR (IE KK=1)
C
      IF (NPT.LT.3) GO TO 20
      IF (KK.EQ.1) GO TO 20
      DX = XB - XA
      DY = YB - YA
      DXSQ = DX*DX
      S(1) = YA
      S(2) = GA
      S(3) = 2.0D0*(3.0D0*DY-(2.0D0*GA+GB)*DX)/DXSQ
      S(4) = 6.0D0*((GA+GB)*DX-2.0D0*DY)/(DXSQ*DX)
      CALL J06FAY(XA,XB,S,DELTAY)
C
C     IF POINT IS LAST POINT ON CURVE, THE FINAL PIECE IS DRAWN IN THE
C     INTERVAL (XB,XC).  IF THERE ARE ONLY TWO POINTS AND DERIVATIVE
C     INFORMATION IS NOT SUPPLIED, A STRAIGHT LINE IS DRAWN.
C
   20 CONTINUE
      IF (ICODE2.NE.9) GO TO 60
      IF (NPT.EQ.2 .AND. (MB.NE.1 .OR. MC.NE.1)) GO TO 40
      DX = XC - XB
      DY = YC - YB
      DXSQ = DX*DX
      S(1) = YB
      S(2) = GB
      S(3) = 2.0D0*(3.0D0*DY-(2.0D0*GB+GC)*DX)/DXSQ
      S(4) = 6.0D0*((GB+GC)*DX-2.0D0*DY)/(DXSQ*DX)
      CALL J06FAY(XB,XC,S,DELTAY)
      GO TO 60
C
   40 CONTINUE
      CALL J06YAF(XB,YB)
      CALL J06YCF(XC,YC)
C
   60 CONTINUE
      RETURN
      END
c
c----------------------------------------------------------------------
c
      SUBROUTINE J06FAY(XA,XB,S,DELTAY)
C     NAG GRAPHICAL SUPPLEMENT, MARK 1 RELEASE. NAG COPYRIGHT 1981.
C     NAG GRAPHICS LIBRARY, MARK 3 RE-ISSUE. NAG COPYRIGHT 1989.
C     NAG GRAPHICS LIBRARY, MARK 4 RE-ISSUE. NAG COPYRIGHT 1992.
C     Clip picture to the user's data region (GRERR41) - April 1992
C
C     PLOTS A CUBIC POLYNOMIAL
C         C(X) = S(1) + H*S(2) + H*H*S(3)/2.0 + H*H*H*S(4)/6.0
C     WHERE H=X-XA, IN THE INTERVAL (XA,XB).  THE STRAIGHT
C     LINE APPROXIMATION WHICH IS PLOTTED, P(X), SATISFIES
C           ABS( C(X)-P(X) ) .LE. DELTAY.
C
C     ROUTINE CREATED   24 MAY 1979
C     LATEST UPDATE
C     AUTHOR            K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS
C
C        XA,XB ... ON ENTRY, XA,XB SPECIFY END-POINTS OF
C                  INTERVAL OVER WHICH CUBIC IS TO BE PLOTTED.
C
C        S ....... ON ENTRY, S(I) HOLDS VALUE OF ITH DERIVATIVE
C                  OF C(X) AT XA.
C
C        DELTAY .. ON ENTRY, DELTAY SPECIFIES ACCURACY REQUIRED
C                  IN STRAIGHT LINE APPROXIMATION.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  DELTAY, XA, XB
C     .. Array Arguments ..
      DOUBLE PRECISION  S(4)
C     .. Local Scalars ..
      DOUBLE PRECISION  FM, H, HINC, HSTEP, S1, S2, S3, S4, SDER2, U, X,
     *                  Y
      INTEGER           J, M
C     .. External Subroutines ..
C      EXTERNAL          J06UAF, J06YAF
      external           j06yaf
C     .. Intrinsic Functions ..
      INTRINSIC         ABS, DBLE, INT, MAX, SQRT
C     .. Executable Statements ..
C
C
C     CALCULATE NUMBER OF STRAIGHT LINE PIECES NEEDED TO APPROXIMATE
C     CUBIC TO WITHIN GIVEN ACCURACY DELTAY
C
      H = XB - XA
      SDER2 = S(3) + H*S(4)
      U = MAX(ABS(S(3)),ABS(SDER2))
      M = INT(SQRT((U*H*H)/(8.0D0*DELTAY))+1.0D0)
      FM = M
      HINC = H/FM
C
C     PLOT CUBIC CURVE
C
      S1 = S(1)
      S2 = S(2)
      S3 = S(3)/2.0D0
      S4 = S(4)/6.0D0
      CALL J06YAF(XA,S1)
      DO 20 J = 1, M
         HSTEP = DBLE(J)*HINC
         X = XA + HSTEP
         Y = S1 + HSTEP*(S2+HSTEP*(S3+HSTEP*S4))
c         CALL J06UAF(X,Y)
         call j06yaf (x, y)
   20 CONTINUE
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE J06CBZ(X,Y,G,TOLX)
      use module_j06sav, only : icode1, icode2, ierror, kk, 
     +                          XA, XB, XC, YA, YB, YC, GA, GB, GC, 
     +                          SENSE,
     +                          MA, MB, MC, METH, NPT
      
C     NAG GRAPHICAL SUPPLEMENT, MARK 1 RELEASE. NAG COPYRIGHT 1981.
C     MARK 2C REVISED. IER-673  ( JANUARY 1989 )
C     NAG GRAPHICS LIBRARY, MARK 3 RE-ISSUE. NAG COPYRIGHT 1989.
C     NAG GRAPHICS LIBRARY, MARK 4 RE-ISSUE. NAG COPYRIGHT 1992.
C     Added SAVE statement
C
C     ESTIMATES SLOPE OF CURVE AT DATA POINT PREVIOUS TO (X,Y).
C     THE CALCULATION IS CARRIED OUT USING INFORMATION AT
C     (X,Y) (STORED AS (XC,YC)) AND THE TWO PREVIOUS POINTS
C     WHOSE COORDINATES ARE STORED AS (XA,YA) AND (XB,YB).
C
C     TWO METHODS ARE AVAILABLE FOR ESTIMATING THE SLOPE AT
C     (XB,YB) - MONOTONIC (METH=1) AND CUBIC BESSEL (METH=2).
C
C     IN THE MONOTONIC METHOD, THE SLOPE (GB) IS CALCULATED AS
C          1/GB = P/SP + (1-P)/SQ
C     WHERE SP IS THE SLOPE OF THE LINE JOINING (XA,YA), (XB,YB)
C     AND   SQ  .  .    .    .  .    .     .    (XB,YB), (XC,YC),
C     AND P = (2*(XC-XB)+(XB-XA))/(3*(XC-XA)),
C     UNLESS SP*SQ.LE.0.0, IN WHICH CASE GB=0.  THIS FORMULA
C     GUARANTEES THAT IF YA.LT.YB, THEN THE CUBIC POLYNOMIAL
C     CONSTRUCTED INCREASES MONOTONICALLY FROM XA TO XB.  AS A
C     CONSEQUENCE, ALL MAXIMA AND MINIMA OCCUR AT DATA POINTS,
C     AND THE GENERAL APPEARANCE IS OF A TIGHT CURVE.
C
C     IN THE CUBIC BESSEL METHOD, THE SLOPE (GB) IS CALCULATED AS
C     THE SLOPE OF A QUADRATIC PASSING THROUGH (XA,YA), (XB,YB),
C     (XC,YC), THE FORMULA BEING
C            GB = P*SP + (1-P)*SQ
C     WHERE SP AND SQ ARE AS ABOVE, BUT HERE
C            P = (XC-XB)/(XC-XA)
C     THE GENERAL APPEARANCE IS OF A MUCH LOOSER CURVE.
C
C     ALTERNATIVELY THE USER CAN HIMSELF SPECIFY THE SLOPE AT (X,Y)
C     IN THE VARIABLE G, HAVING SET ICODE1 IN /CJ06CB/ TO 1.  G IS
C     STORED FIRST IN GC, AND WHEN THE NEXT POINT IS REACHED, IT IS
C     TRANSFERRED TO GB AND USED DIRECTLY (INSTEAD OF EITHER OF THE
C     ABOVE FORMULAE).
C
C     SPECIAL ACTION IS TAKEN AT THE END-POINTS.  IF (X1,Y1), (X2,Y2),
C     (X3,Y3) ARE THE FIRST THREE POINTS, AN EXTRA POINT (X0,Y0) IS
C     CALCULATED, WHERE X0 IS SUCH THAT
C            X1-X0 = X3-X2
C     AND Y0 IS THE VALUE AT X0 OF A QUADRATIC PASSING THROUGH THE
C     FIRST THREE POINTS.  THIS ENABLES THE SLOPE AT (X1,Y1) TO BE
C     ESTIMATED IN THE SAME WAY AS AT INTERIOR DATA POINTS.  A
C     SIMILAR STRATEGY IS EMPLOYED AT THE OTHER END POINT.
C
C     THE X-COORDINATES MUST BE STRICTLY NON-DECREASING OR STRICTLY
C     NON-INCREASING.
C
C     IF TWO SUCCESSIVE X-VALUES DIFFER BY LESS THAN TOLX, THE
C     SECOND POINT IS IGNORED.
C
C     ROUTINE CREATED - MAY 1979.
C     LATEST UPDATE   - JULY 1979
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C        X,Y     - ON ENTRY, X,Y SPECIFY COORDS OF NEXT DATA POINT.
C
C         G - ON ENTRY, G SPECIFIES THE SLOPE AT (X,Y) IF ICODE1=1.
C
C         TOLX - ON ENTRY, TOLX SPECIFIES THE DIFFERENCE IN
C                X-COORDINATES REGARDED AS INSIGNIFICANT.  IF X
C                DIFFERS BY LESS THAN TOLX FROM THE PREVIOUS
C                X-COORDINATE, (X,Y) IS IGNORED.  IF TOLX.LE.
C                100.0*X02ABF(T), THE LATTER VALUE IS USED INSTEAD.
C
C     COMMON BLOCKS AJ06CB,BJ06CB,CJ06CB - EXPLANATION OF VARIABLES -
C
C        XA,XB,XC
C        YA,YB,YC   (X,Y) COORDS OF CURRENT POINT (XC,YC), PREVIOUS POIN
C                   (XB,YB) AND POINT PREVIOUS TO THAT, (XA,YA).
C
C        GA,GB,GC   SLOPES AT THE THREE POINTS.
C
C        MA,MB,MC   SET TO 0 IF SLOPE SUPPLIED BY USER,
C                   AND TO 1 IF SLOPE TO BE ESTIMATED BY ROUTINE.
C
C        METH       METHOD OF SLOPE ESTIMATION
C                    1 - MONOTONIC
C                    2 - CUBIC BESSEL
C
C        YEXTRA, GEXTRA, MEXTRA   Y-VALUE,SLOPE AND METHOD AT KNOT.
C
C        SENSE   1.0 IF X-COORDS INCREASING, -1.0 IF DECREASING.
C
C        NPT  RECORDS NUMBER OF POINTS PROCESSED
C
C        IERROR  ERROR FLAG.
C
C        ICODE1  ON ENTRY, INDICATES WHETHER SLOPE AT (X,Y) IS
C                SUPPLIED IN G (ICODE1=1) OR TO BE ESTIMATED
C                (ICODE1=0).
C
C        ICODE2  ON ENTRY, INDICATES WHETHER (X,Y) IS THE FIRST
C                POINT (ICODE2=1,2), AN INTERMEDIATE POINT
C                (ICODE2=0) OR THE LAST POINT(ICODE2=9).
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  G, TOLX, X, Y
C     .. Scalars in Common ..
C      DOUBLE PRECISION  GA, GB, GC, SENSE, XA, XB, XC, YA, YB, YC
C      INTEGER           ICODE1, ICODE2, IERROR, KK, MA, MB, MC, METH,
C     *                  NPT
C     .. Local Scalars ..
      DOUBLE PRECISION  SBEG, SEND, SP, SQ, XP, XQ, YP, YQ
C     .. External Subroutines ..
      EXTERNAL          J06CBX
C     .. Intrinsic Functions ..
      INTRINSIC         ABS
C     .. Common blocks ..
C      COMMON            /AJ06CB/XA, XB, XC, YA, YB, YC, GA, GB, GC,
C     *                  SENSE
C      COMMON            /BJ06CB/MA, MB, MC, METH, NPT
C      COMMON            /CJ06CB/ICODE1, ICODE2, IERROR, KK
C     .. Save statement ..
C      SAVE              /AJ06CB/, /BJ06CB/, /CJ06CB/
C     .. Executable Statements ..
C
C     THE FLAG KK IS SET INITIALLY TO 1 AND THEN ALTERED TO 0
C     IF X-COORD IS DISTINCT FROM PREVIOUS X-COORD.
C     IF POINT IS FIRST POINT ON CURVE, ITS COORDINATES AND THE
C     METHOD OF SLOPE APPROXIMATION ARE STORED AND THE POINT
C     COUNTER NPT IS SET TO 1
C
      KK = 1
      IF (ICODE2.LT.1 .OR. ICODE2.GT.2) GO TO 20
      XC = X
      YC = Y
      METH = ICODE2
      MC = ICODE1
      IF (MC.EQ.1) GC = G
      NPT = 1
      GO TO 120
C
C     IF X-COORDINATE DIFFERS BY LESS THAN TOLX FROM X-COORDINATE
C     OF PREVIOUS POINT, THEN THE POINT IS IGNORED.  OTHERWISE
C     THE POINT COUNTER IS UPDATED.  IF POINT IS THE SECOND
C     POINT ON THE CURVE, SENSE IS SET TO +1.0 IF POINTS ARE
C     INCREASING AND TO -1.0 IF POINTS ARE DECREASING.
C
   20 CONTINUE
      IF (ABS(X-XC).LE.TOLX) GO TO 100
      KK = 0
      NPT = NPT + 1
      IF (NPT.NE.2) GO TO 40
      SENSE = 1.0D0
      IF (X.LT.XC) SENSE = -1.0D0
      GO TO 60
C
C     A CHECK IS MADE THAT X-VALUES ARE MONOTONIC AND THEN
C     THE X,Y,G AND M VALUES ARE UPDATED
C
   40 CONTINUE
      IERROR = 2
      IF ((X-XC)*SENSE.LT.0.0D0) GO TO 120
      IERROR = 0
      XA = XB
      YA = YB
      MA = MB
      IF (NPT.GT.3 .OR. MA.EQ.1) GA = GB
C
   60 CONTINUE
      XB = XC
      YB = YC
      MB = MC
      IF (MB.EQ.1) GB = GC
      XC = X
      YC = Y
      MC = ICODE1
      IF (MC.EQ.1) GC = G
      IF (NPT.EQ.2) GO TO 120
C
C     THE SLOPE AT THE PREVIOUS POINT (XB,YB) IS CALCULATED
C
      IF (MB.EQ.1) GO TO 80
      XP = XB - XA
      YP = YB - YA
      XQ = XC - XB
      YQ = YC - YB
      SP = YP/XP
      SQ = YQ/XQ
      CALL J06CBX(XP,XQ,SP,SQ,METH,GB)
C
C     IN THE SPECIAL CASE OF THE THIRD POINT, THE SLOPE AT
C     THE FIRST POINT (XA,YA) IS ALSO CALCULATED
C
   80 CONTINUE
      IF (NPT.NE.3) GO TO 100
      IF (MA.EQ.1) GO TO 100
      SBEG = 2.0D0*SP - SQ
      CALL J06CBX(XQ,XP,SBEG,SP,METH,GA)
C
C     IN THE SPECIAL CASE (INDICATED BY ICODE2=9) WHERE
C     (XC,YC) IS THE LAST POINT OF THE CURVE,
C     THE SLOPE AT (XC,YC) IS ALSO CALCULATED....
C     OTHERWISE A RETURN IS MADE
C
  100 CONTINUE
      IF (ICODE2.NE.9 .OR. NPT.LE.2) GO TO 120
      IF (MC.EQ.1) GO TO 120
      XP = XB - XA
      YP = YB - YA
      XQ = XC - XB
      YQ = YC - YB
      SP = YP/XP
      SQ = YQ/XQ
      SEND = 2.0D0*SQ - SP
      CALL J06CBX(XQ,XP,SQ,SEND,METH,GC)
  120 CONTINUE
      RETURN
      END
c
c---------------------------------------------------------------
c
      SUBROUTINE J06CBX(XP,XQ,SP,SQ,METHOD,G)
      use module_j06sav, only : x02akf_j06
            
C     NAG GRAPHICAL SUPPLEMENT, MARK 1 RELEASE. NAG COPYRIGHT 1981.
C     NAG GRAPHICS LIBRARY, MARK 3 RE-ISSUE. NAG COPYRIGHT 1989.
C     NAG GRAPHICS LIBRARY, MARK 4 RE-ISSUE. NAG COPYRIGHT 1992.
C     Replaced X02ABF by X02AKF
C
C     ESTIMATES THE SLOPE OF THE CURVE AT A DATA POINT BY EITHER
C     THE MONOTONIC METHOD (METHOD=1) OR THE CUBIC BESSEL METHOD
C     (METHOD=2) FROM THE SLOPE OF CHORDS JOINING THE DATA POINT
C     TO ITS NEIGHBOURS ON EITHER SIDE.
C
C     ROUTINE CREATED - JULY 1979
C     AUTHOR          - K.W. BRODLIE, LEICS UNIV.
C
C     PARAMETERS -
C
C        XP,XQ ... ON ENTRY, XP,XQ SPECIFY THE X-INTERVALS TO EITHER
C                  SIDE OF THE DATA POINT.
C
C        SP,SQ ... ON ENTRY, SP,SQ SPECIFY THE SLOPES OF THE CHORDS
C                  JOINING THE DATA POINT TO ITS NEIGHBOUR ON EITHER
C                  SIDE.
C
C        METHOD ... ON ENTRY, METHOD SPECIFIES THE METHOD OF SLOPE
C                   ESTIMATION (SEE ABOVE).
C
C        G ... ON EXIT,G CONTAINS THE ESTIMATED SLOPE.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  G, SP, SQ, XP, XQ
      INTEGER           METHOD
C     .. Local Scalars ..
      DOUBLE PRECISION  SMALL
C     .. Executable Statements ..
C
      IF (METHOD.EQ.2) GO TO 20
C
C     MONOTONIC METHOD
C
      SMALL = 100.0D0*X02AKF_J06
      G = 0.0D0
      IF (SP*SQ.GT.SMALL) G = 3.0D0*(XP+XQ)/((2.0D0*XP+XQ)
     *                        /SQ+(XP+2.0D0*XQ)/SP)
      RETURN
C
C     CUBIC BESSEL METHOD
C
   20 CONTINUE
      G = (XQ*SP+XP*SQ)/(XP+XQ)
      RETURN
      END

      SUBROUTINE J26AAU(XMIN,XMAX,YMIN,YMAX,ITOLF,MARGN)
      use module_j06sav, only : zgxmin, zgxmax, zgymin, zgymax, ngmarg, 
     +                          zgcscw, zgcsch, zgamsc, ngpen, ngtolf,
     +                          ngcqu 
      
C     NAG GRAPHICS LIBRARY, MARK 4 RELEASE. NAG COPYRIGHT 1993.
C
C     NAG Graphical Interface - Adobe PostScript Harness - double prec.
C     -----------------------------------------------------------------
C
C     Enquire the user data area limits and tolerance factor.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  XMAX, XMIN, YMAX, YMIN
      INTEGER           ITOLF, MARGN
C     .. Scalars in Common ..
C      DOUBLE PRECISION  ZGAMSC, ZGCSCH, ZGCSCW, ZGXMAX, ZGXMIN, ZGYMAX,
C     *                  ZGYMIN
C      INTEGER           NGCQU, NGMARG, NGTOLF
C     .. Arrays in Common ..
C      INTEGER           NGPEN(4,3)
C     .. Common blocks ..
C      COMMON            /AJ06XA/ZGXMIN, ZGXMAX, ZGYMIN, ZGYMAX, NGMARG
C      COMMON            /BJ26XA/ZGCSCW, ZGCSCH, ZGAMSC, NGPEN, NGTOLF,
C     *                  NGCQU
C     .. Save statement ..
C      SAVE              /AJ06XA/, /BJ26XA/
C     .. Executable Statements ..
C
      XMIN = ZGXMIN
      XMAX = ZGXMAX
      YMIN = ZGYMIN
      YMAX = ZGYMAX
      ITOLF = NGTOLF
      MARGN = NGMARG
      RETURN
      END
c
c-----------------------------------------------------------------------
c
      SUBROUTINE J16AAU(XMIN,XMAX,YMIN,YMAX,ITOLF,MARGN)
      use module_j06sav, only : zgxmin, zgxmax, zgymin, zgymax, ngmarg, 
     +                          zgcscw, zgcsch, zgamsc, ngpen, ngtolf,
     +                          ngcqu 
C     NAG GRAPHICS LIBRARY, MARK 4 RELEASE. NAG COPYRIGHT 1993.
C
C     NAG Graphical Interface - X - double to single precision
C     --------------------------------------------------------
C
C     Enquire the user data area limits and tolerance factor.
C
C     .. Scalar Arguments ..
      DOUBLE PRECISION  XMAX, XMIN, YMAX, YMIN
      INTEGER           ITOLF, MARGN
C     .. Scalars in Common ..
C      DOUBLE PRECISION  ZGAMSC, ZGCSCH, ZGCSCW, ZGXMAX, ZGXMIN, ZGYMAX,
C     *                  ZGYMIN
C      INTEGER           NGCQU, NGMARG, NGTOLF
C     .. Arrays in Common ..
C      INTEGER           NGPEN(4,3)
C     .. Common blocks ..
C      COMMON            /AJ06XA/ZGXMIN, ZGXMAX, ZGYMIN, ZGYMAX, NGMARG
C      COMMON            /BJ16XA/ZGCSCW, ZGCSCH, ZGAMSC, NGPEN, NGTOLF,
C     *                  NGCQU
C     .. Save statement ..
C      SAVE              /AJ06XA/, /BJ16XA/
C     .. Executable Statements ..
C
      XMIN = ZGXMIN
      XMAX = ZGXMAX
      YMIN = ZGYMIN
      YMAX = ZGYMAX
      ITOLF = NGTOLF
      MARGN = NGMARG
      RETURN
      END
