C
C
      SUBROUTINE SMPLOT$(JFILES, LFILES, MFILES, NFILES,
     +                   FILES, TITLES)
C
C ACTION  : Supply coordinate files and create a normal x,y graph
C AUTHOR  : W. G. Bardsley, University of Manchester, U.K.
C           Derived from SIMPLOT 12/03/2001
C           01/06/2001 increased NWORDS from 100 to 300
C           28/09/2002 increased NWORDS from 300 to 500
C           07/10/2002 increased NWORDS from 500 to 1000
C           07/01/2003 redimensioned WIDE(5*NGRAFS)
C           21/10/2004 added call to SYMBOL
C           11/07/2005 increased NWORDS from 1000 to 2000
C           22/06/2006 introduced isitmf and allocatable arrays
C           23/04/2007 added INTENTS
C           01/01/2008 added NXTRA 
C           15/01/2008 redimensioned so NMAX >= 10000 
C           30/07/2009 added call to TMPDEL to delete f$123456.tmp files
C           02/11/2010 added SIZE and WIDE to argument list to SYMBOL
C           01/12/2010 added call to LABEL 
C           04/12/2010 increased dimension in call to SYMBOL to 15
C           28/12/2010 added call to TXTKEY
C           19/01/2011 no longer deletes files supplied
C           06/07/2011 added WORDX and VECTORS in call to LABELS
C           12/07/2011 added WORDY to TXTKEY argument list
C           26/09/2011 made IFILL, IHUE, and FACTOR size NXTRA = NWORDS
C           25/08/2014 ensured arguments are saved/restored for calls to W_SYMBOL
C
C           JFILES: (input/unchanged) = JCOLOR vector (colours)
C           LFILES: (input/unchanged) = L vector (line types)
C           MFILES: (input/unchanged) = M vector (symbol types)
C           NFILES: (input/unchanged) = NFILE1 (no. files)
C            FILES: (input/unchanged) = FSAV (coordinate files)
C           TITLES: (input/unchanged) = title, x-, y-, z-legends
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN) :: NFILES
      INTEGER,             INTENT (IN) :: JFILES(NFILES), 
     +                                    LFILES(NFILES),
     +                                    MFILES(NFILES)
      CHARACTER (LEN = *), INTENT (IN) :: FILES(NFILES), TITLES(4)
C
C Locals
C
      INTEGER    KPANEL, NFILE1, NGRAFS, NGRAF2, NGRAF3, NGRAF4,
     +           NIN, NMAX, NWORDS, NXTRA
      PARAMETER (NGRAFS = 300, NGRAF2 = 2*NGRAFS, NGRAF3 = 3*NGRAFS,
     +           NGRAF4 = 4*NGRAFS, KPANEL = NGRAFS, NIN = 3,
     +           NWORDS = 2000, NXTRA = NWORDS)
      INTEGER    ISEND, JSEND
      PARAMETER (ISEND = 1, JSEND = 4)
      INTEGER    N0, N1, N20, N40, N60
      PARAMETER (N0 = 0, N1 = 1, N20 = 20, N40 = 40, N60 = 60)
      INTEGER    JCOLOR(NGRAFS), L(NGRAFS), M(NGRAFS), NSAV(NGRAFS)
      INTEGER    J_SAV(20), K_SAV(20), L_SAV(20), M_SAV(20)
      INTEGER    I, NCOL, NMAX1, NROW
      INTEGER    IFILL(NXTRA), IHUE(NXTRA)
      DOUBLE PRECISION SIZE(NGRAFS), WIDE(5*NGRAFS)
      DOUBLE PRECISION SIZE_SAV(20), WIDE_SAV(20)
      DOUBLE PRECISION FACTOR(NXTRA)
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      CHARACTER  FSAV(NGRAFS)*1024, FSAV1(NGRAFS)*1024,
     +           LABEL1(NWORDS)*40,
     +           LABVEC(NWORDS)*40, PLINE(KPANEL)*40, PSYMB(KPANEL)*40,
     +           TSAV(NGRAFS)*80, WORDX(NWORDS)*40, WORDY(NWORDS)*40,
     +           VECTORS(N60)*40 
      CHARACTER  BLANK*1, ZERO40*40
      PARAMETER (BLANK = ' ',
     +           ZERO40 = '0000000000000000000000000000000000000000')
      LOGICAL    TYPE_IN
      LOGICAL    BARCAP(NGRAFS), BARCAP_1, BAR_CHART, LIB_FILE,
     +           LOWER(NGRAFS), PIE_CHART, PLOTX(NWORDS), PLOTY(NWORDS),
     +           PLOTZ(NWORDS), PSHOW(KPANEL), SUPPLY_XY, TWO_PLOTS,
     +           UPPER(NGRAFS), VECTOR_FIELD, YAXIS(NGRAFS)
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   GKSGRF$, SYMBOL, ISITMF, TMPDEL, LABELS, TXTKEY
      EXTERNAL   DEFGKS$, PLTOBJ$

C
C Initialise gks and graphical objects
C
      IF (NFILES.LT.N1) RETURN
      CALL DEFGKS$
      CALL PLTOBJ$(N1, N1)
C
C Allocate workspaces
C
      NMAX = NWORDS
      DO I = N1, NFILES
         CALL ISITMF (NCOL, NROW,
     +                FILES(I))
         IF (NROW.GT.NMAX) NMAX = NROW
      ENDDO
C
C Initialise all the array variables (except for coordinates)
C
      BARCAP_1 = .TRUE.
      DO I = N1, KPANEL
         PLINE(I) = BLANK
         PSYMB(I) = ZERO40
         PSHOW(I) = .TRUE.
      ENDDO
      DO I = N1, NGRAFS
         JCOLOR(I) = N0
         L(I) = N1
         M(I) = N1
         NSAV(I) = N1
         SIZE(I) = ONE
         WIDE(I) = ONE
         WIDE(I + NGRAFS) = ONE
         WIDE(I + NGRAF2) = ONE
         WIDE(I + NGRAF3) = ONE
         WIDE(I + NGRAF4) = ONE
         FSAV(I) = BLANK
         FSAV1(I) = BLANK
         TSAV(I) = BLANK
         BARCAP(I) = .TRUE.
         LOWER(I) = .TRUE.
         UPPER(I) = .TRUE.
         YAXIS(I) = .TRUE.
      ENDDO
      DO I = N1, NWORDS
         LABEL1(I) = BLANK
         LABVEC(I) = ZERO40
         WORDX(I) = BLANK
         WORDY(I) = BLANK
         PLOTX(I) = .TRUE.
         PLOTY(I) = .TRUE.
         PLOTZ(I) = .TRUE.
      ENDDO
      DO I = N1, NXTRA
         IFILL(I) = N1
         IHUE(I) = N0
         FACTOR(I) = ONE
      ENDDO  
C
C Retrieve the default arguments using ISEND = 1
C
      CALL LABELS (ISEND, IHUE, IFILL,
     +             LABEL1, PLINE, WORDX, VECTORS) 
      DO I = N1, N20
         LABVEC(I) = VECTORS(I)
         PSYMB(I) = VECTORS(I + N20)
         WORDY(I) = VECTORS(I + N40)
      ENDDO                   
      CALL SYMBOL (ISEND, J_SAV, K_SAV, L_SAV, M_SAV,
     +             SIZE_SAV, WIDE_SAV)
      DO I = N1, N20
         JCOLOR(I) = J_SAV(I)
         L(I) = L_SAV(I)
         M(I) = M_SAV(I)
      ENDDO   
      CALL TXTKEY (LABVEC, PSYMB, WORDY,
     +             STORE) 
C
C Copy the data supplied into the arguments to GKSGRF$ then call GKSGRF$
C
      NFILE1 = NFILES
      DO I = N1, NFILE1
         JCOLOR(I) = JFILES(I)
         L(I) = LFILES(I)
         M(I) = MFILES(I)
         FSAV(I) = FILES(I)
      ENDDO
C
C Over-ride the defaults using JSEND = 4
C 
      CALL SYMBOL (JSEND, JCOLOR, K_SAV, L, M,
     +             SIZE_SAV, WIDE_SAV)     
      BAR_CHART = .FALSE.
      LIB_FILE = .FALSE.
      PIE_CHART = .FALSE.
      SUPPLY_XY = .TRUE.
      TWO_PLOTS = .FALSE.
      TYPE_IN = .FALSE.
      VECTOR_FIELD = .FALSE.

      NMAX1 = NMAX
      
      CALL GKSGRF$(IFILL, IHUE, JCOLOR, KPANEL, L, M, NFILE1,
     +             NGRAFS, NIN, NMAX1, NSAV, NWORDS, NXTRA,
     +             FACTOR, SIZE, WIDE, 
     +             FSAV, FSAV1, LABEL1, LABVEC, PLINE, PSYMB,
     +             TSAV, TITLES, WORDX, WORDY,
     +             BARCAP, BARCAP_1, BAR_CHART, LIB_FILE, LOWER,
     +             PIE_CHART, PLOTX, PLOTY, PLOTZ, PSHOW,
     +             SUPPLY_XY, TWO_PLOTS, TYPE_IN, UPPER,
     +             VECTOR_FIELD, YAXIS)
C
C Delete all temporary files of the type f$123456.tmp used for plotting 
C
      CALL TMPDEL (NFILES,
     +             FSAV1)  
C
C Restore the default arguments using JSEND = 4
C
      CALL SYMBOL (JSEND, J_SAV, K_SAV, L_SAV, M_SAV,
     +             SIZE_SAV, WIDE_SAV)          
      END
C
C
