C
C Special version of SPACE1 for RANNUM
C
      SUBROUTINE SPACE0$(NPTSAV, NRMAX,
     +                   XSAV, XTEMP, YSAV, YTEMP, ZSAV)
C
C ACTION : Draw a 3D space curve
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 8/4/98
C          Derived from SPACE1
C          30/10/1998 removed NX, NY
C          20/11/1998 added call to DEFGKS to initialise parameters in
C                     defngks.ins
C          21/02/2001 introduced NFULL, NXGRID, NYGRID, NZGRID, NPERP
C          24/07/2001 corrected error due to not re-initialising after
C                     each rotation
C          03/09/2001 added call to PSSPEC$
C          09/11/2001 added XMAX1, XMIN1, YMAX1, YMIN1, ZMAX1, ZMIN1 and
C                     SMALL
C          07/07/2006 introduced allocatable arrays  
C          23/04/2007 added INTENTS
C          05/01/2014 checked for NPRESS = 24 
C          15/01/2014 added call to SAVQUE$ 
C
C          NPTSAV: (input/unchanged) no. of points to be plotted (>= 1)
C           NRMAX: (input/unchanged) array size (>= NPTSAV)
C            XSAV: (input/unchanged) x(t)-data
C           XTEMP: workspace 
C            YSAV: (input/unchanged) y(t)-data
C           YTEMP: workspace
C            ZSAV: (input/unchanged) z(t)-data  
C
      IMPLICIT   NONE    
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NPTSAV, NRMAX
      DOUBLE PRECISION, INTENT (IN)    :: XSAV(NRMAX), YSAV(NRMAX),
     +                                    ZSAV(NRMAX) 
      DOUBLE PRECISION, INTENT (INOUT) :: XTEMP(NRMAX), YTEMP(NRMAX)
C
C Local allocatable arrays
C    
      DOUBLE PRECISION, ALLOCATABLE :: X(:), XZERO(:), Y(:),
     +                                 YZERO(:), Z(:)  
C
C Locals
C     
      INTEGER    NPRESS
      INTEGER    NDIVS(3), NFULL, NXGRID, NYGRID, NZGRID
      INTEGER    I, IERR, ITIME, J
      INTEGER    NTYPE, NXTEXT, NYTEXT, NZTEXT
      INTEGER    KMODE, NFILES, NGRAFS, NGRAF5
      PARAMETER (KMODE = 1, NFILES = 1, NGRAFS = 1, NGRAF5 = 5*NGRAFS)
      INTEGER    IU, IV, IW, NBIG, N0, N1, N2, N3, N4, N5, N6, N7,
     +           N8, N9, N10, N11, N12, N13, N14, N15, N16, N17, N24
      PARAMETER (IU = 45, IV = 45, IW = 55, NBIG = 16, N0 = 0, N1 = 1,
     +           N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7,
     +           N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12, N13 = 13,
     +           N14 = 14, N15 = 15, N16 = 16, N17 = 17, N24 = 24)
      INTEGER    NPTS, NXSAV, NYSAV, NZSAV
      INTEGER    ICOLOR(8), ITHETA
      INTEGER    L(NGRAFS), LCOLOR(NGRAFS), M(NGRAFS), MCOLOR(NGRAFS),
     +           NPERP(NGRAFS), NTEMP
      INTEGER    NKLCFG, KVAL_12
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN, ZMAX, ZMIN
      DOUBLE PRECISION XMAX1, XMIN1, YMAX1, YMIN1, ZMAX1, ZMIN1
      DOUBLE PRECISION XDIFF, YDIFF, ZDIFF
      DOUBLE PRECISION X5(N5), Y5(N5)
      DOUBLE PRECISION SIZE1(NGRAFS), WIDE(NGRAF5)
      DOUBLE PRECISION ONE, R2BIG, ZERO
      PARAMETER (ONE = 1.0D+00, R2BIG = 99999.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION ATEMP, CTEMP, SMALL
      PARAMETER (ATEMP = 1.0D+00, CTEMP = 1.0D+00, SMALL = 1.0D-100)
      DOUBLE PRECISION XCLIP(2), YCLIP(2)
      CHARACTER  ARRAYT*(IW), ARRAYX*(IV), ARRAYY*(IV), ARRAYZ*(IV),
     +           PTITLE*(IW), XTITLE*(IV), YTITLE*(IV), ZTITLE*(IV),
     +           TITLEP*(IW), TITLEX*(IV), TITLEY*(IV), TITLEZ*(IV)
      CHARACTER  XTEXT(NBIG)*(IU), YTEXT(NBIG)*(IU), ZTEXT(NBIG)*(IU),
     +           XTEXT1(NBIG)*(IU), YTEXT1(NBIG)*(IU),
     +           ZTEXT1(NBIG)*(IU)
      CHARACTER  FNAME(NGRAFS)*1024, FTITLE(NGRAFS)*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    AXES(2), FRAME, FULL
      LOGICAL    ABORT, ARROWS(3), FIRST, GSAVE, LABELS(3),
     +           NEWRUN, NUMBER(3), TICKS(3), XTSHOW,
     +           X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT
C
C Parameters from DLL in common block in DEFNGKS.INS
C
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS, QUIT
      EXTERNAL   GKSDEK$, GETDEF$, GSELNT$, AFRAME$, GKSDRW$, GKSSYM$,
     +           SURAAA$, SURBBB$, SURCCC$, GSLN$, GSLWSC$, LINE$,
     +           SUR002$, PUTFAT$, 
     +           SPACE2$, SPACE3$, SPACE4$, XYZ2XY$,
     +           FILL_POLYGON$, DEFGKS$, PSSPEC$, GRAPHQ, NKLCFG
      INTRINSIC  MIN, ABS
      SAVE       ICOLOR, ITHETA, L, LCOLOR, M, MCOLOR, NTYPE,
     +           SIZE1, WIDE,
     +           ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +           PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1, YTITLE,
     +           ZTEXT, ZTEXT1, ZTITLE,
     +           ARROWS, AXES, FRAME, FULL, LABELS,
     +           NEWRUN, NUMBER, X2INT, Y2INT, ZTSHOW, Z2INT
C
C Default settings
C

      DATA NXSAV, NYSAV, NZSAV / NBIG, NBIG, NBIG /
      DATA ICOLOR / 15,  0,  0,  0,  0, 0, 0, 0 /
      DATA L / NGRAFS*1 /
      DATA LCOLOR / NGRAFS*0 /
      DATA M / NGRAFS*5 /
      DATA MCOLOR / NGRAFS*0 /
      DATA SIZE1 / NGRAFS*ONE /
      DATA WIDE / NGRAF5*ONE /
      DATA FNAME /NGRAFS*BLANK /
      DATA FTITLE /NGRAFS*BLANK /
      DATA PTITLE / 'SIMFIT 3D space plot (x,y,z)' /
      DATA ARRAYT / '0000000000000000000000000000' /
      DATA XTITLE / 'X' /
      DATA ARRAYX / '0' /
      DATA YTITLE / 'Y' /
      DATA ARRAYY / '0' /
      DATA ZTITLE / 'Z' /
      DATA ARRAYZ / '0' /
      DATA AXES / .TRUE., .TRUE. /
      DATA FRAME / .FALSE. /
      DATA FULL / .TRUE. /
      DATA ITHETA / 0 /
      DATA NTYPE / 1 /
      DATA NXTEXT, NYTEXT, NZTEXT / NBIG, NBIG, N2 /
      DATA XTSHOW, YTSHOW, ZTSHOW / .FALSE., .FALSE., .TRUE. /
      DATA X2INT, Y2INT, Z2INT / .FALSE., .FALSE., .FALSE. /
      DATA X5 / ZERO, ONE, ONE, ZERO, ZERO /
      DATA Y5 / ZERO, ZERO, ONE, ONE, ZERO /
      DATA NEWRUN / .TRUE. /
      DATA NPERP / NGRAFS*0 /
      DATA NFULL, NXGRID, NYGRID, NZGRID / N3, N3, N3, N3 /
C
C Define NPTS, X, Y, Z
C
      NPTS = MIN(NPTSAV, NRMAX)       
      IF (NPTS.LT.1) RETURN  
      
      IERR = N0
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(XZERO)) DEALLOCATE(XZERO, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(YZERO)) DEALLOCATE(YZERO, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.N0) RETURN        
      ALLOCATE(X(NPTS), STAT = IERR)
      IF (IERR.NE.N0) RETURN 
      ALLOCATE(XZERO(NPTS), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(Y(NPTS), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(YZERO(NPTS), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(Z(NPTS), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      
      DO I = 1, NPTS
         X(I) = XSAV(I)
         Y(I) = YSAV(I)
         Z(I) = ZSAV(I)
      ENDDO
      XCLIP(1) = ZERO
      XCLIP(2) = ONE
      YCLIP(1) = ZERO
      YCLIP(2) = ONE
      IF (NEWRUN) THEN
C
C Initialise DEFGGKS.INS
C
         CALL DEFGKS$
C
C Extra defaults to be set up the first time round
C
         DO I = N1, NBIG
            WRITE (XTEXT(I),100) 'x', I
            WRITE (YTEXT(I),100) 'y', I
            WRITE (ZTEXT(I),100) 'z', I
            XTEXT1(I) = '000000000'
            YTEXT1(I) = '000000000'
            ZTEXT1(I) = '000000000'
         ENDDO
         DO I = N1, N3
            ARROWS(I) = .TRUE.
            LABELS(I) = .FALSE.
            NUMBER(I) = .TRUE.
         ENDDO
         NXTEXT = N2
         NYTEXT = N2
         NZTEXT = N2
         XTSHOW = .TRUE.
         YTSHOW = .TRUE.
         ZTSHOW = .TRUE.
         NEWRUN = .FALSE.
      ENDIF
C
C Calculate parameters for scaling
C
      XMAX = X(1)
      XMIN = X(1)
      YMAX = Y(1)
      YMIN = Y(1)
      ZMAX = Z(1)
      ZMIN = Z(1)
      DO J = N1, NPTS
         IF (X(J).GT.XMAX) XMAX = X(J)
         IF (X(J).LT.XMIN) XMIN = X(J)
         IF (Y(J).GT.YMAX) YMAX = Y(J)
         IF (Y(J).LT.YMIN) YMIN = Y(J)
         IF (Z(J).GT.ZMAX) ZMAX = Z(J)
         IF (Z(J).LT.ZMIN) ZMIN = Z(J)
      ENDDO
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      ZDIFF = ZMAX - ZMIN
      IF (ABS(XDIFF).LE.SMALL .OR.
     +    ABS(YDIFF).LE.SMALL .OR.
     +    ABS(ZDIFF).LE.SMALL) THEN
          CALL PUTFAT$ ('Range too small to plot') 
          DEALLOCATE(X, STAT = IERR) 
          DEALLOCATE(XZERO, STAT = IERR)
          DEALLOCATE(Y, STAT = IERR)
          DEALLOCATE(YZERO, STAT = IERR)
          DEALLOCATE(Z, STAT = IERR)
          RETURN
      ENDIF
C
C Store the data limits
C
      XMAX1 = XMAX
      XMIN1 = XMIN
      YMAX1 = YMAX
      YMIN1 = YMIN
      ZMAX1 = ZMAX
      ZMIN1 = ZMIN
C
C
C Subsidiary branch point ............................................
C
   20 CONTINUE
      CALL SPACE3$(ICOLOR, ITHETA, L, LCOLOR, M, MCOLOR, NBIG,
     +             NFILES, NFULL, NGRAFS, NPERP, NTYPE, NXGRID, NXSAV,
     +             NXTEXT, NYGRID, NYSAV, NYTEXT, NZGRID, NZSAV, NZTEXT,
     +             SIZE1, WIDE, XMAX, XMAX1, XMIN, XMIN1, YMAX, YMAX1,
     +             YMIN, YMIN1, ZMAX, ZMAX1, ZMIN, ZMIN1,
     +             ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +             FNAME, FTITLE,
     +             PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1, YTITLE,
     +             ZTEXT, ZTEXT1, ZTITLE,
     +             AXES, ARROWS, FRAME, FULL, LABELS, NUMBER,
     +             XTSHOW, X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT)
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      ZDIFF = ZMAX - ZMIN
C
C Return to start if NTYPE out of range
C
      IF (NTYPE.LT.1) THEN
         DEALLOCATE(X, STAT = IERR) 
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(Y, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR)
         DEALLOCATE(Z, STAT = IERR)
         RETURN
      ENDIF   
      IF (X2INT .AND. XMAX.GT.R2BIG) X2INT = .FALSE.
      IF (X2INT .AND. XMIN.LT.-R2BIG) X2INT = .FALSE.
      IF (Y2INT .AND. YMAX.GT.R2BIG) Y2INT = .FALSE.
      IF (Y2INT .AND. YMIN.LT.-R2BIG) Y2INT = .FALSE.
      IF (Z2INT .AND. ZMAX.GT.R2BIG) Z2INT = .FALSE.
      IF (Z2INT .AND. ZMIN.LT.-R2BIG) Z2INT = .FALSE.
C
C Data are ready so now proceed to create the graph
C
      ABORT = .FALSE.
      FIRST = .TRUE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
C
C Branch point for hardcopy from GKSDEK$ ............................
C
   40 CONTINUE
C
C Define transformations and open graphics
C
      CALL SUR002$(KMODE)
      IF (ICOLOR(1).NE.0) THEN
         CALL GSELNT$(N0)
         CALL FILL_POLYGON$(N5, X5, Y5, ICOLOR(1))
      ENDIF
      IF (PS) CALL PSSPEC$(N2, NOUT_PS)

C
C Draw axes for plot
C
      DO I = N1, N3
         NDIVS(I) = 0
         TICKS(I) = .FALSE.
      ENDDO
      IF (ITHETA.EQ.0 .OR. ITHETA.EQ.180) THEN
C********Editing 23/07/2001 to allow multiple tick marks with numbers
C********IF (.NOT.LABELS(1)) THEN
            TICKS(1) = .TRUE.
C********ELSE
            NDIVS(1) = NXTEXT
C********ENDIF
C********IF (.NOT.LABELS(2)) THEN
            TICKS(2) = .TRUE.
C********ELSE
            NDIVS(2) = NYTEXT
C********ENDIF
      ELSE
C********IF (.NOT.LABELS(2)) THEN
            TICKS(1) = .TRUE.
C********ELSE
            NDIVS(1) = NYTEXT
C********ENDIF
C********IF (.NOT.LABELS(1)) THEN
            TICKS(2) = .TRUE.
C********ELSE
            NDIVS(2) =  NXTEXT
C********ENDIF
      ENDIF
C*****IF (.NOT.LABELS(3)) THEN
          TICKS(3) = .TRUE.
C*****ELSE
          NDIVS(3) = NZTEXT
C*****ENDIF
      ITIME = N1
      CALL SPACE2$(ICOLOR(3), ITIME, NDIVS, NFULL, NXGRID, NYGRID,
     +             NZGRID, AXES, FULL, TICKS)
      CALL AFRAME$(ICOLOR(3), FRAME, PS)
C
C Title and legends
C
      TITLEP = PTITLE
      TITLEX = XTITLE
      TITLEY = YTITLE
      TITLEZ = ZTITLE
      CALL SURAAA$(ICOLOR(4), NOUT_PS, Y_SCALE, ARRAYT, TITLEP,
     +             HARD_COPY, HPGL, PS)
      CALL SURBBB$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, Y_SCALE,
     +             ARRAYX, ARRAYY, ARRAYZ, TITLEX, TITLEY, TITLEZ,
     +             ARROWS, HARD_COPY, HPGL, LABELS, PS, XTSHOW,
     +             YTSHOW, ZTSHOW)
      CALL SURCCC$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, NXTEXT, NYTEXT,
     +             NZTEXT,
     +             XMAX, XMIN, YMAX, YMIN, Y_SCALE, ZMAX, ZMIN,
     +             XTEXT, XTEXT1, YTEXT, YTEXT1, ZTEXT, ZTEXT1,
     +             HARD_COPY, HPGL, LABELS, NUMBER, PS, X2INT,
     +             Y2INT, Z2INT)
C
C Draw the lines if L(1) > 0
C
         IF (L(1).GT.N0) THEN
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = XSAV(J)
               Y(J) = YSAV(J)
               Z(J) = ZSAV(J)
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
C
C Call GKSDRW$ to draw the lines
C
            CALL GKSDRW$(LCOLOR(1), N1, L(1), NPTS, WIDE(1), XTEMP,
     +                   YTEMP)
         ENDIF
C
C Drop perpendiculars if required
C
         IF (NPERP(1).GT.N0) THEN
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = XSAV(J)
               Y(J) = YSAV(J)
               Z(J) = ZSAV(J)
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
            CALL GSELNT$(N1)
            CALL GSLWSC$(ONE)
            IF (NPERP(1).LE.N12) THEN
               IF (NPERP(1).EQ.N1 .OR. NPERP(1).EQ.N4 .OR.
     +             NPERP(1).EQ.N7 .OR. NPERP(1).EQ.N10) THEN
                  CALL GSLN$(N1)
               ELSEIF (NPERP(1).EQ.N2 .OR. NPERP(1).EQ.N5 .OR.
     +                 NPERP(1).EQ.N8 .OR.NPERP(1).EQ.N11) THEN
                  CALL GSLN$(N2)
               ELSE
                  CALL GSLN$(N3)
               ENDIF
               NTEMP = NPTS
               DO J = N1, NTEMP
                  CALL XYZ2XY$(X(J), XZERO(J), Y(J), YZERO(J), ZERO)
                  CALL LINE$(XZERO(J), YZERO(J), XTEMP(J), YTEMP(J),
     +                       MCOLOR(1))
               ENDDO
            ENDIF
C
C Call GKSSYM$ to draw the symbols
C
            IF (NPERP(1).EQ.N4 .OR. NPERP(1).EQ.N5 .OR.
     +          NPERP(1).EQ.N6 .OR. NPERP(1).EQ.N13) THEN
               CALL GKSSYM$(MCOLOR(1), N1, ICOLOR(1), N1, NTEMP,
     +                      ATEMP, CTEMP, SIZE1(1), WIDE(1), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(1).EQ.N7 .OR. NPERP(1).EQ.N8 .OR.
     +              NPERP(1).EQ.N9 .OR. NPERP(1).EQ.N14) THEN
               CALL GKSSYM$(MCOLOR(1), N1, ICOLOR(1), N17, NTEMP,
     +                      ATEMP, CTEMP, SIZE1(1), WIDE(1), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(1).EQ.N10 .OR. NPERP(1).EQ.N11 .OR.
     +              NPERP(1).EQ.N12 .OR. NPERP(1).EQ.N15) THEN
               CALL GKSSYM$(MCOLOR(1), N1, ICOLOR(1), N4, NTEMP,
     +                      ATEMP, CTEMP, SIZE1(1), WIDE(1), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(1).EQ.N16) THEN
               CALL GKSSYM$(MCOLOR(1), N1, ICOLOR(1), N2, NTEMP,
     +                      ATEMP, CTEMP, SIZE1(1), WIDE(1), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(1).EQ.N17) THEN
               CALL GKSSYM$(MCOLOR(1), N1, ICOLOR(1), N3, NTEMP,
     +                      ATEMP, CTEMP, SIZE1(1), WIDE(1), XZERO,
     +                      ONE, ZERO, YZERO)
            ENDIF
         ENDIF
C
C Draw the markers if M(1) > 0
C
         IF (M(1).GT.N0) THEN
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = XSAV(J)
               Y(J) = YSAV(J)
               Z(J) = ZSAV(J)
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
C
C Call GKSSYM$ to draw the symbols
C
            CALL GKSSYM$(MCOLOR(1), N1, ICOLOR(1), M(1), NPTS, ATEMP,
     +                   CTEMP, SIZE1(1), WIDE(1), XTEMP, ONE, ZERO,
     +                   YTEMP)
         ENDIF
C
C End of curve drawing ... Finish off the axes
C
      IF (AXES(2)) THEN
         ITIME = N2
         CALL SPACE2$(ICOLOR(3), ITIME, NDIVS, NFULL, NXGRID, NYGRID,
     +                NZGRID, AXES, FULL, TICKS)
      ENDIF
      FIRST = .FALSE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
      IF (NPRESS.EQ.20) THEN
         GOTO 20
      ELSEIF (NPRESS.EQ.24) THEN  
         KVAL_12 = NKLCFG(N24)
         IF (KVAL_12.EQ.N1) THEN 
            QUIT = .FALSE.
            CALL GRAPHQ (QUIT)
         ELSE
            QUIT = .TRUE.
         ENDIF   
         IF (QUIT) THEN
            DEALLOCATE(X, STAT = IERR) 
            DEALLOCATE(XZERO, STAT = IERR)
            DEALLOCATE(Y, STAT = IERR)
            DEALLOCATE(YZERO, STAT = IERR)
            DEALLOCATE(Z, STAT = IERR)
            RETURN
         ELSE
            GOTO 20
         ENDIF   
      ELSE
         GOTO 40
      ENDIF 
C
C Format statement
C      
  100 FORMAT (A,'label',I3)
      END
C
C
