C
C
      SUBROUTINE SPACE1$(NCMAX, NIN, NFMAX, NPLOTS, NRMAX,
     +                   A, B, X, XTEMP, Y, YTEMP, Z,
     +                   FNAME, FTITLE,
     +                   LIB_FILE, SUPPLY)
C
C ACTION : Draw one or several 3D space curve
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/7/96
C          28/10/1996 Changed arguments to SPACE3, SURAAA, SURBBB, SURCCC
C                     to be consistent with calls to NEWSTR$ and PLTSTR$
C                     This version does not plot the labels XTEXT, etc.
C          14/07/1997 win32 version
C          30/10/1998 removed NX, NY
C          20/11/1998 added call to DEFGKS$ to initialise parameters in
C                     DEFNGKS.INS
C          21/02/2001 introduced NFULL, NXGRID, NYGRID, NZGRID, NPERP
C          03/09/2001 added call to PSSPEC$
C          07/11/2001 added NFMAX, NPLOTS, FNAME, FTITLE, SUPPLY to
C                     argument list to allow direct call from files
C          09/11/2001 added XMAX1, XMIN1, YMAX1, YMIN1, ZMAX1, ZMIN1
C          23/04/2007 added INTENTS
C          05/01/2008 edited and made XZERO and YZERO allocatables 
C          05/01/2014 checked for NPRESS = 24 
C          15/01/2014 added call to SAVQUE$ 
C
C Advice: this version uses NGRAFS as a parameter which is the maximum number
C         of files in a library file or plots that can be supplied
C         When SUPPLY = .TRUE. then NRMAX must be the largest dimension supplied 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NCMAX, NIN, NFMAX, NPLOTS,
     +                                       NRMAX 
      DOUBLE PRECISION,    INTENT (INOUT) :: A(NRMAX,NCMAX), B(NRMAX)
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NRMAX), XTEMP(NRMAX),
     +                                       Y(NRMAX), YTEMP(NRMAX),
     +                                       Z(NRMAX)
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NFMAX), FTITLE(NFMAX)
      LOGICAL,             INTENT (IN)    :: LIB_FILE, SUPPLY 
C      
C Allocatable arrays      
C      
      DOUBLE PRECISION,       ALLOCATABLE :: XZERO(:), YZERO(:)
C
C Locals
C      
      INTEGER    NPRESS
      INTEGER    NDIVS(3), NFILES, NFULL, NXGRID, NYGRID, NZGRID
      INTEGER    I, IERR, IOS, ITIME, J, NTEMP
      INTEGER    NPTS, NTYPE, NXTEXT, NYTEXT, NZTEXT
      INTEGER    KMODE, NGRAFS, NGRAF1, NGRAF5, NMAX
      PARAMETER (KMODE = 1, NGRAFS = 300, NGRAF5 = 5*NGRAFS)
      INTEGER    IU, IV, IW, NBIG, N0, N1, N2, N3, N4, N5, N6, N7, N8,
     +           N9, N10, N11, N12, N13, N14, N15, N16, N17, N24
      PARAMETER (IU = 45, IV = 45, IW = 55, NBIG = 16, N0 = 0, N1 = 1,
     +           N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8,
     +           N9 = 9, N10 = 10, N11 = 11, N12 = 12, N13 = 13,
     +           N14 = 14, N15 = 15, N16 = 16, N17 = 17, N24 = 24)
      INTEGER    NXSAV, NYSAV, NZSAV
      INTEGER    ICOLOR(8), ITHETA
      INTEGER    L(NGRAFS), LCOLOR(NGRAFS), M(NGRAFS), MCOLOR(NGRAFS),
     +           NPERP(NGRAFS)
      INTEGER    NKLCFG, KVAL_12
      INTEGER    ISEND
      PARAMETER (ISEND = 2)
      INTEGER    IBOT, IMID, ITOP, NCMAX1, NCOL, NIN1, NRMAX1, NROW
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN, ZMAX, ZMIN
      DOUBLE PRECISION XMAX1, XMIN1, YMAX1, YMIN1, ZMAX1, ZMIN1
      DOUBLE PRECISION XDIFF, YDIFF, ZDIFF
      DOUBLE PRECISION X5(N5), Y5(N5)
      DOUBLE PRECISION SIZES(NGRAFS), WIDE(5*NGRAFS)
      DOUBLE PRECISION ONE, R2BIG, ZERO
      PARAMETER (ONE = 1.0D+00, R2BIG = 99999.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION SMALL
      PARAMETER (SMALL = 1.0D-100)
      DOUBLE PRECISION ATEMP, CTEMP
      PARAMETER (ATEMP = 1.0D+00, CTEMP = 1.0D+00)
      DOUBLE PRECISION XCLIP(2), YCLIP(2)
      CHARACTER  FILE*1024, TITLE*80
      CHARACTER  ARRAYT*(IW), ARRAYX*(IV), ARRAYY*(IV), ARRAYZ*(IV),
     +           PTITLE*(IW), XTITLE*(IV), YTITLE*(IV), ZTITLE*(IV),
     +           TITLEP*(IW), TITLEX*(IV), TITLEY*(IV), TITLEZ*(IV)
      CHARACTER  XTEXT(NBIG)*(IU), YTEXT(NBIG)*(IU), ZTEXT(NBIG)*(IU),
     +           XTEXT1(NBIG)*(IU), YTEXT1(NBIG)*(IU),
     +           ZTEXT1(NBIG)*(IU)
      CHARACTER  LINE*80
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .TRUE., FIXROW = .FALSE., LABEL = .TRUE.)
      LOGICAL    AXES(2), FRAME, FULL, QUIT
      LOGICAL    ABORT, ARROWS(3), FIRST, GSAVE, LABELS(3),
     +           NEWRUN, NUMBER(3), TICKS(3), XTSHOW,
     +           X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT
C
C Parameters from DLL in common block in DEFNGKS.INS
C
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
      EXTERNAL   MATTIN
      EXTERNAL   GETJM1$, PUTADV$, PUTFAT$
      EXTERNAL   GKSDEK$, GETDEF$, GSELNT$, AFRAME$, GKSDRW$, GKSSYM$,
     +           SURAAA$, SURBBB$, SURCCC$,
     +           SUR002$,
     +           SPACE2$, SPACE3$, SPACE4$, XYZ2XY$,
     +           FILL_POLYGON$, DEFGKS$, LINE$, GSLN$, GSLWSC$,
     +           XYZLIB$, PSSPEC$, NKLCFG, GRAPHQ
      INTRINSIC  MIN, ABS
      SAVE       ICOLOR, ITHETA, L, LCOLOR, M, MCOLOR, NTYPE,
     +           NXSAV, NYSAV, NZSAV, SIZES, WIDE,
     +           ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +           PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1, YTITLE,
     +           ZTEXT, ZTEXT1, ZTITLE,
     +           ARROWS, AXES, FRAME, FULL, LABELS,
     +           NEWRUN, NUMBER, X2INT, Y2INT, ZTSHOW, Z2INT
C
C Default settings
C

      DATA ICOLOR / 15,  0,  0,  0,  0, 0, 0, 0 /
      DATA L / NGRAFS*1 /
      DATA LCOLOR / NGRAFS*0 /
      DATA M / NGRAFS*5 /
      DATA MCOLOR / NGRAFS*0 /
      DATA NXSAV, NYSAV, NZSAV / NBIG, NBIG, NBIG /
      DATA SIZES / NGRAFS*ONE /
      DATA WIDE / NGRAF5*ONE /
      DATA PTITLE / 'SIMFIT 3D space plot (x,y,z)' /
      DATA ARRAYT / '0000000000000000000000000000' /
      DATA XTITLE / 'X' /
      DATA ARRAYX / '0' /
      DATA YTITLE / 'Y' /
      DATA ARRAYY / '0' /
      DATA ZTITLE / 'Z' /
      DATA ARRAYZ / '0' /
      DATA AXES / .TRUE., .TRUE. /
      DATA FRAME / .FALSE. /
      DATA FULL / .TRUE. /
      DATA ITHETA / 0 /
      DATA NTYPE / 1 /
      DATA NXTEXT, NYTEXT, NZTEXT / NBIG, NBIG, NBIG /
      DATA XTSHOW, YTSHOW, ZTSHOW / .FALSE., .FALSE., .TRUE. /
      DATA X2INT, Y2INT, Z2INT / .FALSE., .FALSE., .FALSE. /
      DATA X5 / ZERO,  ONE, ONE, ZERO, ZERO /
      DATA Y5 / ZERO, ZERO, ONE,  ONE,  ONE /
      DATA NEWRUN / .TRUE. /
      DATA NPERP / NGRAFS*0 /
      DATA NFULL, NXGRID, NYGRID, NZGRID / N3, N3, N3, N3 /
C
C Check
C
      IF (NFMAX.LT.N1) RETURN
      IF (NFMAX.GT.NGRAFS) CALL PUTADV$(
     +    'NFMAX > NGRAFS in call to SPACE1')
      IF (SUPPLY) THEN
         IF (NPLOTS.LT.N1) RETURN
         IF (NPLOTS.GT.NGRAFS) THEN
            CALL PUTFAT$ ('Too many plots requested ... maximum = 300')
            RETURN
         ENDIF 
         IF (NPLOTS.GT.NFMAX) THEN
            CALL PUTFAT$('No. of plots requested > No. of files')  
         ENDIF   
      ENDIF 
C
C Initialise and allocate
C        
      NGRAF1 = MIN(NFMAX,NGRAFS)
      NMAX = NRMAX
      IERR = 0
      IF (ALLOCATED(XZERO)) DEALLOCATE(XZERO, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YZERO)) DEALLOCATE(YZERO)
      IF (IERR.NE.0) RETURN
      ALLOCATE(XZERO(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(YZERO(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN    
C
C Initialise
C
      L(2) = 2
      L(3) = 3
      L(4) = 4
      M(2) = 8
      M(3) = 11
      M(4) = 14
      CALL DEFGKS$
      XCLIP(1) = ZERO
      XCLIP(2) = ONE
      YCLIP(1) = ZERO
      YCLIP(2) = ONE
      IF (NEWRUN) THEN
C
C Extra defaults to be set up the first time round
C
         DO I = N1, NBIG
            WRITE (XTEXT(I),100) 'x', I
            WRITE (YTEXT(I),100) 'y', I
            WRITE (ZTEXT(I),100) 'z', I
            XTEXT1(I) = '000000000'
            YTEXT1(I) = '000000000'
            ZTEXT1(I) = '000000000'
         ENDDO
         DO I = N1, N3
            ARROWS(I) = .TRUE.
            LABELS(I) = .FALSE.
            NUMBER(I) = .TRUE.
         ENDDO
         NXTEXT = N2
         NYTEXT = N2
         NZTEXT = N2
         XTSHOW = .TRUE.
         YTSHOW = .TRUE.
         ZTSHOW = .TRUE.
         NEWRUN = .FALSE.
      ENDIF
C
C Read in the data files and calculate parameters for scaling
C
      IF (LIB_FILE) THEN
C
C A library file has been requested
C        
         CALL XYZLIB$(NFILES, NFMAX, NIN, NRMAX,
     +                X, XMAX, XMIN, Y, YMAX, YMIN, Z, ZMAX, ZMIN,
     +                FILE, FNAME, TITLE, FTITLE,
     +                ABORT)
         IF (ABORT .OR. NFILES.LT.N1) THEN
            DEALLOCATE(XZERO, STAT = IERR)
            DEALLOCATE(YZERO, STAT = IERR)
            RETURN
         ENDIF   
      ELSE
         IF (SUPPLY) THEN
C
C Files have been supplied
C           
            NFILES = NPLOTS
         ELSE
C
C Individual files are read in
C           
            IBOT = N0
            IMID = N0
            ITOP = NFMAX
            CALL GETJM1$(IBOT, IMID, ITOP,
     +'No. of xyz-space-curve-data-files to be over-layed (0 = Cancel)')
            NFILES = IMID
         ENDIF
         IF (NFILES.LE.N0) THEN
            DEALLOCATE(XZERO, STAT = IERR)
            DEALLOCATE(YZERO, STAT = IERR)
            RETURN
         ENDIF   
         DO I = N1, NFILES
            NIN1 = NIN
            CLOSE (UNIT = NIN1)
            IF (SUPPLY) THEN
               OPEN (UNIT = NIN1, FILE = FNAME(I), IOSTAT = IOS)
               IF (IOS.NE.N0) THEN
                  CLOSE (UNIT = NIN1)
                  DEALLOCATE(XZERO, STAT = IERR)
                  DEALLOCATE(YZERO, STAT = IERR)                  
                  RETURN
               ENDIF
               READ (NIN1,'(A)',IOSTAT=IOS) FTITLE(I)
               IF (IOS.NE.N0) THEN
                  CLOSE (UNIT = NIN1)
                  DEALLOCATE(XZERO, STAT = IERR)
                  DEALLOCATE(YZERO, STAT = IERR)                   
                  RETURN
               ENDIF
               READ (NIN1,*,IOSTAT=IOS) NROW, NCOL
               IF (IOS.NE.N0 .OR. NCOL.NE.N3 .OR. NROW.LT.N1) THEN
                  CLOSE (UNIT = NIN1)
                  DEALLOCATE(XZERO, STAT = IERR)
                  DEALLOCATE(YZERO, STAT = IERR)                   
                  RETURN
               ENDIF
               NPTS = NROW
               DO J = N1, NPTS
                  READ (NIN1,*,IOSTAT=IOS) X(J), Y(J), Z(J)
                  IF (IOS.NE.N0) THEN
                     CLOSE (UNIT = NIN1)
                     DEALLOCATE(XZERO, STAT = IERR)
                     DEALLOCATE(YZERO, STAT = IERR)                      
                     RETURN
                  ENDIF
               ENDDO
               CLOSE (UNIT = NIN1)
            ELSE
               WRITE (LINE,200) I
               CALL PUTADV$(LINE)
               NCMAX1 = NCMAX
               NCOL = N3
               NRMAX1 = NRMAX
               CALL MATTIN (ISEND, NCMAX1, NCOL, NIN1, NRMAX1, NROW,
     +                      A, B,
     +                      FNAME(I), FTITLE(I), ABORT, FIXCOL, FIXROW,
     +                      LABEL)
               CLOSE (UNIT = NIN1)
               IF (ABORT) RETURN
               NPTS = NROW
               DO J = N1, NPTS
                  X(J) = A(J,N1)
                  Y(J) = A(J,N2)
                  Z(J) = A(J,N3)
               ENDDO
            ENDIF
            IF (I.EQ.N1) THEN
               XMAX = X(1)
               XMIN = X(1)
               YMAX = Y(1)
               YMIN = Y(1)
               ZMAX = Z(1)
               ZMIN = Z(1)
            ENDIF
            DO J = N1, NPTS
               IF (X(J).GT.XMAX) XMAX = X(J)
               IF (X(J).LT.XMIN) XMIN = X(J)
               IF (Y(J).GT.YMAX) YMAX = Y(J)
               IF (Y(J).LT.YMIN) YMIN = Y(J)
               IF (Z(J).GT.ZMAX) ZMAX = Z(J)
               IF (Z(J).LT.ZMIN) ZMIN = Z(J)
            ENDDO
         ENDDO
      ENDIF
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      ZDIFF = ZMAX - ZMIN
      IF (ABS(XDIFF).LE.SMALL) THEN
         CALL PUTFAT$('No variation in X-values')
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR)          
         RETURN
      ENDIF
      IF (ABS(YDIFF).LE.SMALL) THEN
         CALL PUTFAT$('No variation in Y-values')
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR) 
         RETURN
      ENDIF
      IF (ABS(ZDIFF).LE.SMALL) THEN
         CALL PUTFAT$('No variation in Z-values')
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR) 
         RETURN
      ENDIF
      XMAX1 = XMAX
      XMIN1 = XMIN
      YMAX1 = YMAX
      YMIN1 = YMIN
      ZMAX1 = ZMAX
      ZMIN1 = ZMIN
C
C
C Subsidiary branch point ............................................
C
   20 CONTINUE
      CALL SPACE3$(ICOLOR, ITHETA, L, LCOLOR, M, MCOLOR, NBIG,
     +             NFILES, NFULL, NGRAF1, NPERP, NTYPE, NXGRID, NXSAV,
     +             NXTEXT, NYGRID, NYSAV, NYTEXT, NZGRID, NZSAV, NZTEXT,
     +             SIZES, WIDE, XMAX, XMAX1, XMIN, XMIN1, YMAX, YMAX1,
     +             YMIN, YMIN1, ZMAX, ZMAX1, ZMIN, ZMIN1,
     +             ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +             FNAME, FTITLE,
     +             PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1, YTITLE,
     +             ZTEXT, ZTEXT1, ZTITLE,
     +             AXES, ARROWS, FRAME, FULL, LABELS, NUMBER,
     +             XTSHOW, X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT)
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      ZDIFF = ZMAX - ZMIN
C
C Return to start if NTYPE out of range
C
      IF (NTYPE.LT.1) THEN
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR) 
         RETURN
      ENDIF   
      IF (X2INT .AND. XMAX.GT.R2BIG) X2INT = .FALSE.
      IF (X2INT .AND. XMIN.LT.-R2BIG) X2INT = .FALSE.
      IF (Y2INT .AND. YMAX.GT.R2BIG) Y2INT = .FALSE.
      IF (Y2INT .AND. YMIN.LT.-R2BIG) Y2INT = .FALSE.
      IF (Z2INT .AND. ZMAX.GT.R2BIG) Z2INT = .FALSE.
      IF (Z2INT .AND. ZMIN.LT.-R2BIG) Z2INT = .FALSE.
C
C Data are ready so now proceed to create the graph
C
      ABORT = .FALSE.
      FIRST = .TRUE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
C
C Branch point for hardcopy from GKSDEK$ ............................
C
   40 CONTINUE
C
C Define transformations and open graphics
C
      CALL SUR002$(KMODE)
      IF (ICOLOR(1).NE.0) THEN
         CALL GSELNT$(N0)
         CALL FILL_POLYGON$(N5, X5, Y5, ICOLOR(1))
      ENDIF
      IF (PS) CALL PSSPEC$(N2, NOUT_PS)
C
C Draw axes for plot
C
      DO I = N1, N3
         NDIVS(I) = 0
         TICKS(I) = .FALSE.
      ENDDO
      IF (ITHETA.EQ.0 .OR. ITHETA.EQ.180) THEN
C********Eiting 23/07/2001 to allow multiple tick marks with numbers
C********IF (.NOT.LABELS(1)) THEN
            TICKS(1) = .TRUE.
C********ELSE
            NDIVS(1) = NXTEXT
C********ENDIF
C********IF (.NOT.LABELS(2)) THEN
            TICKS(2) = .TRUE.
C********ELSE
            NDIVS(2) = NYTEXT
C********ENDIF
      ELSE
C********IF (.NOT.LABELS(2)) THEN
            TICKS(1) = .TRUE.
C********ELSE
            NDIVS(1) = NYTEXT
C********ENDIF
C********IF (.NOT.LABELS(1)) THEN
            TICKS(2) = .TRUE.
C********ELSE
            NDIVS(2) =  NXTEXT
C********ENDIF
      ENDIF
C*****IF (.NOT.LABELS(3)) THEN
          TICKS(3) = .TRUE.
C*****ELSE
          NDIVS(3) = NZTEXT
C*****ENDIF
      ITIME = N1
      CALL SPACE2$(ICOLOR(3), ITIME, NDIVS, NFULL, NXGRID, NYGRID,
     +             NZGRID, AXES, FULL, TICKS)
      CALL AFRAME$(ICOLOR(3), FRAME, PS)
C
C Title and legends
C
      TITLEP = PTITLE
      TITLEX = XTITLE
      TITLEY = YTITLE
      TITLEZ = ZTITLE
      CALL SURAAA$(ICOLOR(4), NOUT_PS, Y_SCALE, ARRAYT, TITLEP,
     +             HARD_COPY, HPGL, PS)
      CALL SURBBB$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, Y_SCALE,
     +             ARRAYX, ARRAYY, ARRAYZ, TITLEX, TITLEY, TITLEZ,
     +             ARROWS, HARD_COPY, HPGL, LABELS, PS, XTSHOW,
     +             YTSHOW, ZTSHOW)
      CALL SURCCC$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, NXTEXT, NYTEXT,
     +             NZTEXT,
     +             XMAX, XMIN, YMAX, YMIN, Y_SCALE, ZMAX, ZMIN,
     +             XTEXT, XTEXT1, YTEXT, YTEXT1, ZTEXT, ZTEXT1,
     +             HARD_COPY, HPGL, LABELS, NUMBER, PS, X2INT,
     +             Y2INT, Z2INT)
C
C Draw all the curves with L(I) > 0
C
      DO I = N1, NFILES
C
C First read in the data
C
         IF (L(I).GT.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(I))
            READ (NIN,'(A)') FTITLE(I)
            READ (NIN,*) NPTS, J
            DO J = N1, NPTS
               READ (NIN,*) X(J), Y(J), Z(J)
            ENDDO
            CLOSE (UNIT = NIN)
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
C
C Call GKSDRW$ to draw the lines
C
            CALL GKSDRW$(LCOLOR(I), N1, L(I), NPTS, WIDE(I), XTEMP,
     +                   YTEMP)
         ENDIF
      ENDDO
C
C Drop perpendiculars
C
      DO I = N1, NFILES
C
C First read in the data
C
         IF (NPERP(I).GT.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(I))
            READ (NIN,'(A)') FTITLE(I)
            READ (NIN,*) NPTS, J
            DO J = N1, NPTS
               READ (NIN,*) X(J), Y(J), Z(J)
            ENDDO
            CLOSE (UNIT = NIN)
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
            CALL GSELNT$(N1)
            CALL GSLWSC$(ONE)
            IF (NPERP(I).LE.N12) THEN
C
C Drop perpendiculars
C
               IF (NPERP(I).EQ.N1 .OR. NPERP(I).EQ.N4 .OR.
     +             NPERP(I).EQ.N7 .OR. NPERP(I).EQ.N10) THEN
                  CALL GSLN$(N1)
               ELSEIF (NPERP(I).EQ.N2 .OR. NPERP(I).EQ.N5 .OR.
     +                 NPERP(I).EQ.N8 .OR. NPERP(I).EQ.N11) THEN
                  CALL GSLN$(N2)
               ELSE
                  CALL GSLN$(N3)
               ENDIF
               NTEMP = MIN(NPTS, NMAX)
               DO J = N1, NTEMP
                  CALL XYZ2XY$(X(J), XZERO(J), Y(J), YZERO(J), ZERO)
                  CALL LINE$(XZERO(J), YZERO(J), XTEMP(J), YTEMP(J),
     +                       MCOLOR(I))
               ENDDO
            ENDIF
C
C Call GKSSYM$ to draw the symbols
C
            IF (NPERP(I).EQ.N4 .OR. NPERP(I).EQ.N5 .OR.
     +          NPERP(I).EQ.N6 .OR. NPERP(I).EQ.N13) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N1, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N7 .OR. NPERP(I).EQ.N8 .OR.
     +              NPERP(I).EQ.N9 .OR. NPERP(I).EQ.N14) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N17, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N10 .OR. NPERP(I).EQ.N11 .OR.
     +              NPERP(I).EQ.N12 .OR. NPERP(I).EQ.N15) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N4, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N16) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N2, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N17) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N3, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ENDIF
         ENDIF
      ENDDO
C
C Draw all the markers with M(I) > 0
C
      DO I = N1, NFILES
C
C First read in the data
C
         IF (M(I).GT.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(I))
            READ (NIN,'(A)') FTITLE(I)
            READ (NIN,*) NPTS, J
            DO J = N1, NPTS
               READ (NIN,*) X(J), Y(J), Z(J)
            ENDDO
            CLOSE (UNIT = NIN)
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
C
C Call GKSSYM$ to draw the symbols
C
            CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(1), M(I), NPTS, ATEMP,
     +                   CTEMP, SIZES(I), WIDE(I), XTEMP, ONE, ZERO,
     +                   YTEMP)
         ENDIF
      ENDDO
C
C End of curve drawing ... Finish off the axes
C
      IF (AXES(2)) THEN
         ITIME = N2
         CALL SPACE2$(ICOLOR(3), ITIME, NDIVS, NFULL, NXGRID, NYGRID,
     +                NZGRID, AXES, FULL, TICKS)
      ENDIF
      FIRST = .FALSE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
      IF (NPRESS.EQ.20) THEN
         GOTO 20
      ELSEIF (NPRESS.EQ.24) THEN   
         KVAL_12 = NKLCFG(N24)
         IF (KVAL_12.EQ.N1) THEN 
            QUIT = .FALSE.
            CALL GRAPHQ (QUIT)
         ELSE
            QUIT = .TRUE.
         ENDIF   
         IF (QUIT) THEN
            DEALLOCATE(XZERO, STAT = IERR)
            DEALLOCATE(YZERO, STAT = IERR)
            RETURN
         ELSE
            GOTO 20
         ENDIF      
      ELSE
         GOTO 40
      ENDIF  
C
C Format statements
C      
  100 FORMAT (A,'label',I3)
  200 FORMAT ('Now you must input xyz-space-curve-data-file number',I3)
      END
C
C
