C
C
      SUBROUTINE SPACE2$(ICOLOR, ITIME, NDIVS, NFULL, NXGRID, NYGRID,
     +                   NZGRID,
     +                   AXES, FULL, TICKS)
C
C ACTION : Draw axes for space curves
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.10/7/96
C          Derived from SUR003
C          14/07/1997 win32 version
C          23/02/2001 added NFULL, NXGRID, NYGRID, NZGRID
C          21/11/2001 suppressed grid lines at extremes of range to
C                     prevent over-writing
C          23/04/2007 added INTENTS 
C          31/10/2008 added calls to PLTOBJ$ to plot background objects
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: ICOLOR, ITIME, NDIVS(3), NFULL, NXGRID,
     +                        NYGRID, NZGRID 
      LOGICAL, INTENT (IN) :: AXES(2), FULL, TICKS(3)
C
C Locals
C      
      INTEGER    N0, N1, N2, N5, N6
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N5 = 5, N6 = 6)
      INTEGER    I, COLOUR_INDEX
      DOUBLE PRECISION XT(N2), YT(N2)
      DOUBLE PRECISION BOT, SPACE, TOP
      PARAMETER (BOT = 0.0D+00, TOP = 1.0D+00)
      DOUBLE PRECISION ZERO, ONE, PNT05, PNT1
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT05 = 0.05D+00,
     +           PNT1 = 0.1D+00)
      DOUBLE PRECISION DELTA, EPSI(2), XTEMP, YTEMP, ZTEMP
      EXTERNAL   GSELNT$, XYZ2XY$, POLYLINE$, GSLN$, GSLWSC$, PLTOBJ$
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) RETURN
      COLOUR_INDEX = ICOLOR
      CALL GSELNT$(N1)
      CALL GSLWSC$(ONE)
      IF (ITIME.EQ.N1) THEN
C
C Switch on background objects then plot them
C        
         I = N0
         CALL PLTOBJ$(N6, I)
         CALL PLTOBJ$(N5, I)
C
C Resume normal action
C      
         COLOUR_INDEX = ICOLOR
         CALL GSELNT$(N1)
         CALL GSLWSC$(ONE)
C
C First time called draw the background axes etc.
C
         DO I = N1, N2
            IF (TICKS(I)) THEN
               EPSI(I) = PNT05
            ELSE
               EPSI(I) = ZERO
            ENDIF
         ENDDO
         IF (TICKS(3)) THEN
C...0    The extra Z ticks
            CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), BOT)
            CALL XYZ2XY$(BOT - PNT05, XT(2), TOP, YT(2), BOT)
            CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), TOP)
            CALL XYZ2XY$(BOT - PNT05, XT(2), TOP, YT(2), TOP)
            CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
         ENDIF
C
C The axes 1, 2, 3, 4, 5, 6 as in SUR003
C
C...1
         CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), BOT)
         CALL XYZ2XY$(BOT, XT(2), TOP, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...2
         CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), TOP)
         CALL XYZ2XY$(BOT, XT(2), BOT, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...3
         CALL XYZ2XY$(BOT, XT(1), BOT, YT(1), TOP)
         CALL XYZ2XY$(TOP, XT(2), BOT, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...4
         CALL XYZ2XY$(TOP, XT(1), BOT, YT(1), TOP)
         CALL XYZ2XY$(TOP, XT(2), BOT, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...5
         CALL XYZ2XY$(TOP, XT(1), BOT, YT(1), BOT)
         CALL XYZ2XY$(TOP, XT(2), TOP + EPSI(1), YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...6
         CALL XYZ2XY$(TOP + EPSI(2), XT(1), TOP, YT(1), BOT)
         CALL XYZ2XY$(BOT, XT(2), TOP, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
         IF (AXES(1)) THEN
C
C...The dotted axes 7, 8, 9. First call GSLN$ to set LINE_TYPE
C
C...7
            CALL GSLN$(NFULL)
            IF (FULL) THEN
               SPACE = ZERO
            ELSE
               SPACE = PNT1
            ENDIF
            CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), BOT)
            CALL XYZ2XY$(BOT, XT(2), BOT + SPACE, YT(2), BOT)
            CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...8
            CALL XYZ2XY$(BOT + SPACE, XT(1), BOT, YT(1), BOT)
            CALL XYZ2XY$(TOP, XT(2), BOT, YT(2), BOT)
            CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...9
            CALL XYZ2XY$(BOT, XT(1), BOT, YT(1), BOT + SPACE)
            CALL XYZ2XY$(BOT, XT(2), BOT, YT(2), TOP)
            CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...  restore line type
            CALL GSLN$(N1)
         ENDIF
C...7 tick mark
         CALL XYZ2XY$(BOT, XT(1), TOP + EPSI(1), YT(1), BOT)
         CALL XYZ2XY$(BOT, XT(2), TOP, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...8 tick mark
         CALL XYZ2XY$(TOP, XT(1), BOT, YT(1), BOT)
         CALL XYZ2XY$(TOP + EPSI(2), XT(2), BOT, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C
C Now the divisions for labels
C
         IF (NDIVS(1).GT.N0) THEN
C
C Extra tick marks for X-axis
C
            DELTA = ONE/(NDIVS(1) - ONE)
            XTEMP = ZERO - DELTA
            YTEMP = ONE + PNT05
            ZTEMP = ZERO
            DO I = N1, NDIVS(1)
               XTEMP = XTEMP + DELTA
               CALL XYZ2XY$(XTEMP, XT(1), ONE, YT(1), ZTEMP)
               CALL XYZ2XY$(XTEMP, XT(2), YTEMP, YT(2), ZTEMP)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDDO
C
C Add any intermediate X-grid lines
C
            IF (NXGRID.GT.N0 .AND. NDIVS(1).GT.N2) THEN
               CALL GSLN$(NXGRID)
               XTEMP = ZERO
               DO I = N2, NDIVS(1) - N1
                  XTEMP = XTEMP + DELTA
                  CALL XYZ2XY$(XTEMP, XT(1), ONE, YT(1), ZERO)
                  CALL XYZ2XY$(XTEMP, XT(2), ZERO, YT(2), ZERO)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
                  CALL XYZ2XY$(XTEMP, XT(1), ZERO, YT(1), ZERO)
                  CALL XYZ2XY$(XTEMP, XT(2), ZERO, YT(2), ONE)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
               ENDDO
               CALL GSLN$(N1)
            ENDIF
         ENDIF
         IF (NDIVS(2).GT.N0) THEN
C
C Extra tick marks for Y-axis
C
            DELTA = ONE/(NDIVS(2) - ONE)
            XTEMP = ONE + PNT05
            YTEMP = ZERO - DELTA
            ZTEMP = ZERO
            DO I = N1, NDIVS(2)
               YTEMP = YTEMP + DELTA
               CALL XYZ2XY$(ONE, XT(1), YTEMP, YT(1), ZTEMP)
               CALL XYZ2XY$(XTEMP, XT(2), YTEMP, YT(2), ZTEMP)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDDO
C
C Add any intermediate Y-grid lines
C
            IF (NYGRID.GT.N0 .AND. NDIVS(2).GT.N2) THEN
               CALL GSLN$(NYGRID)
               YTEMP = ZERO
               DO I = N2, NDIVS(2) - N1
                  YTEMP = YTEMP + DELTA
                  CALL XYZ2XY$(ZERO, XT(1), YTEMP, YT(1), ZERO)
                  CALL XYZ2XY$(ONE, XT(2), YTEMP, YT(2), ZERO)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
                  CALL XYZ2XY$(ZERO, XT(1), YTEMP, YT(1), ZERO)
                  CALL XYZ2XY$(ZERO, XT(2), YTEMP, YT(2), ONE)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
               ENDDO
               CALL GSLN$(N1)
            ENDIF
         ENDIF
         IF (NDIVS(3).GT.N0) THEN
C
C Extra tick marks for Z-axis
C
            CALL GSELNT$(N1)
            DELTA = ONE/(NDIVS(3) - ONE)
            XTEMP = ZERO - PNT05
            YTEMP = ONE
            ZTEMP = ZERO - DELTA
            DO I = N1, NDIVS(3)
               ZTEMP = ZTEMP + DELTA
               CALL XYZ2XY$(ZERO, XT(1), YTEMP, YT(1), ZTEMP)
               CALL XYZ2XY$(XTEMP, XT(2), YTEMP, YT(2), ZTEMP)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDDO
C
C Add any intermediate grid lines to the rear two planes (inverted V)
C
            IF (NZGRID.GT.N0 .AND. NDIVS(3).GT.N2) THEN
               CALL GSLN$(NZGRID)
               ZTEMP = ZERO
               DO I = N2, NDIVS(3) - N1
                  ZTEMP = ZTEMP + DELTA
                  CALL XYZ2XY$(ONE, XT(1), ZERO, YT(1), ZTEMP)
                  CALL XYZ2XY$(ZERO, XT(2), ZERO, YT(2), ZTEMP)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
                  CALL XYZ2XY$(ZERO, XT(1), ZERO, YT(1), ZTEMP)
                  CALL XYZ2XY$(ZERO, XT(2), ONE, YT(2), ZTEMP)
                  CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
               ENDDO
               CALL GSLN$(N1)
            ENDIF
         ENDIF
      ELSEIF (ITIME.EQ.N2) THEN
C
C Second time called draw the front axes required for space curves
C
         CALL GSLN$(N1)
C...10
         CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), TOP)
         CALL XYZ2XY$(TOP, XT(2), TOP, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...11
         CALL XYZ2XY$(TOP, XT(1), TOP, YT(1), TOP)
         CALL XYZ2XY$(TOP, XT(2), BOT, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...12
         CALL XYZ2XY$(TOP, XT(1), TOP, YT(1), TOP)
         CALL XYZ2XY$(TOP, XT(2), TOP, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
      ENDIF
      END
C
C
