C
C
      SUBROUTINE SPACE3$(ICOLOR, ITHETA, L, LCOLOR, M, MCOLOR, NBIG,
     +                   NFILES, NFULL, NGRAFS, NPERP, NTYPE, NXGRID,
     +                   NXSAV, NXTEXT, NYGRID, NYSAV, NYTEXT, NZGRID,
     +                   NZSAV, NZTEXT,
     +                   SIZES, WIDE,
     +                   XMAX, XMAX1, XMIN, XMIN1, YMAX, YMAX1,
     +                   YMIN, YMIN1, ZMAX, ZMAX1, ZMIN, ZMIN1,
     +                   ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   FNAME, FTITLE, PTITLE, XTEXT, XTEXT1, XTITLE,
     +                   YTEXT, YTEXT1, YTITLE, ZTEXT, ZTEXT1, ZTITLE,
     +                   AXES, ARROWS, FRAME, FULL, LABELS, NUMBER,
     +                   XTSHOW, X2INT, YTSHOW, Y2INT, ZTSHOW,
     +                   Z2INT)
C
C
C ACTION : Make decisions
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/7/96
C          Derived from SURDDD
C          28/10/1996 Added ARRAYT, XTEXT1, etc.
C          14/07/1997 win32 version
C          30/10/1998 removed NX and NY
C          21/02/2001 introduced NFULL, NXGRID.NYGRID, NZGRID, NPERP
C          09/11/2001 added XMAX1, XMIN1, YMAX1, YMIN1, ZMAX1, ZMIN1
C          10/05/2005 added extra WIDE arguments in call to GKSTYP$
C          23/04/2007 added INTENTS
C          10/06/2010 added call to NKLCFG
C          27/04/2011 replaced call to YESNO2 by call to GRAPHQ  
C          09/03/2014 added call to CLOSE_GR_WINDOWS 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NBIG, NGRAFS
      INTEGER,             INTENT (INOUT) :: ICOLOR(8), ITHETA, NTYPE, 
     +                                       L(NGRAFS), LCOLOR(NGRAFS),
     +                                       M(NGRAFS), MCOLOR(NGRAFS),
     +                                       NFILES, NFULL,
     +                                       NPERP(NGRAFS), NXGRID,
     +                                       NXSAV, NXTEXT, NYGRID,
     +                                       NYSAV, NYTEXT, NZGRID,
     +                                       NZSAV, NZTEXT
      DOUBLE PRECISION,    INTENT (INOUT) :: SIZES(NGRAFS),
     +                                       WIDE(5*NGRAFS)
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX, XMIN, YMAX, YMIN,
     +                                       ZMAX, ZMIN
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX1, XMIN1, YMAX1, YMIN1,
     +                                       ZMAX1, ZMIN1
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NGRAFS),
     +                                       FTITLE(NGRAFS)
      CHARACTER (LEN = *), INTENT (INOUT) :: PTITLE, XTEXT(NBIG),
     +                                       XTITLE, YTEXT(NBIG),
     +                                       YTITLE, ZTEXT(NBIG),
     +                                       ZTITLE
      LOGICAL,             INTENT (INOUT) :: AXES(2), ARROWS(3), FRAME,
     +                                       FULL, LABELS(3), NUMBER(3),
     +                                       XTSHOW, X2INT, YTSHOW,
     +                                       Y2INT, ZTSHOW, Z2INT
C
C Locals
C
      INTEGER    I, IMID
      INTEGER    KMODE, N1, N24
      PARAMETER (KMODE = 1, N1 = 1, N24 = 24)
      INTEGER    LSHADE, NCOLOR, NIX, NIY, NMAX, NUMDEC, NUMOPT, NUMTXT
      PARAMETER (LSHADE = 1, NCOLOR = 1, NIX = 4, NIY = 4, NMAX = 100)
      INTEGER    NUMBLD(30), NUMPOS(NMAX)
      INTEGER    KVAL_12, NKLCFG
      DOUBLE PRECISION R2BIG
      PARAMETER (R2BIG = 99999.0D+00)
      CHARACTER  ARRAYT*(*), ARRAYX*(*), ARRAYY*(*), ARRAYZ*(*)
      CHARACTER  XTEXT1(NBIG)*(*), YTEXT1(NBIG)*(*), ZTEXT1(NBIG)*(*)
      CHARACTER  OPTS(30)*100, SYMBOL(6)*12, LINE*100
      CHARACTER  TEXT(200)*80, TRIM80*80
      CHARACTER (LEN = 10) FORMGR, D10(6)
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    CONTAB, CONVAL
      PARAMETER (CONTAB = .FALSE., CONVAL = .FALSE.)
      LOGICAL    BARCAP, LOWER, UPPER, VECTOR_FIELD
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      LOGICAL    QUIT, STORE
      EXTERNAL   E_FORMATS, FORMGR
      EXTERNAL   LBOX02, GRAPHQ, TRIM80, PATCH1, NKLCFG
      EXTERNAL   NEWSTR$, VGACOL$, PUTADV$, XYZLEG$, GKSTYP$, SAVELC$,
     +           GETDG2$
      EXTERNAL   CLOSE_GR_WINDOWS
      INTRINSIC  TRIM
C
C Initialise
C        
      E_NUMBERS = E_FORMATS()            
      BARCAP = .FALSE.
      LOWER = .FALSE.
      UPPER = .FALSE.
      VECTOR_FIELD = .FALSE.
      DO I = 1, 30
         NUMBLD(I) = 0
      ENDDO
      DO I = 1, NMAX
         NUMPOS(I) = 1
      ENDDO
      IF (NFILES.GT.0) THEN
         DO I = 1, NFILES
            TEXT(I) = TRIM80(FNAME(I))
         ENDDO
      ENDIF
C
C Main branch point
C
   10 CONTINUE
      SYMBOL(1) = '[Suppressed]'
      DO I = 1, NFILES
         IF (NPERP(I).GT.0) SYMBOL(1) = '[Displayed]'
      ENDDO
      IF (FRAME) THEN
         SYMBOL(2) = '[Displayed]'
      ELSE
         SYMBOL(2) = '[Suppressed]'
      ENDIF
      IF (.NOT.AXES(1)) THEN
         SYMBOL(3) = '[Suppressed]'
      ELSEIF (FULL) THEN
         SYMBOL(3) = '[Displayed]'
      ELSE
         SYMBOL(3) = '[Suppressed]'
      ENDIF
      IF (E_NUMBERS) THEN
         WRITE (OPTS,100) SYMBOL(1), SYMBOL(2), SYMBOL(3),
     +                    XMIN, XMAX, YMIN, YMAX, ZMIN, ZMAX
      ELSE
        D10(1) = FORMGR(XMIN)
        D10(2) = FORMGR(XMAX)
        D10(3) = FORMGR(YMIN)
        D10(4) = FORMGR(YMAX)
        D10(5) = FORMGR(ZMIN)
        D10(6) = FORMGR(ZMAX)
        WRITE (OPTS,150) SYMBOL(1), SYMBOL(2), SYMBOL(3),
     +                   TRIM(D10(1)), D10(2), TRIM(D10(3)), D10(4),
     +                   TRIM(D10(5)), D10(6)
      ENDIF  
      NUMOPT = 13
      NUMDEC = 1
      CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS,
     +             OPTS)
      IF (NUMDEC.EQ.1) THEN
C
C Display space curve
C
         NTYPE = 1
         RETURN
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Edit title/label/legends
C
   20    CONTINUE
         NUMOPT = 8
         NUMDEC = NUMOPT
         WRITE (OPTS,200)
         CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS, OPTS)
         IF (NUMDEC.EQ.1) THEN
            I = 0
            CALL NEWSTR$(I, PTITLE, ARRAYT)
            GOTO 20
         ELSEIF (NUMDEC.EQ.2) THEN
            CALL XYZLEG$(KMODE, NBIG, NXSAV, NXTEXT, ARRAYX, XTEXT,
     +                   XTEXT1, XTITLE, 'X',
     +                   ARROWS(1), CONTAB, CONVAL, LABELS(1),
     +                   NUMBER(1), X2INT, XTSHOW)
            IF (X2INT .AND. XMAX.GT.R2BIG) THEN
               CALL PUTADV$('X too large for integers')
               X2INT = .FALSE.
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.3) THEN
            CALL XYZLEG$(KMODE, NBIG, NYSAV, NYTEXT, ARRAYY, YTEXT,
     +                   YTEXT1, YTITLE, 'Y',
     +                   ARROWS(2), CONTAB, CONVAL, LABELS(2),
     +                   NUMBER(2), Y2INT, YTSHOW)
            IF (Y2INT .AND. YMAX.GT.R2BIG) THEN
               CALL PUTADV$('Y too large for integers')
               Y2INT = .FALSE.
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.4) THEN
            CALL XYZLEG$(KMODE, NBIG, NZSAV, NZTEXT, ARRAYZ, ZTEXT,
     +                   ZTEXT1, ZTITLE, 'Z',
     +                   ARROWS(3), CONTAB, CONVAL, LABELS(3),
     +                   NUMBER(3), Z2INT, ZTSHOW)
            IF (ZMAX.GT.R2BIG) THEN
               CALL PUTADV$('Z too large for integers')
               Z2INT = .FALSE.
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.5) THEN
            WRITE (OPTS,300) 'X', 'X', 'X', 'X'
            NUMOPT = 4
            NUMDEC = NXGRID + 1
            CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS, OPTS)
            NXGRID = NUMDEC - 1
            GOTO 20
         ELSEIF (NUMDEC.EQ.6) THEN
            WRITE (OPTS,300) 'Y', 'Y', 'Y', 'Y'
            NUMOPT = 4
            NUMDEC = NYGRID + 1
            CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS, OPTS)
            NYGRID = NUMDEC - 1
            GOTO 20
         ELSEIF (NUMDEC.EQ.7) THEN
            WRITE (OPTS,300) 'Z', 'Z', 'Z', 'Z'
            NUMOPT = 4
            NUMDEC = NZGRID + 1
            CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS, OPTS)
            NZGRID = NUMDEC - 1
            GOTO 20
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            GOTO 10
         ENDIF
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Edit axes/geometry
C
   40    CONTINUE
         SYMBOL(1) = BLANK
         SYMBOL(2) = BLANK
         SYMBOL(3) = BLANK
         SYMBOL(4) = BLANK
         IF (ITHETA.EQ.0) THEN
            SYMBOL(1) = '[Selected]'
         ELSEIF (ITHETA.EQ.90) THEN
            SYMBOL(2) = '[Selected]'
         ELSEIF (ITHETA.EQ.180) THEN
            SYMBOL(3) = '[Selected]'
         ELSEIF (ITHETA.EQ.270) THEN
            SYMBOL(4) = '[Selected]'
         ENDIF
         IF (AXES(1)) THEN
            SYMBOL(5) = '[Displayed]'
         ELSE
            SYMBOL(5) = '[Suppressed]'
         ENDIF
         IF (AXES(2)) THEN
            SYMBOL(6) = '[Displayed]'
         ELSE
            SYMBOL(6) = '[Suppressed]'
         ENDIF
         WRITE (OPTS,400) (SYMBOL(I), I = 1, 6)
         NUMOPT = 7
         NUMDEC = NUMOPT
         CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS, OPTS)
         IF (NUMDEC.EQ.1) THEN
            ITHETA = 0
            GOTO 40
         ELSEIF (NUMDEC.EQ.2) THEN
            ITHETA = 90
            GOTO 40
         ELSEIF (NUMDEC.EQ.3) THEN
            ITHETA = 180
            GOTO 40
         ELSEIF (NUMDEC.EQ.4) THEN
            ITHETA = 270
            GOTO 40
         ELSEIF (NUMDEC.EQ.5) THEN
            AXES(1) = .NOT.AXES(1)
            GOTO 40
         ELSEIF (NUMDEC.EQ.6) THEN
            AXES(2) = .NOT.AXES(2)
            GOTO 40
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            GOTO 10
         ENDIF
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Edit a line/symbol type
C
         IF (NFILES.EQ.1) THEN
            IMID = 1
         ELSE
            NUMOPT = NFILES
            NUMDEC = 1
            CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS,
     +                   TEXT)
            IMID = NUMDEC
         ENDIF
         I = IMID
         NTYPE = 1
         CALL GKSTYP$(L(I), M(I), NTYPE, SIZES(I), WIDE(I),
     +                WIDE(I + NGRAFS), WIDE(I + 2*NGRAFS), FNAME(I),
     +                FTITLE(I), BARCAP, LOWER, UPPER, VECTOR_FIELD)
         GOTO 10
      ELSEIF (NUMDEC.EQ.5) THEN
C
C Change status of NPERP
C
         IF (NFILES.EQ.1) THEN
            IMID = 1
         ELSE
            NUMOPT = NFILES
            NUMDEC = 1
            CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS,
     +                   TEXT)
            IMID = NUMDEC
         ENDIF
         WRITE (OPTS,500)
         NUMOPT = 18
         NUMDEC = NPERP(IMID) + 1
         CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS,
     +                OPTS)
         NPERP(IMID) = NUMDEC - 1
         GOTO 10
      ELSEIF (NUMDEC.EQ.6) THEN
C
C Edit colour palette
C
   60    CONTINUE
         WRITE (OPTS,600)
         NUMOPT = 7
         NUMDEC = NUMOPT
         CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS, OPTS)
         IF (NUMDEC.LT.5) THEN
            IF (NUMDEC.GT.1) NUMDEC = NUMDEC + 1
            CALL VGACOL$(ICOLOR(NUMDEC))
            IF (NUMDEC.EQ.1) THEN
C
C Store the background colour
C
               STORE = .TRUE.
               CALL SAVELC$(ICOLOR(NUMDEC), STORE)
            ENDIF
            GOTO 60
         ELSEIF (NUMDEC.EQ.5) THEN
            IF (NFILES.EQ.1) THEN
               IMID = 1
            ELSE
               NUMOPT = NFILES
               NUMDEC = 1
               CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS,
     +                      TEXT)
               IMID = NUMDEC
            ENDIF
            I = IMID
            CALL VGACOL$(LCOLOR(I))
            GOTO 60
         ELSEIF (NUMDEC.EQ.6) THEN
            IF (NFILES.EQ.1) THEN
               IMID = 1
            ELSE
               NUMOPT = NFILES
               NUMDEC = 1
               CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS,
     +                      TEXT)
               IMID = NUMDEC
            ENDIF
            I = IMID
            CALL VGACOL$(MCOLOR(I))
            GOTO 60
         ELSE
            GOTO 10
         ENDIF
      ELSEIF (NUMDEC.EQ.7) THEN
C
C Change status of frame round plot
C
         FRAME = .NOT.FRAME
         GOTO 10
      ELSEIF (NUMDEC.EQ.8) THEN
C
C Suppress origin
C
         WRITE (OPTS,700)
         NUMOPT = 7
         IF (.NOT.AXES(1)) THEN
            NUMDEC = NUMOPT
         ELSEIF (FULL) THEN
            NUMDEC = NFULL
         ELSE
            NUMDEC = NFULL + 3
         ENDIF
         CALL LBOX02 (NCOLOR, NIX, NIY, NUMDEC, NUMOPT, NUMPOS,
     +                OPTS)
         IF (NUMDEC.LE.3) THEN
            AXES(1) = .TRUE.
            FULL = .TRUE.
            NFULL = NUMDEC
         ELSEIF (NUMDEC.LE.6) THEN
            AXES(1) = .TRUE.
            FULL = .FALSE.
            NFULL = NUMDEC - 3
         ELSE
            AXES(1) = .FALSE.
         ENDIF
         GOTO 10
      ELSEIF (NUMDEC.EQ.9) THEN
C
C X-range
C
         IF (E_NUMBERS) THEN
            WRITE (LINE,800) 'X', XMIN1, XMAX1
         ELSE
            D10(1) = FORMGR(XMIN1)
            D10(2) = FORMGR(XMAX1) 
            WRITE (LINE,850) 'X', TRIM(D10(1)), D10(2) 
          ENDIF 
         CALL GETDG2$(XMIN, XMAX, LINE)
         IF (XMIN.GT.XMIN1) THEN
            CALL PUTADV$('X-min too large ... restored to default')
            XMIN = XMIN1
         ENDIF
         IF (XMAX.LT.XMAX1) THEN
            CALL PUTADV$('X-max too small ... restored to default')
            XMAX = XMAX1
         ENDIF
         GOTO 10
      ELSEIF (NUMDEC.EQ.10) THEN
C
C Y-range
C
         IF (E_NUMBERS) THEN
            WRITE (LINE,800) 'Y', YMIN1, YMAX1
         ELSE
            D10(1) = FORMGR(YMIN1)
            D10(2) = FORMGR(YMAX1)
            WRITE (LINE,850) 'Y', TRIM(D10(1)), D10(2)
         ENDIF  
         CALL GETDG2$(YMIN, YMAX, LINE)
         IF (YMIN.GT.YMIN1) THEN
            CALL PUTADV$('Y-min too large ... restored to default')
            YMIN = YMIN1
         ENDIF
         IF (YMAX.LT.YMAX1) THEN
            CALL PUTADV$('Y-max too small ... restored to default')
            YMAX = YMAX1
         ENDIF
         GOTO 10
      ELSEIF (NUMDEC.EQ.11) THEN
C
C Z-range
C
         IF (E_NUMBERS) THEN
            WRITE (LINE,800) 'Z', ZMIN1, ZMAX1
         ELSE
            D10(1) = FORMGR(ZMIN1)
            D10(2) = FORMGR(ZMAX1)
            WRITE (LINE,850) 'Z', TRIM(D10(1)), D10(2)
         ENDIF  
         CALL GETDG2$(ZMIN, ZMAX, LINE)
         IF (ZMIN.GT.ZMIN1) THEN
            CALL PUTADV$('Z-min too large ... restored to default')
            ZMIN = ZMIN1
         ENDIF
         IF (ZMAX.LT.ZMAX1) THEN
            CALL PUTADV$('Z-max too small ... restored to default')
            ZMAX = ZMAX1
         ENDIF
         GOTO 10
      ELSEIF (NUMDEC.EQ.12) THEN
C
C Help
C
         WRITE (OPTS,900)
         NUMTXT = 22
         NUMBLD(1) = 1
         CALL PATCH1 (NCOLOR, NIX, NIY, LSHADE, NUMBLD, NUMTXT,
     +                OPTS,
     +                BORDER)
         GOTO 10
      ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Quit
C
         KVAL_12 = NKLCFG(N24)
         IF (KVAL_12.EQ.N1) THEN 
            QUIT = .FALSE.
            CALL GRAPHQ (QUIT)
         ELSE
            QUIT = .TRUE.
         ENDIF   
         IF (QUIT) THEN
            NTYPE = - 1
            CALL CLOSE_GR_WINDOWS
            RETURN
         ELSE
            GOTO 10
         ENDIF
      ENDIF 
C
C Format statements
C      
  100 FORMAT (
     + 'Display plot'
     +/'Edit title/labels/legends/grid-lines'
     +/'Edit axes/geometry/angle of rotation'
     +/'Edit lines/symbols/sizes/thicknesses'
     +/'Edit perpendiculars and projections',2X,A
     +/'Edit colours for graphical objects'
     +/'Plot a rectangular frame round graph',2X,A
     +/'Alter extension of (x,y) axes to origin',2X,A
     +/'Change the x_data range',2X,1P,E11.3,',',E11.3
     +/'Change the y_data range',2X,1P,E11.3,',',E11.3
     +/'Change the z_data range',2X,1P,E11.3,',',E11.3
     +/'Help'
     +/'Quit ... Exit these plot options')
  150 FORMAT (
     + 'Display plot'
     +/'Edit title/labels/legends/grid-lines'
     +/'Edit axes/geometry/angle of rotation'
     +/'Edit lines/symbols/sizes/thicknesses'
     +/'Edit perpendiculars and projections',2X,A
     +/'Edit colours for graphical objects'
     +/'Plot a rectangular frame round graph',2X,A
     +/'Alter extension of (x,y) axes to origin',2X,A
     +/'Change the x_data range',2X,A,',',1X,A
     +/'Change the y_data range',2X,A,',',1X,A
     +/'Change the z_data range',2X,A,',',1X,A
     +/'Help'
     +/'Quit ... Exit these plot options')    
  200 FORMAT (
     + 'Edit plot title'
     +/'Edit X-legend features'
     +/'Edit Y-legend features'
     +/'Edit Z-legend features'
     +/'Change X-grid line type'
     +/'Change Y-grid line type'
     +/'Change Z-grid line type'
     +/'Apply')
  300 FORMAT (
     + 'No ',A1,' grid lines'
     +/'Solid ',A1,' grid lines'
     +/'Dashed ',A1,' grid line'
     +/'Dotted ',A1,' grid lines')
  400 FORMAT (
     + 'Rotate by 0 degrees',2X,A
     +/'Rotate by 90 degrees',2X,A
     +/'Rotate by 180 degrees',2X,A
     +/'Rotate by 270 degrees',2X,A
     +/'Add on the rear axes',2X,A
     +/'Add on the front axes',2X,A
     +/'Apply')
  500 FORMAT (
     + 'No perpendiculars'
     +/'Normal Line'
     +/'Dashed line'
     +/'Dotted line'
     +/'Normal Line (+ Spot)'
     +/'Dashed line (+ Spot)'
     +/'Dotted line (+ Spot)'
     +/'Normal Line (+ Minus)'
     +/'Dashed line (+ Minus)'
     +/'Dotted line (+ Minus)'
     +/'Normal Line (+ Asterisk)'
     +/'Dashed line (+ Asterisk)'
     +/'Dotted line (+ Asterisk)'
     +/'No line ... projected Spot'
     +/'No line ... projected Minus'
     +/'No line ... projected Asterisk'
     +/'No line ... projected Plus'
     +/'No line ... projected Cross')
  600 FORMAT (
     + 'Colour for background'
     +/'Colour for graph axes'
     +/'Colour for plot title'
     +/'Colour for xy-legends'
     +/'Colour for space line'
     +/'Colour for plot symbol'
     +/'Apply')
  700 FORMAT (
     + 'Solid lines'
     +/'Dashed lines'
     +/'Dotted lines'
     +/'Solid lines (omit origin)'
     +/'Dashed lines (omit origin)'
     +/'Dotted lines (omit origin)'
     +/'Suppress rear x,y axes')
  800 FORMAT ('Range required for ',A,': data range is',1P,E11.3,
     +',',E11.3)
  850 FORMAT ('Range required for ',A,': data range is',1X,A,
     +',',1X,A)   
  900 FORMAT (
     + 'Plotting points, curves and perpendiculars'
     +/
     +/'The (x,y,z) data points can be displayed in several ways.'
     +/'1)`Connected by lines to make a continuous curve (e.g. when'
     +/'  `parameteric space curves are appropriate).'
     +/'2)`Shown as plotting symbols (e.g. circles, triangles, squares'
     +/'  `for experimental data points).'
     +/'3)`Shown with perpendiculars to the base (e.g. when examining'
     +/'  `data sets for spatial clustering).'
     +/'There are many possible combinations of line types that can be'
     +/'used for connecting data points, drawing axes, creating grid'
     +/'lines or dropping as perpendiculars, all of which can selected'
     +/'from menus.'/
     +/'The labelling convention is the same for all axes. The default'
     +/'scheme is for the extreme values to be labelled with the end'
     +/'values for the range, a descriptive legend and a directional'
     +/'arrow, which is necessary to indicate the direction of the'
     +/'axes as the plot is rotated. If you want to have subdivisions'
     +/'with intermediate values, tick marks, and possibly a grid, then'
     +/'select labels and choose the number required. Then, by editing'
     +/'the labels, an arbitrary numbering scheme can be imposed.')
      END
C
C
