C
C
      SUBROUTINE SPACE4$(ITHETA, N,
     +                   X, XTEMP, Y, YTEMP)
C
C
C ACTION : Transform XYZ to correspond to rotations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/7/96
C          Derived fron Z2TEMP
C          14/07/1997 win32 version     
C          23/04/2007 added INTENTS
C
C ADVICE : This version must have 0 < X, Y, < 1 and it alters X and Y
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N 
      INTEGER,          INTENT (INOUT) :: ITHETA 
      DOUBLE PRECISION, INTENT (INOUT) :: X(N), XTEMP(N),
     +                                    Y(N), YTEMP(N)
C
C Locals
C      
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    I
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      EXTERNAL   PUTWAR$
C
C Initialise if ITHETA not 0, 90, 180, 270
C
      IF (ITHETA.NE.0 .AND. ITHETA.NE.90 .AND.ITHETA.NE.180 .AND.
     +    ITHETA.NE.270) THEN
         CALL PUTWAR$('ITHETA re-set to 0 in SPACE4$')
         ITHETA = 0
      ENDIF
C
C Define temporary variables depending on ITHETA
C
      IF (ITHETA.EQ.0) THEN
         RETURN
      ELSEIF (ITHETA.EQ.90) THEN
         DO I = N1, N
            XTEMP(I) = ONE - Y(I)
            YTEMP(I) = X(I)
         ENDDO
      ELSEIF (ITHETA.EQ.180) THEN
         DO I = N1, N
            XTEMP(I) = ONE - X(I)
            YTEMP(I) = ONE - Y(I)
         ENDDO
      ELSEIF (ITHETA.EQ.270) THEN
         DO I = N1, N
            XTEMP(I) = Y(I)
            YTEMP(I) = ONE - X(I)
         ENDDO
      ENDIF
C
C Finally re-set X and Y
C
      DO I = N1, N
         X(I) = XTEMP(I)
         Y(I) = YTEMP(I)
      ENDDO
      END
C
C
