C
C
      SUBROUTINE SPACE6$(NFILES,  
     +                   FNAME,
     +                   PLOT_ARROWS,
     +                   PLOT_LABELS,
     +                   PLOT_LINES,
     +                   PLOT_PERPENDICULARS,
     +                   PLOT_SYMBOLS) 
C
C ACTION : Draw one or several 3D space curveS, scatter plots, or biplots
C AUTHOR : W.G.Bardsley, University of Manchester
C          05/01/2007 derived from SPACE1$
C          05/01/2014 checked for NPRESS = 24 
C          15/01/2014 added call to SAVQUE$ 

C
C ITYPE = 1: space curves
C ITYPE = 2: scatter plots
C ITYPE = 3: biplot
C
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NFILES
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(NFILES)
      LOGICAL,             INTENT (IN)    :: PLOT_ARROWS,
     +                                       PLOT_LABELS,
     +                                       PLOT_LINES,
     +                                       PLOT_PERPENDICULARS,
     +                                       PLOT_SYMBOLS 
C      
C Allocatable arrays      
C      
      DOUBLE PRECISION,       ALLOCATABLE :: XZERO(:), YZERO(:)
      DOUBLE PRECISION,       ALLOCATABLE :: X(:), XTEMP(:),
     +                                       Y(:), YTEMP(:), Z(:) 
      DOUBLE PRECISION,       ALLOCATABLE :: X_SHIFT(:), Y_SHIFT(:), 
     +                                       THETA(:)    
      CHARACTER (LEN = 80),   ALLOCATABLE :: FTITLE(:)
      CHARACTER (LEN = 40),   ALLOCATABLE :: LABEL(:), VECTOR(:)
C
C Locals
C      
      INTEGER    NPRESS
      INTEGER    NDIVS(3), NFULL, NIN, NXGRID, NYGRID, NZGRID
      INTEGER    I, IERR, ITIME, J, K, NMAX, NTEMP
      INTEGER    NPTS, NSTART_I, NSTART_IM1, NTYPE, NXTEXT, NYTEXT,
     +           NZTEXT
      INTEGER    KMODE, NGRAFS, NGRAF1, NGRAF5
      PARAMETER (KMODE = 1, NGRAFS = 300, NGRAF5 = 5*NGRAFS)
      INTEGER    IU, IV, IW, NBIG, N0, N1, N2, N3, N4, N5, N6, N7, N8,
     +           N9, N10, N11, N12, N13, N14, N15, N16, N17, N24
      PARAMETER (IU = 45, IV = 45, IW = 55, NBIG = 16, N0 = 0, N1 = 1,
     +           N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6, N7 = 7, N8 = 8,
     +           N9 = 9, N10 = 10, N11 = 11, N12 = 12, N13 = 13,
     +           N14 = 14, N15 = 15, N16 = 16, N17 = 17, N24 = 24)
      INTEGER    IFONT, NCFONT, NGKS
      PARAMETER (NCFONT = 102, NGKS = 1) 
      INTEGER    NXSAV, NYSAV, NZSAV
      INTEGER    ICOLOR(8), ITHETA
      INTEGER    L(NGRAFS), LCOLOR(NGRAFS), M(NGRAFS), MCOLOR(NGRAFS),
     +           NARR(NGRAFS), NFONT(NGRAFS), NFONT_I, NLAB(NGRAFS),
     +           NPERP(NGRAFS), NSTART(NGRAFS + 1)
      INTEGER    JCOLOR(NGRAFS), KCOLOR(NGRAFS)
      INTEGER    JSEND, NWMAX, NTOTAL
      PARAMETER (JSEND = 1, NWMAX = 2000)
      INTEGER    NCOLS, NROWS
      INTEGER    KVAL_12, NKLCFG
      DOUBLE PRECISION XMAX, XMIN, YMAX, YMIN, ZMAX, ZMIN
      DOUBLE PRECISION XMAX_SAV, XMIN_SAV, YMAX_SAV, YMIN_SAV, 
     +                 ZMAX_SAV, ZMIN_SAV
      DOUBLE PRECISION XMAX1, XMIN1, YMAX1, YMIN1, ZMAX1, ZMIN1
      DOUBLE PRECISION XMAX1_SAV, XMIN1_SAV, YMAX1_SAV, YMIN1_SAV,
     +                 ZMAX1_SAV, ZMIN1_SAV      
      DOUBLE PRECISION XDIFF, YDIFF, ZDIFF
      DOUBLE PRECISION X0, X5(N5), Y0, Y5(N5), Z0
      DOUBLE PRECISION X1(2), X1TEMP(2), Y1(2), Y1TEMP(2), Z1(2)
      DOUBLE PRECISION X_TEMP, Y_TEMP, Z_TEMP
      DOUBLE PRECISION Z_ADD
      DOUBLE PRECISION HEAD(NGRAFS), HTEMP, SIZES(NGRAFS),
     +                 WIDE(5*NGRAFS)
      DOUBLE PRECISION ASIZE, FSIZE, SLANT
      PARAMETER (ASIZE = 0.015D+00, FSIZE = 1.0D+00, SLANT = 0.0D+00)
      DOUBLE PRECISION ONE, R2BIG, ZERO
      PARAMETER (ONE = 1.0D+00, R2BIG = 99999.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION SMALL
      PARAMETER (SMALL = 1.0D-100)
      DOUBLE PRECISION ATEMP, CTEMP
      PARAMETER (ATEMP = 1.0D+00, CTEMP = 1.0D+00)
      DOUBLE PRECISION XCLIP(2), XSIZE(NGRAFS), XSIZE_I, YCLIP(2)
      CHARACTER  ARRAYT*(IW), ARRAYX*(IV), ARRAYY*(IV), ARRAYZ*(IV),
     +           PTITLE*(IW), XTITLE*(IV), YTITLE*(IV), ZTITLE*(IV),
     +           TITLEP*(IW), TITLEX*(IV), TITLEY*(IV), TITLEZ*(IV)
      CHARACTER  XTEXT(NBIG)*(IU), YTEXT(NBIG)*(IU), ZTEXT(NBIG)*(IU),
     +           XTEXT1(NBIG)*(IU), YTEXT1(NBIG)*(IU),
     +           ZTEXT1(NBIG)*(IU)
      CHARACTER  BLANK*1, FONT*1, TYPE1*4, VEC40*40
      PARAMETER (BLANK = ' ', 
     +           FONT = BLANK,
     +           TYPE1 = 'free',
     +           VEC40 = '0000000000000000000000000000000000000000')
      CHARACTER  NOT_THREE*80, NO_ROWS*80, TOO_MANY*80
      PARAMETER (NOT_THREE =
     +'SPACE6$ file format error ...must have 3 columns, i.e., x,y,z',
     +           NO_ROWS =
     +'SPACE6$ file format error ... must have at least 1 row',
     +           TOO_MANY =
     +'Too many files submitted to SPACE6$ ... maxmimum = 300')  
      LOGICAL    AXES(2), FRAME, FULL
      LOGICAL    ABORT, ARROWS(3), FIRST, GSAVE, LABELS(3),
     +           NEWRUN, NUMBER(3), TICKS(3), XTSHOW,
     +           X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT
      LOGICAL    ADJUST, PLOT_WORDS, QUIT
C
C Parameters from DLL in common block in DEFNGKS.INS
C
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
      EXTERNAL   PUTFAT$, ISITMF, GETWRD, GETNOU
      EXTERNAL   GKSDEK$, GETDEF$, GSELNT$, AFRAME$, GKSDRW$, GKSSYM$,
     +           SURAAA$, SURBBB$, SURCCC$, GETGKS_INT, GETGKS_LGL,
     +           SUR002$, WGB_ARROW$, PLTSTR$, 
     +           SPACE2$, SPACE7$, SPACE4$, XYZ2XY$,
     +           FILL_POLYGON$, DEFGKS$, LINE$, GSLN$, GSLWSC$,
     +           PSSPEC$, NKLCFG, GRAPHQ
      INTRINSIC  MIN, ABS
      SAVE       ICOLOR, ITHETA, L, LCOLOR, M, MCOLOR, NTYPE,
     +           NXSAV, NYSAV, NZSAV, SIZES, WIDE,
     +           ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +           PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1, YTITLE,
     +           ZTEXT, ZTEXT1, ZTITLE,
     +           ARROWS, AXES, FRAME, FULL, LABELS,
     +           NEWRUN, NUMBER, X2INT, Y2INT, ZTSHOW, Z2INT
C
C Default settings
C
      DATA ICOLOR / 15,  0,  0,  0,  0, 0, 0, 0 /
      DATA L / NGRAFS*1 /
      DATA LCOLOR / NGRAFS*0 /
      DATA M / NGRAFS*5 /
      DATA MCOLOR / NGRAFS*0 /
      DATA NXSAV, NYSAV, NZSAV / NBIG, NBIG, NBIG /
      DATA SIZES / NGRAFS*ONE /
      DATA WIDE / NGRAF5*ONE /
      DATA PTITLE / 'SIMFIT 3D space plot' /
      DATA ARRAYT / '00000000000000000000' /
      DATA XTITLE / 'X' /
      DATA ARRAYX / '0' /
      DATA YTITLE / 'Y' /
      DATA ARRAYY / '0' /
      DATA ZTITLE / 'Z' /
      DATA ARRAYZ / '0' /
      DATA AXES / .TRUE., .TRUE. /
      DATA FRAME / .FALSE. /
      DATA FULL / .TRUE. /
      DATA ITHETA / 0 /
      DATA NTYPE / 1 /
      DATA NXTEXT, NYTEXT, NZTEXT / NBIG, NBIG, NBIG /
      DATA XTSHOW, YTSHOW, ZTSHOW / .FALSE., .FALSE., .TRUE. /
      DATA X2INT, Y2INT, Z2INT / .FALSE., .FALSE., .FALSE. /
      DATA X5 / ZERO,  ONE, ONE, ZERO, ZERO /
      DATA Y5 / ZERO, ZERO, ONE,  ONE,  ONE /
      DATA NEWRUN / .TRUE. /
      DATA NLAB / NGRAFS*0 /
      DATA NPERP / NGRAFS*0 /
      DATA NFULL, NXGRID, NYGRID, NZGRID / N3, N3, N3, N3 /
      DATA NARR / NGRAFS*20 /
      DATA HEAD / NGRAFS*ONE /
      DATA JCOLOR / NGRAFS*0 /
      DATA KCOLOR / NGRAFS*0 /
      DATA NFONT / NGRAFS*5 /
      DATA XSIZE / NGRAFS*ONE /
C
C Part 1: Check, initialise, and allocate....................................
C =======
C
      IF (NFILES.LT.N1) RETURN
      IF (NFILES.GT.NGRAFS) THEN
         CALL PUTFAT$(TOO_MANY)
         RETURN
      ENDIF   
      NMAX = N0
      NTOTAL = N0
      NSTART(1) = N1
      DO I = N1, NFILES
         CALL ISITMF (NCOLS, NROWS, 
     +                FNAME(I))
         IF (NCOLS.NE.3) THEN
            CALL PUTFAT$(NOT_THREE)
            RETURN
         ENDIF
         IF (NROWS.LT.N1) THEN
            CALL PUTFAT$(NO_ROWS)
            RETURN
         ENDIF
         IF (NROWS.GT.NMAX) NMAX = NROWS   
         NTOTAL = NTOTAL + NROWS  
         NSTART(I + 1) = NSTART(I) + NROWS
      ENDDO
C
C Find an unopened unit
C      
      CALL GETNOU (NIN)
C
C Allocate
C    
      NGRAF1 = NFILES
      IERR = 0
      IF (ALLOCATED(XZERO)) DEALLOCATE(XZERO, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XTEMP)) DEALLOCATE(XTEMP, STAT = IERR)
      IF (IERR.NE.0) RETURN        
      IF (ALLOCATED(YZERO)) DEALLOCATE(YZERO)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YTEMP)) DEALLOCATE(YTEMP, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.0) RETURN                     
      IF (ALLOCATED(FTITLE)) DEALLOCATE(FTITLE)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(LABEL)) DEALLOCATE(LABEL)
      IF (IERR.NE.0) RETURN  
      IF (ALLOCATED(VECTOR)) DEALLOCATE(VECTOR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(X_SHIFT)) DEALLOCATE(X_SHIFT)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y_SHIFT)) DEALLOCATE(Y_SHIFT)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(THETA)) DEALLOCATE(THETA)
      IF (IERR.NE.0) RETURN     
      ALLOCATE(XZERO(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(X(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(XTEMP(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN        
      ALLOCATE(YZERO(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE(Y(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(YTEMP(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN         
      ALLOCATE(Z(NMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN         
      ALLOCATE(FTITLE(NFILES), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE(LABEL(NWMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(VECTOR(NWMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      ALLOCATE(X_SHIFT(NWMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Y_SHIFT(NWMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(THETA(NWMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN         
C
C Part 2: Initialise standard defaults......................................
C =======
C        
      
      DO I = N1, NWMAX
         X_SHIFT(I) = ZERO
         Y_SHIFT(I) = ZERO
         THETA(I) = ZERO
         LABEL(I) = BLANK
         VECTOR(I) = VEC40
      ENDDO
C
C Plot biplot type arrows ... label colours = arrow colours
C      
      IF (PLOT_ARROWS) THEN
         DO I = N1, NFILES
            NARR(I) = 20
            JCOLOR(I) = 0
         ENDDO
         NARR(2) = 21
         NARR(3) = 1
         NARR(4) = 16 
         JCOLOR(1) = 4
         JCOLOR(2) = 1
         DO I = N1, NFILES
            KCOLOR(I) = JCOLOR(I)
         ENDDO   
      ELSE
         DO I = N1, NFILES
            NARR(I) = 0
         ENDDO         
      ENDIF
C
C Plot labels ... at arrow heads or symbols
C      
      IF (PLOT_LABELS .AND. NTOTAL.LE.NWMAX) THEN
         PLOT_WORDS = .TRUE.
         DO I = N1, NFILES
            NLAB(I) = 1
            CALL ISITMF (NCOLS, NROWS, 
     +                   FNAME(I))
            CALL GETWRD (JSEND, NCOLS, NIN, NROWS, NROWS,
     +                   FNAME(I), LABEL(NSTART(I)))
         ENDDO
      ELSE
         PLOT_WORDS = .FALSE.
         DO I = N1, NFILES
            NLAB(I) = 0
         ENDDO      
      ENDIF
C
C Plot lines ... joining symbols
C
      IF (PLOT_LINES) THEN
         DO I = N1, NFILES
            L(I) = 1
            LCOLOR(I) = 0
         ENDDO
         LCOLOR(2) = 4
         LCOLOR(3) = 1
      ELSE
         DO I = N1, NFILES
            L(I) = 0
         ENDDO         
      ENDIF     
C
C Plot perpendiculars ... from symbols to floor
C
      IF (PLOT_PERPENDICULARS) THEN
         DO I = N1, NFILES
            NPERP(I) = 1
         ENDDO
      ELSE
         DO I = N1, NFILES
            NPERP(I) = 0
         ENDDO         
      ENDIF 
C
C Plot symbols ... label colours = symbol colours
C
      IF (PLOT_SYMBOLS) THEN
         DO I = N1, NFILES
            M(I) = 1
            MCOLOR(I) = 0
         ENDDO
         M(1) = 5
         M(2) = 8
         M(3) = 11
         M(4) = 14
         M(5) = 6
         M(6) = 9
         M(7) = 12
         M(8) = 15
         M(9) = 7
         M(10) = 10
         M(11) = 13
         M(12) = 16
         MCOLOR(2) = 4
         MCOLOR(3) = 1
         DO I = N1, NFILES
            KCOLOR(I) = MCOLOR(I)
         ENDDO   
      ELSE
         DO I = N1, NFILES
            M(I) = 0
         ENDDO         
      ENDIF            
           
      CALL DEFGKS$
      XCLIP(1) = ZERO
      XCLIP(2) = ONE
      YCLIP(1) = ZERO
      YCLIP(2) = ONE
      IF (NEWRUN) THEN
C
C Extra defaults to be set up the first time round
C
         DO I = N1, NBIG
            WRITE (XTEXT(I),100) 'x', I
            WRITE (YTEXT(I),100) 'y', I
            WRITE (ZTEXT(I),100) 'z', I
            XTEXT1(I) = '000000000'
            YTEXT1(I) = '000000000'
            ZTEXT1(I) = '000000000'
         ENDDO
         DO I = N1, N3
            ARROWS(I) = .TRUE.
            LABELS(I) = .FALSE.
            NUMBER(I) = .TRUE.
         ENDDO
         NXTEXT = N2
         NYTEXT = N2
         NZTEXT = N2
         XTSHOW = .TRUE.
         YTSHOW = .TRUE.
         ZTSHOW = .TRUE.
         NEWRUN = .FALSE.
      ENDIF
C
C Read in the data files and calculate parameters for scaling
C
      DO I = N1, NFILES 
         OPEN (UNIT = NIN, FILE = FNAME(I))
         READ (NIN,'(A)') FTITLE(I)
         READ (NIN,*) NPTS, NCOLS
         READ (NIN,*) X(1), Y(1), Z(1)
         IF (I.EQ.1) THEN
            XMAX = X(1)
            XMIN = X(1)
            YMAX = Y(1)
            YMIN = Y(1)
            ZMAX = Z(1)
            ZMIN = Z(1)
         ELSE
            IF (X(1).GT.XMAX) XMAX = X(1)
            IF (X(1).LT.XMIN) XMIN = X(1)
            IF (Y(1).GT.YMAX) YMAX = Y(1)
            IF (Y(1).LT.YMIN) YMIN = Y(1)
            IF (Z(1).GT.ZMAX) ZMAX = Z(1)
            IF (Z(1).LT.ZMIN) ZMIN = Z(1)
         ENDIF
               
         DO J = N2, NPTS
            READ (NIN,*) X(J), Y(J), Z(J)      
            IF (X(J).GT.XMAX) XMAX = X(J)
            IF (X(J).LT.XMIN) XMIN = X(J)
            IF (Y(J).GT.YMAX) YMAX = Y(J)
            IF (Y(J).LT.YMIN) YMIN = Y(J)
            IF (Z(J).GT.ZMAX) ZMAX = Z(J)
            IF (Z(J).LT.ZMIN) ZMIN = Z(J)
         ENDDO
         CLOSE (UNIT = NIN)
      ENDDO
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      ZDIFF = ZMAX - ZMIN
      IF (ABS(XDIFF).LE.SMALL) THEN
         CALL PUTFAT$('No variation in X-values')
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(XTEMP, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(YTEMP, STAT = IERR)
         DEALLOCATE(Z, STAT = IERR)
         DEALLOCATE(FTITLE, STAT = IERR)                  
         DEALLOCATE(LABEL, STAT = IERR)
         DEALLOCATE(VECTOR, STAT = IERR)         
         DEALLOCATE(X_SHIFT, STAT = IERR)
         DEALLOCATE(Y_SHIFT, STAT = IERR)
         DEALLOCATE(THETA, STAT = IERR)
         RETURN
      ENDIF
      IF (ABS(YDIFF).LE.SMALL) THEN
         CALL PUTFAT$('No variation in Y-values')
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(XTEMP, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(YTEMP, STAT = IERR)
         DEALLOCATE(Z, STAT = IERR)
         DEALLOCATE(FTITLE, STAT = IERR)                  
         DEALLOCATE(LABEL, STAT = IERR)
         DEALLOCATE(VECTOR, STAT = IERR)         
         DEALLOCATE(X_SHIFT, STAT = IERR)
         DEALLOCATE(Y_SHIFT, STAT = IERR)
         DEALLOCATE(THETA, STAT = IERR)
         RETURN
      ENDIF
      IF (ABS(ZDIFF).LE.SMALL) THEN
         CALL PUTFAT$('No variation in Z-values')
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(XTEMP, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(YTEMP, STAT = IERR)
         DEALLOCATE(Z, STAT = IERR)
         DEALLOCATE(FTITLE, STAT = IERR)                  
         DEALLOCATE(LABEL, STAT = IERR)
         DEALLOCATE(VECTOR, STAT = IERR)         
         DEALLOCATE(X_SHIFT, STAT = IERR)
         DEALLOCATE(Y_SHIFT, STAT = IERR)
         DEALLOCATE(THETA, STAT = IERR)
         RETURN
      ENDIF
C
C Define parameters to save and restore ranges
C      
      XMAX1 = XMAX
      XMIN1 = XMIN
      YMAX1 = YMAX
      YMIN1 = YMIN
      ZMAX1 = ZMAX
      ZMIN1 = ZMIN
      XMAX_SAV = XMAX
      XMIN_SAV = XMIN
      YMAX_SAV = YMAX
      YMIN_SAV = YMIN
      ZMAX_SAV = ZMAX
      ZMIN_SAV = ZMIN
      XMAX1_SAV = XMAX
      XMIN1_SAV = XMIN
      YMAX1_SAV = YMAX
      YMIN1_SAV = YMIN
      ZMAX1_SAV = ZMAX
      ZMIN1_SAV = ZMIN
C
C Part 3: Main branch point ............................................
C =======
C
   20 CONTINUE
C
C Restore defaults
C   
      XMAX = XMAX_SAV
      XMIN = XMIN_SAV
      YMAX = YMAX_SAV
      YMIN = YMIN_SAV
      ZMAX = ZMAX_SAV
      ZMIN = ZMIN_SAV
      XMAX1 = XMAX1_SAV
      XMIN1 = XMIN1_SAV
      YMAX1 = YMAX1_SAV
      YMIN1 = YMIN1_SAV
      ZMAX1 = ZMAX1_SAV
      ZMIN1 = ZMIN1_SAV  
C
C Call the main menu
C       
      CALL SPACE7$(ICOLOR, ITHETA, JCOLOR, KCOLOR, L, LCOLOR, M, MCOLOR,
     +             NARR, NBIG, NFILES, NFONT, NFULL, NGRAF1, NLAB, 
     +             NPERP, NSTART, NTOTAL, NTYPE, NWMAX, NXGRID, NXSAV,
     +             NXTEXT, NYGRID, NYSAV, NYTEXT, NZGRID, NZSAV, NZTEXT,
     +             HEAD, SIZES, THETA, WIDE,
     +             XMAX, XMAX1, XMIN, XMIN1, XSIZE, X_SHIFT,
     +             YMAX, YMAX1, YMIN, YMIN1, Y_SHIFT, 
     +             ZMAX, ZMAX1, ZMIN, ZMIN1,
     +             ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +             FNAME, FTITLE, LABEL, PTITLE, VECTOR,
     +             XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1, YTITLE,
     +             ZTEXT, ZTEXT1, ZTITLE,
     +             AXES, ARROWS, FRAME, FULL, LABELS, NUMBER,
     +             PLOT_WORDS,
     +             XTSHOW, X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT)
C
C Store new defaults
C     
      XMAX_SAV = XMAX
      XMIN_SAV = XMIN
      YMAX_SAV = YMAX
      YMIN_SAV = YMIN
      ZMAX_SAV = ZMAX
      ZMIN_SAV = ZMIN
      XMAX1_SAV = XMAX1
      XMIN1_SAV = XMIN1
      YMAX1_SAV = YMAX1
      YMIN1_SAV = YMIN1
      ZMAX1_SAV = ZMAX1
      ZMIN1_SAV = ZMIN1
C
C Check for 0,0,0 if arrows are to be plotted
C      
      ADJUST = .FALSE.
      DO I = N1, NFILES
         IF (NARR(I).GT.N0) THEN
            ADJUST = .TRUE.
            EXIT
         ENDIF
      ENDDO
      IF (ADJUST) THEN
         IF (XMIN.GT.ZERO) XMIN = ZERO
         IF (XMAX.LT.ZERO) XMAX = ZERO  
         IF (YMIN.GT.ZERO) YMIN = ZERO
         IF (YMAX.LT.ZERO) YMAX = ZERO
         IF (ZMIN.GT.ZERO) ZMIN = ZERO
         IF (ZMAX.LT.ZERO) ZMAX = ZERO 
         IF (XMIN1.GT.ZERO) XMIN1 = ZERO
         IF (XMAX1.LT.ZERO) XMAX1 = ZERO  
         IF (YMIN1.GT.ZERO) YMIN1 = ZERO
         IF (YMAX1.LT.ZERO) YMAX1 = ZERO
         IF (ZMIN1.GT.ZERO) ZMIN1 = ZERO
         IF (ZMAX1.LT.ZERO) ZMAX1 = ZERO       
      ENDIF 
C
C Re-calculate ranges
C             
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      ZDIFF = ZMAX - ZMIN
C
C Return to start if NTYPE out of range
C
      IF (NTYPE.LT.1) THEN
         DEALLOCATE(XZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(XTEMP, STAT = IERR)
         DEALLOCATE(YZERO, STAT = IERR)
         DEALLOCATE(X, STAT = IERR)
         DEALLOCATE(YTEMP, STAT = IERR)
         DEALLOCATE(Z, STAT = IERR)
         DEALLOCATE(FTITLE, STAT = IERR)                  
         DEALLOCATE(LABEL, STAT = IERR)
         DEALLOCATE(VECTOR, STAT = IERR)         
         DEALLOCATE(X_SHIFT, STAT = IERR)
         DEALLOCATE(Y_SHIFT, STAT = IERR)
         DEALLOCATE(THETA, STAT = IERR)
         RETURN
      ENDIF   
      IF (X2INT .AND. XMAX.GT.R2BIG) X2INT = .FALSE.
      IF (X2INT .AND. XMIN.LT.-R2BIG) X2INT = .FALSE.
      IF (Y2INT .AND. YMAX.GT.R2BIG) Y2INT = .FALSE.
      IF (Y2INT .AND. YMIN.LT.-R2BIG) Y2INT = .FALSE.
      IF (Z2INT .AND. ZMAX.GT.R2BIG) Z2INT = .FALSE.
      IF (Z2INT .AND. ZMIN.LT.-R2BIG) Z2INT = .FALSE.
C
C Data are ready so now proceed to create the graph
C
      ABORT = .FALSE.
      FIRST = .TRUE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
C
C Branch point for hardcopy from GKSDEK$ ............................
C
   40 CONTINUE
C
C Define transformations and open graphics
C
      CALL SUR002$(KMODE)
      IF (ICOLOR(1).NE.0) THEN
         CALL GSELNT$(N0)
         CALL FILL_POLYGON$(N5, X5, Y5, ICOLOR(1))
      ENDIF
      IF (PS) CALL PSSPEC$(N2, NOUT_PS)
C
C Draw axes for plot
C
      DO I = N1, N3
         NDIVS(I) = 0
         TICKS(I) = .FALSE.
      ENDDO
      IF (ITHETA.EQ.0 .OR. ITHETA.EQ.180) THEN
C********Eiting 23/07/2001 to allow multiple tick marks with numbers
C********IF (.NOT.LABELS(1)) THEN
            TICKS(1) = .TRUE.
C********ELSE
            NDIVS(1) = NXTEXT
C********ENDIF
C********IF (.NOT.LABELS(2)) THEN
            TICKS(2) = .TRUE.
C********ELSE
            NDIVS(2) = NYTEXT
C********ENDIF
      ELSE
C********IF (.NOT.LABELS(2)) THEN
            TICKS(1) = .TRUE.
C********ELSE
            NDIVS(1) = NYTEXT
C********ENDIF
C********IF (.NOT.LABELS(1)) THEN
            TICKS(2) = .TRUE.
C********ELSE
            NDIVS(2) =  NXTEXT
C********ENDIF
      ENDIF
C*****IF (.NOT.LABELS(3)) THEN
          TICKS(3) = .TRUE.
C*****ELSE
          NDIVS(3) = NZTEXT
C*****ENDIF
      ITIME = N1
      CALL SPACE2$(ICOLOR(3), ITIME, NDIVS, NFULL, NXGRID, NYGRID,
     +             NZGRID, AXES, FULL, TICKS)
      CALL AFRAME$(ICOLOR(3), FRAME, PS)
C
C Title and legends
C
      TITLEP = PTITLE
      TITLEX = XTITLE
      TITLEY = YTITLE
      TITLEZ = ZTITLE
      CALL SURAAA$(ICOLOR(4), NOUT_PS, Y_SCALE, ARRAYT, TITLEP,
     +             HARD_COPY, HPGL, PS)
      CALL SURBBB$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, Y_SCALE,
     +             ARRAYX, ARRAYY, ARRAYZ, TITLEX, TITLEY, TITLEZ,
     +             ARROWS, HARD_COPY, HPGL, LABELS, PS, XTSHOW,
     +             YTSHOW, ZTSHOW)
      CALL SURCCC$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, NXTEXT, NYTEXT,
     +             NZTEXT,
     +             XMAX, XMIN, YMAX, YMIN, Y_SCALE, ZMAX, ZMIN,
     +             XTEXT, XTEXT1, YTEXT, YTEXT1, ZTEXT, ZTEXT1,
     +             HARD_COPY, HPGL, LABELS, NUMBER, PS, X2INT,
     +             Y2INT, Z2INT)
C
C Part 4: Draw all the lines with L(I) > 0.................................
C =======
C
      DO I = N1, NFILES
C
C First read in the data
C
         IF (L(I).GT.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(I))
            READ (NIN,'(A)') FTITLE(I)
            READ (NIN,*) NPTS, J
            DO J = N1, NPTS
               READ (NIN,*) X(J), Y(J), Z(J)
            ENDDO
            CLOSE (UNIT = NIN)
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
C
C Call GKSDRW$ to draw the lines
C
            CALL GKSDRW$(LCOLOR(I), N1, L(I), NPTS, WIDE(I), XTEMP,
     +                   YTEMP)
         ENDIF
      ENDDO
C
C Part 5: Drop perpendiculars...............................................
C =======
C
      DO I = N1, NFILES
C
C First read in the data
C
         IF (NPERP(I).GT.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(I))
            READ (NIN,'(A)') FTITLE(I)
            READ (NIN,*) NPTS, J
            DO J = N1, NPTS
               READ (NIN,*) X(J), Y(J), Z(J)
            ENDDO
            CLOSE (UNIT = NIN)
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            Z0 = ZERO
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
               CALL XYZ2XY$(X(J), XZERO(J), Y(J), YZERO(J), Z0)
            ENDDO
            CALL GSELNT$(N1)
            CALL GSLWSC$(ONE)
            IF (NPERP(I).LE.N12) THEN
C
C Drop perpendiculars
C
               IF (NPERP(I).EQ.N1 .OR. NPERP(I).EQ.N4 .OR.
     +             NPERP(I).EQ.N7 .OR. NPERP(I).EQ.N10) THEN
                  CALL GSLN$(N1)
               ELSEIF (NPERP(I).EQ.N2 .OR. NPERP(I).EQ.N5 .OR.
     +                 NPERP(I).EQ.N8 .OR. NPERP(I).EQ.N11) THEN
                  CALL GSLN$(N2)
               ELSE
                  CALL GSLN$(N3)
               ENDIF
               NTEMP = MIN(NPTS, NMAX)
               DO J = N1, NTEMP
                  CALL LINE$(XZERO(J), YZERO(J), XTEMP(J), YTEMP(J),
     +                       MCOLOR(I))
               ENDDO
            ENDIF
C
C Part 6: Call GKSSYM$ to draw the projections.................................
C =======
C
            IF (NPERP(I).EQ.N4 .OR. NPERP(I).EQ.N5 .OR.
     +          NPERP(I).EQ.N6 .OR. NPERP(I).EQ.N13) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N1, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N7 .OR. NPERP(I).EQ.N8 .OR.
     +              NPERP(I).EQ.N9 .OR. NPERP(I).EQ.N14) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N17, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N10 .OR. NPERP(I).EQ.N11 .OR.
     +              NPERP(I).EQ.N12 .OR. NPERP(I).EQ.N15) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N4, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N16) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N2, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ELSEIF (NPERP(I).EQ.N17) THEN
               CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(I), N3, NTEMP,
     +                      ATEMP, CTEMP, SIZES(I), WIDE(I), XZERO,
     +                      ONE, ZERO, YZERO)
            ENDIF
         ENDIF
      ENDDO
C
C Part 7: Draw all the markers with M(I) > 0.............................
C =======
C
      DO I = N1, NFILES
C
C First read in the data
C
         IF (M(I).GT.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(I))
            READ (NIN,'(A)') FTITLE(I)
            READ (NIN,*) NPTS, J
            DO J = N1, NPTS
               READ (NIN,*) X(J), Y(J), Z(J)
            ENDDO
            CLOSE (UNIT = NIN)
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
C
C Call GKSSYM$ to draw the symbols
C
            CALL GKSSYM$(MCOLOR(I), N1, ICOLOR(1), M(I), NPTS, ATEMP,
     +                   CTEMP, SIZES(I), WIDE(I), XTEMP, ONE, ZERO,
     +                   YTEMP)
         ENDIF
      ENDDO   
C
C Part 8: Draw all the arrows with NARR(I) > 0...............................
C =======
C
      DO I = N1, NFILES
C
C First read in the data
C
         IF (NARR(I).GT.N0) THEN
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FNAME(I))
            READ (NIN,'(A)') FTITLE(I)
            READ (NIN,*) NPTS, J
            DO J = N1, NPTS
               READ (NIN,*) X(J), Y(J), Z(J)
            ENDDO
            CLOSE (UNIT = NIN)
C
C Normalise the data
C
            DO J = N1, NPTS
               X(J) = (X(J) - XMIN)/XDIFF
               Y(J) = (Y(J) - YMIN)/YDIFF
               Z(J) = (Z(J) - ZMIN)/ZDIFF
            ENDDO
C
C Transform the data depending on ITHETA
C
            CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
            DO J = N1, NPTS
               CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
            ENDDO
C
C Calculate 0,0,0 using J = 2 to avoid problems with SPACE4$
C  
            DO J = 1, 2
               X1(J) = -XMIN/XDIFF
               Y1(J) = -YMIN/YDIFF          
               Z1(J) = -ZMIN/ZDIFF
            ENDDO
            J = 2
            CALL SPACE4$(ITHETA, J, X1, X1TEMP, Y1, Y1TEMP)  
            CALL XYZ2XY$(X1(1), X0, Y1(1), Y0, Z1(1)) 
C
C Call WGB_ARROW$ to draw the symbols, setting X0,Y0,Z0 = 0,0,0
C
            CALL GSELNT$(N1)
            CALL GSLWSC$(ONE)
            HTEMP = ASIZE*HEAD(I)
            DO J = N1, NPTS 
               CALL WGB_ARROW$(NARR(I), JCOLOR(I), ICOLOR(1),
     +                         HTEMP, XTEMP(J), X0, YTEMP(J), Y0)
            ENDDO
         ENDIF
      ENDDO

C
C Part 9: Draw all the labels.............................................
C =======
C
      IF (PLOT_WORDS) THEN
         CALL GETGKS_INT (N5, NOUT_PS)
         CALL GETGKS_LGL (N2,
     +                    HARD_COPY)  
         CALL GETGKS_LGL (N3,
     +                    HPGL)        
         CALL GETGKS_LGL (N6,
     +                    PS)   
        
         DO I = N1, NFILES
C
C First read in the data
C
            IF (NLAB(I).GT.N0) THEN
               NSTART_I = NSTART(I)
               NSTART_IM1 = NSTART_I - N1
               CLOSE (UNIT = NIN)
               OPEN (UNIT = NIN, FILE = FNAME(I))
               READ (NIN,'(A)') FTITLE(I)
               READ (NIN,*) NPTS, J
               DO J = N1, NPTS
                  READ (NIN,*) X(J), Y(J), Z(J)
               ENDDO
               CLOSE (UNIT = NIN)
C
C Normalise the data
C
               DO J = N1, NPTS
                  X(J) = (X(J) - XMIN)/XDIFF
                  Y(J) = (Y(J) - YMIN)/YDIFF
                  Z(J) = (Z(J) - ZMIN)/ZDIFF
               ENDDO
C
C Transform the data depending on ITHETA
C
               CALL SPACE4$(ITHETA, NPTS, X, XTEMP, Y, YTEMP)
C
C Make the projective transformation
C
              
               IF (NARR(I).GT.N0) THEN
                  DO J = N1, NPTS
                     CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J), Z(J))
                  ENDDO
C
C Method 1: move the labels by adding/subtracting depending on the quadrant
C           Note: when calculating displacements the data have been normalised to (0,1)
C                  
                  DO J = N1, NPTS
                     IF (XTEMP(J).GE.X0) THEN
                        XTEMP(J) = XTEMP(J) + 0.005D+00
                        IF (YTEMP(J).GE.Y0) THEN
                           YTEMP(J) = YTEMP(J) + 0.005D+00
                        ELSE
                           YTEMP(J) = YTEMP(J) - 0.025D+00
                        ENDIF     
                     ELSE  
                        XTEMP(J) = XTEMP(J) - 0.05D+00
                        IF (YTEMP(J).GE.Y0) THEN
                           YTEMP(J) = YTEMP(J) + 0.005D+00
                        ELSE
                           YTEMP(J) = YTEMP(J) - 0.05D+00
                        ENDIF     
                     ENDIF     
                  ENDDO  
C
C method 2: this technique merely extends the vectors centrifugally
C           Note: when calculating displacements the data have been normalised to (0,1)
C
C                  
C                  DO J = N1, NPTS
C                     IF (XTEMP(J).GE.X0) THEN
C                        XTEMP(J) = 1.025D+00*XTEMP(J)
C                        YTEMP(J) = 1.05D+00*YTEMP(J)
C                     ELSE
C                        XTEMP(J) = 1.10D+00*XTEMP(J) 
C                        YTEMP(J) = 1.10D+00*YTEMP(J)
C                     ENDIF    
C                  ENDDO 
               ELSE  
C
C method 3: just move labels upwards
C           Note: when calculating displacements the data have been normalised to (0,1)
C                 
                   Z_ADD = 0.01D+00
                   DO J = N1, NPTS
                     Z_TEMP = Z_ADD + Z(J)
                     CALL XYZ2XY$(X(J), XTEMP(J), Y(J), YTEMP(J),
     +                            Z_TEMP)
                  ENDDO    
               ENDIF   
               IF (PS) WRITE (NOUT_PS,200) XSIZE(I)              
C
C Call PLTSTR$ to draw the LABELS
C
               CALL GSELNT$(N1)
               IFONT = KCOLOR(I)
               NFONT_I = NFONT(I)
               XSIZE_I = FSIZE*XSIZE(I)
               DO J = N1, NPTS 
                  K = NSTART_IM1 + J
                  X_TEMP = XTEMP(J) + X_SHIFT(K)
                  Y_TEMP = YTEMP(J) + Y_SHIFT(K)
                  CALL PLTSTR$(IFONT, NCFONT, NFONT_I, NGKS, NOUT_PS,
     +                         THETA(K), XSIZE_I, SLANT,
     +                         X_TEMP, Y_TEMP, Y_SCALE,
     +                         FONT, LABEL(K),
     +                         VECTOR(K), TYPE1,                     
     +                         HARD_COPY, HPGL, PS)
               ENDDO
            ENDIF
         ENDDO      
      ENDIF   
C
C Part 10: End of curve drawing ... Finish off the axes.......................
C ========
C
      IF (AXES(2)) THEN
         ITIME = N2
         CALL SPACE2$(ICOLOR(3), ITIME, NDIVS, NFULL, NXGRID, NYGRID,
     +                NZGRID, AXES, FULL, TICKS)
      ENDIF
      FIRST = .FALSE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS, XCLIP, YCLIP, ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
      IF (NPRESS.EQ.20) THEN
         GOTO 20
      ELSEIF (NPRESS.EQ.24) THEN   
         KVAL_12 = NKLCFG(N24)
         IF (KVAL_12.EQ.N1) THEN 
            QUIT = .FALSE.
            CALL GRAPHQ (QUIT)
         ELSE
            QUIT = .TRUE.
         ENDIF   
         IF (QUIT) THEN
            DEALLOCATE(XZERO, STAT = IERR)
            DEALLOCATE(X, STAT = IERR)
            DEALLOCATE(XTEMP, STAT = IERR)
            DEALLOCATE(YZERO, STAT = IERR)
            DEALLOCATE(X, STAT = IERR)
            DEALLOCATE(YTEMP, STAT = IERR)
            DEALLOCATE(Z, STAT = IERR)
            DEALLOCATE(FTITLE, STAT = IERR)                  
            DEALLOCATE(LABEL, STAT = IERR)
            DEALLOCATE(VECTOR, STAT = IERR)         
            DEALLOCATE(X_SHIFT, STAT = IERR)
            DEALLOCATE(Y_SHIFT, STAT = IERR)
            DEALLOCATE(THETA, STAT = IERR)
            RETURN
         ELSE
            GOTO 20
         ENDIF         
      ELSE
         GOTO 40
      ENDIF  
C
C Format statements
C      
  100 FORMAT (A,'label',I3)
C
C this format statement must NOT be edited
C      
  200 FORMAT ('/tl-size tl-size',1X,f7.3,1X,'mul def')  
      END
C
C



