c
c
      subroutine space8$(isend, jcolor, kcolor, narr, nfont, nlab, npts,
     +                   ntotal, nwmax,
     +                   head, theta, xsize, x_shift, y_shift,
     +                   label, vector)
c
c action: overflow menus for SPACE7$
c author: w.g.bardsley, university of manchester, u.k., 08/01/2008
c
c isend = 1: edit arrows
c isend = 2: edit labels
c            
      implicit none
c
c arguments
c      
      integer,             intent (in)    :: isend, npts, ntotal,
     +                                       nwmax
      integer,             intent (inout) :: nfont, nlab
      integer,             intent (inout) :: jcolor, kcolor, narr 
      double precision,    intent (inout) :: head, theta(npts), xsize,
     +                                       x_shift(npts), 
     +                                       y_shift(npts)      
      character (len = *), intent (inout) :: label(npts), vector(npts)
c
c locals
c      
      integer    imid, numdec, numopt
      integer    jsend
      integer    numtxt
      parameter (numtxt = 22)
      integer    numbld(numtxt)
      double precision theta_min, theta_max
      parameter (theta_max = 360.0d+00, theta_min = -theta_max)
      double precision fmin, fmax
      parameter (fmin = 0.10d+00, fmax = 10.0d+00)
      character  cipher(2)*40, line*100, text(30)*100
      character  font(13)*30
      character  blank*1, current*40
      parameter (blank = ' ', current = '[Current choice]')
      logical    again, repeet
      external   listbx, getd01$, vgacol$, getdm1$, newstr$, patch2
      save       imid
      data       imid / 1 /
      data       numbld / numtxt*0 / 
      if (isend.eq.1) then
c
c isend = 1: edit arrows
c =========
c        
         repeet = .true.
         do while (repeet)
            write (text,100) narr, jcolor, head
            numopt = 5
            numdec = numopt - 1
            call listbx (numdec, numopt,
     +                   text)           
            if (numdec.eq.1) then
c
c arrow type
c              
               write (text,200) 
               numopt = 14
               if (narr.eq.0) then
                  numdec = numopt  
               elseif (narr.eq.1) then
                  numdec = 1
               elseif (narr.eq.16) then
                  numdec = 2  
               elseif (narr.ge.17) then
                  numdec = narr - 8   
               else
                  numdec = narr - 1
               endif 
               if (numdec.lt.1 .or. numdec.gt.numopt) numdec = 1          
               call listbx (numdec, numopt,
     +                      text)
               if (numdec.eq.numopt) then
                  narr = 0
               elseif (numdec.eq.1) then
                  narr = 1
               elseif (numdec.eq.2) then
                  narr = 16        
               elseif (numdec.ge.9) then
                  narr = numdec + 8   
               else
                  narr = numdec - 1
               endif
            elseif (numdec.eq.2) then 
c
c arrow colour
c            
               call vgacol$(jcolor)
            elseif (numdec.eq.3) then
c
c arrow size
c            
               write (line,300) head
               call getd01$(head,
     +                      line)               
            elseif (numdec.eq.numopt - 1) then
c
c help
c  
               write (text,1000)
               numbld(1) = 1
               numbld(15) = 1
               call patch2 (numbld, numtxt,
     +                      text)
               numbld(1) = 0
               numbld(15) = 0                      
            elseif (numdec.eq.numopt) then 
c
c Apply
c             
               repeet = .false.
            endif
         enddo
      elseif (isend.eq.2) then
c
c isend = 2: edit labels
c ==========
c      
         if (ntotal.lt.1 .or. ntotal.gt.nwmax .or.
     +       npts.lt.1 .or. npts.gt.nwmax) return
         if (imid.lt.1 .or. imid.gt.npts) imid = 1 
         write (font,400)
         if (nfont.lt.1 .or. nfont.gt.13) nfont = 5   
         repeet = .true.
         do while (repeet)
             if (nlab.eq.1) then
                cipher(1) = current
                cipher(2) = blank
             else
                nlab = 0
                cipher(1) = blank
                cipher(2) = current
             endif      
             numopt = 8
             numdec = numopt - 1
             write (text,500) cipher(1), cipher(2), kcolor,
     +                        font(nfont), xsize
             call listbx (numdec, numopt,
     +                    text)
            if (numdec.eq.1) then
c
c display labels
c              
               nlab = 1
            elseif (numdec.eq.2) then
c
c suppress labels
c            
               nlab = 0
            elseif (numdec.eq.3) then   
c
c edit/move/rotate labels
c            
               numopt = npts
               call listbx (imid, numopt,
     +                      label)               
               again = .true.
               do while(again)
                  numopt = 6
                  numdec = numopt
                  write (text,600) label(imid), 
     +                             x_shift(imid), y_shift(imid), 
     +                             theta(imid)
                  call listbx (numdec, numopt,
     +                         text)
                  if (numdec.eq.1) then
                     jsend = 1
                     call newstr$(jsend,
     +                            label(imid), vector(imid))                         
                  elseif (numdec.eq.2) then 
                     jsend = 2
                     call newstr$(jsend,
     +                            label(imid), vector(imid))    
                  elseif (numdec.eq.3) then
                     call getd01$(x_shift(imid), 
     +'shift required: < 0 to move left, > 0 to move right' )
                  elseif (numdec.eq.4) then 
                     call getd01$(y_shift(imid), 
     +'shift required: < 0 to move down, > 0 to move up')                        
                  elseif (numdec.eq.5) then
                     call getdm1$(theta_min, theta(imid), theta_max, 
     +'angle of rotation required: < 0 clockwise, > 0 anticlockwise')
                  elseif (numdec.eq.numopt) then 
                     again = .false.
                  endif
               enddo
            elseif (numdec.eq.4) then
c
c label colour
c            
               call vgacol$(kcolor)
            elseif (numdec.eq.5) then
c
c label font
c            
               numopt = 13
               write (text,400)
               
               call listbx (nfont, numopt,
     +                      text)
            elseif (numdec.eq.6) then
c
c label size
c            
               call getdm1$(fmin, xsize, fmax,
     +                      'Font size required')              
            elseif (numdec.eq.numopt - 1) then
c
c help
c  
               write (text,1000)
               numbld(1) = 1
               numbld(15) = 1
               call patch2 (numbld, numtxt,
     +                      text)
               numbld(1) = 0
               numbld(15) = 0                  
            elseif(numdec.eq.numopt) then
               repeet = .false.
            endif      
         enddo     
      endif
  100 format (
     + 'Edit arrow type: current =',i4
     +/'Edit arrow colour: curent =',i4
     +/'Edit arrow size: current =',f8.3
     +/'Help'
     +/'Apply')   
  200 format ( 
     + 'Normal arrow'
     +/'Dashed arrow'
     +/'Outline arrow: hollow'
     +/'Outline arrow: filled'
     +/'Shaft only: solid'
     +/'Shaft only: dashed'
     +/'Shaft only: dotted'
     +/'Shaft only: dash-dotted'
     +/'Head only: plus'
     +/'Head only: multiply'
     +/'Head only: asterisk'
     +/'Script head: solid shaft'
     +/'Script head: dashed shaft'
     +/'Suppress')
  300 format ('Arrow size required: current =',f8.3) 
  400 format (
     + 'Times-Roman'
     +/'Times-Bold'
     +/'Times-Italic'
     +/'Times-BoldItalic'
     +/'Helvetica'
     +/'Helvetica-Bold'
     +/'Helvetica-Oblique'
     +/'Helvetica-BoldOblique'
     +/'Courier'
     +/'Courier-Bold'
     +/'Courier-Oblique'
     +/'Courier-BoldOblique'
     +/'Symbol')     
  500 format (
     + 'Display labels',2x,a
     +/'Suppress labels',2x,a
     +/'Edit/move/rotate labels'
     +/'Change label colour: current =',i4
     +/'Change font type: current =',2x,a
     +/'Change font size: current =',f8.3
     +/'Help'
     +/'Apply') 
  600 format (
     + 'Simple editing: label =',1x,a
     +/'Advanced editing'
     +/'Translate right/left: current =',1p,e11.3
     +/'Translate up/down: current =',      e11.3
     +/'Rotate: current =',0p,f8.3
     +/'Apply') 
 1000 format (
     + 'Fixed objects'
     +/
     +/'Some objects on this graph are fixed by physical constraints,'
     +/'e.g, lines, symbols, perpendiculars, or 3D biplot arrows. These'
     +/'are grouped into sets (by file) and you can only alter display'
     +/'properties of such sets globally. For instance, you can switch'
     +/'on or switch off the display groupwise, and you can change the'  
     +/'types, sizes and colours. Suppose, for instance, that the data'
     +/'have been supplied in six files, and you decide to edit the'
     +/'properties of, say file number 4. Clearly it makes sense that'
     +/'all lines, graph plotting symbols, fonts, sizes, and colours'
     +/'will apply globally within group 4, and will not affect the'
     +/'other groups. So you must first choose the file to be edited.'
     +/
     +/'Variable objects'
     +/
     +/'Labels plotted on the graph may however have to be translated,'
     +/'edited, or rotated, e.g., when the labels in default positions'
     +/'are illegible. In some cases you may find it best to suppress'
     +/'individual labels by setting them as blanks, and using the red'
     +/'arrow to drag and drop replacement labels, if the convenient'
     +/'technique provided by this control proves too complicated.') 
      end
c
c           