C
C
      SUBROUTINE SPACES$(IPANEL, ISHAPE, KANGLE, KTIC, NXMAG,
     +                   A, B, C, CZ, D, DZ, EHEIGHT, EPSI,
     +                   EXTRA1, EXTRA2, EXTRA3, EXTRA4,
     +                   XA, XB, XC, XD, XDIFF, XEND, XEND1, XEND2,
     +                   XMAX, XMAX1, XMIN, XMIN1, XSTART, XSTRT1, XTIC,
     +                   YA, YADD, YB, YC, YD, YDIFF, YEND, YEND1,
     +                   YEND2, YMAX, YMAX1, YMIN, YMIN1, YSTART,
     +                   YSTRT1, YTIC, YYJUMP,
     +                   ZA, ZB, ZC, ZD, ZDIFF, ZMAX, ZMAX1, ZMIN,
     +                   ZMIN1,
     +                   XTITLE,
     +                   BAR_CHART, OFFSET, PANEL, PLOT_TITLE, ROTATE,
     +                   SIDE, TWO_PLOTS)
C
C ACTION : Calculate spaces for simplot
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/6/95
C          30/07/1996 Added ISHAPE
C          03/10/1996 Added XD, YD, ZD and redefined GKS transformations
C                     so that XA, XB, YA, YB always agree with XSTART, XEND, YSTART,
C                     YEND, etc and XMIN, XMAX, YMIN, YMAX are always mapped onto
C                     XA, XB, YA, YB while XMIN1, XMAX1, YMAIN1, YMAX2 always map
C                     onto XC, XD, YC, YD
C          10/12/1996 Corrected a mistake in defining XC, XD, YC, YD, ZC, ZD
C          14/07/1997 win32 version
C          21/07/2001 added XTITLE to correct YSTART if no X-axis legend
C          10/01/2003 added YADD to argument list
C          23/04/2007 added INTENTS
C          11/02/2011 revised INTENTS 
C          17/03/2011 made YADD INTENT (IN) 
C          13/06/2019 used SAVRES$ to calculate YTOX 
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,             INTENT (IN)    :: IPANEL, ISHAPE, KANGLE,
     +                                       KTIC, NXMAG
      DOUBLE PRECISION,    INTENT (IN)    :: EHEIGHT, EPSI, XEND1,
     +                                       XEND2, XSTRT1,
     +                                       XTIC, YADD, YEND1, YEND2,
     +                                       YSTRT1, YTIC, YYJUMP
      DOUBLE PRECISION,    INTENT (OUT)   :: A, B, C, CZ, D, DZ, EXTRA1,
     +                                       EXTRA2, EXTRA3, EXTRA4,
     +                                       XA, XB, XC, XD, XDIFF,
     +                                       XEND, XMAX1, XMIN1, XSTART,
     +                                       YA, YB, YC, YD,
     +                                       YDIFF, YEND, YMAX1, YMIN1,
     +                                       YSTART, ZA, ZB, ZC, ZD,
     +                                       ZDIFF, ZMAX1, ZMIN1
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX, XMIN, YMAX, YMIN, 
     +                                       ZMAX, ZMIN
      CHARACTER (LEN = *), INTENT (IN)    :: XTITLE
      LOGICAL,             INTENT (IN)    :: BAR_CHART, OFFSET, PANEL,
     +                                       PLOT_TITLE, ROTATE, SIDE,
     +                                       TWO_PLOTS
C
C Locals
C
      INTEGER    IXRES, IYRES
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      DOUBLE PRECISION X_SVG, Y_SVG
      DOUBLE PRECISION ZERO, ONE, TWO, FIVE, TEN
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FIVE = 5.0D+00, TEN = 10.0D+00)
      DOUBLE PRECISION PNT02, PNT05, SIX
      PARAMETER (PNT02 = 0.02D+00, PNT05 = 0.05D+00, SIX = 6.0D+00)
      DOUBLE PRECISION YDOWN
      PARAMETER (YDOWN = 0.075D+00)
      DOUBLE PRECISION SIN45, SIN60, SIN75, SIN90
      PARAMETER (SIN45 = 0.707D+00, SIN60 = 0.866D+00,
     +           SIN75 = 0.966D+00, SIN90 = 1.0D+00)
      DOUBLE PRECISION XDELTA, XTEMP, YDELTA, YTEMP, YTOX, ZDELTA, ZTEMP
      CHARACTER (LEN = 1) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ACTIVE_SVG
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
      EXTERNAL   SAVRES$
      EXTERNAL   SVGPAR 
      INTRINSIC  ABS, DBLE
C
C Define YTOX
C  
      CALL SAVRES$(IXRES, IYRES,
     +             STORE)
      YTOX = DBLE(IYRES)/DBLE(IXRES) 
      CALL SVGPAR (N0,
     +             X_SVG, Y_SVG,
     +             ACTIVE_SVG)
      IF (ACTIVE_SVG) YTOX = Y_SVG*YTOX/X_SVG  
C
C Define XSTART, XEND, YSTART, YEND
C
      XSTART = XSTRT1
      IF (TWO_PLOTS) THEN
         XEND = XEND2
      ELSE
         XEND = XEND1
      ENDIF
      YSTART = YSTRT1
      IF (XTITLE.EQ.BLANK) YSTART = YSTART - YDOWN
      IF (PLOT_TITLE) THEN
         YEND = YEND2
      ELSE
         YEND = YEND1
      ENDIF
      IF (ROTATE) THEN
         IF (KANGLE.EQ.2 .OR. KANGLE.EQ.9) THEN
            YSTART = YSTART + SIN45*YADD
         ELSEIF (KANGLE.EQ.3 .OR. KANGLE.EQ.8) THEN
            YSTART = YSTART + SIN60*YADD
         ELSEIF (KANGLE.EQ.4 .OR. KANGLE.EQ.7) THEN
            YSTART = YSTART + SIN75*YADD
         ELSEIF (KANGLE.EQ.5 .OR. KANGLE.EQ.6) THEN
            YSTART = YSTART + SIN90*YADD
         ENDIF
      ENDIF
      IF (PANEL .AND. .NOT.SIDE) THEN
         IF (IPANEL.LE.3) THEN
            YSTART = YSTART + YYJUMP/TWO
         ELSE
            YSTART = YSTART + YYJUMP
         ENDIF
      ENDIF
C
C Adjust if extra space is needed for exponent in X-axis title ........
C
      EXTRA1 = EHEIGHT + EHEIGHT/TEN
      EXTRA2 = EHEIGHT - EHEIGHT/FIVE
      EXTRA3 = EHEIGHT + EHEIGHT/TEN
      EXTRA4 = EHEIGHT - EHEIGHT/FIVE
      IF (NXMAG.GE. - N2 .AND. NXMAG.LE.N3) THEN
         YSTART = YSTART - EXTRA1 - EXTRA2
         EXTRA1 = ZERO
         EXTRA2 = ZERO
      ENDIF
C
C Expand plotting space if tick marks do not point outwards ...........
C
      IF (KTIC.GT.1) THEN
         XSTART = XSTART - YTIC
         XEND = XEND + YTIC
         YSTART = YSTART - XTIC
         YEND = YEND + XTIC
      ENDIF
C
C Check that XMAX, XMIN, YMAX, YMIN are satisfactory then .............
C define XMAX1 etc. to expand the limits and free the origin
C EPSI is required to allow clustering of values at fixed X or Y
C
      IF (XMIN.GT.XMAX) THEN
         XTEMP = XMIN
         XMIN = XMAX
         XMAX = XTEMP
      ENDIF
      IF (YMIN.GT.YMAX) THEN
         YTEMP = YMIN
         YMIN = YMAX
         YMAX = YTEMP
      ENDIF
      IF ((XMAX - XMIN).LE.EPSI) THEN
         XMAX = XMAX + PNT02*ABS(XMAX) + EPSI
         XMIN = XMIN - PNT02*ABS(XMIN) - EPSI
      ENDIF
      IF ((YMAX - YMIN).LE.EPSI) THEN
         YMAX = YMAX + PNT02*ABS(YMAX) + EPSI
         YMIN = YMIN - PNT02*ABS(YMIN) - EPSI
      ENDIF
      XDIFF = XMAX - XMIN
      YDIFF = YMAX - YMIN
      XMAX1 = XMAX + PNT05*XDIFF
      XMIN1 = XMIN - PNT05*XDIFF
      YMAX1 = YMAX + PNT05*YDIFF
      YMIN1 = YMIN - PNT05*YDIFF
      IF (TWO_PLOTS) THEN
         IF (ZMIN.GT.ZMAX) THEN
            ZTEMP = ZMIN
            ZMIN = ZMAX
            ZMAX = ZTEMP
         ENDIF
         IF ((ZMAX - ZMIN).LE.EPSI) THEN
            ZMAX = ZMAX + PNT02*ABS(ZMAX) + EPSI
            ZMIN = ZMIN - PNT02*ABS(ZMIN) - EPSI
         ENDIF
         ZDIFF = ZMAX - ZMIN
         ZMAX1 = ZMAX + PNT05*ZDIFF
         ZMIN1 = ZMIN - PNT05*ZDIFF
      ENDIF
C
C Adjust XSTART, XEND using ISHAPE to get 3:4, 3:3 or 4:3 aspect ratios
C
      IF (ISHAPE.EQ.N1) THEN
C
C 3:4 format ... no action required
C
         CONTINUE
      ELSEIF (ISHAPE.EQ.N2) THEN
C
C Square format ... move XSTART, XEND until square
C
         IF (BAR_CHART .AND. PANEL .AND. SIDE) THEN
            XEND = XEND2
         ELSE
            XDELTA = (XEND - XSTART - YTOX*(YEND - YSTART))/TWO
            IF (PANEL .AND. SIDE) THEN
               XEND = XEND - TWO*XDELTA
            ELSE
               XTEMP = (XSTART - (ONE - XEND))/TWO
               XSTART = XSTART + XDELTA - XTEMP
               XEND = XEND - XDELTA - XTEMP
            ENDIF
         ENDIF
      ELSEIF (ISHAPE.EQ.N3) THEN
C
C 4:3 format ... move XSTART, XEND until 4:3
C
         XDELTA = (XEND - XSTART - YTOX*YTOX*(YEND - YSTART))/TWO
         IF (PANEL.AND.SIDE) THEN
            XEND = XEND - TWO*XDELTA
         ELSE
            XTEMP = (XSTART - (ONE - XEND))/TWO
            XSTART = XSTART + XDELTA - XTEMP
            XEND = XEND - XDELTA - XTEMP
         ENDIF
      ELSEIF (ISHAPE.EQ.N4) THEN
C
C 1:2 format ... move YSTART, YEND
C
         YTEMP = (YEND - YSTART)/SIX
         YSTART = YSTART + YTEMP
         YEND = YEND - YTEMP
      ENDIF
C
C Calculate XA, XB, XC etc. to define plotting space ..................
C
      IF (OFFSET) THEN
         XC = XSTART
         XD = XEND
         XTEMP = (XD - XC)*(ONE - (XMAX - XMIN)/(XMAX1 - XMIN1))/TWO
         XA = XC + XTEMP
         XB = XD - XTEMP
         YC = YSTART
         YD = YEND
         YTEMP = (YD - YC)*(ONE - (YMAX - YMIN)/(YMAX1 - YMIN1))/TWO
         YA = YC + YTEMP
         YB = YD - YTEMP
         IF (TWO_PLOTS) THEN
            ZC = YSTART
            ZD = YEND
            ZTEMP = (ZD - ZC)*(ONE - (ZMAX - ZMIN)/(ZMAX1 - ZMIN1))/TWO
            ZA = ZC + ZTEMP
            ZB = ZD - ZTEMP
         ELSE
            ZA = ZERO
            ZB = ONE
            ZC = ZERO
            ZD = ONE   
         ENDIF
      ELSE
         XA = XSTART
         XB = XEND
         YA = YSTART
         YB = YEND
         XDELTA = (XB - XA)*((XMAX1 - XMIN1)/(XMAX - XMIN) - ONE)/TWO
         XC = XA - XDELTA
         XD = XB + XDELTA
         YDELTA = (YB - YA)*((YMAX1 - YMIN1)/(YMAX - YMIN) - ONE)/TWO
         YC = YA - YDELTA
         YD = YB + YDELTA
         IF (TWO_PLOTS) THEN
            ZA = YSTART
            ZB = YEND
            ZDELTA = (ZB - ZA)*((ZMAX1 - ZMIN1)/(ZMAX - ZMIN) - ONE)/TWO
            ZC = ZA - ZDELTA
            ZD = ZB + ZDELTA
         ELSE
            ZA = ZERO
            ZB = ONE
            ZC = ZERO
            ZD = ONE   
         ENDIF
      ENDIF
C
C Now define A, B, C, D for Scatchard plot error bar caps etc. ........
C
      A = (XB - XA)/(XMAX - XMIN)
      B = (XA*XMAX - XB*XMIN)/(XMAX - XMIN)
      C = YTOX*(YB - YA)/(YMAX - YMIN)
      D = YTOX*(YA*YMAX - YB*YMIN)/(YMAX - YMIN)
      IF (TWO_PLOTS) THEN
         CZ = YTOX*(ZB - ZA)/(ZMAX - ZMIN)
         DZ = YTOX*(ZA*ZMAX - ZB*ZMIN)/(ZMAX - ZMIN)
      ELSE
         CZ = ZERO
         DZ = ONE   
      ENDIF
      END
C
C
