C
C
      SUBROUTINE STRGET$(NIN, N10,
     +                   ARRAY, FNAME, F10, SEARCH, STRNG,
     +                   ABORT)
C

C ACTION : Locate Postscript STRING and ARRAY in FNAME
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 18/12/95 
C          23/04/2007 added INTENTS
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NIN, N10 
      CHARACTER (LEN = *), INTENT (IN)  :: FNAME, F10, SEARCH 
      CHARACTER (LEN = *), INTENT (OUT) :: ARRAY, STRNG 
      LOGICAL,             INTENT (OUT) :: ABORT   
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART,
     +           NTEXT
      PARAMETER (ICOLOR = 1, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 3,
     +           NSTART = 5, NTEXT = 7)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    LEN200, N1, N13
      PARAMETER (N1 = 1, N13 = 13)
      INTEGER    N0
      PARAMETER (N0 = 0)
      INTEGER    IOS
      CHARACTER  TEXT(NTEXT)*80
      CHARACTER  COPY*80
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .TRUE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, LEN200
      EXTERNAL   PUTADV$
      INTRINSIC  INDEX, LEN
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Open the file FNAME on unit NIN
C
      ABORT = .TRUE.
      IF (LEN(STRNG).LE.N13) THEN
         CALL PUTADV$('String is too short to be graphics text')
         RETURN
      ENDIF
      CLOSE (UNIT = NIN)
      OPEN (UNIT = NIN, FILE = FNAME, STATUS = 'OLD', ERR = 20,
     +      IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CALL PUTADV$('File cannot be opened')
         GOTO 20
      ENDIF
      CLOSE (UNIT = N10)
      OPEN (UNIT = N10, FILE = F10, STATUS = 'OLD', ERR = 20,
     +      IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CALL PUTADV$('File cannot be opened')
         GOTO 20
      ENDIF
      IOS = N0
      DO WHILE (IOS.EQ.N0)
         READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) STRNG
         IF (IOS.NE.N0) GOTO 20
         WRITE (N10,100,ERR=20,IOSTAT=IOS) STRNG
         IF (IOS.NE.N0) GOTO 20
         COPY = STRNG(N1:LEN200(STRNG) - N13)
         IF (INDEX(COPY, SEARCH).GT.N0) THEN
            READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) ARRAY
            IF (IOS.NE.N0) GOTO 20
            WRITE (N10,100,ERR=20,IOSTAT=IOS) ARRAY
            IF (IOS.NE.N0) GOTO 20
            IF (INDEX(ARRAY, ') fx').GT.N0) THEN
               WRITE (TEXT,200) STRNG, ARRAY
               NUMDEC = 1
               NUMBLD(2) = 1
               NUMBLD(3) = 1
               CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                      NUMOPT, NUMPOS, NSTART, NTEXT,
     +                      TEXT,
     +                      BORDER, FLASH, HIGH)
               IF (NUMDEC.EQ.1) THEN
                  ABORT = .FALSE.
                  RETURN
               ELSEIF (NUMDEC.NE.2) THEN
                  ABORT = .TRUE.
                  CLOSE (UNIT = NIN)
                  CLOSE (UNIT = N10)
                  RETURN
               ENDIF
            ENDIF
         ENDIF
      ENDDO
   20 CONTINUE
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = N10)
      CALL PUTADV$('The graphics text string requested was not found')
C
C Format statements
C      
  100 FORMAT (A)
  200 FORMAT (
     + 'The graphics text string and key located are:'
     +/A
     +/A
     +/
     +/'Edit this string'
     +/'Continue search'
     +/'Cancel')
      END
C     
C