C
C
      SUBROUTINE STRIPE$(COLOUR_INDEX, IFILL,
     +                   ALPHA, BETA, X, Y)
C
C ACTION : Draw stripes if inside box
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 22/6/95
C          14/07/1997 win32 version
C          19/05/2007 added INTENTS
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: COLOUR_INDEX, IFILL 
      DOUBLE PRECISION, INTENT (IN) :: ALPHA, BETA, X(4), Y(4)
C
C Locals
C      
      INTEGER    NCROSS
      DOUBLE PRECISION EPSI, ZERO, ONE
      PARAMETER (EPSI = 1.0D-35, ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION BOT, RATIO, TOP, XX1, XX2, YY1, YY2
      EXTERNAL   DASHED_LINE$, SOLID_LINE$
      INTRINSIC  ABS
C
C Initialise NCROSS
C
      NCROSS = 0
C
C 1) Check (X(1),Y(1)) to (X(4),Y(4))
C
      BOT = Y(1) - Y(4) - BETA*(X(1) - X(4))
      IF (ABS(BOT).GE.EPSI) THEN
         TOP = ALPHA + BETA*X(4) - Y(4)
         RATIO = TOP/BOT
         IF (RATIO.GE.ZERO .AND. RATIO.LE.ONE) THEN
            NCROSS = NCROSS + 1
            XX1 = RATIO*X(1) + (ONE - RATIO)*X(4)
            YY1 = RATIO*Y(1) + (ONE - RATIO)*Y(4)
         ENDIF
      ENDIF
C
C 2) Check (X(2),Y(2)) to (X(3),Y(3))
C
      BOT = Y(2) - Y(3) - BETA*(X(2) - X(3))
      IF (ABS(BOT).GE.EPSI) THEN
         TOP = ALPHA + BETA*X(3) - Y(3)
         RATIO = TOP/BOT
         IF (RATIO.GE.ZERO .AND. RATIO.LE.ONE) THEN
            NCROSS = NCROSS + 1
            IF (NCROSS.EQ.1) THEN
               XX1 = RATIO*X(2) + (ONE - RATIO)*X(3)
               YY1 = RATIO*Y(2) + (ONE - RATIO)*Y(3)
            ELSE
               XX2 = RATIO*X(2) + (ONE - RATIO)*X(3)
               YY2 = RATIO*Y(2) + (ONE - RATIO)*Y(3)
               IF (ABS(XX2 - XX1).LE.EPSI .AND.
     +             ABS(YY2 - YY1).LE.EPSI) NCROSS = 1
            ENDIF
         ENDIF
      ENDIF
      IF (NCROSS.EQ.2) GOTO 20
C
C 3) Check (X(3),Y(3)) to (X(4),Y(4))
C
      BOT = Y(3) - Y(4) - BETA*(X(3) - X(4))
      IF (ABS(BOT).GE.EPSI) THEN
         TOP = ALPHA + BETA*X(4) - Y(4)
         RATIO = TOP/BOT
         IF (RATIO.GE.ZERO .AND. RATIO.LE.ONE) THEN
            NCROSS = NCROSS + 1
            IF (NCROSS.EQ.1) THEN
               XX1 = RATIO*X(3) + (ONE - RATIO)*X(4)
               YY1 = RATIO*Y(3) + (ONE - RATIO)*Y(4)
            ELSE
               XX2 = RATIO*X(3) + (ONE - RATIO)*X(4)
               YY2 = RATIO*Y(3) + (ONE - RATIO)*Y(4)
               IF (ABS(XX2 - XX1).LE.EPSI .AND.
     +             ABS(YY2 - YY1).LE.EPSI) NCROSS = 1
            ENDIF
         ENDIF
      ENDIF
      IF (NCROSS.EQ.2) GOTO 20
C
C 4) Check (X(1),Y(1)) to (X(2),Y(2))
C
      BOT = Y(1) - Y(2) - BETA*(X(1) - X(2))
      IF (ABS(BOT).GE.EPSI) THEN
         TOP = ALPHA + BETA*X(2) - Y(2)
         RATIO = TOP/BOT
         IF (RATIO.GE.ZERO .AND. RATIO.LE.ONE) THEN
            NCROSS = NCROSS + 1
            IF (NCROSS.EQ.1) THEN
               XX1 = RATIO*X(1) + (ONE - RATIO)*X(2)
               YY1 = RATIO*Y(1) + (ONE - RATIO)*Y(2)
            ELSE
               XX2 = RATIO*X(1) + (ONE - RATIO)*X(2)
               YY2 = RATIO*Y(1) + (ONE - RATIO)*Y(2)
               IF (ABS(XX2 - XX1).LE.EPSI .AND.
     +             ABS(YY2 - YY1).LE.EPSI) NCROSS = 1
            ENDIF
         ENDIF
      ENDIF
      IF (NCROSS.EQ.2) GOTO 20
      RETURN
   20 CONTINUE
      IF (IFILL.LE.7) THEN
         CALL SOLID_LINE$(XX1, YY1, XX2, YY2, COLOUR_INDEX)
      ELSE
         CALL DASHED_LINE$(XX1, YY1, XX2, YY2, COLOUR_INDEX)
      ENDIF
      END
C
C
