C
C
      SUBROUTINE STROKE$(COLOUR_INDEX, IFILL, NGRAF,
     +                   ALPHA, BETA, X, Y)
C
C ACTION : Draw stripes if inside SEGMENT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 22/6/95
C          14/07/1997 win32 version 
C          22/04/2007 added INTENTS 
C
C          The routine seeks for an intersection between the line joining
C          adjacent points and y = alpha + beta*x and if so joins pairs of
C          such intersections to hatch the pie chart segment

      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: COLOUR_INDEX, IFILL, NGRAF
      DOUBLE PRECISION, INTENT (IN) :: ALPHA, BETA, X(NGRAF), Y(NGRAF)
C
C Locals
C      
      INTEGER    I, IP1, NCROSS
      DOUBLE PRECISION EPSI, ZERO, ONE
      PARAMETER (EPSI = 1.0D-35, ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION BOT, RATIO, TOP, XX1, XX2, YY1, YY2
      EXTERNAL   DASHED_LINE$, SOLID_LINE$
      INTRINSIC  ABS
C
C Initialise NCROSS
C
      NCROSS = 0
C
C Check (X(I),Y(I)) to (X(I+1),Y(I+1))
C
      DO I = 1, NGRAF - 1
         IP1 = I + 1
         BOT = Y(I) - Y(IP1) - BETA*(X(I) - X(IP1))
         IF (ABS(BOT).GE.EPSI) THEN
            TOP = ALPHA + BETA*X(IP1) - Y(IP1)
            RATIO = TOP/BOT
C
C If 0 < RATIO < 1 the intersection is between the two consecutive points
C
            IF (RATIO.GE.ZERO .AND. RATIO.LE.ONE) THEN
               NCROSS = NCROSS + 1
               IF (NCROSS.EQ.1) THEN
                  XX1 = RATIO*X(I) + (ONE - RATIO)*X(IP1)
                  YY1 = RATIO*Y(I) + (ONE - RATIO)*Y(IP1)
               ELSE
                  XX2 = RATIO*X(I) + (ONE - RATIO)*X(IP1)
                  YY2 = RATIO*Y(I) + (ONE - RATIO)*Y(IP1)
                  IF (ABS(XX2 - XX1).LE.EPSI .AND.
     +                ABS(YY2 - YY1).LE.EPSI) NCROSS = 1
               ENDIF
            ENDIF
         ENDIF
C
C If there are two intersections draw the line and continue looking
C
         IF (NCROSS.EQ.2) THEN
            NCROSS = 0
            IF (IFILL.LE.7) THEN
               CALL SOLID_LINE$(XX1, YY1, XX2, YY2, COLOUR_INDEX)
            ELSE
               CALL DASHED_LINE$(XX1, YY1, XX2, YY2, COLOUR_INDEX)
            ENDIF
         ENDIF
      ENDDO
      END
C
C
