C
C
      SUBROUTINE STRPRN$(ILH, ILM, IRM, IYPOS, NOUT,
     +                   STRNG, TYPE1)
C
C ACTION : Print successive PostScript STRINGS
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 12/12/95
C          23/04/2007 added INTENTS
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: ILH, ILM, IRM, IYPOS, NOUT 
      CHARACTER (LEN = *), INTENT (IN) :: STRNG, TYPE1
C
C Locals
C      
      INTEGER    LEN200
      INTEGER    N0, N1, N3, N4, NMAX
      PARAMETER (N0 = 0, N1 = 1, N3 = 3, N4 = 4, NMAX = 55)
      INTEGER    I, ICOUNT, LS1, NSTART, NSTOP
      CHARACTER  BLANK*1, LETTER*1
      PARAMETER (BLANK = ' ')
      CHARACTER  BUFFER*120, WORD*120, TEMP*120
      EXTERNAL   TRIML1, LEN200
      EXTERNAL   STRCHK$
      IF (TYPE1.EQ.'OPEN' .OR. TYPE1.EQ.'Open' .OR.
     +    TYPE1.EQ.'open') THEN
C
C First time write the header
C
         WRITE (NOUT,100) ILM, IRM, IYPOS, ILH
         RETURN
      ELSE
C
C Copy STRING into TEMP then initialise
C
         BUFFER = BLANK
         TEMP = STRNG
         WORD = BLANK
         CALL TRIML1 (TEMP)
         LS1 = LEN200(TEMP)
         ICOUNT = N0
         NSTART = N0
         NSTOP = N0
C
C Parse TEMP
C
         DO I = N1, LS1
            LETTER = TEMP(I:I)
            IF (LETTER.NE.BLANK) THEN
               ICOUNT = ICOUNT + N1
               WORD(ICOUNT:ICOUNT) = LETTER
            ELSE
C
C Check that the word is ok for printing
C
               CALL STRCHK$(WORD)
               CALL TRIML1 (WORD)
               ICOUNT = LEN200(WORD)
               IF (ICOUNT.GT.N0) THEN
                  IF (NSTART.EQ.N0) THEN
                     NSTART = N1
                     NSTOP = ICOUNT + N4
                  ELSE
                     NSTART = NSTOP + N1
                     NSTOP = NSTART + ICOUNT + N3
                  ENDIF
                  BUFFER(NSTART:NSTOP)='('//WORD(N1:ICOUNT)//' )p'
C
C Print out BUFFER substring if long enough
C
                  IF (NSTOP.GT.NMAX) THEN
                     WRITE (NOUT,200) BUFFER(N1:NSTOP)
                     NSTART = N0
                     NSTOP = N0
                  ENDIF
               ENDIF
               ICOUNT = N0
               WORD = BLANK
            ENDIF
         ENDDO
C
C Empty last words out of the BUFFER
C
         IF (ICOUNT.GT.N0) THEN
C
C Check that the word is ok for printing
C
            CALL STRCHK$(WORD)
            CALL TRIML1 (WORD)
            ICOUNT = LEN200(WORD)
            IF (NSTART.EQ.N0) THEN
               NSTART = N1
               NSTOP = ICOUNT + N4
            ELSE
               NSTART = NSTOP + N1
               NSTOP = NSTART + ICOUNT + N3
            ENDIF
            BUFFER(NSTART:NSTOP)='('//WORD(N1:ICOUNT)//' )p'
            WRITE (NOUT,200) BUFFER(N1:NSTOP)
         ENDIF
      ENDIF   
C
C This format statement must NOT be edited
C      
  100 FORMAT (
     + '/LM',I6,' def'
     +/'/RM',I6,' def'
     +/'/ypos',I6,' def'
     +/'/lineheight',I6,' def'
     +/'/newline {ypos lineheight sub /ypos exch def LM ypos moveto}',
     +' def'
     +/'/p {dup stringwidth pop currentpoint pop add RM gt',
     +' {newline} if'
     +/' show} def'
     +/'LM ypos moveto')
  200 FORMAT (A)
      END
C 
C