C
C Important note
C ==============
C
C The special structure of this routine results from the fact that
C the menus can be called directly or from button presses and call
C back functions in the w_graphics.dll. Where the routines have
C shared arguments it is necessary to store altered parameters since
C the dll has no common block or module to communicate shared
C parameters.
C The menuing system is linked to the clearwin module in w_clearwin.dll 
C to make sure control parameters are saved.
C
C The routine depends critically on the value of NPRESS as returned
C from button.for in response to button presses from the simplot
C graphics window, as follows:
C
C NPRESS =  0: quit
C NPRESS =  1: use the menu directly
C NPRESS =  2: titles
C NPRESS =  3: legends
C NPRESS =  4: axes
C NPRESS =  5: style
C NPRESS =  6: edit data/symbols/line-types
C NPRESS =  7: panel
C NPRESS =  8: edit text
C NPRESS =  9: edit arrows
C NPRESS = 10: colours
C NPRESS = 11: transform
C NPRESS = 12: configure
C NPRESS = 13: edit objects
C NPRESS = 14: help
C NPRESS = 15: drag text
C NPRESS = 16: drag arrow head
C NPRESS = 17: drag arrow tail
C NPRESS = 18: drag text
C NPRESS = 19: drag panel
C NPRESS = 20: use menu
C NPRESS = 21: save
C NPRESS = 22: PostScript
C NPRESS = 23: Windows hardcopy
C
C The menu routines can be called with ISEND/JSEND values to control
C the cross-interactions between button presses as follows:
C
C ISEND/JSEND = 1: store
C ISEND/JSEND = 2: edit then store
C ISEND/JSEND = 3: retrieve
C
C This is necessary to make sure MODULE_SAVEGKS is up-to-date
C
      SUBROUTINE STYGKS$(IFILL, IHUE, ISHAPE, JCOLOR,
     +                   KANGLE, KCOLOR, KPANEL, KTIC,
     +                   L, LCOLOR, LPREV, M, MTRANS, MXDROP, MXTIC,
     +                   MXTICT, MYTIC, MYTICT, MZTIC,
     +                   NCLIP, NFILES, NGRAFS, NGROUP, NIN,
     +                   NKCOL, NLOG, NPRESS, NPTS, NSAV, NWORDS, NXTRA,
     +                   ASAV, ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   FACTOR, RTOL, SIZE, THICK, WIDE,
     +                   XCLIP, XCOORD, XCOORD_T, XMAX, XMAXT, XMIN,
     +                   XMINT,
     +                   YCLIP, YCOORD, YCOORD_T, YDROP, YMAX, YMAXT,
     +                   YMAX3,
     +                   YMAX4, YMIN, YMINT, YMIN3, YMIN4, YSAV1, YSAV2,
     +                   ZCOORD, ZMAX, ZMIN, ZSCALE,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   FSAV, FSAV1, LABELS, LABVEC, PLINE,
     +                   PSYMB, PTITLE, QTITLE, TSAV, WORDX, WORDY,
     +                   XTITLE, YTITLE, ZTITLE,
     +                   ABORT, BARCAP, BARCAP_1, BAR_CHART, BORDER,
     +                   BOXIT, CENTRE, DENDRO_GRAM, EXTEND_LINES,
     +                   FRAME, GRATICULE, LOWER, MONO, NATLOG, NUMBRX,
     +                   OFFSET, PANEL, PCENTX, PCENTY, PCENTZ,
     +                   PHIGHX, PHIGHY, PHIGHZ,
     +                   PIE_CHART, PLOT_LABELS, PLOT_TITLE, PLOTX,
     +                   PLOTY, PLOTZ,
     +                   POWERX, POWERY, POWERZ, ROTATE,
     +                   SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS,
     +                   SHOW_YAXIS, SHOW_ZAXIS,
     +                   SIDE, SWAP_YZ, THREE_D, TWO_PLOTS, UPPER,
     +                   XDIL, XDIV, XGRID, XLOG, XTOINT,
     +                   VECTOR_FIELD, VIDEO, YAXIS,
     +                   YDIV, YGRID, YLOG, YTOINT,
     +                   ZTOINT)
C
C ACTION : Call the menus
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          24/01/2001 derived from GKSSTY$
C          20/07/2001 added SHOW_XAXIS
C          01/08/2001 defined MAXTIC = NWORDS - 1
C          15/08/2001 added MXDROP and YDROP
C          08/09/2001 added THREE_D
C          07/01/2003 redimensioned WIDE(5*NGRAFS)
C          21/10/2004 added DENDRO_GRAM, SHOW_BACKGROUND and SHOW_QUADRANTS
C          20/11/2004 changed CONFIG$ to CONFYG$
C          14/07/2005 added PLOT_LABELS to MENU04$
C          19/08/2005 added EXTEND_LINES  
C          09/05/2007 added INTENTS
C          10/06/2010 added call to NKLCFG 
C          20/05/2013 added call to SIMPLOT_METAFILE_3 and FSAV1 to argument list for CONFYG$ 
C          15/01/2014 introduced call to GRAPHQ
C          26/01/2014 added call to GRAPHICS_BUTTON_PRESS$ to ensure graph-close-down under the new scheme 
C          05/01/2016 added SHOW_XAXIS, SHOW_YAXIS, SHOW_XAXIS to argument list for call to CONFYG$ 
C          07/01/2016 added RESTORE_RANGE to allow configuration files to act as templates
C          11/12/2017 set NUMOPT = 14 to suppress the mistaken exit option when choosing NUMDEC = 15
C           
C
      IMPLICIT   NONE
C
C Integers in argument list
C                              
      INTEGER, INTENT (IN)    :: KPANEL, NCLIP, NGRAFS, NIN, NKCOL,
     +                           NLOG, NWORDS, NXTRA
      INTEGER, INTENT (INOUT) :: NFILES, IFILL(NXTRA), IHUE(NXTRA),
     +                           ISHAPE, NGROUP, JCOLOR(NGRAFS), KANGLE,
     +                           KCOLOR(NKCOL), KTIC, L(NGRAFS), LCOLOR,
     +                           LPREV, M(NGRAFS), NPRESS, NPTS,
     +                           NSAV(NGRAFS), MTRANS, MXDROP, MXTIC,
     +                           MYTIC, MZTIC
C
C Reals in argument list
C
      DOUBLE PRECISION, INTENT (INOUT) :: ASAV, ASYMP, DRAGTI, DRAGXL,
     +                                    DRAGYL, DRAGZL,
     +                                    FACTOR(NXTRA), RTOL,
     +                                    SIZE(NGRAFS), THICK,
     +                                    WIDE(5*NGRAFS)
      DOUBLE PRECISION, INTENT (INOUT) :: XCLIP(NCLIP), XCOORD,
     +                                    XCOORD_T(0:23), XMAX, XMIN
      DOUBLE PRECISION, INTENT (INOUT) :: YCLIP(NCLIP), YCOORD,
     +                                    YCOORD_T(0:23), YDROP,
     +                                    YMAX, YMAX3, YMAX4, YMIN,
     +                                    YMIN3, YMIN4, YSAV1, YSAV2,
     +                                    ZCOORD, ZMAX, ZMIN, ZSCALE
      DOUBLE PRECISION, INTENT (INOUT) :: XMAXT(0:23), XMINT(0:23),
     +                                    YMAXT(0:23), YMINT(0:23)
C
C Characters in argument list
C
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAYQ, ARRAYT(0:15),
     +                                       ARRAYX(0:15), ARRAYY(0:15),
     +                                       ARRAYZ(0:15), FSAV(NGRAFS),
     +                                       FSAV1(NGRAFS),
     +                                       LABELS(NWORDS),
     +                                       LABVEC(NWORDS),
     +                                       TSAV(NGRAFS),
     +                                       PLINE(KPANEL), 
     +                                       PSYMB(KPANEL),
     +                                       PTITLE(0:15), QTITLE, 
     +                                       WORDX(NWORDS),
     +                                       WORDY(NWORDS),
     +                                       XTITLE(0:15), 
     +                                       YTITLE(0:15),
     +                                       ZTITLE(0:15)
C
C Logicals in argument list
C
      LOGICAL, INTENT (INOUT) :: BARCAP(NGRAFS), BARCAP_1, BAR_CHART,
     +                           LOWER(NGRAFS), UPPER(NGRAFS), 
     +                           YAXIS(NGRAFS)
      LOGICAL, INTENT (INOUT) :: BORDER, BOXIT, CENTRE, DENDRO_GRAM,
     +                           EXTEND_LINES, FRAME, GRATICULE,
     +                           NATLOG(NLOG), NUMBRX, OFFSET, PANEL,
     +                           PCENTX, PCENTY, PCENTZ, PHIGHX, PHIGHY,
     +                           PHIGHZ, PIE_CHART, PLOT_LABELS,
     +                           PLOT_TITLE, PLOTX(NWORDS),
     +                           PLOTY(NWORDS), PLOTZ(NWORDS), POWERX,
     +                           POWERY, POWERZ, ROTATE
      LOGICAL, INTENT (INOUT) :: SHOW_BACKGROUND, SHOW_QUADRANTS,
     +                           SHOW_XAXIS, SHOW_YAXIS, SHOW_ZAXIS,
     +                           SIDE, SWAP_YZ, THREE_D, TWO_PLOTS,
     +                           XDIL, XDIV, XGRID, XLOG, XTOINT,
     +                           YDIV, YGRID, YLOG, YTOINT, ZTOINT
      LOGICAL, INTENT (INOUT) :: MONO, VECTOR_FIELD, VIDEO  
      LOGICAL, INTENT (OUT)   :: ABORT
C      
C Locals
C      
      INTEGER    I_PRESS_0, NDEC
      PARAMETER (I_PRESS_0 = 0)
      INTEGER    I, IADD8, ISEND, JSEND
      INTEGER    MTRAN1, MXTICT(0:23), MYTICT(0:23)
      INTEGER    K2, MAXTIC, MINTIC
      PARAMETER (K2 = 2, MINTIC = - 1)
      INTEGER    ICOLOR, NUMOPT, NUMDEC
      PARAMETER (ICOLOR = 7, NUMOPT = 14)
      INTEGER    IXL, IYL, LSHADE, NSTART, NTEXT
      PARAMETER (IXL = 4, IYL = 4, LSHADE = 1, NSTART = 10,
     +           NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    NSPLIT, N1, N24
      PARAMETER (NSPLIT = 2, N1 = 1, N24 = 24)
      INTEGER    KVAL_12, NKLCFG 
      DOUBLE PRECISION XSPLIT(NSPLIT), YSPLIT(NSPLIT)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION XPDRAG, YPDRAG  
      DOUBLE PRECISION YMAX3_SAV, YMAX4_SAV,
     +                 YMIN3_SAV, YMIN4_SAV
      DOUBLE PRECISION ZMAX_SAV, ZMIN_SAV
      CHARACTER (LEN = 1024) META_FNAME
      CHARACTER  GTYPE*34, LTYPE*19, OPTION(NUMOPT)*40
      CHARACTER  TEXT(30)*100, NA3*4, NA4*4, NA11*4
      CHARACTER  ARRAYT_1*100, ARRAYX_1*100, ARRAYY_1*100, ARRAYZ_1*100,
     +           PTITLE_1*100, XTITLE_1*100, YTITLE_1*100, ZTITLE_1*100          
      LOGICAL    BORDOR, FLASH, HIGH
      PARAMETER (BORDOR = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AGAIN, MENU, OK , STORE
      LOGICAL    ACTION, RESTORE_RANGE
      EXTERNAL   PUTFAT$, PUTWAR$, PUTADV$
      EXTERNAL   MENU02$, MENU04$, MENU05$, MENU06$, MENU07$, MENU10$,
     +           MENU11$, SIMHLP$, PLTOBJ$, CONFYG$, SAVEXY$, SAVETR$
      EXTERNAL   GRAPHQ, LBOX01, NKLCFG, GRAPHICS_BUTTON_PRESS$
      EXTERNAL   SIMPLOT_METAFILE_3
      SAVE       XSPLIT, YSPLIT
      DATA       XSPLIT / ZERO, ZERO /
      DATA       YSPLIT / ZERO, ZERO /
      DATA       NUMBLD / NTEXT*0 /
      DATA       NUMPOS / NUMOPT*0 /
C
C initialise ABORT
C      
      ABORT = .FALSE.
      RESTORE_RANGE = .FALSE.
C
C Special action to initialise a metafile
C      
      STORE = .FALSE.
      CALL SIMPLOT_METAFILE_3 (META_FNAME,
     +                         ACTION, STORE) 
      IF (ACTION) THEN
         MAXTIC = NWORDS - 1
         STORE = .TRUE.
         CALL SIMPLOT_METAFILE_3 (META_FNAME,
     +                            ACTION, STORE)
C
C Read a metafile
C
            ARRAYT_1 = ARRAYT(MTRANS)
            ARRAYX_1 = ARRAYX(MTRANS)
            ARRAYY_1 = ARRAYY(MTRANS)
            ARRAYZ_1 = ARRAYZ(MTRANS)
            PTITLE_1 = PTITLE(MTRANS)
            XTITLE_1 = XTITLE(MTRANS)
            YTITLE_1 = YTITLE(MTRANS)
            ZTITLE_1 = ZTITLE(MTRANS)
            XSPLIT(1) = XMIN
            XSPLIT(2) = XMAX
            YSPLIT(1) = YMIN
            YSPLIT(2) = YMAX
            STORE = .FALSE.
            CALL SAVEXY$(XPDRAG, YPDRAG, STORE)
            CALL CONFYG$(IFILL, IHUE, ISHAPE, JCOLOR, KANGLE, KCOLOR,
     +                   KPANEL, KTIC, L, LCOLOR,
     +                   M, MTRANS, MXTIC, MYTIC, MZTIC,
     +                   NCLIP, NFILES, NGROUP, NIN, NKCOL, NLOG,
     +                   NPTS, NSPLIT, NWORDS, NXTRA,
     +                   ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   FACTOR, SIZE, THICK, WIDE,
     +                   XCLIP, XCOORD, XMAX, XMIN, XPDRAG, XSPLIT,
     +                   YCLIP, YCOORD, YMAX, YMAX3, YMAX4, YMIN, YMIN3,
     +                   YMIN4, YPDRAG, YSPLIT,
     +                   ZCOORD, ZMAX, ZMIN, ZSCALE,
     +                   ARRAYQ, ARRAYT_1, ARRAYX_1, ARRAYY_1, ARRAYZ_1,
     +                   FSAV1,
     +                   LABELS, LABVEC, PLINE, PSYMB,
     +                   PTITLE_1, QTITLE, WORDX, WORDY, XTITLE_1,
     +                   YTITLE_1, ZTITLE_1,
     +                   BARCAP, BARCAP_1, BAR_CHART, BORDER, BOXIT,
     +                   CENTRE, DENDRO_GRAM, EXTEND_LINES,
     +                   FRAME, GRATICULE, LOWER, MONO, NATLOG, NUMBRX,
     +                   OFFSET,
     +                   PANEL, PCENTX, PCENTY, PCENTZ, PHIGHX, PHIGHY,
     +                   PHIGHZ, PIE_CHART, PLOT_TITLE, PLOTX, PLOTY,
     +                   PLOTZ, POWERX, POWERY, POWERZ,
     +                   RESTORE_RANGE, ROTATE, 
     +                   SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS, 
     +                   SHOW_YAXIS, SHOW_ZAXIS, SIDE,               
     +                   SWAP_YZ, THREE_D, TWO_PLOTS, UPPER,
     +                   VECTOR_FIELD, VIDEO, XGRID, XTOINT, YAXIS, 
     +                   YGRID, YTOINT, ZTOINT)
            IF (MTRANS.GE.8 .AND. MTRANS.LE.15 .AND. NATLOG(10)) THEN
               IADD8 = 8
            ELSE
               IADD8 = 0
            ENDIF
            MTRAN1 = MTRANS + IADD8
            XCOORD_T(MTRAN1) = XCOORD
            XMAXT(MTRAN1) = XMAX
            XMINT(MTRAN1) = XMIN
            YCOORD_T(MTRAN1) = YCOORD
            YMAXT(MTRAN1) = YMAX
            YMINT(MTRAN1) = YMIN
            ARRAYT(MTRANS) = ARRAYT_1
            ARRAYX(MTRANS) = ARRAYX_1
            ARRAYY(MTRANS) = ARRAYY_1
            ARRAYZ(MTRANS) = ARRAYZ_1
            PTITLE(MTRANS) = PTITLE_1
            XTITLE(MTRANS) = XTITLE_1
            YTITLE(MTRANS) = YTITLE_1
            ZTITLE(MTRANS) = ZTITLE_1
            IF (MXTIC.GT.MAXTIC) MXTIC = MAXTIC
            IF (MYTIC.GT.MAXTIC) MYTIC = MAXTIC
            IF (MZTIC.GT.MAXTIC) MZTIC = MAXTIC
            IF (MXTIC.LT.MINTIC) MXTIC = MINTIC
            IF (MYTIC.LT.MINTIC) MYTIC = MINTIC
            IF (MZTIC.LT.MINTIC) MZTIC = MINTIC
            MXTICT(MTRAN1) = MXTIC
            MYTICT(MTRAN1) = MYTIC
C
C JSEND = 1: Store the initialised parameters
C
            STORE = .TRUE.
            CALL SAVEXY$(XPDRAG, YPDRAG, STORE)
            CALL SAVETR$(MTRANS, STORE)
            JSEND = 1
            CALL MENU02$(JSEND, NPRESS,
     +                   DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                   PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)
            CALL MENU04$(JSEND,
     +                   KANGLE, KTIC,
     +                   MXDROP, MXTICT(MTRAN1), MYTICT(MTRAN1),
     +                   MZTIC, NGROUP, NPTS, NWORDS,
     +                   XCOORD, XMAX, XMIN, YCOORD, YDROP, YMAX, YMIN,
     +                   ZCOORD, ZMAX, ZMIN,
     +                   LABELS, LABVEC, WORDX, WORDY,
     +                   BAR_CHART,
     +                   NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                   PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                   PLOTX, PLOTY, PLOTZ, ROTATE, SHOW_XAXIS,
     +                   SHOW_YAXIS, SHOW_ZAXIS,
     +                   TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
            CALL MENU05$(JSEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
     +                   ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
     +                   EXTEND_LINES, FRAME, GRATICULE, OFFSET,
     +                   PIE_CHART, PLOT_TITLE, SHOW_BACKGROUND,
     +                   SHOW_QUADRANTS, THREE_D, TWO_PLOTS, XGRID,
     +                   YGRID)
            CALL MENU06$(JSEND, IFILL, IHUE, L, LPREV, M, NFILES,
     +                   NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
     +                   FACTOR, SIZE, WIDE, FSAV, FSAV1,
     +                   LABELS, LABVEC, TSAV, BARCAP, BARCAP_1,
     +                   BAR_CHART, PIE_CHART, LOWER, UPPER,
     +                   VECTOR_FIELD)
            CALL MENU07$(IFILL, IHUE, JSEND, ISHAPE, KPANEL, NFILES,
     +                   NPTS, NXTRA,
     +                   FSAV1(1), PLINE, PSYMB,
     +                   BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
            CALL MENU10$(NGRAFS, NKCOL, JSEND, JCOLOR, KCOLOR, LCOLOR,
     +                   NFILES, FSAV, MONO, VIDEO)
            CALL MENU11$(JSEND, MTRANS, NLOG,
     +                   ASYMP, ASAV, YMAXT, YMINT, YSAV1,
     +                   YSAV2, RTOL, NATLOG, POWERX, POWERY, POWERZ)

      ENDIF
C
C Check for redundant NPRESS as follows:-
C NPRESS = 8 : text
C NPRESS = 9 : arrows
C NPRESS = 13: objects
C NPRESS > 14: dragging and hardcopy
C
      IF (NPRESS.LE.0  .OR. NPRESS.EQ.8  .OR. NPRESS.EQ.9 .OR.
     +    NPRESS.EQ.13 .OR. NPRESS.GT.14) RETURN
C
C The main loop
C
      MAXTIC = NWORDS - 1
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
C
C Set the defaults for data ranges
C
         IF (MTRANS.GE.8 .AND. MTRANS.LE.15 .AND. NATLOG(10)) THEN
            IADD8 = 8
         ELSE
            IADD8 = 0
         ENDIF
         MTRAN1 = MTRANS + IADD8
         
         XMAX = XMAXT(MTRAN1)
         XMIN = XMINT(MTRAN1)
         YMAX = YMAXT(MTRAN1)
         YMIN = YMINT(MTRAN1)
         MXTIC = MXTICT(MTRAN1)
         MYTIC = MYTICT(MTRAN1)
         
         IF (NPRESS.EQ.1) THEN
C
C NPRESS = 1: GKSSTY$ has been called from the MENU button on the main graph
C ===========
C
            IF (MTRANS.LT.8) THEN
               LTYPE = ' '
            ELSE
               IF (NATLOG(1)) THEN
                  LTYPE = '(log is base e)'
               ELSEIF (NATLOG(2)) THEN
                  LTYPE = '(log is base 2)'
               ELSEIF (NATLOG(3)) THEN
                  LTYPE = '(log is base 3)'
               ELSEIF (NATLOG(4)) THEN
                  LTYPE = '(log is base 4)'
               ELSEIF (NATLOG(5)) THEN
                  LTYPE = '(log is base 5)'
               ELSEIF (NATLOG(6)) THEN
                  LTYPE = '(log is base 6)'
               ELSEIF (NATLOG(7)) THEN
                  LTYPE = '(log is base 7)'
               ELSEIF (NATLOG(8)) THEN
                  LTYPE = '(log is base 8)'
               ELSEIF (NATLOG(9)) THEN
                  LTYPE = '(log is base 9)'
               ELSEIF (NATLOG(10)) THEN
                  LTYPE = '(log is base 10)'
               ENDIF
            ENDIF
            IF (MTRANS.EQ.0) THEN
               GTYPE = '(x, y) ... Original coordinates'
            ELSEIF (MTRANS.EQ.1) THEN
               GTYPE = '(y, x) ... Reversed coordinates'
            ELSEIF (MTRANS.EQ.2) THEN
               GTYPE = '(x, 1/y) ... Dixon plot'
            ELSEIF (MTRANS.EQ.3) THEN
               GTYPE = '(1/x,y) ... Single reciprocal plot'
            ELSEIF (MTRANS.EQ.4) THEN
               GTYPE = '(1/x,1/y) ... Lineweaver-Burk plot'
            ELSEIF (MTRANS.EQ.5) THEN
               GTYPE = '(y/x, y) ... Scatchard plot'
            ELSEIF (MTRANS.EQ.6) THEN
               GTYPE = '(y, y/x) ... Eadie-Hofstee plot'
            ELSEIF (MTRANS.EQ.7) THEN
               GTYPE = '(x, x/y) ... Hanes plot'
            ELSEIF (MTRANS.EQ.8) THEN
               GTYPE = '(log(x), y) ... x-semilog plot'
            ELSEIF (MTRANS.EQ.9) THEN
               GTYPE = '(x, log(y)) ... y-semilog plot'
            ELSEIF (MTRANS.EQ.10) THEN
               GTYPE = '(log(x), log(y)) ... log-log plot'
            ELSEIF (MTRANS.EQ.11) THEN
               GTYPE = '(log(x),log[y/(A-y)]) .. Hill plot'
            ELSEIF (MTRANS.EQ.12) THEN
               GTYPE = '(x, log[1/y) .. Dilution Curve'
            ELSEIF (MTRANS.EQ.13) THEN
               GTYPE = '(log[y), x .. Reverse y-semilog'
            ELSEIF (MTRANS.EQ.14) THEN
               GTYPE = '(y, log[x) .. Reverse x-semilog'
            ELSEIF (MTRANS.EQ.15) THEN
               GTYPE = '(log[y], log[x) .. Reverse Log-Log'
            ENDIF
            NA3 = '    '
            NA4 = '    '
            NA11 = '    '
            IF (BAR_CHART) THEN
               NA11 = '(NA)'
               WRITE (TEXT,100) 'Bar Chart', 'Groups'
            ELSEIF (PIE_CHART) THEN
               NA3 = '(NA)'
               NA4 = '(NA)'
               NA11 = '(NA)'
               WRITE (TEXT,100) 'Pie Chart', 'No axes'
            ELSEIF (TWO_PLOTS) THEN
               NA11 = '(NA)'
               WRITE (TEXT,100) 'Double Plot', 'Y and Z Axes'
            ELSEIF (VECTOR_FIELD) THEN
               NA11 = '(NA)'
               WRITE (TEXT,100) 'Vector Field', 'Directions'
            ELSE
               WRITE (TEXT,100) GTYPE, LTYPE
            ENDIF
            WRITE (OPTION,200) NA3, NA4, NA11
            DO I = 1, NUMOPT
               TEXT(9 + I) = OPTION(I)
            ENDDO
C
C Called from main editing menu so set ISEND = 2: edit plot parameters
C
            ISEND = 2
            MENU = .TRUE.
            NUMDEC = 1
            NUMBLD(1) = 4
            NUMBLD(NSTART - 3) = 1
            NUMBLD(NSTART - 2) = 1
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDOR, FLASH, HIGH)
            NDEC = NUMDEC
            NPRESS = NUMDEC
         ELSE
C
C NPRESS > 1: GKSSTY$ has been called from an individual button (button
C =========== number = NPRESS) so set ISEND = 3 to retrieve edited parameters
C             Also set AGAIN = .FALSE. and MENU = .FALSE. so that only
C             retrieving and saving is done.
C             NDEC is set to the button pressed from the SIMPLOT main plot.
C
            ISEND = 3
            AGAIN = .FALSE.
            MENU = .FALSE.
            NDEC = NPRESS
         ENDIF
C
C Subsequent action depends upon NDEC from menus or button pressed
C
         IF (NDEC.EQ.1) THEN
C
C Display the plot
C
            AGAIN = .FALSE.
            MENU = .FALSE.
         ELSEIF (NDEC.EQ.2 .OR. NDEC.EQ.3) THEN
C
C Edit the plot title and legends
C
            CALL MENU02$(ISEND, NPRESS,
     +                   DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                   PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)
     
C
C Store parameters for MENU5$ since there is overlap, e.g PLOT_TITLE
C
C           JSEND = 1
C            CALL MENU05$(JSEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
C     +                   ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
C     +                   EXTEND_LINES, FRAME, GRATICULE, OFFSET,
C     +                   PIE_CHART, PLOT_TITLE, SHOW_BACKGROUND,
C     +                   SHOW_QUADRANTS, THREE_D, TWO_PLOTS, XGRID,
C     +                   YGRID)
     
         ELSEIF (NDEC.EQ.4) THEN
C
C Edit the axes
C
            IF (PIE_CHART) THEN
               CALL PUTFAT$('Not available with pie charts')
            ELSE
               CALL MENU04$(ISEND,
     +                      KANGLE, KTIC,
     +                      MXDROP, MXTIC, MYTIC, MZTIC,
     +                      NGROUP, NPTS, NWORDS,
     +                      XCOORD, XMAX, XMIN,
     +                      YCOORD, YDROP, YMAX, YMIN,
     +                      ZCOORD, ZMAX, ZMIN,
     +                      LABELS, LABVEC, WORDX, WORDY,
     +                      BAR_CHART,
     +                      NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                      PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                      PLOTX, PLOTY, PLOTZ, ROTATE, SHOW_XAXIS,
     +                      SHOW_YAXIS, SHOW_ZAXIS,
     +                      TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
C
C Re-set XCOORD, YCOORD, ZCOORD if limits exceeded
C
               IF (XCOORD.LT.XMIN .OR. XCOORD.GT.XMAX) XCOORD = XMIN
               IF (YCOORD.LT.YMIN .OR. YCOORD.GT.YMAX) YCOORD = YMIN
               IF (ZCOORD.LT.XMIN .OR. ZCOORD.GT.XMAX) ZCOORD = XMAX
C
C Re-set MXTICT, MYTICT, MZTIC if limits exceeded
C
               MXTICT(MTRAN1) = MXTIC
               MYTICT(MTRAN1) = MYTIC
               IF (MXTICT(MTRAN1).GT.MAXTIC) MXTICT(MTRAN1) = MAXTIC
               IF (MYTICT(MTRAN1).GT.MAXTIC) MYTICT(MTRAN1) = MAXTIC
               IF (MZTIC.GT.MAXTIC) MZTIC = MAXTIC
               IF (MXTICT(MTRAN1).LT.MINTIC) MXTICT(MTRAN1) = MINTIC
               IF (MYTICT(MTRAN1).LT.MINTIC) MYTICT(MTRAN1) = MINTIC
               IF (MZTIC.LT.MINTIC) MZTIC = MINTIC
C
C Set the defaults for data ranges
C
               XCOORD_T(MTRAN1) = XCOORD
               XMAXT(MTRAN1) = XMAX
               XMINT(MTRAN1) = XMIN
               YCOORD_T(MTRAN1) = YCOORD
               YMAXT(MTRAN1) = YMAX
               YMINT(MTRAN1) = YMIN
               
C
C Store parameters for MENU05$ since there is overlap, e.g. KTIC
C
C               JSEND = 1
C               CALL MENU05$(JSEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
C     +                      ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
C     +                      EXTEND_LINES, FRAME, GRATICULE, OFFSET,
C     +                      PIE_CHART, PLOT_TITLE, SHOW_BACKGROUND,
C     +                      SHOW_QUADRANTS, THREE_D, TWO_PLOTS,
C     +                      XGRID, YGRID)
C
C Store parameters for MENU06$ since there is overlap, e.g. LABELS, LABVEC
C
C               JSEND = 1
C               CALL MENU06$(JSEND, IFILL, IHUE, L, LPREV, M, NFILES,
C     +                      NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
C     +                      FACTOR, SIZE, WIDE, FSAV, FSAV1,
C     +                      LABELS, LABVEC, TSAV, BARCAP, BARCAP_1,
C     +                      BAR_CHART, PIE_CHART, LOWER, UPPER,
C     +                      VECTOR_FIELD)
C
C Store parameters for MENU11$ since there is overlap, e.g. YMAXT, YMINT
C
C               JSEND = 1
C               CALL MENU11$(JSEND, MTRANS, NLOG,
C     +                      ASYMP, ASAV, YMAXT, YMINT, YSAV1,
C     +                      YSAV2, RTOL, NATLOG, POWERX, POWERY, POWERZ)
               
            ENDIF
         ELSEIF (NDEC.EQ.5) THEN
C
C Edit the overall plot shape and details
C
            CALL MENU05$(ISEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
     +                   ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
     +                   EXTEND_LINES, FRAME, GRATICULE, OFFSET,
     +                   PIE_CHART, PLOT_TITLE, SHOW_BACKGROUND,
     +                   SHOW_QUADRANTS, THREE_D, TWO_PLOTS, XGRID,
     +                   YGRID)
     
C
C Store parameters for MENU02$ since there is overlap, e.g. PLOT_TITLE
C
C            JSEND = 1
C            CALL MENU02$(JSEND, NPRESS,
C     +                   DRAGTI, DRAGXL, DRAGYL, DRAGZL,
C     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
C     +                   PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
C     +                   PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)
C
C Store parameters for MENU04$ since there is overlap, e.g. KTIC
C
C            JSEND = 1
C            CALL MENU04$(JSEND,
C     +                   KANGLE, KTIC,
C     +                   MXDROP, MXTIC, MYTIC, MZTIC,
C     +                   NGROUP, NPTS, NWORDS,
C     +                   XCOORD, XMAX, XMIN,
C     +                   YCOORD, YDROP, YMAX, YMIN,
C     +                   ZCOORD, ZMAX, ZMIN,
C     +                   LABELS, LABVEC, WORDX, WORDY,
C     +                   BAR_CHART,
C     +                   NUMBRX, PCENTX, PCENTY, PCENTZ,
C     +                   PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
C     +                   PLOTX, PLOTY, PLOTZ, ROTATE, SHOW_XAXIS,
C     +                   SHOW_YAXIS, SHOW_ZAXIS,
C     +                   TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
C
C Store parameters for MENU07$ since there is overlap, e.g. ISHAPE
C
C            JSEND = 1
C            CALL MENU07$(IFILL, IHUE, JSEND, ISHAPE, KPANEL, NFILES,
C     +                   NPTS, NXTRA,
C     +                   FSAV1(1), PLINE, PSYMB,
C     +                   BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
     
         ELSEIF (NDEC.EQ.6) THEN
C
C Line and symbol types
C
            CALL MENU06$(ISEND, IFILL, IHUE, L, LPREV, M, NFILES,
     +                   NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
     +                   FACTOR, SIZE, WIDE, FSAV, FSAV1,
     +                   LABELS, LABVEC, TSAV, BARCAP, BARCAP_1,
     +                   BAR_CHART, PIE_CHART, LOWER, UPPER,
     +                   VECTOR_FIELD)
     
C
C Store parameters for MENU04$ since there is overlap, e.g. LABELS, LABVEC
C
C            JSEND = 1
C            CALL MENU04$(JSEND,
C     +                   KANGLE, KTIC,
C     +                   MXDROP, MXTIC, MYTIC, MZTIC,
C     +                   NGROUP, NPTS, NWORDS,
C     +                   XCOORD, XMAX, XMIN, YCOORD, YDROP, YMAX, YMIN,
C     +                   ZCOORD, ZMAX, ZMIN,
C     +                   LABELS, LABVEC, WORDX, WORDY,
C     +                   BAR_CHART,
C     +                   NUMBRX, PCENTX, PCENTY, PCENTZ,
C     +                   PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
C     +                   PLOTX, PLOTY, PLOTZ, ROTATE, SHOW_XAXIS,
C     +                   SHOW_YAXIS, SHOW_ZAXIS,
C     +                   TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
C
C Store parameters for MENU07$ since there is overlap, e.g. IHUE
C
C            JSEND = 1
C            CALL MENU07$(IFILL, IHUE, JSEND, ISHAPE, KPANEL, NFILES,
C     +                   NPTS, NXTRA,
C     +                   FSAV1(1), PLINE, PSYMB,
C     +                   BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
C
C Store parameters for MENU10$ since there is overlap, e.g. NFILES 
C     
C            JSEND = 1
C            CALL MENU10$(NGRAFS, NKCOL, JSEND, JCOLOR, KCOLOR, LCOLOR,
C     +                   NFILES, FSAV, MONO, VIDEO)
     
       ELSEIF (NDEC.EQ.7) THEN
C
C Information panel
C
            CALL MENU07$(IFILL, IHUE, ISEND, ISHAPE, KPANEL, NFILES,
     +                   NPTS, NXTRA,
     +                   FSAV1(1), PLINE, PSYMB,
     +                   BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
            IF (PANEL) THEN
C
C Set clipping = 3:4 if side panel has been selected
C
               XCLIP(1) = ZERO
               XCLIP(2) = ONE
               YCLIP(1) = ZERO
               YCLIP(2) = ONE
            ENDIF
C
C Adjust ZSCALE to keep plotting symbols appropriately sized
c This code is copied from MENU05$ to make sure the symbol size is
C re-adjusted if a panel is selected and the shape is changed
C
            IF (PLOT_TITLE) THEN
               ZSCALE = 1.0D+00
            ELSE
               ZSCALE = 0.9D+00
            ENDIF
            IF (ISHAPE.EQ.2) THEN
               ZSCALE = 1.3333D+00*ZSCALE
            ELSEIF (ISHAPE.EQ.3) THEN
               ZSCALE = 2.0D+00*ZSCALE
            ELSEIF (ISHAPE.EQ.4) THEN
               ZSCALE = 1.0D+00*ZSCALE
            ENDIF
            
C
C Store parameters for MENU05$ since there is overlap, e.g. ISHAPE
C
C            JSEND = 1
C            CALL MENU05$(JSEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
C     +                   ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
C     +                   EXTEND_LINES, FRAME, GRATICULE, OFFSET,
C     +                   PIE_CHART, PLOT_TITLE, SHOW_BACKGROUND,
C     +                   SHOW_QUADRANTS, THREE_D, TWO_PLOTS, XGRID,
C     +                   YGRID)
C
C Store parameters for MENU06$ since there is overlap, e.g. IHUE
C
C            JSEND = 1
C            CALL MENU06$(JSEND, IFILL, IHUE, L, LPREV, M, NFILES,
C     +                   NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
C     +                   FACTOR, SIZE, WIDE, FSAV, FSAV1,
C     +                   LABELS, LABVEC, TSAV, BARCAP, BARCAP_1,
C     +                   BAR_CHART, PIE_CHART, LOWER, UPPER,
C     +                   VECTOR_FIELD)
            
          ELSEIF (NDEC.EQ.8) THEN
C
C Text
C
             NPRESS = 8
             CALL PLTOBJ$(K2, NPRESS)
         ELSEIF (NDEC.EQ.9) THEN
C
C Arrows
C
            NPRESS = 9
            CALL PLTOBJ$(K2, NPRESS)
         ELSEIF (NDEC.EQ.10) THEN
C
C Set the colour scheme
C
            CALL MENU10$(NGRAFS, NKCOL, ISEND, JCOLOR, KCOLOR, LCOLOR,
     +                   NFILES, FSAV, MONO, VIDEO)
         ELSEIF (NDEC.EQ.11) THEN
C
C Select the transformation required
C
            IF (TWO_PLOTS) THEN
               CALL PUTFAT$('Not available in two plot mode')
            ELSEIF (BAR_CHART .OR. PIE_CHART) THEN
               CALL PUTFAT$('Not available with bar or pie charts')
            ELSEIF (VECTOR_FIELD) THEN
               CALL PUTFAT$('Not available with vector fields')
            ELSE
               CALL MENU11$(ISEND, MTRANS, NLOG,
     +                      ASYMP, ASAV, YMAXT, YMINT, YSAV1,
     +                      YSAV2, RTOL, NATLOG, POWERX, POWERY, POWERZ)
               IF (MTRANS.GE.8 .AND. MTRANS.LE.15 .AND.
     +             NATLOG(10)) THEN
                  IADD8 = 8
               ELSE
                  IADD8 = 0
               ENDIF
               MTRAN1 = MTRANS + IADD8
               XMAX = XMAXT(MTRAN1)
               XMIN = XMINT(MTRAN1)
               YMAX = YMAXT(MTRAN1)
               YMIN = YMINT(MTRAN1)
               MXTIC = MXTICT(MTRAN1)
               MYTIC = MYTICT(MTRAN1)
               XCOORD = XCOORD_T(MTRAN1)
               YCOORD = YCOORD_T(MTRAN1)
C
C Store parameters for MENU04$ since there is overlap, e.g. XMAX, XMIN, YMAX, YMIN
C
               JSEND = 1
               CALL MENU04$(JSEND,
     +                      KANGLE, KTIC,
     +                      MXDROP, MXTIC, MYTIC, MZTIC,
     +                      NGROUP, NPTS, NWORDS,
     +                      XCOORD, XMAX, XMIN,
     +                      YCOORD, YDROP, YMAX, YMIN,
     +                      ZCOORD, ZMAX, ZMIN,
     +                      LABELS, LABVEC, WORDX, WORDY,
     +                      BAR_CHART,
     +                      NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                      PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                      PLOTX, PLOTY, PLOTZ, ROTATE, SHOW_XAXIS,
     +                      SHOW_YAXIS, SHOW_ZAXIS,
     +                      TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
C
C Is a warning required ?
C
               OK = .TRUE.
               IF (.NOT.XDIV) THEN
                  IF (MTRANS.EQ.3 .OR. MTRANS.EQ.4 .OR.
     +                MTRANS.EQ.5 .OR. MTRANS.EQ.6) THEN
                      OK = .FALSE.
                      CALL PUTFAT$(
     +               '1/x and y/x cannot be plotted for x = 0')
                  ENDIF
               ENDIF
               IF (.NOT.XLOG) THEN
                  IF (MTRANS.EQ.8  .OR. MTRANS.EQ.10 .OR. MTRANS.EQ.11
     +                .OR. MTRANS.EQ.14 .OR. MTRANS.EQ.15) THEN
                      OK = .FALSE.
                      CALL PUTFAT$(
     +               'log(x) cannot be plotted for x =< 0')
                  ENDIF
               ENDIF
               IF (.NOT.YDIV) THEN
                  IF (MTRANS.EQ.2 .OR. MTRANS.EQ.4 .OR.
     +                MTRANS.EQ.7) THEN
                     OK = .FALSE.
                     CALL PUTFAT$(
     +              '1/y and x/y cannot be plotted for y = 0')
                  ENDIF
               ENDIF
               IF (.NOT.YLOG) THEN
                  IF (MTRANS.EQ.9  .OR. MTRANS.EQ.10 .OR.
     +                MTRANS.EQ.13 .OR. MTRANS.EQ.15) THEN
                     OK = .FALSE.
                     CALL PUTFAT$(
     +              'log(y) cannot be plotted for y =< 0')
                  ENDIF
               ENDIF
               IF (MTRANS.EQ.11 .AND. .NOT.YLOG) THEN
                  OK = .FALSE.
                  CALL PUTFAT$(
     +           'Hill plot requires 0 < y < A')
               ENDIF
               IF (MTRANS.EQ.12) THEN
                  IF (.NOT.XLOG .OR. .NOT.XDIL) THEN
                     OK = .FALSE.
                     CALL PUTFAT$(
     +              'Dilution plots require 0 < x =< 1')
                  ENDIF
               ENDIF
               IF (.NOT.OK) CALL PUTWAR$(
     +'Data unsuitable for this transformation  ...   points omitted')
            ENDIF
         ELSEIF (NDEC.EQ.12) THEN
C
C Read/Write a configuration file
C
            ARRAYT_1 = ARRAYT(MTRANS)
            ARRAYX_1 = ARRAYX(MTRANS)
            ARRAYY_1 = ARRAYY(MTRANS)
            ARRAYZ_1 = ARRAYZ(MTRANS)
            PTITLE_1 = PTITLE(MTRANS)
            XTITLE_1 = XTITLE(MTRANS)
            YTITLE_1 = YTITLE(MTRANS)
            ZTITLE_1 = ZTITLE(MTRANS)
            XSPLIT(1) = XMIN
            XSPLIT(2) = XMAX
            YSPLIT(1) = YMIN
            YSPLIT(2) = YMAX
C-------------------------------------------------------------------
C Start to save range parameters before reading a configuration file
C            
            YMAX3_SAV = YMAX3
            YMAX4_SAV = YMAX4 
            YMIN3_SAV = YMIN3
            YMIN4_SAV = YMIN4
            ZMAX_SAV = ZMAX
            ZMIN_SAV = ZMIN
C
C End saving range parameters
C-------------------------------------------------------------------            
            STORE = .FALSE.
            CALL SAVEXY$(XPDRAG, YPDRAG, STORE)
            CALL CONFYG$(IFILL, IHUE, ISHAPE, JCOLOR, KANGLE, KCOLOR,
     +                   KPANEL, KTIC, L, LCOLOR,
     +                   M, MTRANS, MXTIC, MYTIC, MZTIC,
     +                   NCLIP, NFILES, NGROUP, NIN, NKCOL, NLOG,
     +                   NPTS, NSPLIT, NWORDS, NXTRA,
     +                   ASYMP, DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   FACTOR, SIZE, THICK, WIDE,
     +                   XCLIP, XCOORD, XMAX, XMIN, XPDRAG, XSPLIT,
     +                   YCLIP, YCOORD, YMAX, YMAX3, YMAX4, YMIN, YMIN3,
     +                   YMIN4, YPDRAG, YSPLIT,
     +                   ZCOORD, ZMAX, ZMIN, ZSCALE,
     +                   ARRAYQ, ARRAYT_1, ARRAYX_1, ARRAYY_1, ARRAYZ_1,
     +                   FSAV1,
     +                   LABELS, LABVEC, PLINE, PSYMB,
     +                   PTITLE_1, QTITLE, WORDX, WORDY, XTITLE_1,
     +                   YTITLE_1, ZTITLE_1,
     +                   BARCAP, BARCAP_1, BAR_CHART, BORDER, BOXIT,
     +                   CENTRE, DENDRO_GRAM, EXTEND_LINES, FRAME,
     +                   GRATICULE, LOWER, MONO, NATLOG, NUMBRX, OFFSET,
     +                   PANEL, PCENTX, PCENTY, PCENTZ, PHIGHX, PHIGHY,
     +                   PHIGHZ, PIE_CHART, PLOT_TITLE, PLOTX, PLOTY,
     +                   PLOTZ, POWERX, POWERY, POWERZ,
     +                   RESTORE_RANGE, ROTATE, 
     +                   SHOW_BACKGROUND, SHOW_QUADRANTS, SHOW_XAXIS, 
     +                   SHOW_YAXIS, SHOW_ZAXIS, SIDE,
     +                   SWAP_YZ, THREE_D, TWO_PLOTS, UPPER,
     +                   VECTOR_FIELD, VIDEO, XGRID, XTOINT, YAXIS, 
     +                   YGRID, YTOINT, ZTOINT)
            IF (MTRANS.GE.8 .AND. MTRANS.LE.15 .AND. NATLOG(10)) THEN
               IADD8 = 8
            ELSE
               IADD8 = 0
            ENDIF
            MTRAN1 = MTRANS + IADD8
C---------------------------------------------------------------------
C Start to restore range parameters after reading a configuration file
C  
            IF (RESTORE_RANGE) THEN 
               MXTIC = MXTICT(MTRAN1)
               MYTIC = MYTICT(MTRAN1)

               XCOORD = XCOORD_T(MTRAN1)
               XMAX = XMAXT(MTRAN1)
               XMIN = XMINT(MTRAN1)
                
               YCOORD = YCOORD_T(MTRAN1)
               YMAX = YMAXT(MTRAN1)
               YMIN = YMINT(MTRAN1)
                
               YMAX3 = YMAX3_SAV 
               YMAX4 = YMAX4_SAV  
               YMIN3 = YMIN3_SAV 
               YMIN4 = YMIN4_SAV
               
               ZMAX = ZMAX_SAV 
               ZMIN = ZMIN_SAV          
            ENDIF   
C
C End restoring range parameters 
C-------------------------------------------------------------------            
            
           
            XCOORD_T(MTRAN1) = XCOORD
            XMAXT(MTRAN1) = XMAX
            XMINT(MTRAN1) = XMIN
            YCOORD_T(MTRAN1) = YCOORD
            YMAXT(MTRAN1) = YMAX
            YMINT(MTRAN1) = YMIN
            ARRAYT(MTRANS) = ARRAYT_1
            ARRAYX(MTRANS) = ARRAYX_1
            ARRAYY(MTRANS) = ARRAYY_1
            ARRAYZ(MTRANS) = ARRAYZ_1
            PTITLE(MTRANS) = PTITLE_1
            XTITLE(MTRANS) = XTITLE_1
            YTITLE(MTRANS) = YTITLE_1
            ZTITLE(MTRANS) = ZTITLE_1
            IF (MXTIC.GT.MAXTIC) MXTIC = MAXTIC
            IF (MYTIC.GT.MAXTIC) MYTIC = MAXTIC
            IF (MZTIC.GT.MAXTIC) MZTIC = MAXTIC
            IF (MXTIC.LT.MINTIC) MXTIC = MINTIC
            IF (MYTIC.LT.MINTIC) MYTIC = MINTIC
            IF (MZTIC.LT.MINTIC) MZTIC = MINTIC
            MXTICT(MTRAN1) = MXTIC
            MYTICT(MTRAN1) = MYTIC
C
C JSEND = 1: Store the initialised parameters
C
            STORE = .TRUE.
            CALL SAVEXY$(XPDRAG, YPDRAG, STORE)
            CALL SAVETR$(MTRANS, STORE)
            JSEND = 1
            CALL MENU02$(JSEND, NPRESS,
     +                   DRAGTI, DRAGXL, DRAGYL, DRAGZL,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                   PIE_CHART, PLOT_TITLE, SWAP_YZ, TWO_PLOTS)
            CALL MENU04$(JSEND,
     +                   KANGLE, KTIC,
     +                   MXDROP, MXTICT(MTRAN1), MYTICT(MTRAN1),
     +                   MZTIC, NGROUP, NPTS, NWORDS,
     +                   XCOORD, XMAX, XMIN, YCOORD, YDROP, YMAX, YMIN,
     +                   ZCOORD, ZMAX, ZMIN,
     +                   LABELS, LABVEC, WORDX, WORDY,
     +                   BAR_CHART,
     +                   NUMBRX, PCENTX, PCENTY, PCENTZ,
     +                   PHIGHX, PHIGHY, PHIGHZ, PLOT_LABELS,
     +                   PLOTX, PLOTY, PLOTZ, ROTATE, SHOW_XAXIS,
     +                   SHOW_YAXIS, SHOW_ZAXIS,
     +                   TWO_PLOTS, XTOINT, YTOINT, ZTOINT)
            CALL MENU05$(JSEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
     +                   ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
     +                   EXTEND_LINES, FRAME, GRATICULE, OFFSET,
     +                   PIE_CHART, PLOT_TITLE, SHOW_BACKGROUND,
     +                   SHOW_QUADRANTS, THREE_D, TWO_PLOTS, XGRID,
     +                   YGRID)
            CALL MENU06$(JSEND, IFILL, IHUE, L, LPREV, M, NFILES,
     +                   NGRAFS, NGROUP, NPTS, NSAV, NWORDS, NXTRA,
     +                   FACTOR, SIZE, WIDE, FSAV, FSAV1,
     +                   LABELS, LABVEC, TSAV, BARCAP, BARCAP_1,
     +                   BAR_CHART, PIE_CHART, LOWER, UPPER,
     +                   VECTOR_FIELD)
            CALL MENU07$(IFILL, IHUE, JSEND, ISHAPE, KPANEL, NFILES,
     +                   NPTS, NXTRA,
     +                   FSAV1(1), PLINE, PSYMB,
     +                   BAR_CHART, PANEL, PIE_CHART, SIDE, TWO_PLOTS)
            CALL MENU10$(NGRAFS, NKCOL, JSEND, JCOLOR, KCOLOR, LCOLOR,
     +                   NFILES, FSAV, MONO, VIDEO)
            CALL MENU11$(JSEND, MTRANS, NLOG,
     +                   ASYMP, ASAV, YMAXT, YMINT, YSAV1,
     +                   YSAV2, RTOL, NATLOG, POWERX, POWERY, POWERZ)
         ELSEIF (NDEC.EQ.13) THEN
C
C Object
C
            NPRESS = 13
            CALL PLTOBJ$(K2, NPRESS)
         ELSEIF (NDEC.EQ.14) THEN
C
C Help
C
            CALL SIMHLP$
         ELSEIF (NDEC.EQ.15) THEN
C
C Quit the plot ... First warn the user ... THIS OPTION SUPPRESSED 11/12/2017
C
            KVAL_12 = NKLCFG(N24)
            IF (KVAL_12.EQ.N1) THEN
               CALL GRAPHQ (ABORT)
               IF (ABORT) THEN
                  AGAIN = .FALSE.
                  MENU = .FALSE.
                  CALL GRAPHICS_BUTTON_PRESS$(I_PRESS_0)
               ENDIF
            ELSE
               AGAIN = .FALSE.
               MENU = .FALSE.   
               CALL GRAPHICS_BUTTON_PRESS$(I_PRESS_0)
           ENDIF   
         ENDIF
         IF (MENU) THEN
            AGAIN = .TRUE.
            NPRESS = 1
         ELSE
            AGAIN = .FALSE.
            NPRESS = 0
         ENDIF
      ENDDO
C
C Finally check if axes have been moved and BOXIT must be cancelled
C
      IF (BOXIT) THEN
         IF (XCOORD.GT.XMIN .AND. XCOORD.LT.XMAX .OR.
     +       YCOORD.GT.YMIN .AND. YCOORD.LT.YMAX) THEN
             AGAIN = .TRUE.
             BOXIT = .FALSE.
         ENDIF
         IF (TWO_PLOTS) THEN
            IF (ZCOORD.GT.XMIN .AND. ZCOORD.LT.XMAX) THEN
               AGAIN = .TRUE.
               BOXIT = .FALSE.
            ENDIF
         ENDIF
         IF (AGAIN) THEN
            CALL PUTADV$(
     +'Box round data cancelled (inconsistent with translated axes)')
            JSEND = 1
            CALL MENU05$(JSEND, ISHAPE, KTIC, THICK, XCLIP, YCLIP,
     +                   ZSCALE, BAR_CHART, BORDER, BOXIT, CENTRE,
     +                   EXTEND_LINES, FRAME, GRATICULE, OFFSET,
     +                   PIE_CHART, PLOT_TITLE, SHOW_BACKGROUND,
     +                   SHOW_QUADRANTS, THREE_D, TWO_PLOTS, XGRID,
     +                   YGRID)
         ENDIF
      ENDIF 
C
C Format statements
C      
  100 FORMAT (
     + 'Quick editing options without screen updating'
     +/
     +/'Change details here as required, then display to'
     +/'refresh, and print or Save As ... a graphics file.'
     +/
     +/'Current graph type or coordinate axes:'
     +/A
     +/A
     +/)
  200 FORMAT (
     + 'Quit editing ... Display current plot'
     +/'Titles'
     +/'Legends',2X,A4
     +/'Labels',2X,A4
     +/'Style'
     +/'Data'
     +/'Panel'
     +/'Text'
     +/'Arrows/Lines'
     +/'Colours'
     +/'Transform',2X,A4
     +/'Configure'
     +/'Objects'
     +/'Help')
c suppressed exit option 11/12/2017     
c     +/'Quit ... Exit current plot')
      END
C
C
