C
C
      SUBROUTINE SUPPXY$(NFILES, NGRAFS, NIN, NMAX, NPTS, NSAV,
     +                   NTYPE, NTYPE1, NTYPE2, NTYPE3, NY, NZ,
     +                   XMAX, XMIN, YMAX, YMAX3,
     +                   YMAX4, YMIN, YMIN3, YMIN4,
     +                   FSAV, TSAV,
     +                   ABORT, BARCAP, LOWER, UPPER)

      USE MODULE_SAVEGKS, ONLY : X, XH, XL, Y, YH, YL
C
C ACTION: Check user supplied data for plotting if not a barchart or piechart
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         ABORT = .TRUE. if files not usable
C         05/03/2001 derived from LIBFIL$
C         14/10/2004 minor editing 
C         23/04/2007 added INTENTS
C         29/01/2008 removed X, ..., YL from argument list, added MODULE_SAVEGKS
C                    and call to GKSSAV$ 
C         21/08/2011 added INQUIRE to check if file supplied does exist
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NGRAFS, NIN
      INTEGER,             INTENT (INOUT) :: NMAX 
      INTEGER,             INTENT (INOUT) :: NFILES, NSAV(NGRAFS)
      INTEGER,             INTENT (OUT)   :: NPTS, NTYPE, NTYPE1,
     +                                       NTYPE2, NTYPE3, NY, NZ 
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX, XMIN, YMAX, YMAX3,
     +                                       YMAX4, YMIN, YMIN3, YMIN4
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(NGRAFS), TSAV(NGRAFS)
      LOGICAL,             INTENT (INOUT) :: BARCAP(NGRAFS),
     +                                       LOWER(NGRAFS),
     +                                       UPPER(NGRAFS)
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C
      INTEGER    I, IOS, J, IADD1, NCOL, NROW
      INTEGER    K0, K1, K2, K3, K4, K6
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K4 = 4, K6 = 6)
      DOUBLE PRECISION A, B, C, D, G, H, RTOL, TEMP, X02AME$
      CHARACTER  LINE*100
      LOGICAL    THERE   
      INTRINSIC  ABS
      EXTERNAL   PUTFAT$, X02AME$, MAXMIN$, GKSSAV$
C
C First initialise ABORT, etc.
C
      ABORT = .TRUE.
      NPTS = K0
      NTYPE = K1
      NTYPE1 = K0
      NTYPE2 = K0
      NTYPE3 = K0
      NY = K0
      NZ = K0
      RTOL = 1.0D+09*X02AME$()
C
C Read data off all files
C
      IF (NFILES.GT.K0) THEN
         IADD1 = K0
         DO I = K1, NFILES
            IADD1 = IADD1 + K1
            INQUIRE (FILE = FSAV(I), EXIST = THERE) 
            IF (.NOT.THERE) GOTO 20
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FSAV(I), IOSTAT = IOS)
            IF (IOS.NE.K0) GOTO 20
            READ (NIN,100,END=20,ERR=20,IOSTAT=IOS) TSAV(I)
            IF (IOS.NE.K0) GOTO 20
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NROW, NCOL
            IF (IOS.NE.K0) GOTO 20
C
C Expand array size if required
C              
            IF (NROW.GT.NMAX) THEN
               NMAX = NROW
               CALL GKSSAV$(K2, NMAX,
     +                      ABORT)
               IF (ABORT) GOTO 20
            ENDIF                       
            IF (NCOL.EQ.K2 .OR. NCOL.EQ.K3) THEN
C
C Read X, Y ... Define YMAX3, YMAX4, YMIN3, YMIN4
C
               NTYPE = K1
               NTYPE1 = NTYPE1 + K1
               NPTS = K0
               DO J = K1, NROW
                  READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B
                  IF (IOS.NE.K0) GOTO 20
                  NPTS = NPTS + K1
                  X(NPTS) = A
                  Y(NPTS) = B
                  IF (ABS(A).GT.RTOL) THEN
                     TEMP = B/A
                     IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                     IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                  ENDIF
                  IF (ABS(B).GT.RTOL) THEN
                     TEMP = A/B
                     IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                     IF (TEMP.LT.YMIN4) YMIN4 = TEMP
                  ENDIF
               ENDDO
            ELSEIF (NCOL.EQ.K4) THEN
C
C Read X, XH, XL, Y, YH, YL .... Define YMAX3, YMAX4, YMIN3, YMIN4
C
               NTYPE = K2
               NTYPE2 = NTYPE2 + K1
               NPTS = K0
               DO J = K1, NROW
                  READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D
                  IF (IOS.NE.K0) GOTO 20
                  IF (B.GT.C .OR. C.GT.D) GOTO 20
                  NPTS = NPTS + K1
                  X(NPTS) = A
                  XH(NPTS) = A
                  XL(NPTS) = A
                  YL(NPTS) = B
                  Y(NPTS) = C
                  YH(NPTS) = D
                  IF (ABS(A).GT.RTOL) THEN
                     TEMP = B/A
                     IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                     TEMP = D/A
                     IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                  ENDIF
                  IF (ABS(B).GT.RTOL) THEN
                     TEMP = A/B
                     IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                  ENDIF
                  IF (ABS(D).GT.RTOL) THEN
                     TEMP = A/D
                     IF (TEMP.LT.YMIN4) YMIN4 = TEMP
                  ENDIF
               ENDDO
            ELSEIF (NCOL.EQ.K6) THEN
C
C Read X, XH, XL, Y, YH, YL .... Define YMAX3, YMAX4, YMIN3, YMIN4
C
               NTYPE = K6
               NTYPE2 = NTYPE2 + K1
               NPTS = K0
               DO J = K1, NROW
                  READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) G, A, H, B, C, D
                  IF (IOS.NE.K0) GOTO 20
                  NPTS = NPTS + K1
                  X(NPTS) = A
                  XH(NPTS) = H
                  XL(NPTS) = G
                  YL(NPTS) = B
                  Y(NPTS) = C
                  YH(NPTS) = D
                  IF (ABS(A).GT.RTOL) THEN
                     TEMP = B/A
                     IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                     TEMP = D/A
                     IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                  ENDIF
                  IF (ABS(B).GT.RTOL) THEN
                     TEMP = A/B
                     IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                  ENDIF
                  IF (ABS(D).GT.RTOL) THEN
                     TEMP = A/D
                     IF (TEMP.LT.YMIN4) YMIN4 = TEMP
                  ENDIF
               ENDDO
            ENDIF
C
C Define logicals
C
            IF (NTYPE.EQ.K1) THEN
               BARCAP(IADD1) = .FALSE.
               LOWER(IADD1) = .FALSE.
               UPPER(IADD1) = .FALSE.
            ELSEIF (NTYPE.EQ.K2 .OR. NTYPE.EQ.K6) THEN
               BARCAP(IADD1) = .TRUE.
               LOWER(IADD1) = .TRUE.
               UPPER(IADD1) = .TRUE.
            ENDIF
            NSAV(IADD1) = NTYPE
C
C Find the minimum and maximum of the current X and Y Values ..........
C
            IF (IADD1.EQ.K1) THEN
               CALL MAXMIN$(K0, NPTS, X, XMAX, XMIN)
               CALL MAXMIN$(K0, NPTS, Y, YMAX, YMIN)
            ELSE
               CALL MAXMIN$(K1, NPTS, X, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS, Y, YMAX, YMIN)
            ENDIF
            IF (NTYPE.EQ.K2 .OR. NTYPE.EQ.K6) THEN
               CALL MAXMIN$(K1, NPTS, XH, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS, XL, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS, YH, YMAX, YMIN)
               CALL MAXMIN$(K1, NPTS, YL, YMAX, YMIN)
            ENDIF
         ENDDO
         ABORT = .FALSE.
         CLOSE (UNIT = NIN)
         RETURN
      ELSE
         RETURN
      ENDIF
C
C LABEL 20: here only if a crash
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      WRITE (LINE,200) IADD1
      CALL PUTFAT$(LINE)   
C
C Format statements
C      
  100 FORMAT (A)
  200 FORMAT ('File',1X,I3,1X,'is not a consistent plot type file')
      END
C
C
