C
C
      SUBROUTINE SUPPYZ$(NFILES, NGRAFS, NIN, NMAX, NPTS, NSAV,
     +                   NTYPE, NTYPE1, NTYPE2, NTYPE3, NY, NZ,
     +                   XMAX, XMIN, YMAX, YMAX3,
     +                   YMAX4, YMIN, YMIN3, YMIN4, ZMAX, ZMIN,
     +                   FSAV, TSAV,
     +                   ABORT, BARCAP, LOWER, UPPER, YAXIS)

      USE MODULE_SAVEGKS, ONLY : X, Y
C
C ACTION: Check user supplied data for plotting with two Y-scales
C AUTHOR: W. G. Bardsley, University of Manchester, U.K.
C         ABORT = .TRUE. if files not usable
C         03/10/2010 derived from SUPPXY$ when GKSGRF$ is called with TWO_PLOTS = .TRUE.
C         20/05/2013 added check box to check that NY*NZ.NE.0      
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NGRAFS, NFILES, NIN
      INTEGER,             INTENT (INOUT) :: NMAX 
      INTEGER,             INTENT (INOUT) :: NSAV(NGRAFS)
      INTEGER,             INTENT (OUT)   :: NPTS, NTYPE, NTYPE1,
     +                                       NTYPE2, NTYPE3, NY, NZ 
      DOUBLE PRECISION,    INTENT (INOUT) :: XMAX, XMIN, YMAX, YMAX3,
     +                                       YMAX4, YMIN, YMIN3, YMIN4,
     +                                       ZMAX, ZMIN
      CHARACTER (LEN = *), INTENT (INOUT) :: FSAV(NGRAFS), TSAV(NGRAFS)
      LOGICAL,             INTENT (INOUT) :: BARCAP(NGRAFS),
     +                                       LOWER(NGRAFS),
     +                                       UPPER(NGRAFS)
      LOGICAL,             INTENT (INOUT) :: YAXIS(NGRAFS)
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Allocatable
C      
      CHARACTER (LEN = 23), ALLOCATABLE :: TEXT(:)
C
C Locals
C
      INTEGER    I, IERR, IOS, J, IADD1, KFILES, NCOL, NROW
      INTEGER    I_FIRSTY, I_FIRSTZ
      INTEGER    K0, K1, K2, K3, K6
      PARAMETER (K0 = 0, K1 = 1, K2 = 2, K3 = 3, K6 = 6)
      DOUBLE PRECISION A, B, RTOL, TEMP, X02AME$
      CHARACTER (LEN = 100) LINE
      CHARACTER (LEN = 50 ) TITLE
      PARAMETER (TITLE = 'Select files to plot on LHS, i.e. Y_axis')
      INTRINSIC  ABS
      EXTERNAL   PUTFAT$, X02AME$, MAXMIN$, GKSSAV$
      EXTERNAL   CHKBOX
C
C First initialise ABORT, etc.
C
      ABORT = .TRUE.
      KFILES = NFILES
      NPTS = K0
      NTYPE = K1
      NTYPE1 = K0
      NTYPE2 = K0
      NTYPE3 = K0
      NY = K0
      NZ = K0
      I_FIRSTY = K0
      I_FIRSTZ = K0
      DO I = K1, KFILES
         IF (YAXIS(I)) THEN
            NY = NY + K1
            IF (NY.EQ.K1) I_FIRSTY = I
         ELSE
            NZ = NZ + K1
            IF (NZ.EQ.K1) I_FIRSTZ = I
         ENDIF
      ENDDO  
      DO WHILE (NY*NZ.EQ.K0) 
         IERR = K0
         IF (ALLOCATED(TEXT)) DEALLOCATE (TEXT, STAT = IERR)
         IF (IERR.EQ.K0) ALLOCATE(TEXT(NFILES), STAT = IERR)
         IF (IERR.EQ.K0) THEN
            DO I = K1, KFILES
               WRITE (TEXT(I),100) I
            ENDDO
            CALL CHKBOX (NFILES,
     +                   TEXT, TITLE,
     +                   YAXIS)                     
         ENDIF
         DEALLOCATE (TEXT, STAT = IERR)
         I_FIRSTY = K0
         I_FIRSTZ = K0
         NY = K0
         NZ = K0    
         DO I = K1, KFILES
            IF (YAXIS(I)) THEN
               NY = NY + K1
               IF (NY.EQ.K1) I_FIRSTY = I
            ELSE
               NZ = NZ + K1
               IF (NZ.EQ.K1) I_FIRSTZ = I
            ENDIF
         ENDDO  
      ENDDO      
      RTOL = 1.0D+09*X02AME$()
C
C Read data off all files
C
      IF (KFILES.GT.K0) THEN
         IADD1 = K0
         DO I = K1, KFILES
            IADD1 = IADD1 + K1
            CLOSE (UNIT = NIN)
            OPEN (UNIT = NIN, FILE = FSAV(I))
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TSAV(I)
            IF (IOS.NE.K0) GOTO 20
            READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) NROW, NCOL
            IF (IOS.NE.K0) GOTO 20
C
C Expand array size if required
C              
            IF (NROW.GT.NMAX) THEN
               NMAX = NROW
               CALL GKSSAV$(K2, NMAX,
     +                      ABORT)
               IF (ABORT) GOTO 20
            ENDIF                       
            IF (NCOL.EQ.K2 .OR. NCOL.EQ.K3) THEN
C
C Read X, Y ... Define YMAX3, YMAX4, YMIN3, YMIN4
C
               NTYPE = K1
               NTYPE1 = NTYPE1 + K1
               NPTS = K0
               DO J = K1, NROW
                  READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B
                  IF (IOS.NE.K0) GOTO 20
                  NPTS = NPTS + K1
                  X(NPTS) = A
                  Y(NPTS) = B
                  IF (ABS(A).GT.RTOL) THEN
                      TEMP = B/A
                     IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                     IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                  ENDIF
                  IF (ABS(B).GT.RTOL) THEN
                     TEMP = A/B
                     IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                     IF (TEMP.LT.YMIN4) YMIN4 = TEMP
                  ENDIF
               ENDDO
            ENDIF
C
C Define logicals
C
            IF (NTYPE.EQ.K1) THEN
               BARCAP(IADD1) = .FALSE.
               LOWER(IADD1) = .FALSE.
               UPPER(IADD1) = .FALSE.
            ELSEIF (NTYPE.EQ.K2 .OR. NTYPE.EQ.K6) THEN
               BARCAP(IADD1) = .TRUE.
               LOWER(IADD1) = .TRUE.
               UPPER(IADD1) = .TRUE.
            ENDIF
            NSAV(IADD1) = NTYPE
C
C Find the minimum and maximum of the current X, Y and Z Values ..........
C
            IF (IADD1.EQ.I_FIRSTY) THEN
               CALL MAXMIN$(K0, NPTS, X, XMAX, XMIN)
               CALL MAXMIN$(K0, NPTS, Y, YMAX, YMIN)
            ELSEIF (IADD1.EQ.I_FIRSTZ) THEN
               CALL MAXMIN$(K0, NPTS, X, XMAX, XMIN)
               CALL MAXMIN$(K0, NPTS, Y, ZMAX, ZMIN) 
            ELSEIF (YAXIS(IADD1)) THEN   
               CALL MAXMIN$(K1, NPTS, X, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS, Y, YMAX, YMIN)   
            ELSE
               CALL MAXMIN$(K1, NPTS, X, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS, Y, ZMAX, ZMIN)
            ENDIF
         ENDDO
         ABORT = .FALSE.
         CLOSE (UNIT = NIN)
         RETURN
      ELSE
         RETURN
      ENDIF
C
C LABEL 20: here only if a crash
C =========
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      WRITE (LINE,200) IADD1
      CALL PUTFAT$(LINE)   
C
C Format statements
C      
  100 FORMAT ('File, i.e. data set',i4)
  200 FORMAT ('File',1X,I3,1X,'is not a consistent plot type file')
      END
C
C
