C
C
      SUBROUTINE SUR000$(ISEND, MODEL, NMAX, NX, NY,
     +                   VECTOR, XMAX, XMIN, YMAX, YMIN, Z,
     +                   ABORT)
C
C ACTION : Get surface type data
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 4/9/95
C ADVICE : ISEND = 1: use MODEL, make data for demonstration
C          ISEND = 2: read VECTOR from a file, define NX, NY, Z
C          ISEND = 3: supply VECTOR, define NX, NY, Z
C          ISEND = 4: supply NX, NY, Z, define VECTOR
C          ISEND = 5: create an output file
C          ISEND = n: no action if n is not 1, 2, 3, 4 or 5
C          16/08/2001 allowed input from vector or matrix file
C          08/02/2005 added CHECKF
C          16/05/2005 defined TITLE before call to VECOUT
C          13/07/2005 renamed RANDOM to RANDOM@ 
C          12/05/2007 added INTENTS and G05CCFG/G05CAFG 
C          02/08/2008 added call to ISITSF 
C          27/02/2018 added extra parameters
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, MODEL, NMAX
      INTEGER,          INTENT (INOUT) :: NX, NY
      DOUBLE PRECISION, INTENT (INOUT) :: VECTOR(NMAX**2 + 6) 
      DOUBLE PRECISION, INTENT (INOUT) :: XMAX, XMIN, YMAX, YMIN,
     +                                    Z(NMAX, NMAX)
      LOGICAL,          INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    NBIG, NPTS
      INTEGER    N0, N1, N2, N3, N6, N10
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N6 = 6, N10 = 10)
      INTEGER    NXX, NYY
      PARAMETER (NXX = 40, NYY = 40)
      INTEGER    I, IOS, J, K, L, NCOL, NROW
      DOUBLE PRECISION DUMMY, G05CAFG
      DOUBLE PRECISION RSQD, XDIFF, XTEMP, YDIFF, YTEMP
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, FIFTY, CENT
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, FIFTY = 50.0D+00, CENT = 100.0D+00) 
      DOUBLE PRECISION F4PNT25, F18, F20, F25, F40, F60
      PARAMETER (F4PNT25 = 4.25D+00, F18 = 18.0D+00, F20 = 20.0D+00, 
     +           F25 = 25.0D+00, F40 = 40.0D+00, F60 = 60.0D+00) 
      DOUBLE PRECISION PNT07, PNT12, PNT125, PNT25, PNT3, PNT5, PNT7
      PARAMETER (PNT07 = 0.07D+00, PNT12 = 0.12D+00, PNT125 = 0.125D+00,
     +           PNT25 = 0.25D+00, PNT3 = 0.3D+00, PNT5 = 0.5D+00, 
     +           PNT7 = 0.7D+00)     
      CHARACTER  FNAME*1024, LINE*100, TITLE*80
      LOGICAL    LABEL
      PARAMETER (LABEL = .TRUE.)
      EXTERNAL   VECOUT, OFILES, CHECKF, ISITSF
      EXTERNAL   PUTFAT$
      EXTERNAL   G05CCFG, G05CAFG
      INTRINSIC  EXP, DBLE, NINT, SQRT, COS
      ABORT = .TRUE.
      IF (ISEND.LT.1 .OR. ISEND.GT.5) RETURN
      IF (ISEND.EQ.1) THEN
C
C Define VECTOR and Z according to the value of MODEL
C
         IF (MODEL.LE.10) THEN
            NX = NXX
            NY = NYY
         ELSEIF (MODEL.EQ.11) THEN  
            CALL G05CCFG
            NX = 16
            NY = 4
            DO J = 1, NY
               DO I = 1, NX
                  Z(I,J) = F60 + NINT(F40*G05CAFG(DUMMY))
     +                     - 3*I - 4*J
                  IF (Z(I,J).LT.ZERO) Z(I,J) = ZERO
               ENDDO
            ENDDO
         ENDIF
         Z(1,1) = CENT
         Z(1,2) = 96.0D+00
         Z(2,1) = 92.0D+00
         Z(2,2) = 88.0D+00
         XMIN = ZERO
         XMAX = ONE
         YMIN = ZERO
         YMAX = ONE
         IF (MODEL.EQ.4) THEN
            XMAX = CENT
            YMAX = CENT
         ENDIF
         VECTOR(1) = DBLE(NX)
         VECTOR(2) = DBLE(NY)
         VECTOR(3) = DBLE(XMIN)
         VECTOR(4) = DBLE(XMAX)
         VECTOR(5) = DBLE(YMIN)
         VECTOR(6) = DBLE(YMAX)
         XDIFF = (XMAX - XMIN)/(DBLE(NX) - ONE)
         YDIFF = (YMAX - YMIN)/(DBLE(NY) - ONE)
         YTEMP = - YDIFF
         L = 6
         DO I = 1, NY
            YTEMP = YTEMP + YDIFF
            XTEMP = - XDIFF
            DO J = 1, NX
               XTEMP = XTEMP + XDIFF
               IF (MODEL.EQ.1) THEN
                  Z(J,I) =  (EXP(-PNT5*((XTEMP - PNT3)/PNT07)**2) +
     +                       PNT5* EXP(-PNT5*((XTEMP - PNT7)/PNT12)**2))
     +                     *(EXP(-PNT5*((YTEMP - PNT3)/PNT07)**2) +
     +                       PNT5*EXP(-PNT5*((YTEMP - PNT7)/PNT12)**2))
               ELSEIF (MODEL.EQ.2) THEN
                  RSQD = (XTEMP - PNT25)**2 + (YTEMP - PNT5)**2
                  Z(J,I) = EXP(- F18*RSQD)
               ELSEIF (MODEL.EQ.3) THEN
                  RSQD = (XTEMP - PNT25)**2 + (YTEMP - PNT25)**2
                  Z(J,I) = TWO*EXP(-THREE*SQRT(RSQD))*
     +                     (F4PNT25 + COS(F40*SQRT(RSQD)))
               ELSEIF (MODEL.EQ.4) THEN
                  Z(J,I) = FIFTY*EXP(-YTEMP/CENT)*
     +                     (ONE + COS(F25*YTEMP/CENT))*
     +                      EXP(-XTEMP/F20)
               ELSEIF (MODEL.EQ.5) THEN
                  Z(J,I) = CENT*EXP(-((XTEMP - PNT5)/PNT25)**2)*
     +                          EXP(-((YTEMP - PNT5)/PNT125)**2)
               ENDIF
               L = L + 1
               VECTOR(L) = DBLE(Z(J,I))
            ENDDO
         ENDDO
         ABORT = .FALSE.
      ELSEIF (ISEND.EQ.2) THEN
C
C Open a file to read in VECTOR (or Z then generate VECTOR)
C
         CLOSE (UNIT = N10)
         CALL OFILES (N3, N10,
     +                FNAME, 
     +                ABORT)
         CLOSE (UNIT = N10)
         IF (ABORT) THEN
            RETURN
         ELSE
            CALL ISITSF (J, K,
     +                   FNAME)         
            IF (J.GT.0 .AND. K.GT.0) THEN
               OPEN (UNIT = N10, FILE = FNAME)
            ELSE
               ABORT = .TRUE.
               RETURN
            ENDIF
         ENDIF         
         READ (N10,'(A)',IOSTAT=IOS) TITLE
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) N1
            CALL PUTFAT$(LINE)
            CLOSE (UNIT = N10)
            ABORT = .TRUE.
            RETURN
         ENDIF
C
C Close N10 before calling CHECKF
C
         CLOSE (UNIT = N10)
         CALL CHECKF (FNAME, TITLE,
     +                ABORT)
         IF (ABORT) THEN
            RETURN
         ELSE
C
C Re-connect N10 and re-read the TITLE
C
            OPEN (UNIT = N10, FILE = FNAME)
            READ (N10,'(A)',IOSTAT=IOS) TITLE
         ENDIF
         READ (N10,*,IOSTAT=IOS) I, J
         IF (IOS.NE.N0) THEN
            WRITE (LINE,100) N2
            CALL PUTFAT$(LINE)
            CLOSE (UNIT = N10)
            ABORT = .TRUE.
            RETURN
         ENDIF
         NROW = I
         NCOL = J
         IF (NROW.LT.N2 .OR. NCOL.LT.N1) THEN
            CALL PUTFAT$('Incorrect dimensions for surface plotting')
            CLOSE (UNIT = N10)
            ABORT = .TRUE.
            RETURN
         ENDIF
         IF (NCOL*NROW .GT. NMAX**2) THEN
            CALL PUTFAT$('File is too large to plot')
            CLOSE (UNIT = N10)
            ABORT = .TRUE.
            RETURN
         ENDIF
         IF (NCOL.EQ.N1) THEN
C
C Data file is a vector file
C
            NPTS = NROW
            DO I = N1, NROW
               READ (N10,*,IOSTAT=IOS) VECTOR(I)
               IF (IOS.NE.N0) THEN
                  WRITE (LINE,100) I + N2
                  CALL PUTFAT$(LINE)
                  CLOSE (UNIT = N10)
                  ABORT = .TRUE.
                  RETURN
               ENDIF
            ENDDO
         ELSE
C
C Data file is a matrix file
C
            NPTS = NCOL*NROW + N6
            IF (NCOL.GT.NMAX .OR. NROW.GT.NMAX) THEN
               CALL PUTFAT$('File is too large to plot')
               CLOSE (UNIT = N10)
               ABORT = .TRUE.
               RETURN
            ENDIF
            DO I = N1, NROW
               READ (N10,*,IOSTAT=IOS) (Z(I,J), J = N1, NCOL)
               IF (IOS.NE.N0) THEN
                  WRITE (LINE,100) I + N2
                  CALL PUTFAT$(LINE)
                  CLOSE (UNIT = N10)
                  ABORT = .TRUE.
                  RETURN
               ENDIF
            ENDDO
            VECTOR(1) = DBLE(NROW)
            VECTOR(2) = DBLE(NCOL)
            VECTOR(3) = DBLE(N1)
            VECTOR(4) = DBLE(NROW)
            VECTOR(5) = DBLE(N1)
            VECTOR(6) = DBLE(NCOL)
            K = N6
            DO J = N1, NCOL
               DO I = N1, NROW
                  K = K + N1
                  VECTOR(K) = Z(I,J)
               ENDDO
            ENDDO
         ENDIF
         CLOSE (UNIT = N10)
C
C VECTOR has now been defined from either a vector or matrix file
C
         NX = NINT(VECTOR(1))
         NY = NINT(VECTOR(2))
         IF (NX*NY + N6.NE.NPTS) THEN
            ABORT = .TRUE.
            CALL PUTFAT$('Not a surface file ... Wrong dimensions')
            RETURN
         ENDIF
         IF (NX.LT.N2 .OR. NY.LT.N2) THEN
            ABORT = .TRUE.
            CALL PUTFAT$('Wrong dimensions ... NX and NY must be > 1')
            RETURN
         ENDIF
         XMIN = VECTOR(3)
         XMAX = VECTOR(4)
         YMIN = VECTOR(5)
         YMAX = VECTOR(6)
         IF (XMIN.GT.XMAX) THEN
            ABORT = .TRUE.
            CALL PUTFAT$('Not a surface file ... Xmin > Xmax')
            RETURN
         ENDIF
         IF (YMIN.GT.YMAX) THEN
            ABORT = .TRUE.
            CALL PUTFAT$('Not a surface file ... Ymin > Ymax')
            RETURN
         ENDIF
         K = N0
         L = N6
         DO J = N1, NY
            K = K + N1
            DO I = N1, NX
               L = L + N1
               Z(I,K) = VECTOR(L)
            ENDDO
         ENDDO
         ABORT = .FALSE.
      ELSEIF (ISEND.EQ.3) THEN
C
C Supply VECTOR, calculate NX, NY, Z
C
         NX = NINT(VECTOR(1))
         NY = NINT(VECTOR(2))
         XMIN = VECTOR(3)
         XMAX = VECTOR(4)
         YMIN = VECTOR(5)
         YMAX = VECTOR(6)
         L = N6
         DO J = N1, NY
            DO I = N1, NX
               L = L + N1
               Z(I,J) = VECTOR(L)
            ENDDO
         ENDDO
         ABORT = .FALSE.
      ELSEIF (ISEND.EQ.4) THEN
C
C Supply NX, NY, Z, XMAX, XMIN, YMAX, YMIN, calculate VECTOR
C
         VECTOR(1) = DBLE(NX)
         VECTOR(2) = DBLE(NY)
         VECTOR(3) = XMIN
         VECTOR(4) = XMAX
         VECTOR(5) = YMIN
         VECTOR(6) = YMAX
         L = N6
         DO J = N1, NY
            DO I = N1, NX
               L = L + N1
               VECTOR(L) = Z(I,J)
            ENDDO
         ENDDO
         ABORT = .FALSE.
      ELSEIF (ISEND.EQ.5) THEN
C
C Output VECTOR to a file
C
         NBIG = NMAX**2 + N6
         NPTS = NX*NY + N6
         CLOSE (UNIT = N10)
         WRITE (TITLE,200)
         CALL VECOUT (N1, NBIG, N10, NPTS,
     +                VECTOR,
     +                FNAME, TITLE,
     +                ABORT, LABEL, LABEL)
         CLOSE (UNIT = N10)
         ABORT = .TRUE.
      ENDIF 
C
C Format statements
C      
  100 FORMAT ('Formatting error ... check file at line',I6)
  200 FORMAT ('Data for a 3D surface plot')
      END
C 
C
