C
C
      SUBROUTINE SUR001$(NMAX, NX, NXTEMP, NY, NYTEMP,
     +                   X, XTEMP, Y, YTEMP, Z, ZMAX, ZMIN, ZTEMP)
C
C ACTION : Transform Z then define X and Y
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.24/8/95
C          12/05/2007 added INTENTS 
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: NMAX, NX,  NY
      INTEGER,          INTENT (OUT)   :: NXTEMP, NYTEMP  
      DOUBLE PRECISION, INTENT (INOUT) :: Z(NMAX,NY)
      DOUBLE PRECISION, INTENT (OUT)   :: X(NX), XTEMP(NX), Y(NY),
     +                                    YTEMP(NY), ZMAX, ZMIN,
     +                                    ZTEMP(NMAX,NY)
C
C Locals
C      
      INTEGER    I, J
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION XDIFF, YDIFF, ZDIFF
      INTRINSIC  DBLE
C
C Define NXTEMP, NYTEMP
C
      NXTEMP = NX
      NYTEMP = NY
C
C Find ZMIN, ZMAX
C
      ZMIN = Z(1,1)
      ZMAX = Z(1,1)
      DO J = 1, NY
         DO I = 1, NX
            IF (Z(I,J).LT.ZMIN) ZMIN = Z(I,J)
            IF (Z(I,J).GT.ZMAX) ZMAX = Z(I,J)
         ENDDO
      ENDDO
      ZDIFF = ZMAX - ZMIN
C
C Normalise Z
C
      DO J = 1, NY
         DO I = 1, NX
            Z(I,J) = (Z(I,J) - ZMIN)/ZDIFF
            ZTEMP(I,J) = Z(I,J)
         ENDDO
      ENDDO
C
C Define X and Y
C
      X(1) = ZERO
      XTEMP(1) = X(1)
      X(NX) = ONE
      XTEMP(NX) = X(NX)
      XDIFF = (X(NX) - X(1))/(DBLE(NX) - ONE)
      DO I = 2, NX - 1
         X(I) = X(I - 1) + XDIFF
         XTEMP(I) = X(I)
      ENDDO
      Y(1) = ZERO
      YTEMP(1) = Y(1)
      Y(NY) = ONE
      YTEMP(NY) = Y(NY)
      YDIFF = (Y(NY) - Y(1))/(DBLE(NY) - ONE)
      DO I = 2, NY - 1
         Y(I) = Y(I - 1) + YDIFF
         YTEMP(I) = Y(I)
      ENDDO
      END
C  
C