C  
C
      SUBROUTINE SUR002$(KMODE)
C
C ACTION : Open workstations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.24/8/95 
C          12/05/2007 added INTENT
C
      IMPLICIT   NONE
C
C Argument
C      
      INTEGER, INTENT (IN) :: KMODE 
C
C Locals
C      
      INTEGER    ISEND, N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, HALF, THIRD, RANGE1, YTOX
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00,
     +           HALF = ONE/TWO, THIRD = ONE/THREE,
     +           RANGE1 = 0.75D+00, YTOX = 0.75D+00)
      DOUBLE PRECISION X3BOT, X3TOP, Y3BOT, Y3TOP
      PARAMETER (X3BOT = HALF*(ONE - YTOX*RANGE1),
     +           X3TOP = ONE - X3BOT,
     +           Y3BOT = HALF*(ONE - RANGE1),
     +           Y3TOP = ONE - Y3BOT)
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 0.025D+00)
      EXTERNAL   INIT_4$, GSLN$, GSWN$, GSVP$
      ISEND = N0
      CALL INIT_4$(ISEND)
      IF (ISEND.NE.0) RETURN
      CALL GSLN$(N1)
      IF (KMODE.EQ.3) THEN
         CALL GSWN$(N1, -ONE/YTOX, ONE/YTOX, -ONE, ONE)
         CALL GSVP$(N1, ZERO, ONE, THIRD - EPSI, ONE - EPSI)
         CALL GSWN$(N2, ZERO, ONE, ZERO, ONE)
         CALL GSVP$(N2, ZERO, ONE, THIRD - EPSI, ONE - EPSI)
         CALL GSWN$(N3, -ONE/YTOX, ONE/YTOX, -ONE, ONE)
         CALL GSVP$(N3, ZERO, ONE, ZERO, TWO*THIRD)
         CALL GSWN$(N4, ZERO, ONE, ZERO, ONE)
         CALL GSVP$(N4, ZERO, ONE, ZERO, TWO*THIRD)
      ELSE
         CALL GSWN$(N1, -ONE/YTOX, ONE/YTOX, -ONE, ONE)
         CALL GSVP$(N1, ZERO, ONE, ZERO, ONE)
         CALL GSWN$(N2, ZERO, ONE, ZERO, ONE)
         CALL GSVP$(N2, ZERO, ONE, ZERO, ONE)
         CALL GSWN$(N3, ZERO, ONE, ZERO, ONE)
         CALL GSVP$(N3, X3BOT, X3TOP, Y3BOT, Y3TOP)
      ENDIF
      END
C 
C