C 
C
      SUBROUTINE SUR003$(ICOLOR, KMODE, NDIVS,
     +                   AXES, FULL, TICKS)
C
C ACTION : Axes
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.24/8/95
C          12/05/2007 added INTENTS
C
C          1 = RHS Z axis
C          2 = top rear Y axis
C          3 = top rear X axis
C          4 = LHS Z axis
C          5 = front Y axis
C          6 = front X axis
C          7 = bottom rear Y axis
C          8 = bottom rear Z axis
C          9 = rear Z axis
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER, INTENT (IN) :: ICOLOR, KMODE, NDIVS(*) 
      LOGICAL, INTENT (IN) :: AXES, FULL, TICKS(*)
C
C lOCALS
C      
      INTEGER    N1, N2, N3
      PARAMETER (N1 = 1, N2 = 2, N3 = 3)
      INTEGER    I, COLOUR_INDEX
      DOUBLE PRECISION XT(N2), YT(N2)
      DOUBLE PRECISION BOT, TOP
      PARAMETER (BOT = 0.0D+00, TOP = 1.0D+00)
      DOUBLE PRECISION ZERO, ONE, TWO, PNT05
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           PNT05 = 0.05D+00)
      DOUBLE PRECISION DELTA, EPSI(2), XTEMP, YTEMP, ZTEMP
      EXTERNAL   GSELNT$, XYZ2XY$, POLYLINE$
      INTRINSIC  DBLE
      IF (ICOLOR.LT.0 .OR. ICOLOR.GT.71) RETURN
      COLOUR_INDEX = ICOLOR
      CALL GSELNT$(N1)
      DO I = 1, 2
         IF (TICKS(I) .AND. KMODE.NE.3) THEN
            EPSI(I) = PNT05
         ELSE
            EPSI(I) = ZERO
         ENDIF
      ENDDO
      IF (AXES .AND. TICKS(3)) THEN
C...0    The extra Z ticks
         CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), BOT)
         CALL XYZ2XY$(BOT - PNT05, XT(2), TOP, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
         CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), TOP)
         CALL XYZ2XY$(BOT - PNT05, XT(2), TOP, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
      ENDIF
      IF (AXES .AND. FULL) THEN
C...2
         CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), TOP)
         CALL XYZ2XY$(BOT, XT(2), BOT, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...3
         CALL XYZ2XY$(BOT, XT(1), BOT, YT(1), TOP)
         CALL XYZ2XY$(TOP, XT(2), BOT, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...4
         CALL XYZ2XY$(TOP, XT(1), BOT, YT(1), TOP)
         CALL XYZ2XY$(TOP, XT(2), BOT, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...9
         CALL XYZ2XY$(BOT, XT(1), BOT, YT(1), BOT)
         CALL XYZ2XY$(BOT, XT(2), BOT, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
      ENDIF
      IF (AXES) THEN
C...1
         CALL XYZ2XY$(BOT, XT(1), TOP, YT(1), BOT)
         CALL XYZ2XY$(BOT, XT(2), TOP, YT(2), TOP)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...5
         CALL XYZ2XY$(TOP, XT(1), BOT, YT(1), BOT)
         CALL XYZ2XY$(TOP, XT(2), TOP + EPSI(1), YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...6
         CALL XYZ2XY$(TOP + EPSI(2), XT(1), TOP, YT(1), BOT)
         CALL XYZ2XY$(BOT, XT(2), TOP, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...7
         CALL XYZ2XY$(BOT, XT(1), TOP + EPSI(1), YT(1), BOT)
         CALL XYZ2XY$(BOT, XT(2), BOT, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
C...8
         CALL XYZ2XY$(BOT, XT(1), BOT, YT(1), BOT)
         CALL XYZ2XY$(TOP + EPSI(2), XT(2), BOT, YT(2), BOT)
         CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
      ENDIF
C
C Now the divisions for labels
C
      IF (AXES) THEN
         IF (KMODE.EQ.3) THEN
            CALL GSELNT$(N3)
         ELSE
            CALL GSELNT$(N1)
         ENDIF
         IF (NDIVS(1).GT.0) THEN
            IF (KMODE.EQ.4 .AND. .NOT.TICKS(1)) THEN
               DELTA = ONE/DBLE(NDIVS(1))
               XTEMP = ZERO - DELTA/TWO
               YTEMP = ONE + PNT05
               ZTEMP = ZERO
            ELSE
               DELTA = ONE/(DBLE(NDIVS(1)) - ONE)
               XTEMP = ZERO - DELTA
               YTEMP = ONE + PNT05
               ZTEMP = ZERO
            ENDIF
            DO I = 1, NDIVS(1)
               XTEMP = XTEMP + DELTA
               CALL XYZ2XY$(XTEMP, XT(1), ONE, YT(1), ZTEMP)
               CALL XYZ2XY$(XTEMP, XT(2), YTEMP, YT(2), ZTEMP)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDDO
         ENDIF
         IF (NDIVS(2).GT.0) THEN
            IF (KMODE.EQ.4 .AND. .NOT.TICKS(2)) THEN
               DELTA = ONE/DBLE(NDIVS(2))
               XTEMP = ONE + PNT05
               YTEMP = ZERO - DELTA/TWO
               ZTEMP = ZERO
            ELSE
               DELTA = ONE/DBLE((NDIVS(2)) - ONE)
               XTEMP = ONE + PNT05
               YTEMP = ZERO - DELTA
               ZTEMP = ZERO
            ENDIF
            DO I = 1, NDIVS(2)
               YTEMP = YTEMP + DELTA
               CALL XYZ2XY$(ONE, XT(1), YTEMP, YT(1), ZTEMP)
               CALL XYZ2XY$(XTEMP, XT(2), YTEMP, YT(2), ZTEMP)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDDO
         ENDIF
         IF (NDIVS(3).GT.0) THEN
            CALL GSELNT$(N1)
            DELTA = ONE/(NDIVS(3) - ONE)
            XTEMP = ZERO - PNT05
            YTEMP = ONE
            ZTEMP = ZERO - DELTA
            DO I = 1, NDIVS(3)
               ZTEMP = ZTEMP + DELTA
               CALL XYZ2XY$(ZERO, XT(1), YTEMP, YT(1), ZTEMP)
               CALL XYZ2XY$(XTEMP, XT(2), YTEMP, YT(2), ZTEMP)
               CALL POLYLINE$(N2, XT, YT, COLOUR_INDEX)
            ENDDO
         ENDIF
      ENDIF
      END
C                            
C