C
C
      SUBROUTINE SURBBB$(ICOLOR, ITHETA, KMODE, NOUT_PS,
     +                   Y_SCALE,
     +                   ARRAYX, ARRAYY, ARRAYZ, XTITLE, YTITLE,
     +                   ZTITLE,
     +                   ARROWS, HARD_COPY, HPGL, LABELS, PS, XTSHOW,
     +                   YTSHOW, ZTSHOW)
C
C ACTION : X, Y, Z titles for 3D histograms
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/9/95
C          12/05/2007 added INTENTS
C
      IMPLICIT   NONE 
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: ICOLOR, ITHETA, KMODE, NOUT_PS
      DOUBLE PRECISION,    INTENT (IN) :: Y_SCALE
      CHARACTER (LEN = *), INTENT (IN) :: ARRAYX, ARRAYY, ARRAYZ,
     +                                    XTITLE, YTITLE, ZTITLE
      LOGICAL,             INTENT (IN) :: ARROWS(*), HARD_COPY, HPGL, 
     +                                    LABELS(*), PS, XTSHOW, YTSHOW,
     +                                    ZTSHOW
C
C Locals
C
      INTEGER    ISEND, L, NGKS, N2, N4
      PARAMETER (ISEND = 1, L = 0, N2 = 2, N4 = 4)
      INTEGER    NTFONT, NFONT_PS
      DOUBLE PRECISION SIZE1, SLANT, XBEGIN, YBEGIN
      DOUBLE PRECISION X1, X2, Y1, Y2, ZSCALE
      DOUBLE PRECISION HEAD, XPT
      PARAMETER (HEAD = 0.015D+00, XPT = 1.50D+00)
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  FONT*12, TYPE1*2
      PARAMETER (FONT = '/Times-Roman')
C
C Externals
C
      EXTERNAL   GSELNT$, WGB_ARROW$, PLTSTR$, WGBFNT$
C
C Set the fonts
C
      CALL WGBFNT$(NTFONT, NFONT_PS,
     +             SLANT)
C
C Draw the X Title ..................................................
C
      IF (XTSHOW .AND. XTITLE .NE. ' ' .AND. .NOT.LABELS(1)) THEN
         IF (KMODE.EQ.3) THEN
            CALL GSELNT$(N4)
            NGKS = N4
         ELSE
            CALL GSELNT$(N2)
            NGKS = N2
         ENDIF
         YBEGIN = 0.15D+00
         IF (ITHETA.EQ.0 .OR. ITHETA.EQ.180) THEN
            XBEGIN = 0.65D+00
            TYPE1 = 'tl'
         ELSE
            XBEGIN = 0.355D+00
            TYPE1 = 'tr'
         ENDIF
         SIZE1 = XPT
         CALL PLTSTR$(ICOLOR, NTFONT, NFONT_PS, NGKS, NOUT_PS,
     +                ZERO, SIZE1, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                FONT, XTITLE, ARRAYX, TYPE1,
     +                HARD_COPY, HPGL, PS)
      ENDIF
C
C Draw the Y Title ..................................................
C
      IF (YTSHOW .AND. YTITLE .NE. ' ' .AND. .NOT.LABELS(2)) THEN
         IF (KMODE.EQ.3) THEN
            CALL GSELNT$(N4)
            NGKS = N4
         ELSE
            CALL GSELNT$(N2)
            NGKS = N2
         ENDIF
         YBEGIN = 0.15D+00
         IF (ITHETA.EQ.0 .OR. ITHETA.EQ.180) THEN
            XBEGIN = 0.355D+00
            TYPE1 = 'tr'
         ELSE
            XBEGIN = 0.65D+00
            TYPE1 = 'tl'
         ENDIF
         SIZE1 = XPT
         CALL PLTSTR$(ICOLOR, NTFONT, NFONT_PS, NGKS, NOUT_PS,
     +                ZERO, SIZE1, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                FONT, YTITLE, ARRAYY, TYPE1,
     +                HARD_COPY, HPGL, PS)
      ENDIF
C
C Draw the Z Title ..................................................
C
      IF (ZTSHOW .AND. ZTITLE .NE. ' ' .AND. .NOT. LABELS(3)) THEN
         CALL GSELNT$(N2)
         NGKS = N2
         XBEGIN = 0.79D+00
         YBEGIN = 0.5D+00
         TYPE1 = 'tl'
         SIZE1 = XPT
         CALL PLTSTR$(ICOLOR, NTFONT, NFONT_PS, NGKS, NOUT_PS,
     +                ZERO, SIZE1, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                FONT, ZTITLE, ARRAYZ, TYPE1,
     +                HARD_COPY, HPGL, PS)
      ENDIF
      IF (ARROWS(1) .OR. ARROWS(2) .OR. ARROWS(3)) THEN
C
C Draw the lower RIGHT arrow
C
         IF (KMODE.EQ.3) THEN
            CALL GSELNT$(N4)
         ELSE
            CALL GSELNT$(N2)
         ENDIF
         IF (ITHETA.EQ.0 .OR. ITHETA.EQ.270) THEN
            X2 = 0.64D+00
            X1 = X2 - 0.05D+00
            Y2 = 0.15D+00
            Y1 = Y2 - 0.04D+00
         ELSE
            X2 = 0.685D+00
            X1 = X2 + 0.05D+00
            Y2 = 0.185D+00
            Y1 = Y2 + 0.04D+00
         ENDIF
         IF (ITHETA.EQ.0   .AND. ARROWS(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ.90  .AND. ARROWS(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ.180 .AND. ARROWS(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ.270 .AND. ARROWS(2) .AND. .NOT.LABELS(2)) THEN
            CALL WGB_ARROW$(ISEND, ICOLOR, L, HEAD, X1, X2, Y1, Y2)
         ENDIF
C
C Draw the lower LEFT arrow
C
         IF (ITHETA.EQ.0 .OR. ITHETA.EQ.90) THEN
            X2 = 0.355D+00
            X1 = X2 + 0.05D+00
            Y2 = 0.16D+00
            Y1 = Y2 - 0.04D+00
         ELSE
            X2 = 0.315D+00
            X1 = X2 - 0.05D+00
            Y2 = 0.185D+00
            Y1 = Y2 + 0.04D+00
         ENDIF
         IF (ITHETA.EQ.0   .AND. ARROWS(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ.90  .AND. ARROWS(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ.180 .AND. ARROWS(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ.270 .AND. ARROWS(1) .AND. .NOT.LABELS(1)) THEN
            CALL WGB_ARROW$(ISEND, ICOLOR, L, HEAD, X1, X2, Y1, Y2)
         ENDIF
C
C Draw the Z arrow
C
         IF (ARROWS(3) .AND. .NOT.LABELS(3)) THEN
            CALL GSELNT$(N2)
            XBEGIN = 0.79D+00
            IF (KMODE.EQ.3) THEN
               YBEGIN = 0.54D+00
               ZSCALE = 0.6666666D+00
            ELSE
               YBEGIN = 0.5D+00
               ZSCALE = 1.0D+00
            ENDIF
            X2 = XBEGIN + 0.007D+00
            X1 = X2
            Y2 = YBEGIN + 0.04D+00
            Y1 = Y2 + 0.07D+00
            CALL WGB_ARROW$(ISEND, ICOLOR, L,
     +                      ZSCALE*HEAD, X1, X2, Y1, Y2)
         ENDIF
      ENDIF
      END
C 
C
