C
C SURCCC$
C EXPFLT$
C
      SUBROUTINE SURCCC$(ICOLOR, ITHETA, KMODE, NOUT_PS, NXTEXT, NYTEXT,
     +                   NZTEXT,
     +                   XMAX, XMIN, YMAX, YMIN,
     +                   Y_SCALE, ZMAX, ZMIN,
     +                   XTEXT, XTEXT1, YTEXT, YTEXT1, ZTEXT, ZTEXT1,
     +                   HARD_COPY, HPGL, LABELS, NUMBER, PS,
     +                   X2INT, Y2INT, Z2INT)
C
C ACTION : X, Y, Z values for 3D Histograms
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 30/9/95
C          23/07/2001 revised to allow multiple numbers 
C          12/05/2007 added INTENTS
C          15/12/2014 added calls to EXPFLT$ to reformat numerical labels and added EPSI and
C                     FACTOR so that extra points are set to zero if it seems to be required 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: ICOLOR, ITHETA, KMODE,
     +                                       NOUT_PS, NXTEXT, NYTEXT,
     +                                       NZTEXT
      DOUBLE PRECISION,    INTENT (IN)    :: XMAX, XMIN, YMAX, YMIN,
     +                                       Y_SCALE, ZMAX, ZMIN
      CHARACTER (LEN = *), INTENT (IN)    :: XTEXT(NXTEXT),
     +                                       XTEXT1(NXTEXT),
     +                                       YTEXT(NYTEXT),
     +                                       YTEXT1(NYTEXT),
     +                                       ZTEXT(NZTEXT),
     +                                       ZTEXT1(NZTEXT)
      LOGICAL,             INTENT (IN)    :: HARD_COPY, HPGL, LABELS(3),
     +                                       NUMBER(3), PS
      LOGICAL,             INTENT (INOUT) :: X2INT, Y2INT, Z2INT 
C
C Locals
C
      INTEGER    IFONT, JFONT, NFONT, NFONT_PS, NTFONT
      INTEGER    I, NGKS
      DOUBLE PRECISION SIZE1
      DOUBLE PRECISION FSCALE
      LOGICAL    SCALE_DOWN
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N8, N12, N90, N180, N270
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N8 = 8, N12 = 12, N90 = 90, N180 = 180,
     +           N270 = 270)
      DOUBLE PRECISION ZERO, ONE, PNT2, PNT4, PNT6
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PNT2 = 0.2D+00,
     +           PNT4 = 0.4D+00, PNT6 = 0.6D+00)
      DOUBLE PRECISION XPT
      PARAMETER (XPT = 1.5D+00)
      DOUBLE PRECISION R2BIG
      PARAMETER (R2BIG = 0.9999999D+05)
      DOUBLE PRECISION FACTOR
      PARAMETER (FACTOR = 1.0D-03)
      DOUBLE PRECISION DELTAX, DELTAY, DELTAZ, EPSI, SLANT, X(6), Y(6)
      DOUBLE PRECISION XADDPS, XSTART, XSTOP, YSTART, YSTOP
      DOUBLE PRECISION XTEMP, YTEMP, ZTEMP
      CHARACTER  BLANK*1, TYPE1*2, VALUE(6)*45, SYMBOL(6)*45
      CHARACTER  EXTRAX(20)*45, EXTRAY(20)*45, EXTRAZ(20)*45
      PARAMETER (BLANK = ' ')
      CHARACTER  FONT*8
      PARAMETER (FONT = '/Courier')
C
C Externals
C
      EXTERNAL   PSNUMB$, GSELNT$, XYZTXT$, PLNUMB$, PLTSTR$, WGBFNT$
      EXTERNAL   EXPFLT$
      INTRINSIC  ABS, DBLE
      DATA       X / 0.515D+00, 0.790D+00, 0.790D+00, 0.790D+00,
     +               0.275D+00, 0.005D+00 /
      DATA       Y / 0.050D+00, 0.260D+00, 0.310D+00, 0.710D+00,
     +               0.050D+00, 0.265D+00 /
      IF (.NOT.NUMBER(1) .AND. .NOT.NUMBER(2) .AND.
     +    .NOT.NUMBER(3) .AND. .NOT.LABELS(1) .AND.
     +    .NOT.LABELS(2) .AND. .NOT.LABELS(3)) RETURN
C
C Define the fonts: 102 = Helvetica, 106 = TimesRoman, 107 = TimesItalic
C
      CALL WGBFNT$(NTFONT, NFONT_PS, SLANT)
      IF (NTFONT.EQ.102) THEN
         IFONT = 102
         JFONT = 102
      ELSEIF (NTFONT.EQ.106) THEN
         IFONT = 106
         JFONT = 106
      ELSE
         IFONT = 106
         JFONT = 107
      ENDIF
      NFONT = NFONT_PS
C
C Define the label sizes
C
      SCALE_DOWN = .FALSE.
      FSCALE = ONE
      IF (LABELS(1) .OR. LABELS(2) .OR. LABELS(3)) THEN
         IF (NXTEXT.GT.N12 .OR. NYTEXT.GT.N12 .OR. NZTEXT.GT.N12) THEN
            SCALE_DOWN = .TRUE.
            FSCALE = PNT4
         ELSEIF (NXTEXT.GT.N8 .OR. NYTEXT.GT.N8 .OR. NZTEXT.GT.N8) THEN
            SCALE_DOWN = .TRUE.
            FSCALE = PNT6
         ENDIF
      ENDIF
C
C Check
C
       IF (X2INT .AND. XMAX.GT.R2BIG) X2INT = .FALSE.
       IF (X2INT .AND. XMIN.LT. - R2BIG) X2INT = .FALSE.
       IF (Y2INT .AND. YMAX.GT.R2BIG) Y2INT = .FALSE.
       IF (Y2INT .AND. YMIN.LT. - R2BIG) Y2INT = .FALSE.
       IF (Z2INT .AND. ZMAX.GT.R2BIG) Z2INT = .FALSE.
       IF (Z2INT .AND. ZMIN.LT. - R2BIG) Z2INT = .FALSE.
C
C Define the label values. First the defaults.
C
      DO I = N1, N6
         VALUE(I) = BLANK
      ENDDO
C
C The Z-numbers do not depend on THETA
C
      IF (NUMBER(3) .AND. .NOT.LABELS(3)) THEN
         WRITE (VALUE(3),200) ZMIN
          WRITE (VALUE(4),200) ZMAX
         CALL EXPFLT$(VALUE(3),
     +                Z2INT)
         CALL EXPFLT$(VALUE(4),
     +                Z2INT)            
         IF (NZTEXT.GT.N2) THEN
            DELTAZ = (ZMAX - ZMIN)/DBLE(NZTEXT - N1)
            EPSI = FACTOR*DELTAZ
            ZTEMP = ZMIN
            DO I = N1, NZTEXT - N2
               ZTEMP = ZTEMP + DELTAZ
               IF (ABS(ZTEMP).LT.EPSI) ZTEMP = ZERO 
               WRITE (EXTRAZ(I),200) ZTEMP
               CALL EXPFLT$(EXTRAZ(I),
     +                      Z2INT)                  
            ENDDO
         ENDIF
      ELSEIF (LABELS(3)) THEN
         VALUE(3) = ZTEXT(1)
         SYMBOL(3) = ZTEXT1(1)
         VALUE(4) = ZTEXT(NZTEXT)
         SYMBOL(4) = ZTEXT1(NZTEXT)
      ENDIF
C
C Create EXTRAX and EXTRAY for intermediate numbers
C
      IF (NXTEXT.GT.2 .AND. NUMBER(1) .AND. .NOT.LABELS(1)) THEN
         DELTAX = (XMAX - XMIN)/DBLE(NXTEXT - N1)
         EPSI = FACTOR*DELTAX 
         XTEMP = XMIN
         DO I = N1, NXTEXT - N2
            XTEMP = XTEMP + DELTAX
            IF (ABS(XTEMP).LT.EPSI) XTEMP = ZERO
            WRITE (EXTRAX(I),200) XTEMP
            CALL EXPFLT$(EXTRAX(I),
     +                   X2INT)              
         ENDDO
      ENDIF
      IF (NYTEXT.GT.2 .AND. NUMBER(2) .AND. .NOT.LABELS(2)) THEN
         DELTAY = (YMAX - YMIN)/DBLE(NYTEXT - N1)
         EPSI = FACTOR*DELTAY
         YTEMP = YMIN
         DO I = N1, NYTEXT - N2
            YTEMP = YTEMP + DELTAY
            IF (ABS(YTEMP).LT.EPSI) YTEMP = ZERO
            WRITE (EXTRAY(I),200) YTEMP
            CALL EXPFLT$(EXTRAY(I),
     +                   Y2INT)               
         ENDDO
      ENDIF
C
C Write the X, Y numbers if valid and depending on ITHETA
C
      IF (ITHETA.EQ.N0) THEN
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(1),200) XMAX
            WRITE (VALUE(2),200) XMIN
            CALL EXPFLT$(VALUE(1),
     +                   X2INT)
            CALL EXPFLT$(VALUE(2),
     +                   X2INT)              
         ELSEIF (LABELS(1)) THEN
            VALUE(1) = XTEXT(NXTEXT)
            SYMBOL(1) = XTEXT1(NXTEXT)
            VALUE(2) = XTEXT(1)
            SYMBOL(2) = XTEXT1(1)
         ENDIF
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(5),200) YMAX
            WRITE (VALUE(6),200) YMIN
            CALL EXPFLT$(VALUE(5),
     +                   Y2INT)
            CALL EXPFLT$(VALUE(6),
     +                   Y2INT)              
         ELSEIF (LABELS(2)) THEN
            VALUE(5) = YTEXT(NYTEXT)
            SYMBOL(5) = YTEXT1(NYTEXT)
            VALUE(6) = YTEXT(1)
            SYMBOL(6) = YTEXT1(1)
         ENDIF
      ELSEIF (ITHETA.EQ.N90) THEN
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(1),200) YMIN
            WRITE (VALUE(2),200) YMAX
            CALL EXPFLT$(VALUE(1),
     +                   Y2INT)              
            CALL EXPFLT$(VALUE(2),
     +                   Y2INT)              
         ELSEIF (LABELS(2)) THEN
            VALUE(1) = YTEXT(1)
            SYMBOL(1) = YTEXT1(1)
            VALUE(2) = YTEXT(NYTEXT)
            SYMBOL(2) = YTEXT1(NYTEXT)
         ENDIF
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(5),200) XMAX
            WRITE (VALUE(6),200) XMIN
            CALL EXPFLT$(VALUE(5),
     +                   X2INT)              
            CALL EXPFLT$(VALUE(6),
     +                   X2INT)              
         ELSEIF (LABELS(1)) THEN
            VALUE(5) = XTEXT(NXTEXT)
            SYMBOL(5) = XTEXT1(NXTEXT)
            VALUE(6) = XTEXT(1)
            SYMBOL(6) = XTEXT1(1)
         ENDIF
      ELSEIF (ITHETA.EQ.N180) THEN
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(1),200) XMIN
            WRITE (VALUE(2),200) XMAX
            CALL EXPFLT$(VALUE(1),
     +                   X2INT)              
            CALL EXPFLT$(VALUE(2),
     +                   X2INT)              
         ELSEIF (LABELS(1)) THEN
            VALUE(1) = XTEXT(1)
            SYMBOL(1) = XTEXT1(1)
            VALUE(2) = XTEXT(NXTEXT)
            SYMBOL(2) = XTEXT1(NXTEXT)
         ENDIF
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(5),200) YMIN
            WRITE (VALUE(6),200) YMAX
            CALL EXPFLT$(VALUE(5),
     +                   Y2INT)              
            CALL EXPFLT$(VALUE(6),
     +                   Y2INT)              
         ELSEIF (LABELS(2)) THEN
            VALUE(5) = YTEXT(1)
            SYMBOL(5) = YTEXT1(1)
            VALUE(6) = YTEXT(NYTEXT)
            SYMBOL(6) = YTEXT1(NYTEXT)
         ENDIF
      ELSEIF (ITHETA.EQ.N270) THEN
         IF (NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            WRITE (VALUE(1),200) YMAX
            WRITE (VALUE(2),200) YMIN
            CALL EXPFLT$(VALUE(1),
     +                   Y2INT)               
            CALL EXPFLT$(VALUE(2),
     +                   Y2INT)               
         ELSEIF (LABELS(2)) THEN
            VALUE(1) = YTEXT(NYTEXT)
            SYMBOL(1) = YTEXT1(NYTEXT)
            VALUE(2) = YTEXT(1)
            SYMBOL(2) = YTEXT1(1)
         ENDIF
         IF (NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            WRITE (VALUE(5),200) XMIN
            WRITE (VALUE(6),200) XMAX
            CALL EXPFLT$(VALUE(5),
     +                   X2INT)              
            CALL EXPFLT$(VALUE(6),
     +                   X2INT)              
         ELSEIF (LABELS(1)) THEN
            VALUE(5) = XTEXT(1)
            SYMBOL(5) = XTEXT1(1)
            VALUE(6) = XTEXT(NXTEXT)
            SYMBOL(6) = XTEXT1(NXTEXT)
         ENDIF
      ENDIF

C
C Draw the LABELS
C
      IF (KMODE.EQ.N3) THEN
         CALL GSELNT$(N4)
         NGKS = N4
      ELSE
         CALL GSELNT$(N2)
         NGKS = N2
      ENDIF
      IF (PS.AND.SCALE_DOWN) WRITE (NOUT_PS,300) FSCALE, FSCALE
C
C The lower right axes
C
      SIZE1 = FSCALE*XPT
      TYPE1 = 'tl'
      DO I = N1, N2
         IF (ITHETA.EQ.  N0 .AND. NUMBER(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ. N90 .AND. NUMBER(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ.N180 .AND. NUMBER(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ.N270 .AND. NUMBER(2) .AND. .NOT.LABELS(2)) THEN
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR, X(I), Y(I), VALUE(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, IFONT, NGKS, SIZE1,
     +                      X(I), Y(I), Y_SCALE, TYPE1, VALUE(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ELSEIF (KMODE.NE.4) THEN
            CALL PLTSTR$(ICOLOR, JFONT, NFONT, NGKS, NOUT_PS,
     +                   ZERO, SIZE1, ZERO, X(I), Y(I), Y_SCALE,
     +                   FONT, VALUE(I), SYMBOL(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDIF
      ENDDO
C
C The lower left axes
C
      SIZE1 = FSCALE*XPT
      TYPE1 = 'tr'
      DO I = N5, N6
         IF (ITHETA.EQ.  N0 .AND. NUMBER(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ. N90 .AND. NUMBER(1) .AND. .NOT.LABELS(1) .OR.
     +       ITHETA.EQ.N180 .AND. NUMBER(2) .AND. .NOT.LABELS(2) .OR.
     +       ITHETA.EQ.N270 .AND. NUMBER(1) .AND. .NOT.LABELS(1)) THEN
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR,
     +                      X(I)+PNT2, Y(I),
     +                      VALUE(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, IFONT, NGKS,
     +                      SIZE1, X(I) + PNT2, Y(I), Y_SCALE,
     +                      TYPE1, VALUE(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ELSEIF (KMODE.NE.N4) THEN
            CALL PLTSTR$(ICOLOR, JFONT, NFONT, NGKS, NOUT_PS,
     +                   ZERO, SIZE1, ZERO, X(I) + PNT2, Y(I), Y_SCALE,
     +                   FONT, VALUE(I), SYMBOL(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDIF
      ENDDO

C
C The extra text labels
C
      IF (NXTEXT.GT.N1) THEN
         XADDPS = ZERO
         TYPE1 = 'tl'
         IF (ITHETA.EQ.N0) THEN
            XSTART = X(2)
            XSTOP = X(1)
            YSTART = Y(2)
            YSTOP = Y(1)
         ELSEIF (ITHETA.EQ.N90) THEN
            XADDPS = PNT2
            XSTART = X(6)
            XSTOP = X(5)
            YSTART = Y(6)
            YSTOP = Y(5)
            TYPE1 = 'tr'
         ELSEIF (ITHETA.EQ.N180) THEN
            XSTART = X(1)
            XSTOP = X(2)
            YSTART = Y(1)
            YSTOP = Y(2)
         ELSE
            XADDPS = PNT2
            XSTART = X(5)
            XSTOP = X(6)
            YSTART = Y(5)
            YSTOP = Y(6)
            TYPE1 = 'tr'
         ENDIF
      ENDIF
      SIZE1 = FSCALE*XPT
      IF (NXTEXT.GT.N2 .AND. NUMBER(1) .AND. .NOT.LABELS(1)) THEN
         DELTAX = (XSTOP - XSTART)/DBLE(NXTEXT - N1)
         DELTAY = (YSTOP - YSTART)/DBLE(NXTEXT - N1)
         XTEMP = XSTART
         YTEMP = YSTART
         IF (ITHETA.EQ.N90 .OR. ITHETA.EQ.N270) XTEMP = XTEMP + PNT2
         DO I = N1, NXTEXT - N2
            XTEMP = XTEMP + DELTAX
            YTEMP = YTEMP + DELTAY
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR,
     +                      XTEMP, YTEMP,
     +                      EXTRAX(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, IFONT, NGKS,
     +                      SIZE1, XTEMP, YTEMP, Y_SCALE,
     +                      TYPE1, EXTRAX(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ENDDO
      ELSEIF (NXTEXT.GT.N1 .AND. LABELS(1)) THEN
         CALL XYZTXT$(ICOLOR, JFONT, KMODE, NGKS, NXTEXT, NOUT_PS,
     +                SIZE1, XADDPS, XSTART, XSTOP, Y_SCALE,
     +                YSTART, YSTOP,
     +                XTEXT1, XTEXT, TYPE1,
     +                HARD_COPY, HPGL, PS)
      ENDIF
      IF (NYTEXT.GT.N1) THEN
         XADDPS = ZERO
         TYPE1 = 'tl'
         IF (ITHETA.EQ.N0) THEN
            XADDPS = PNT2
            XSTART = X(6)
            XSTOP = X(5)
            YSTART = Y(6)
            YSTOP = Y(5)
            TYPE1 = 'tr'
         ELSEIF (ITHETA.EQ.N90) THEN
            XSTART = X(1)
            XSTOP = X(2)
            YSTART = Y(1)
            YSTOP = Y(2)
         ELSEIF (ITHETA.EQ.N180) THEN
            XADDPS = PNT2
            XSTART = X(5)
            XSTOP = X(6)
            YSTART = Y(5)
            YSTOP = Y(6)
            TYPE1 = 'tr'
         ELSE
            XSTART = X(2)
            XSTOP = X(1)
            YSTART = Y(2)
            YSTOP = Y(1)
         ENDIF
      ENDIF
      SIZE1 = FSCALE*XPT
      IF (NYTEXT.GT.N2 .AND. NUMBER(2) .AND. .NOT.LABELS(2)) THEN
         DELTAX = (XSTOP - XSTART)/DBLE(NYTEXT - N1)
         DELTAY = (YSTOP - YSTART)/DBLE(NYTEXT - N1)
         XTEMP = XSTART
         YTEMP = YSTART
         IF (ITHETA.EQ.N0 .OR. ITHETA.EQ.N180) XTEMP = XTEMP + PNT2
         DO I = N1, NYTEXT - N2
            XTEMP = XTEMP + DELTAX
            YTEMP = YTEMP + DELTAY
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR, 
     +                      XTEMP, YTEMP,
     +                      EXTRAY(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, IFONT, NGKS, SIZE1,
     +                      XTEMP, YTEMP, Y_SCALE, 
     +                      TYPE1, EXTRAY(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ENDDO
      ELSEIF (NYTEXT.GT.N1 .AND. LABELS(2)) THEN
         CALL XYZTXT$(ICOLOR, JFONT, KMODE, NGKS, NYTEXT, NOUT_PS,
     +                SIZE1, XADDPS, XSTART, XSTOP, Y_SCALE,
     +                YSTART, YSTOP,
     +                YTEXT1, YTEXT, TYPE1,
     +                HARD_COPY, HPGL, PS)
      ENDIF
C
C The Z axes
C
      CALL GSELNT$(N2)
      NGKS = N2
      SIZE1 = FSCALE*XPT
      TYPE1 = 'tl'
      DO I = N3, N4
         IF (NUMBER(3) .AND. .NOT.LABELS(3)) THEN
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR,
     +                      X(I), Y(I),
     +                      VALUE(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, IFONT, NGKS,
     +                      SIZE1, X(I), Y(I), Y_SCALE,
     +                      TYPE1, VALUE(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ELSEIF (LABELS(3)) THEN
            CALL PLTSTR$(ICOLOR, JFONT, NFONT, NGKS, NOUT_PS,
     +                   ZERO, SIZE1, ZERO, X(I), Y(I), Y_SCALE,
     +                   FONT, VALUE(I), SYMBOL(I), TYPE1,
     +                   HARD_COPY, HPGL, PS)
         ENDIF
      ENDDO
      IF (NZTEXT.GT.N2 .AND. NUMBER(3) .AND. .NOT.LABELS(3)) THEN
         DELTAY = (Y(4) - Y(3))/DBLE(NZTEXT - N1)
         XTEMP = X(3)
         YTEMP = Y(3)
         TYPE1 = 'tl'
         DO I = N1, NZTEXT - N2
            YTEMP = YTEMP + DELTAY
            IF (PS) THEN
               CALL PSNUMB$(ICOLOR,
     +                      XTEMP, YTEMP,
     +                      EXTRAZ(I), TYPE1)
            ELSE
               CALL PLNUMB$(ICOLOR, IFONT, NGKS,
     +                      SIZE1, XTEMP, YTEMP, Y_SCALE,
     +                      TYPE1, EXTRAZ(I),
     +                      HARD_COPY, HPGL)
            ENDIF
         ENDDO
      ELSEIF (NZTEXT.GT.N1 .AND. LABELS(3)) THEN
         XADDPS = ZERO
         XSTART = X(3)
         XSTOP = XSTART
         YSTART = Y(3)
         YSTOP = Y(4)
         TYPE1 = 'tl'
         CALL XYZTXT$(ICOLOR, JFONT, N2, NGKS, NZTEXT, NOUT_PS,
     +                SIZE1, XADDPS, XSTART, XSTOP, Y_SCALE,
     +                YSTART, YSTOP, 
     +                ZTEXT1, ZTEXT, TYPE1,
     +                HARD_COPY, HPGL, PS)
      ENDIF
      IF (PS.AND.SCALE_DOWN) WRITE (NOUT_PS,300) ONE/FSCALE, ONE/FSCALE 
C
C These format statements must NOT be edited
C      
C  100 FORMAT (I11)
  200 FORMAT (1P,E11.4)
  300 FORMAT ('% scale the font sizes',
     +       /'/tl-size tl-size ',F4.2,' mul def'
     +       /'/tr-size tr-size ',F4.2,' mul def')
      END
C
C----------------------------------------------------------------------------------
C
      subroutine expflt$(value,
     +                   xtoint)
c
c action: transform 'value' from exponential notation to integer or floating point if in range
c author: w.g.bardsley, university of manchester, 15/10/2014
c
c  value: should be entered as x written to value with, e.g. 1p,e11.3 or 1p,e11.4
c xtoint: if .true. then attempt to return value in integer form where appropriate
c         otherwise write out value in floating point or exponential notation
c      
      implicit   none
c
c argument
c      
      character (len = *), intent (inout) :: value
      logical,             intent (in)    :: xtoint 
c
c local
c      
      integer    ios, j, k, l, l_lower, l_upper
      integer    maxlen, minlen
      parameter (maxlen = 20, minlen = 3)
      double precision x
      character (len = 20) word20, form20
      character (len = 11) word11
      character (len = 2 ) blank2, dot_0
      parameter (blank2 = '  ', dot_0 = '.0')
      character (len = 3 ) dot_0e
      parameter (dot_0e = '.0E')
      character (len = 1 ) blank, dot, e_lower, e_upper
      parameter (blank = ' ', dot = '.', e_lower = 'e', e_upper = 'E')
      external   form20
      intrinsic  index, len_trim
c
c check that reformatting can be done
c      
      l_lower = index(value, e_lower)
      l_upper = index(value, e_upper)
      if (l_lower.lt.1 .and. l_upper.lt.1) return 
      l = len_trim(value)
      if (l.gt.maxlen .or. l.lt.minlen) return
      read (value,*,iostat=ios) x
      if (ios.ne.0) return
c
c write the value of x to the word11 variable
c        
      write (word11,'(1p,e11.4)',iostat=ios) x
      if (ios.ne.0) return
c
c if successful use form20 to reformat value
c        
      word20 = blank  
      word20 = form20(x)
      value = blank
      value = word20(1:l)  
      l_lower = index(value, e_lower)
      l_upper = index(value, e_upper)
      
      if (l_lower.gt.0 .or. l_upper.gt.0) then
c
c it still requires exponential format so delete the .0 if XTOINT = .TRUE.
c        
         if (xtoint) then
            j = len_trim(value)
            k = index(value,dot_0e)
            if (k.eq.j - 5) then
               value(k:k + 3) = value(k + 2:k + 5)
               value (j - 1:j) = blank2  
            endif
         endif
      else 
c
c add a trailing .0 if required when it is an integer and XTOINT = .FALSE.
c         
         if (index(value,dot).gt.0) return  
         if (.not.xtoint) then  
            k = len_trim(value) 
            if (l - k.ge.2) then
               value(k + 1:k + 2) = dot_0
            endif
         endif    
      endif  
      end  
c
c          




      