C
C
      SUBROUTINE SURD2S$(ISEND, NMAX, NX, NY,
     +                   VECTOR, XMAX, XMIN, YMAX, YMIN, Z,
     +                   UNUSED)
C
C ACTION : Double to single for call to H3DMAK$
C          This version does not change the precision but
C          it is maintained for compatibility with the DBOS
C          version and for future development
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/9/95
c          22/06/2007 added INTENTS
C          18/10/2011 defined NX1 = NX, NY1 = NY for call to SURFAC$
C          15/10/2013 introduced allocatable arrays and changed some INTENTS    
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, NMAX, NX, NY 
      DOUBLE PRECISION, INTENT (IN)    :: XMAX, XMIN, YMAX, YMIN
      DOUBLE PRECISION, INTENT (INOUT) :: VECTOR(NMAX**2 + 6),
     +                                    Z(NMAX,NMAX)
      LOGICAL,          INTENT (INOUT) :: UNUSED(NMAX,NMAX)
C
C Allocatable
C      
      DOUBLE PRECISION, ALLOCATABLE :: X1(:), XT1(:), XTEMP1(:),
     +                                 Y1(:), YT1(:), YTEMP1(:),
     +                                 ZTEMP1(:,:)
C
C Locals
C     
      INTEGER    IERR, MODEL, NMAX1, NX1, NY1
      DOUBLE PRECISION XMAX1, XMIN1, YMAX1, YMIN1 
      EXTERNAL   SURFAC$
C
C Allocate
C
      IERR = 0
      IF (ALLOCATED(X1))       DEALLOCATE(X1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XT1))      DEALLOCATE(XT1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(XTEMP1))   DEALLOCATE(XTEMP1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(Y1))       DEALLOCATE(Y1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YT1))      DEALLOCATE(YT1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(YTEMP1))   DEALLOCATE(YTEMP1, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(ZTEMP1))   DEALLOCATE(ZTEMP1, STAT = IERR)
      IF (IERR.NE.0) RETURN   
           
      NMAX1 = NMAX
      
      ALLOCATE(X1(NMAX1), STAT = IERR)
      IF (IERR.NE.0) RETURN     
      ALLOCATE(XT1(NMAX1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(XTEMP1(NMAX1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(Y1(NMAX1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(YT1(NMAX1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(YTEMP1(NMAX1), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(ZTEMP1(NMAX1,NMAX1), STAT = IERR)
      IF (IERR.NE.0) RETURN
C
C Copy INTENT (IN) arguments that can be changed by SURFAC$ when ISEND < 3
C        
      XMAX1 = XMAX
      XMIN1 = XMIN
      YMAX1 = YMAX
      YMIN1 = YMIN
      NX1 = NX
      NY1 = NY
C
C Pass calculations on to SURFAC$
C      
      CALL SURFAC$(ISEND, MODEL, NMAX1, NX1, NY1, VECTOR,
     +             X1, XMAX1, XMIN1, XT1, XTEMP1,
     +             Y1, YMAX1, YMIN1, YT1, YTEMP1,
     +             Z, ZTEMP1, UNUSED)
C
C Deallocate
C     
      DEALLOCATE (X1, STAT = IERR)
      DEALLOCATE (XT1, STAT = IERR)
      DEALLOCATE (XTEMP1, STAT = IERR)
      DEALLOCATE (Y1, STAT = IERR)
      DEALLOCATE (YT1, STAT = IERR)
      DEALLOCATE (YTEMP1, STAT = IERR)
      DEALLOCATE (ZTEMP1, STAT = IERR)
      END
C
C