C
C SURDDD$: MENUS for surface plotting
C
C
      SUBROUTINE SURDDD$(ICOLOR, ISEND, ITHETA, KMODE, NBIG, NCON,
     +                   NCON1, NMAX,
     +                   NTYPE, NX, NXSAV, NXTEXT, NY, NYSAV, NYTEXT,
     +                   NZMAX, NZSAV, NZTEXT,
     +                   TEMP, VECPRO, VECTOR,
     +                   XMAX, XMIN, YMAX, YMIN, Z, ZMAX,
     +                   ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1,
     +                   YTITLE, ZTEXT, ZTEXT1, ZTITLE,
     +                   AXES, ARROWS, CONTAB, CONVAL, FRAME, FULL,
     +                   LABELS, NUMBER, XTSHOW, X2INT, YTSHOW, Y2INT,
     +                   ZTSHOW, Z2INT)
C
C
C ACTION : Make decisions about 3D plots
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 4/9/95
C          30/10/1998 removed ZMIN from argument list
C          20/03/2001 added NBIG
C          21/11/2001 added NCON1, NZMAX, TEMP, VECPRO
C          30/12/2013 replaced LBOX02 by LSTBOX, PATCH1 by PATCH2 and minor editing
C          18/01/2014 introduced calls to SAVQUE$
C          09/03/2014 added call to CLOSE_GR_WINDOWS 
C
      IMPLICIT   NONE 
C
C Arguments
C             
      INTEGER,             INTENT (IN)    :: NBIG, NMAX, NZMAX 
      INTEGER,             INTENT (INOUT) :: NX, NY 
      INTEGER,             INTENT (INOUT) :: ICOLOR(8), ISEND, ITHETA,
     +                                       KMODE, NCON, NCON1, NTYPE,
     +                                       NXSAV, NXTEXT, NYSAV,
     +                                       NYTEXT, NZSAV, NZTEXT 
      DOUBLE PRECISION,    INTENT (INOUT) :: TEMP(NZMAX), VECPRO(NZMAX)
      DOUBLE PRECISION,    INTENT (IN)    :: VECTOR(NMAX**2 + 6),
     +                                       Z(NMAX,NMAX) 
      DOUBLE PRECISION,    INTENT (IN)    :: XMAX, XMIN, YMAX, YMIN,
     +                                       ZMAX 
      CHARACTER (LEN = *), INTENT (INOUT) :: ARRAYT, ARRAYX, ARRAYY,
     +                                       ARRAYZ, PTITLE,
     +                                       XTEXT(NBIG), XTEXT1(NBIG),
     +                                       XTITLE, YTEXT(NBIG),
     +                                       YTEXT1(NBIG), YTITLE,
     +                                       ZTEXT(NBIG), ZTEXT1(NBIG),
     +                                       ZTITLE   
      LOGICAL,             INTENT (INOUT) :: AXES, ARROWS(3), CONTAB,
     +                                       CONVAL, FRAME, FULL,
     +                                       LABELS(3), NUMBER(3),
     +                                       XTSHOW, X2INT, YTSHOW,
     +                                       Y2INT, ZTSHOW, Z2INT
C
C Locals
C
      integer    isend_1, itolf_1, meth_1
      parameter (isend_1 = 2)
      INTEGER    I, NIN, NPTS
      INTEGER    N1, N2, N5
      PARAMETER (N1 = 1, N2 = 2, N5 = 5)
      INTEGER    NUMDEC, NUMOPT, NUMSTA, NUMTXT
      INTEGER    NUMBLD(30)
      INTEGER    IBOT, IMID, ITOP
      DOUBLE PRECISION R2BIG, ZERO, ONE
      PARAMETER (R2BIG = 0.9999999D+05, ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  OPTS(30)*100, SYMBOL(9)*6, TYPE1*12
      CHARACTER  FNAME*1024, LINE*100, TITLE*80
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER (LEN = 40) CIPHER(4)
      LOGICAL    QUERY_EXIT
      LOGICAL    ABORT, AGAIN, FIXNPT, LABEL, STORE
      PARAMETER (FIXNPT = .FALSE., LABEL = .FALSE., STORE = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, SHOWIT, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           SHOWIT = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   VEC1IN, GETNOU, EDITOR, PATCH2, LSTBOX
      EXTERNAL   NEWSTR$, VGACOL$, SUR000$, PUTADV$, XYZLEG$, GETJM1$,
     +           PUTFAT$, SAVELC$, J06CFG, SAVQUE$
      EXTERNAL   CLOSE_GR_WINDOWS
      DATA       NUMBLD / 30*0 /
      DATA       CIPHER / 'the 3D surface z = f(x,y)',
     +                    'the 2D contour diagram',
     +                    'the surface and contours', 
     +                    '3D skyscrapers or cylinders' /
   10 CONTINUE
      IF (KMODE.EQ.2) THEN
         SYMBOL(1) = '[NA]'
         SYMBOL(2) = '[NA]'
      ELSE
         SYMBOL(1) = BLANK
         SYMBOL(2) = BLANK
      ENDIF
      IF (ISEND.EQ.2) THEN
         SYMBOL(3) = '[NA]'
      ELSE
         SYMBOL(3) = BLANK
      ENDIF
      IF (FRAME) THEN
         SYMBOL(4) = '[Yes]'
      ELSE
         SYMBOL(4) = '[No]'
      ENDIF
      WRITE (OPTS,100) CIPHER(KMODE), (SYMBOL(I), I = 1, 4),
     +                 CIPHER(KMODE)
      NUMOPT = 10
      NUMDEC = NTYPE
      IF (NUMDEC.LT.1) THEN
         NUMDEC = 1
      ELSEIF (NUMDEC.GT.NUMOPT) THEN
         NUMDEC = NUMOPT
      ENDIF 
      NUMSTA = 3 
      NUMTXT = NUMSTA + NUMOPT - 1
      NUMBLD(1) = 4     
      CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +             OPTS)
      NUMBLD(1) = 0
      IF (NUMDEC.EQ.8 .OR. NUMDEC.EQ.9) THEN
         QUERY_EXIT = .TRUE.
         CALL SAVQUE$ (QUERY_EXIT, STORE)
      ENDIF    
      IF (NUMDEC.LT.4) THEN
         IF (KMODE.EQ.2 .AND. NUMDEC.EQ.2 .OR.
     +       KMODE.EQ.2 .AND. NUMDEC.EQ.3) THEN
             CALL PUTADV$('Not available ... Option 1 substituted')
             NUMDEC = 1
         ENDIF
         NTYPE = NUMDEC
      ELSEIF (NUMDEC.EQ.4) THEN
   20    CONTINUE
         NUMOPT = 5
         NUMDEC = NUMOPT
         IF (KMODE.EQ.2) THEN
            SYMBOL(1) = '[NA]'
         ELSE
            SYMBOL(1) = BLANK
         ENDIF
         WRITE (OPTS,200) SYMBOL(1)
         NUMSTA = 3
         NUMTXT = NUMSTA + NUMOPT - 1
         NUMBLD(1) = 4
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                OPTS)
         NUMBLD(1) = 0 
         IF (NUMDEC.GE.1 .AND. NUMDEC.LE.4) THEN
            QUERY_EXIT = .TRUE.
            CALL SAVQUE$ (QUERY_EXIT, STORE)
         ENDIF   
         IF (NUMDEC.EQ.1) THEN
            I = 0
            CALL NEWSTR$(I,
     +                   PTITLE, ARRAYT)
            GOTO 20
         ELSEIF (NUMDEC.EQ.2) THEN
            CALL XYZLEG$(KMODE, NBIG, NXSAV, NXTEXT, ARRAYX, XTEXT,
     +                   XTEXT1, XTITLE, 'X',
     +                   ARROWS(1), CONTAB, CONVAL, LABELS(1),
     +                   NUMBER(1), X2INT, XTSHOW)
            IF (X2INT .AND. XMAX.GT.R2BIG) THEN
               CALL PUTADV$('X too large for integers')
               X2INT = .FALSE.
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.3) THEN
            CALL XYZLEG$(KMODE, NBIG, NYSAV, NYTEXT, ARRAYY, YTEXT,
     +                   YTEXT1, YTITLE, 'Y',
     +                   ARROWS(2), CONTAB, CONVAL, LABELS(2),
     +                   NUMBER(2), Y2INT, YTSHOW)
            IF (Y2INT .AND. YMAX.GT.R2BIG) THEN
               CALL PUTADV$('Y too large for integers')
               Y2INT = .FALSE.
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.4) THEN
            IF (KMODE.EQ.2) THEN
               CALL PUTFAT$('Not allowed with contour diagrams')
               GOTO 20
            ENDIF
            CALL XYZLEG$(KMODE, NBIG, NZSAV, NZTEXT, ARRAYZ, ZTEXT,
     +                   ZTEXT1, ZTITLE, 'Z',
     +                   ARROWS(3), CONTAB, CONVAL, LABELS(3),
     +                   NUMBER(3), Z2INT, ZTSHOW)
            IF (Z2INT .AND. ZMAX.GT.R2BIG) THEN
               CALL PUTADV$('Z too large for integers')
               Z2INT = .FALSE.
            ENDIF
            GOTO 20
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            GOTO 10
         ENDIF
      ELSEIF (NUMDEC.EQ.5) THEN
   40    CONTINUE
         IF (KMODE.EQ.2) THEN
            IF (AXES) THEN
               SYMBOL(1) = BLANK
               SYMBOL(2) = '[Yes]'
            ELSE
               SYMBOL(1) = '[Yes]'
               SYMBOL(2) = BLANK
            ENDIF
            WRITE (SYMBOL(3),'(A3,I3)') 'n =', NCON
         ELSEIF (AXES) THEN
            SYMBOL(1) = ' '
            IF (FULL) THEN
               SYMBOL(2) = BLANK
               SYMBOL(3) = '[Yes]'
            ELSE
               SYMBOL(2) = '[Yes]'
               SYMBOL(3) = BLANK
            ENDIF
         ELSE
            SYMBOL(1) = '[Yes]'
            SYMBOL(2) = BLANK
            SYMBOL(3) = BLANK
         ENDIF
         SYMBOL(4) = BLANK
         SYMBOL(5) = BLANK
         SYMBOL(6) = BLANK
         SYMBOL(7) = BLANK
         IF (ITHETA.EQ.0) THEN
            SYMBOL(4) = '[Yes]'
         ELSEIF (ITHETA.EQ.90) THEN
            SYMBOL(5) = '[Yes]'
         ELSEIF (ITHETA.EQ.180) THEN
            SYMBOL(6) = '[Yes]'
         ELSEIF (ITHETA.EQ.270) THEN
            SYMBOL(7) = '[Yes]'
         ENDIF
         IF (KMODE.NE.2) THEN
            WRITE (OPTS,300) (SYMBOL(I), I = 1, 7)
            NUMOPT = 8
         ELSE
            IF (NCON1.EQ.1) THEN
               TYPE1 = 'Linear'
            ELSEIF (NCON1.EQ.2) THEN
               TYPE1 = 'Increasing'
            ELSEIF (NCON1.EQ.3) THEN
               TYPE1 = 'Decreasing'
            ELSEIF (NCON1.EQ.4) THEN
               TYPE1 = 'User-defined'
            ENDIF
            WRITE (OPTS,400) (SYMBOL(I), I = 1, 3), TYPE1,
     +                       (SYMBOL(I), I = 4, 7)
            NUMOPT = 9
         ENDIF
         NUMSTA = 3
         NUMDEC = NUMOPT
         NUMTXT = NUMSTA + NUMOPT - 1
         NUMBLD(1) = 4
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                OPTS)
         NUMBLD(1) = 0
         IF (NUMDEC.LT.NUMOPT) THEN
            QUERY_EXIT = .TRUE.
            CALL SAVQUE$ (QUERY_EXIT, STORE)
         ENDIF   
         IF (NUMOPT.EQ.8 .AND. NUMDEC.GT.3) NUMDEC = NUMDEC + 1
         IF (NUMDEC.EQ.1) THEN
            AXES = .FALSE.
            FULL = .FALSE.
            GOTO 40
         ELSEIF (NUMDEC.EQ.2) THEN
            AXES = .TRUE.
            FULL = .FALSE.
            GOTO 40
         ELSEIF (NUMDEC.EQ.3) THEN
            IF (KMODE.EQ.2) THEN
               AGAIN = .TRUE.
               DO WHILE (AGAIN)
                  WRITE (OPTS,500) NCON
                  NUMSTA = 3
                  NUMOPT = 8
                  NUMDEC = NUMOPT
                  NUMTXT = NUMSTA + NUMOPT - 1 
                  NUMBLD(1) = 4
                  CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                         OPTS)
                  NUMBLD(1) = 0
                  IF (NUMDEC.LT.NUMOPT) THEN
                     QUERY_EXIT = .TRUE.
                     CALL SAVQUE$ (QUERY_EXIT, STORE)
                  ENDIF   
                  IF (NUMDEC.EQ.1) THEN
                     IBOT = 2
                     IMID = NCON
                     ITOP = 100
                     CALL GETJM1$(IBOT, IMID, ITOP,
     +                           'Number of contours required')
                     NCON = IMID
                  ELSEIF (NUMDEC.LE.4) then
                     AGAIN = .FALSE.
                     NCON1 = NUMDEC - 1
                  ELSEIF (NUMDEC.EQ.5) THEN
                     AGAIN = .FALSE.
                     NCON1 = 4
                     DO I = 1, NCON
                        IF (.NOT.AGAIN) THEN
                           IF (VECPRO(I).LT.ZERO .OR.
     +                         VECPRO(I).GT.ONE) THEN
                               WRITE (LINE,600) I
                               CALL PUTFAT$(LINE)
                               AGAIN = .TRUE.
                           ENDIF
                        ENDIF
                     ENDDO
                  ELSEIF (NUMDEC.EQ.6) THEN
                     I = 0
                     CALL GETNOU (NIN)
                     CLOSE (UNIT = NIN)
                     CALL VEC1IN (I, NIN, NZMAX, NPTS,
     +                            TEMP, 
     +                            FNAME, TITLE,
     +                            ABORT, FIXNPT, LABEL)
                     CLOSE (UNIT = NIN)
                     IF (.NOT.ABORT) THEN
                        DO I = 1, NPTS
                           VECPRO(I) = TEMP(I)
                        ENDDO
                        IF (NPTS.LT.NCON) CALL PUTADV$(
     +'No. of proportions initialised < current no. of contours')
                     ENDIF
                  ELSEIF (NUMDEC.EQ.7) THEN
                     LINE = 'Editing proportions: 0 =< x =< 1'
                     CALL EDITOR (N2, N1, N1, NZMAX, NCON,
     +                            VECPRO,
     +                            LINE,
     +                            CURVE, FIXCOL, FIXROW, SHOWIT, ORDER,
     +                            WEIGHT)
                  ELSEIF (NUMDEC.EQ.8) THEN
                     WRITE (OPTS,700)
                     NUMBLD(1) = 1
                     NUMTXT = 20
                     CALL PATCH2 (NUMBLD, NUMTXT,
     +                            OPTS)
                     NUMBLD(1) = 0
                  ENDIF
               ENDDO
            ELSE
               AXES = .TRUE.
               FULL = .TRUE.
            ENDIF
            GOTO 40
         ELSEIF (NUMDEC.EQ.4) THEN
            CALL J06CFG (isend_1, itolf_1, meth_1)
            GOTO 40   
         ELSEIF (NUMDEC.EQ.5) THEN
            ITHETA = 0
            GOTO 40
         ELSEIF (NUMDEC.EQ.6) THEN
            ITHETA = 90
            GOTO 40
         ELSEIF (NUMDEC.EQ.7) THEN
            ITHETA = 180
            GOTO 40
         ELSEIF (NUMDEC.EQ.8) THEN
            ITHETA = 270
            GOTO 40
         ELSE
            GOTO 10
         ENDIF
      ELSEIF (NUMDEC.EQ.6) THEN
   60    CONTINUE
         IF (KMODE.EQ.4) THEN
            SYMBOL(1) = BLANK
            SYMBOL(2) = BLANK
            SYMBOL(3) = BLANK
         ELSE
            SYMBOL(1) = '[NA]'
            SYMBOL(2) = '[NA]'
            SYMBOL(3) = '[NA]'
         ENDIF
         WRITE (OPTS,800) SYMBOL(1), SYMBOL(2), SYMBOL(3)
         NUMOPT = 9
         NUMDEC = NUMOPT
         NUMSTA = 3
         NUMTXT = NUMSTA + NUMOPT - 1
         NUMBLD(1) = 1
         CALL LSTBOX (NUMBLD, NUMDEC, NUMOPT, NUMSTA, NUMTXT,
     +                OPTS)
         NUMBLD(1) = 0
         IF (NUMDEC.LT.NUMOPT) THEN
            IF (KMODE.NE.4 .AND. NUMDEC.GT.5) THEN
               CALL PUTFAT$('Only available for bar charts')
               GOTO 60
            ENDIF
            CALL VGACOL$(ICOLOR(NUMDEC))
            IF (NUMDEC.EQ.1) CALL SAVELC$(ICOLOR(NUMDEC),
     +                                    STORE)
            QUERY_EXIT = .TRUE.
            CALL SAVQUE$ (QUERY_EXIT, STORE)
            GOTO 60
         ELSE
            GOTO 10
         ENDIF
      ELSEIF (NUMDEC.EQ.7) THEN
         IF (ISEND.EQ.2) THEN
            CALL PUTADV$('You are already using such a file')
         ELSE
            CALL SUR000$(N5, I, NMAX, NX, NY,
     +                   VECTOR, XMAX, XMIN, YMAX, YMIN, Z,
     +                   ABORT)
         ENDIF
         GOTO 10
      ELSEIF (NUMDEC.EQ.8) THEN
         FRAME = .NOT.FRAME
         GOTO 10
      ELSE
         NTYPE = NUMDEC
         IF (NUMDEC.EQ.10) CALL CLOSE_GR_WINDOWS
         RETURN
      ENDIF    
C
C Format statements
C      
  100 FORMAT (
     + 'Options for',1X,A
     +/
     +/'Display/Save as a wire frame model'
     +/'Display/Save as a facet model',2X,A
     +/'Display/Save as a patch model',2X,A
     +/'Edit title/labels/legends'
     +/'Edit axes/geometry/contours'
     +/'Edit the colour palette'
     +/'Save As ... SIMPLOT data file',2X,A
     +/'Plot a frame round graph',2X,A
     +/'Change plot type'
     +/'Quit ... Exit',1X,A)
  200 FORMAT (
     + 'Options for editing the title and legends'
     +/
     +/'Edit the title'
     +/'Edit X-legend features'
     +/'Edit Y-legend features'
     +/'Edit Z-legend features',2X,A
     +/'Apply')
  300 FORMAT (
     + 'Options for editing the 3D display'
     +/
     +/'Display 0 plot axes',2X,A
     +/'Display 5 plot axes',2X,A
     +/'Display 9 plot axes',2X,A
     +/'Rotate by 0 degrees',2X,A
     +/'Rotate by 90 degrees',2X,A
     +/'Rotate by 180 degrees',2X,A
     +/'Rotate by 270 degrees',2X,A
     +/'Apply')
  400 FORMAT (
     + 'Options for editing the 2D contour diagram'
     +/
     +/'Display 0 plot axes',2X,A
     +/'Display 2 plot axes',2X,A
     +/'Edit contour spacing [',A,']',2X,A
     +/'Change contour smoothing method'
     +/'Rotate by 0 degrees',2X,A
     +/'Rotate by 90 degrees',2X,A
     +/'Rotate by 180 degrees',2X,A
     +/'Rotate by 270 degrees',2X,A
     +/'Apply')
  500 FORMAT (
     + 'Options for editing the contour spacing'
     +/
     +/'Change number of contours [n =',I3,']'
     +/'Display: Z-spacing = linear (arithmetic)'
     +/'Display: Z-spacing = increasing (geometric)'
     +/'Display: Z-spacing = decreasing (geometric)'
     +/'Display: Z-spacing = user defined (arbitrary)'
     +/'User defined intervals: install'
     +/'User defined intervals: edit'
     +/'Help')
  600 FORMAT ('Impossible value encountered at proportion(',I3,')')
  700 FORMAT (
     + 'Controlling the spacing of contour values'
     +/
     +/'You can vary the number of contours and their spacing, and'
     +/'you can decide whether to display identifiers on the contours,'
     +/'or whether to leave them as continuous, unbroken curves. Now,'
     +/'with relatively smooth, gentle surfaces, the default linear'
     +/'(arithmetic) spacing will probably be satisfactory but, if the'
     +/'surface has pronounced ridges or spikes, you should investigate'
     +/'the effect of having contours at (geometrically) increasing or'
     +/'(geometrically) decreasing intervals. However, with extreme'
     +/'cases, you may wish to use your own contour spacing scheme.'
     +/'To define your own intervals, you need to supply a vector of'
     +/'proportions (in increasing order of size) that will then be'
     +/'used to calculate the proportionate spacing. What happens is'
     +/'that the choice of ranges for (x,y) generates a range z-min to'
     +/'z-max for z = f(x,y), which is mapped internally onto (0,1).'
     +/'Proportions supplied then partition the interval (0,1), and'
     +/'hence control the Z-spacing. Default values (out of range to'
     +/'force intervention) are supplied, so you can just edit these,'
     +/'or install a vector of pre-selected proportions from a file.')
  800 FORMAT (
     + 'Options for editing the plot colours'
     +/
     +/'Colour for Background'
     +/'Colour for Foreground'
     +/'Colour for graph Axes'
     +/'Colour for plot Title'
     +/'Colour for XY-legends'
     +/'Bar chart LHS facet',2X,A
     +/'Bar chart RHS facet',2X,A
     +/'Bar chart TOP facet',2X,A
     +/'Apply')
      END
C
C
