C
C
      SUBROUTINE SURFAC$(ISEND, MODEL, NMAX, NX, NY,
     +                   VECTOR, X, XMAX, XMIN, XT, XTEMP, Y, YMAX,
     +                   YMIN, YT, YTEMP, Z, ZTEMP,
     +                   UNUSED)
C
C ACTION : Draw a 3D surface
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 18/9/95
C          Action in SUR000 and H3D000 as follows:-
C          ISEND = 1: supply MODEL, calculate NX, NY, VECTOR, Z
C          ISEND = 2: read VECTOR  from  file, calculate NX, NY, Z
C          ISEND = 3: user supplies VECTOR, calculate NX, NY, Z
C          ISEND = 4: user supplies NX, NY, Z, calculate VECTOR
C          13/03/1996 Warn user if insufficient grid points
C          27/10/1996 Added arrays of symbols for PLTSTR$
C          20/11/1998 added call to DEFGKS$ to initialise parameters in
C                     defngks.ins
C          23/07/2001 changed definition of NDIVS
C          03/09/2001 added call to PSSPEC$
C          21/11/2001 added NCON1 to control contour type and PATCH1
C          24/02/2002 added NEBMAX, EB, EBTEMP, ERRBAR, NCOLEB, NROWEB,
C                     EBOK, ERRBAR, TICK1
C          26/06/2003 added CONTR5$
C          15/11/2004 prevented surfaces and contours if size =< kxymin
C          08/02/2005 added CHECKF  
C          12/05/2007 added INTENTS
C          31/10/2008 added call to PLTOBJ$ to switch off background objects
C          10/06/2010 added call to NKLCFG
C          27/04/2011 replaced call to YESNO2 by call to GRAPHQ 
C          05/01/2014 checked for NPRESS = 24 
C          15/01/2014 added call to SAVQUE$
C          10/03/2014 added call to CLOSE_GR_WINDOWS  
C          15/12/2014 changed default ZTOINT to .FALSE.
C
      IMPLICIT   NONE   
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: ISEND, MODEL, NMAX  
      INTEGER,          INTENT (INOUT) :: NX, NY 
      DOUBLE PRECISION, INTENT (INOUT) :: VECTOR(NMAX**2 + 6)
      DOUBLE PRECISION, INTENT (INOUT) :: X(NMAX), XMAX, XMIN, XT(NMAX), 
     +                                    XTEMP(NMAX), Y(NMAX), YMAX,
     +                                    YMIN, YT(NMAX), YTEMP(NMAX), 
     +                                    Z(NMAX,NMAX), ZTEMP(NMAX,NMAX) 
      LOGICAL,          INTENT (INOUT) :: UNUSED(NMAX,NMAX)
C
C Locals
C      
      INTEGER    NPRESS
      INTEGER    NDIVS(3)
      INTEGER    I, J, K, L
      INTEGER    KVAL_12, NKLCFG
      INTEGER    NTYPE, NXSAV, NXTEXT, NYSAV, NYTEXT, NZSAV, NZTEXT
      INTEGER    IU, IV, IW, NBIG, N0, N1, N2, N3, N4, N5, N6, N9, N24
C*****increased no. characters 26/11/2000
C*****PARAMETER (IU = 45, IV = 45, IW = 55,
      PARAMETER (IU = 55, IV = 55, IW = 65,
     +           NBIG = 16, N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4,
     +           N5 = 5, N6 = 6, N9 = 9, N24 = 24)
      INTEGER    ICOLOR(8), ITHETA, NCON, NCON1, NXTEMP, NYTEMP
      INTEGER    KXYMIN, NXYMIN, NZMAX
      PARAMETER (KXYMIN = 5, NXYMIN = 20, NZMAX = 100)
      INTEGER    NINEB, NEBMAX, NCOLEB, NROWEB
      PARAMETER (NEBMAX = 200)
      INTEGER    KMODE, NUMOPT, NUMSTA
      PARAMETER (NUMOPT = 12, NUMSTA = 7)
      INTEGER    NUMBLD(30), NUMTXT
      DOUBLE PRECISION A, B, ZDIFF, ZMAX, ZMIN
      DOUBLE PRECISION HTS(NZMAX), TEMP(NZMAX), VECPRO(NZMAX), X5(N5),
     +                 Y5(N5)
      DOUBLE PRECISION EB(NEBMAX,NEBMAX), EBTEMP(NEBMAX,NEBMAX),
     +                 EBVEC(NEBMAX**2 + 6), EXPAND, XBOT, XTOP
      DOUBLE PRECISION EPSI, R2BIG, ONE, ZERO
      PARAMETER (EPSI = 1.0D-100, R2BIG = 0.9999999D+05, ONE = 1.0D+00,
     +           ZERO = 0.0D+00)
      DOUBLE PRECISION XCLIP(2), YCLIP(2)
      CHARACTER  ARRAYT*(IW), ARRAYX*(IV), ARRAYY*(IV), ARRAYZ*(IV),
     +           PTITLE*(IW), XTITLE*(IV), YTITLE*(IV), ZTITLE*(IV),
     +           TITLEP*(IW), TITLEX*(IV), TITLEY*(IV), TITLEZ*(IV)
      CHARACTER  XTEXT(NBIG)*(IU), YTEXT(NBIG)*(IU), ZTEXT(NBIG)*(IU)
      CHARACTER  XTEXT1(NBIG)*(IU), YTEXT1(NBIG)*(IU), ZTEXT1(NBIG)*(IU)
      CHARACTER  OPTS(30)*100
      CHARACTER  FNAME*1024, TITLE*80
      CHARACTER (LEN = 60) WORD60
      CHARACTER (LEN = 12) FORM12, WORD12_X, WORD12_Y
      LOGICAL    EBOK, ERRBAR, FRAME
      LOGICAL    ABORT, ARROWS(3), AXES, FIRST, FULL, GSAVE, LABELS(3),
     +           NEWRUN, NUMBER(3), TICKS(3), TICK1(3), READY, WIRE,
     +           XTSHOW, X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT
      LOGICAL    CONTAB, CONVAL, CYLIND, QUERY_EXIT, STORE
      LOGICAL    BORDER, CONLAB
      PARAMETER (BORDER = .FALSE., CONLAB = .FALSE.)
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
C
C Parameters from DLL in common block in defngks.ins
C
      INTEGER    IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS
      DOUBLE PRECISION C_SCALE, PI, X_SCALE, Y_SCALE
      LOGICAL    DOTMAT, HARD_COPY, HPGL, META, PCL, PS
      LOGICAL    QUIT
      EXTERNAL   FORM12
      EXTERNAL   PUTADV$, PUTFAT$
      EXTERNAL   LSTBOX, GRAPHQ, PATCH1, MATTIN, GETNOU, GETDM1, NKLCFG
      EXTERNAL   GKSDEK$, GETDEF$, GSELNT$, AFRAME$,
     +           SURAAA$, SURBBB$, SURCCC$, SURDDD$,
     +           SUR000$, SUR001$, SUR002$, SUR003$,
     +           H3DPLT$, H3D001$, SUR005$, SUR006$,
     +           CON003$, CONBBB$, CONCCC$, H3DCYL$,
     +           CONTR2$, CONTR5$, PLTOBJ$, SAVQUE$,
     +           Z2TEMP$,
     +           FILL_POLYGON$, DEFGKS$, PSSPEC$
      EXTERNAL   CLOSE_GR_WINDOWS
      INTRINSIC  MIN, EXP, LOG, DBLE
      SAVE       ICOLOR, ITHETA, NCON, NCON1, NTYPE,
     +           ARRAYT, ARRAYX, ARRAYY, ARRAYZ, VECPRO,
     +           PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1, YTITLE,
     +           ZTEXT, ZTEXT1, ZTITLE,
     +           AXES, ARROWS, CONTAB, CONVAL, FULL, FRAME, LABELS,
     +           NEWRUN, NUMBER, X2INT, Y2INT, ZTSHOW, Z2INT, EXPAND
C
C Default settings
C
C Colours: 1=background, 2=foreground, 3=axes, 4=title, 5=legends,
C          6=lhs-facet, 7=rhs-facet, 8=top-facet
      DATA ICOLOR / 15,  0,  0,  0,  0, 9, 3, 14 /
      DATA ARRAYT / '00000000000000000000000000000' /
      DATA ARRAYX / '0' /
      DATA ARRAYY / '0' /
      DATA ARRAYZ / '0' /
      DATA PTITLE / 'SIMFIT 3D plot for z = f(x,y)' /
      DATA XTITLE / 'X' /
      DATA YTITLE / 'Y' /
      DATA ZTITLE / 'Z' /
      DATA AXES / .TRUE. /
      DATA FRAME / .FALSE. /
      DATA ARROWS / .FALSE., .FALSE., .TRUE. /
      DATA CONTAB / .TRUE. /
      DATA CONVAL / .TRUE. /
      DATA FULL / .FALSE. /
      DATA LABELS / .TRUE., .TRUE., .FALSE. /
      DATA NUMBER / .FALSE., .FALSE., .TRUE. /
      DATA ITHETA / 0 /
      DATA NCON, NCON1 / 10, 1 /
      DATA NTYPE / 1 /
      DATA NXSAV, NYSAV, NZSAV / NBIG, NBIG, NBIG /
      DATA NXTEXT, NYTEXT, NZTEXT / N2, N2, N2 /
      DATA XTSHOW, YTSHOW, ZTSHOW / .TRUE., .TRUE., .TRUE. /
      DATA X2INT, Y2INT, Z2INT / .FALSE., .FALSE., .FALSE. /
      DATA X5 / 0.0D+00, 1.0D+00, 1.0D+00, 0.0D+00, 0.0D+00 /
      DATA Y5 / 0.0D+00, 0.0D+00, 1.0D+00, 1.0D+00, 0.0D+00 /
      DATA EXPAND / 0.8D+00 /
      DATA NEWRUN / .TRUE. /
      DATA NUMBLD / 30*0 /
      DATA VECPRO / NZMAX*2.0D+00 /
C
C Switch off background objects
C  
      I = N0    
      CALL PLTOBJ$(N6, I)
C
C Initialise error bar data
C
      NCOLEB = N0
      NROWEB = N0
      EBOK = .FALSE.
      ERRBAR = .FALSE.
      DO I = N1, NEBMAX**2 + 6
         EBVEC(I) = ZERO
      ENDDO
      DO J = N1, NEBMAX
         DO I = N1, NEBMAX
            EB(I,J) = ZERO
            EBTEMP(I,J) = ZERO
         ENDDO
      ENDDO
C
C Initialise defngks.ins
C
      CALL DEFGKS$
C
C Set READY = .FALSE. to ensure new data
C
      READY = .FALSE.
      IF (NEWRUN) THEN
         DO I = 1, NBIG
            WRITE (XTEXT(I),100) 'x', I
            WRITE (YTEXT(I),100) 'y', I
            WRITE (ZTEXT(I),100) 'z', I
            XTEXT1(I) = '000000000'
            YTEXT1(I) = '000000000'
            ZTEXT1(I) = '000000000'
         ENDDO
      ENDIF
      XCLIP(1) = ZERO
      XCLIP(2) = ONE
      YCLIP(1) = ZERO
      YCLIP(2) = ONE
C
C Main branch point ...............................................
C
      IF (ISEND.EQ.1) THEN
         WORD60 = 'isend = 1 (User supplies a model)'
      ELSEIF (ISEND .EQ.2) THEN     
         WORD60 = 'isend = 2 (Read a vector from a file)'
      ELSEIF (ISEND.EQ.3) THEN     
         WORD60 = 'isend = 3 (User supplies a vector)'
      ELSE   
         WORD60 = 'isend = 4 (User supplies a matrix)'
      ENDIF   
      IF (ISEND.LT.N4) THEN
         NX = N0
         NY = N0
      ENDIF   
      NEWRUN = .TRUE.
   20 CONTINUE
      ERRBAR = .FALSE.
      WORD12_X = FORM12(NX)
      WORD12_Y = FORM12(NY)
      WRITE (OPTS,200) WORD60, WORD12_X, WORD12_Y, EXPAND
      KMODE = NUMOPT - 1
      NUMTXT = NUMSTA + NUMOPT - 1
      NUMBLD(1) = 4
      CALL LSTBOX (NUMBLD, KMODE, NUMOPT, NUMSTA, NUMTXT,
     +             OPTS)
      NUMBLD(1) = 0
      IF (KMODE.GE.8 .AND. KMODE.LE.10) THEN
         QUERY_EXIT = .TRUE.
         STORE = .TRUE.
         CALL SAVQUE$ (QUERY_EXIT, STORE)
      ENDIF   
      IF (KMODE.GE.4 .AND. KMODE.LE.7) THEN
         IF (KMODE.EQ.5 .OR. KMODE.EQ.7) THEN
            IF (EBOK) THEN
               ERRBAR = .TRUE.
            ELSE
               CALL PUTFAT$('First install error bars')
               ERRBAR = .FALSE.
               GOTO 20
            ENDIF
         ENDIF
         IF (KMODE.LE.5) THEN
            CYLIND = .FALSE.
         ELSE
            CYLIND = .TRUE.
         ENDIF
         KMODE = 4
      ELSEIF (KMODE.EQ.NUMOPT - 4) THEN
         TITLE = 'Not assigned'
         CALL GETNOU (NINEB)
         CLOSE (UNIT = NINEB)
         CALL MATTIN (N0, NEBMAX, NCOLEB, NINEB, NEBMAX, NROWEB,
     +                EB, EBVEC,
     +                FNAME, TITLE,
     +                ABORT, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NINEB)
         IF (ABORT) THEN
            NCOLEB = N0
            NROWEB = N0
            EBOK = .FALSE.
            ERRBAR = .FALSE.
         ELSE
            EBOK = .TRUE.
            DO J = N1, NCOLEB
               IF (EBOK) THEN
                  DO I = N1, NROWEB
                     IF (EBOK) THEN
                        IF (EB(I,J).LT.ZERO) THEN
                           EBOK = .FALSE.
                           CALL PUTFAT$(
     +'Negative error bar encountered ... Error bars discarded')
                        ENDIF
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            IF (EBOK) THEN
               DO I = 1, 6
                  EBVEC(I) = ZERO
               ENDDO
               K = 0
               L = 6
               DO J = 1, NY
                  K = K + 1
                  DO I = 1, NX
                     L = L + 1
                     EBVEC(L) = EB(I,J)
                     EBTEMP(I,J) = EB(I,J)
                  ENDDO
               ENDDO
            ELSE
               NCOLEB = N0
               NROWEB = N0
               ERRBAR = .FALSE.
            ENDIF
         ENDIF
         IF (.NOT.EBOK) THEN
            DO I = N1, NEBMAX**2 + 6
               EBVEC(I) = ZERO
            ENDDO
            DO J = N1, NEBMAX
               DO I = N1, NEBMAX
                  EB(I,J) = ZERO
                  EBTEMP(I,J) = ZERO
               ENDDO
            ENDDO           
         ENDIF  
         GOTO 20
      ELSEIF (KMODE.EQ.NUMOPT - 3) THEN
         XBOT = 0.1D+00
         XTOP = 1.0D+00
         CALL GETDM1 (XBOT, EXPAND, XTOP,
     +'The Bar or cylinder expansion factor required')
         GOTO 20
      ELSEIF (KMODE.EQ.NUMOPT - 2) THEN
         CALL CONTR5$(N1, ITHETA, ICOLOR(1), N3,
     +                XMAX, XMIN, YMAX, YMIN)
         GOTO 20
      ELSEIF (KMODE.EQ.NUMOPT - 1) THEN
         WRITE (OPTS,300)
         NUMBLD(1) = 1
         NUMTXT = 22
         CALL PATCH1 (N9, N4, N4, N0, NUMBLD, NUMTXT,
     +                OPTS,
     +                BORDER)
         NUMBLD(1) = 0
         GOTO 20
      ELSEIF (KMODE.EQ.NUMOPT) THEN
         KVAL_12 = NKLCFG(N24)
         IF (KVAL_12.EQ.N1) THEN
            QUIT = .FALSE.
            CALL GRAPHQ (QUIT)
         ELSE
            QUIT = .TRUE.
         ENDIF   
         IF (QUIT) THEN
            CALL CLOSE_GR_WINDOWS
            RETURN
         ELSE
            GOTO 20
         ENDIF
      ELSE
         ERRBAR = .FALSE.
      ENDIF
C
C Get new data set in VECTOR and also in Z as follows:-
C Make (ISEND=1), get (ISEND=2), supply V (ISEND=3), supply Z (ISEND=4)
C
      IF (.NOT.READY) THEN
         CALL SUR000$(ISEND, MODEL, NMAX, NX, NY, 
     +                VECTOR, XMAX, XMIN, YMAX, YMIN, Z,
     +                ABORT)
         IF (ABORT) THEN
            CALL CLOSE_GR_WINDOWS
            RETURN
         ENDIF   
         NXSAV = MIN(NBIG,NX)
         NYSAV = MIN(NBIG,NY)
         NZSAV = NBIG
      ELSE
C
C Use VECTOR to redefine Z for each new cycle *****************
C Do not delete the next code  ...  It is needed to ensure that
C Z is always correct even after changes such as when KMODE = 4
C
         K = 0
         L = 6
         DO J = 1, NY
            K = K + 1
            DO I = 1, NX
               L = L + 1
               Z(I,K) = VECTOR(L)
               IF (ERRBAR) EB(I,K) = EBVEC(L)
            ENDDO
         ENDDO
      ENDIF
C
C Check ZDIFF
C
      ZMIN = Z(1,1)
      ZMAX = Z(1,1)
      DO J = 1, NY
         DO I = 1, NX
            IF (Z(I,J).LT.ZMIN) ZMIN = Z(I,J)
            IF (Z(I,J).GT.ZMAX) ZMAX = Z(I,J)
         ENDDO
      ENDDO
      ZDIFF = ZMAX - ZMIN
      IF (ZDIFF.LE.EPSI) THEN
         CALL PUTFAT$('No Z-variation ... adjust data/parameters')
         CALL CLOSE_GR_WINDOWS
         RETURN
      ENDIF
C
C Data is now available so set READY = .TRUE.
C
      READY = .TRUE.
C
C Prevent surfaces and contours for NX or NY < KXYMIN
C
      IF (KMODE.LE.3) THEN
         IF (NX.LT.KXYMIN .OR. NY.LT.KXYMIN) THEN
            CALL PUTFAT$('Insufficient data for surface/contour plot')
            KMODE = 4
            ERRBAR = .FALSE.
            CYLIND = .FALSE.
         ENDIF
      ENDIF
C
C Normalise X, Y, Z depending on KMODE
C The normalisation in H3D001 alters the Z baseline so Z >= 0 for bars
C
      IF (KMODE.LE.3) THEN
         CALL SUR001$(NMAX, NX, NXTEMP, NY, NYTEMP,
     +                X, XTEMP, Y, YTEMP, Z, ZMAX, ZMIN, ZTEMP)
         IF (NEWRUN) THEN
            DO I = 1, 3
               ARROWS(I) = .TRUE.
               LABELS(I) = .FALSE.
               NUMBER(I) = .TRUE.
            ENDDO
            NXTEXT = N2
            NYTEXT = N2
            NZTEXT = N2
            XTSHOW = .TRUE.
            YTSHOW = .TRUE.
            ZTSHOW = .TRUE.
         ENDIF
      ELSE
         IF (ERRBAR) THEN
            IF (NX.GT.NROWEB) THEN
               CALL PUTFAT$('Insufficient rows of x-error bars')
               ERRBAR = .FALSE.
               EBOK = .FALSE.
            ENDIF
            IF (ERRBAR .AND. NY.GT.NCOLEB) THEN
               CALL PUTFAT$('Insufficient columns of y-error bars')
               ERRBAR = .FALSE.
               EBOK = .FALSE.
            ENDIF
         ENDIF
         CALL H3D001$(NEBMAX, NMAX, NX, NXTEMP, NY, NYTEMP,
     +                EB, EBTEMP,
     +                X, XTEMP, Y, YTEMP, Z, ZMAX, ZMIN, ZTEMP,
     +                ERRBAR)
         IF (NEWRUN) THEN
            DO I = 1, N2
               ARROWS(I) = .FALSE.
               LABELS(I) = .TRUE.
               NUMBER(I) = .FALSE.
            ENDDO
            ARROWS(3) = .TRUE.
            LABELS(3) = .FALSE.
            NUMBER(3) = .TRUE.
            IF (NX.LE.NBIG) THEN
               NXTEXT = NX
               XTSHOW = .FALSE.
            ELSE
               NXTEXT = N2
               XTSHOW = .TRUE.
            ENDIF
            IF (NY.LE.NBIG) THEN
               NYTEXT = NY
               YTSHOW = .FALSE.
            ELSE
               NYTEXT = N2
               YTSHOW = .TRUE.
            ENDIF
            NZTEXT = N2
         ENDIF
      ENDIF
      IF (X2INT .AND. XMAX.GT.R2BIG) X2INT = .FALSE.
      IF (Y2INT .AND. YMAX.GT.R2BIG) Y2INT = .FALSE.
      IF (Z2INT .AND. ZMAX.GT.R2BIG) Z2INT = .FALSE.
      NEWRUN = .FALSE.
C
C Subsidiary branch point ............................................
C
   40 CONTINUE
      CALL SURDDD$(ICOLOR, ISEND, ITHETA, KMODE, NBIG, NCON, NCON1,
     +             NMAX, NTYPE, NX, NXSAV, NXTEXT, NY, NYSAV, NYTEXT,
     +             NZMAX, NZSAV, NZTEXT,
     +             TEMP, VECPRO, VECTOR,
     +             XMAX, XMIN, YMAX, YMIN, Z, ZMAX,
     +             ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +             PTITLE, XTEXT, XTEXT1, XTITLE, YTEXT, YTEXT1,
     +             YTITLE, ZTEXT, ZTEXT1, ZTITLE,
     +             AXES, ARROWS, CONTAB, CONVAL, FRAME, FULL, LABELS,
     +             NUMBER, XTSHOW, X2INT, YTSHOW, Y2INT, ZTSHOW, Z2INT)
C
C Return if NTYPE = 10 on return from SURDDD$
C
      IF (NTYPE.EQ.10) THEN
         KVAL_12 = NKLCFG(N24)
         IF (KVAL_12.EQ.N1) THEN
            QUIT = .FALSE.
            CALL GRAPHQ (QUIT)
         ELSE
            QUIT = .TRUE.
         ENDIF   
         IF (QUIT) THEN
            CALL CLOSE_GR_WINDOWS
            RETURN
         ELSE
            GOTO 20
         ENDIF   
      ENDIF   
C
C Return to start if NTYPE out of range
C           
      IF (NTYPE.LT.1 .OR. NTYPE.GT.3) GOTO 20
C
C Create graph
C
      ABORT = .FALSE.
      FIRST = .TRUE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS,
     +             XCLIP, YCLIP, 
     +             ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS,
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
C
C Branch point for hardcopy from GKSDEK$ ............................
C
   60 CONTINUE
C
C Define transformations and open graphics
C
      CALL Z2TEMP$(ITHETA, NEBMAX, NMAX, NX, NXTEMP, NY, NYTEMP,
     +             EB, EBTEMP, X, XTEMP, Y, YTEMP, Z, ZTEMP)
      CALL SUR002$(KMODE)
      IF (ICOLOR(1).NE.0) THEN
         CALL GSELNT$(N0)
         CALL FILL_POLYGON$(N5, X5, Y5, ICOLOR(1))
      ENDIF
      IF (PS) CALL PSSPEC$(N2, NOUT_PS)
C
C Draw axes for plot if ICOLOR in range (0,15)
C
      DO I = 1, 3
         TICKS(I) = .TRUE.
         TICK1(I) = .FALSE.
      ENDDO
C********Editing 23/07/2001 to allow multiple tick marks with numbers
C********Editing 26/02/2002 introduced TICK1 for bar/cylinder charts
      IF (ITHETA.EQ.0 .OR. ITHETA.EQ.180) THEN
         NDIVS(1) = NXTEXT
         NDIVS(2) = NYTEXT
         IF (.NOT.LABELS(1)) TICK1(1) = .TRUE.
         IF (.NOT.LABELS(2)) TICK1(2) = .TRUE.
      ELSE
         NDIVS(1) = NYTEXT
         NDIVS(2) = NXTEXT
         IF (.NOT.LABELS(2)) TICK1(1) = .TRUE.
         IF (.NOT.LABELS(1)) TICK1(2) = .TRUE.
      ENDIF
      NDIVS(3) = NZTEXT
      IF (.NOT.LABELS(3)) TICK1(3) = .TRUE.
      IF (KMODE.EQ.2) THEN
         CALL CON003$(ICOLOR(3), KMODE,
     +                AXES, TICKS)
      ELSEIF (KMODE.EQ.3) THEN
         CALL SUR003$(ICOLOR(3), KMODE, NDIVS,
     +                AXES, FULL, TICKS)
         CALL CON003$(ICOLOR(3), KMODE,
     +                AXES, TICKS)
      ELSE
         CALL SUR003$(ICOLOR(3), KMODE, NDIVS,
     +                AXES, FULL, TICK1)
      ENDIF
      CALL AFRAME$(ICOLOR(3), 
     +             FRAME, PS)
C
C Title and legends
C
      TITLEP = PTITLE
      TITLEX = XTITLE
      TITLEY = YTITLE
      TITLEZ = ZTITLE
      CALL SURAAA$(ICOLOR(4), NOUT_PS, Y_SCALE, ARRAYT, TITLEP,
     +             HARD_COPY, HPGL, PS)
      IF (KMODE.EQ.2 .OR. KMODE.EQ.3) THEN
C
C Warn user if sparse data
C
         IF (NX.LT.NXYMIN .OR. NY.LT.NXYMIN) CALL PUTADV$(
     +   'Insufficient x,y grid points ... Contour algorithm may fail')
C
C Set contours for 0 < HTS < 1 (i.e. just inside the z-range)
C
         IF (NCON1.LE.3) THEN
            ZDIFF = ONE/(DBLE(NCON) + ONE)
            A = ZDIFF
            B = ONE - ZDIFF
            HTS(1) = A
            HTS(NCON) = B
         ENDIF
         IF (NCON1.EQ.1) THEN
C
C Linear spread of contours
C
            ZDIFF = (B - A)/(DBLE(NCON) - ONE)
            DO I = 2, NCON - 1
               HTS(I) = HTS(I - 1) + ZDIFF
            ENDDO
         ELSEIF (NCON1.EQ.2) THEN
C
C Increasing z-spacing
C
            ZDIFF = LOG(B/A)/(DBLE(NCON) - ONE)
            HTS(1) = LOG(A)
            DO I = 2, NCON - 1
               HTS(I) = HTS(I - 1) + ZDIFF
            ENDDO
            DO I = 1, NCON - 1
               HTS(I) = EXP(HTS(I))
            ENDDO
         ELSEIF (NCON1.EQ.3) THEN
C
C Decreasing z-spacing
C
            ZDIFF = LOG(B/A)/(DBLE(NCON) - ONE)
            TEMP(1) = LOG(A)
            TEMP(NCON) = LOG(B)
            DO I = 2, NCON - 1
               TEMP(I) = TEMP(I - 1) + ZDIFF
            ENDDO
            DO I = 1, NCON
               TEMP(I) = EXP(TEMP(I))
            ENDDO
            DO I = 2, NCON - 1
               HTS(I) = HTS(I - 1) + TEMP(NCON - I + 2) -
     +                  TEMP(NCON - I + 1)
            ENDDO
         ELSEIF (NCON1.EQ.4) THEN
C
C Use the users vector of proportions
C
            DO I = 1, NCON
               HTS(I) = VECPRO(I)
            ENDDO
         ENDIF
      ENDIF
      IF (KMODE.NE.2) THEN
         CALL SURBBB$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, Y_SCALE,
     +                ARRAYX, ARRAYY, ARRAYZ, TITLEX, TITLEY, TITLEZ,
     +                ARROWS, HARD_COPY, HPGL, LABELS, PS, XTSHOW,
     +                YTSHOW, ZTSHOW)
         CALL SURCCC$(ICOLOR(5), ITHETA, KMODE, NOUT_PS, NXTEXT, NYTEXT,
     +                NZTEXT,
     +                XMAX, XMIN, YMAX, YMIN, Y_SCALE, ZMAX, ZMIN,
     +                XTEXT, XTEXT1, YTEXT, YTEXT1, ZTEXT, ZTEXT1,
     +                HARD_COPY, HPGL, LABELS, NUMBER, PS, X2INT,
     +                Y2INT, Z2INT)
      ELSE
C
C Calculate the actual values of the contours
C
         ZDIFF = ZMAX - ZMIN
         DO I = 1, NCON
            TEMP(I) = ZMIN + ZDIFF*HTS(I)
         ENDDO
         CALL CONBBB$(ICOLOR(5), ITHETA, NOUT_PS, Y_SCALE, ARRAYX,
     +                ARRAYY, TITLEX, TITLEY,
     +                ARROWS, HARD_COPY, HPGL, LABELS, PS, XTSHOW,
     +                YTSHOW)
         CALL CONCCC$(ICOLOR(5), ITHETA, NCON, NOUT_PS, NXTEXT, NYTEXT,
     +                TEMP, XMAX, XMIN, YMAX, YMIN, Y_SCALE,
     +                XTEXT, XTEXT1, YTEXT, YTEXT1,
     +                CONTAB, HARD_COPY, HPGL, LABELS, NUMBER, PS,
     +                X2INT, Y2INT)
      ENDIF
C
C Draw a surface or 3D histogram if ICOLOR in range (0,15)
C
      IF (KMODE.EQ.1) THEN
         IF (NTYPE.EQ.1) THEN
            CALL SUR005$(ICOLOR(1), ICOLOR(2), NMAX, NXTEMP, NYTEMP,
     +                   XTEMP, XT, YTEMP, YT, ZTEMP)
         ELSE
            IF (NTYPE.EQ.2) THEN
               WIRE = .TRUE.
            ELSE
               WIRE = .FALSE.
            ENDIF
            CALL SUR006$(ICOLOR(2), NMAX, NXTEMP, NYTEMP, XTEMP, XT,
     +                   YTEMP, YT, ZTEMP, WIRE)
         ENDIF
      ELSEIF (KMODE.EQ.2) THEN
         CALL GSELNT$(N3)
         CALL CONTR2$(ICOLOR(2), KMODE, NCON, NX, NY, NMAX, NOUT_PS,
     +                HTS, Y_SCALE, ZTEMP,
     +                CONVAL, HARD_COPY, HPGL, PS, UNUSED)
         CALL CONTR5$(N2, ITHETA, ICOLOR(1), N3,
     +                XMAX, XMIN, YMAX, YMIN)
      ELSEIF (KMODE.EQ.3) THEN
         IF (NTYPE.EQ.1) THEN
            CALL SUR005$(ICOLOR(1), ICOLOR(2), NMAX, NXTEMP, NYTEMP,
     +                   XTEMP, XT, YTEMP, YT, ZTEMP)
         ELSE
            IF (NTYPE.EQ.2) THEN
               WIRE = .TRUE.
            ELSE
               WIRE = .FALSE.
            ENDIF
            CALL SUR006$(ICOLOR(2), NMAX, NXTEMP, NYTEMP,
     +                   XTEMP, XT, YTEMP, YT, ZTEMP, WIRE)
         ENDIF
         CALL GSELNT$(N3)
         CALL CONTR2$(ICOLOR(2), KMODE, NCON, NX, NY, NMAX, NOUT_PS,
     +                HTS, Y_SCALE, ZTEMP,
     +                CONLAB, HARD_COPY, HPGL, PS, UNUSED)
      ELSEIF (KMODE.EQ.4) THEN
         IF (CYLIND) THEN
            CALL H3DCYL$(ICOLOR(1), ICOLOR(2), ICOLOR(6), ICOLOR(8),
     +                   NEBMAX, NMAX, NTYPE, NXTEMP, NYTEMP,
     +                   EBTEMP, EXPAND, XTEMP, XT, YTEMP, YT, ZTEMP,
     +                   ERRBAR)
         ELSE
            CALL H3DPLT$(ICOLOR(1), ICOLOR(2), ICOLOR(6), ICOLOR(7),
     +                   ICOLOR(8), NEBMAX, NMAX, NTYPE, NXTEMP, NYTEMP,
     +                   EBTEMP, EXPAND, XTEMP, XT, YTEMP, YT, ZTEMP,
     +                   ERRBAR)
         ENDIF
      ENDIF
      FIRST = .FALSE.
      GSAVE = .TRUE.
      CALL GKSDEK$(NPRESS,
     +             XCLIP, YCLIP, 
     +             ABORT, FIRST, GSAVE)
C
C Get parameters from DLL in common block in DEFGKS.INS
C
      CALL GETDEF$(IX_OFF, IY_OFF, LINE_TYPE, NOUT_PS, 
     +             C_SCALE, PI, X_SCALE, Y_SCALE,
     +             DOTMAT, HARD_COPY, HPGL, META, PCL, PS)
      IF (NPRESS.EQ.20) THEN
         GOTO 40
      ELSEIF (NPRESS.EQ.24) THEN
         KVAL_12 = NKLCFG(N24)
         IF (KVAL_12.EQ.N1) THEN
            QUIT = .FALSE.
            CALL GRAPHQ (QUIT)
         ELSE
            QUIT = .TRUE.
         ENDIF   
         IF (QUIT) THEN
            CALL CLOSE_GR_WINDOWS
            RETURN
         ELSE
            GOTO 40
         ENDIF   
      ELSE
         GOTO 60
      ENDIF     
C
C Format statements
C      
  100 FORMAT (A,'label',I3)
  200 FORMAT (
     + 'Surface and Contour procedures'
     +/
     +/'Method:',1X,A
     +/'Number of X-values:',1X,A
     +/'Number of Y-values:',1X,A
     +/
     +/'Plot z = f(x,y) [3D surface]'
     +/'Plot z = f(x,y) [2D contours]'
     +/'Plot z = f(x,y) [3D surface and 2D contours]'
     +/'Plot data [3D skyscrapers]'
     +/'Plot data [3D skyscrapers plus error bars]'
     +/'Plot data [3D cylinders]'
     +/'Plot data [3D cylinders plus error bars]'
     +/'Install skyscraper/cylinder error bars'
     +/'Change skyscraper/cylinder size (',F4.2,')'
     +/'Install/Edit contour overlays'
     +/'Help'
     +/'Quit ... Exit surface and contour procedures')
  300 FORMAT (
     + ' Plotting z = f(x,y) and n by m data matrices'
     +/
     +/'Data for a function of two variables can be plotted as a 3D'
     +/'surface using an orthogonal net of curves at equally spaced x,'
     +/'y intervals, as a contour diagram, as a surface with a 2D set'
     +/'of projected contours, or as a 3D bar chart.'
     +/'The z = f(x,y) data can be supplied directly in a vector format'
     +/'when 3D plotting is called from a curve fitting or other type'
     +/'of SIMFIT program, but you can also supply data as a n by m'
     +/'matrix of values. You can swap between these graph types as'
     +/'long as certain restrictions are recognised.'
     +/'1)`Data must be very numerous and accurate to plot 3D surfaces'
     +/'  `or 2D contour diagrams (e.g. simulated data).'
     +/'2)`Surface and contour plotting is best done directly from a'
     +/'  `graphics, simulation or plotting program.'
     +/'3)`Data must be sparse in order to plot a 3D bar chart.'
     +/'4)`3D bar charts are best created from relatively small n by'
     +/'  `m data matrices (e.g. as used for statistical analysis).'
     +/'5)`Elements in a n by m data matrix are regarded as z values'
     +/'  `obtained at equal increments of x and y.'
     +/'6)`3D bars or cylinders can have variable size, and error bar'
     +/'  `can be installed from a corresponding n by m data matrix.')
      END
C
C
