c
c
      subroutine symlab$(isend, jvec, n, 
     +                   lvec)
c
c action: restore a colour, fill style, label, etc. after editing
c author: w.g.bardsley, university of manchester, u.k., 11/11/2004
c         07/05/2007 added intents
c         02/11/2010 added sizes and thick to argument list to symbol
c         01/12/2010 added panels to arguments list to labels
c         23/04/2011 increased dimension to 20 in call to labels
c         06/07/2011 added WORDX and VECTORS in call to LABELS

c
c     isend: (input/unchanged) as follows:
c            isend = 1: overwrite jcolor in symbol ... line/symbol colour
c            isend = 2: overwrite kcolor in symbol ... titles, etc.
c            isend = 3: overwrite l in symbol      ... line type
c            isend = 4: overwrite m in symbol      ... symbol type
c            isend = 5: overwrite jcolor in labels ... bar/segment colour
c            isend = 6: overwrite kfill in labels  ... bar/segment fill style
c            isend = 7: overwrite labels in labels ... x-axes labels
c      jvec: (input/unchanged) integer vector
C         n: (input/unchanged) size of the vectors
c      lvec: (input/unchanged) character vector
c      Note: when isend < 7 only jvec is referenced but when
c            when isend = 7 only lvec is referenced
c
      implicit none
c
c arguments
c
      integer,             intent (in) :: isend, n, jvec(n)
      character (len = *), intent (in) :: lvec(n)
c
c locals
c
      integer    nmax
      parameter (nmax = 20)
      integer    i, j, jcolor(nmax), jsend, kcolor(nmax), kfill(nmax),
     +           l(nmax), m(nmax)
      double precision sizes(nmax), thick(nmax)
      character  lines(nmax)*40, panels(nmax)*40, wordx(nmax)*20,
     +           vectors(60)*40
      external   labels, symbol
      intrinsic  min
c
c check isend
c

      if (isend.lt.1 .or. isend.gt.7 .or. n.lt.1) return
c
c get the defaults from symbol or labels (jsend = 1)
c
      jsend = 1
      if (isend.le.4) then
         call symbol (jsend, jcolor, kcolor, l, m,
     +                sizes, thick)
      else
         call labels (jsend, jcolor, kfill,
     +                lines, panels, wordx, vectors)
      endif
c
c overwrite the edited values (jsend = 4 or 3) with the edited values
c
      j = min(n, nmax)
      
      if (isend.le.4) then
         if (isend.eq.1) then
            do i = 1, j
               jcolor(i) = jvec(i)
            enddo
         elseif (isend.eq.2) then
            do i = 1, j
               kcolor(i) = jvec(i)
            enddo
         elseif (isend.eq.3) then
            do i = 1, j
               l(i) = jvec(i)
            enddo
         elseif (isend.eq.4) then
            do i = 1, j
               m(i) = jvec(i)
            enddo
         endif
         jsend = 4
         call symbol (jsend, jcolor, kcolor, l, m,
     +                sizes, thick)         
      else
         if (isend.eq.5) then
            do i = 1, j
               jcolor(i) = jvec(i)
            enddo
         elseif (isend.eq.6) then
            do i = 1, j
               kfill(i) = jvec(i)
            enddo
         elseif (isend.eq.7) then
            do i = 1, j
               lines(i) = lvec(i)
            enddo
         endif
         jsend = 4
         call labels (jsend, jcolor, kfill,
     +                lines, panels, wordx, vectors)
      endif
      end
c
c
