C
C
      SUBROUTINE TITLES$(ICOLOR, IPANEL, ISHAPE, KCOLOR, KTIC,
     +                   NKCOL, NOUT_PS, NTFONT, NXFONT, NYFIG, NYFONT,
     +                   NZFIG,
     +                   DRAGTI, DRAGXL, DRAGYL, DRAGZL, THEIGHT,
     +                   XA, XB, XCLIP, XEND, XHEIGHT, XPX, XPY, XPT,
     +                   XSTART, YA, YB, Y_SCALE, YTIC, YXJUMP,
     +                   ARRAYQ, ARRAYT, ARRAYX, ARRAYY, ARRAYZ,
     +                   PTITLE, QTITLE, XTITLE, YTITLE, ZTITLE,
     +                   CENTRE, HARD_COPY, HPGL, MONO,
     +                   PANEL, PLOT_TITLE, PS, SIDE, SWAP_YZ)

C
C ACTION : Titles and  legends for SIMPLOT
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 6/6/95
C          30/07/1996 Added ISHAPE
C          19/09/1996 Added PLTSTR$ and extensively revised
C          30/09/1996 Removed XMOVE
C          03/10/1996 Extensive revision and added CENTRE
C          16/10/1996 Added NYFIG, removed ISHAPE
C          14/07/1997 win32 version
C          21/02/2000 Added DRAGTI, DRAGXL, DRAGYL, DRAGZL
C          23/02/2000 added DSHIFT to allow changes in font size
C          18/10/2000 restored ISHAPE to allow ISHAPE = 4 and added
C                     ARRAYQ and QTITLE
C          19/10/2004 added ITYPE, TSIZE, XSIZE, YSIZE, ZSIZE, STORE 
C          07/05/2007 added INTENTS
C          23/10/2010 added ROTATE_Z and adjusted position of swapped Y and Z axes
C          11/02/2011 corrected for xl or yl when plotting Z-axis in PostScript
C          20/04/2011 added calls to FSIZE1$
C          25/03/2019 decreased YBEGIN by subtracting YTIC to move X_LEGEND down a bit
C
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NKCOL, NOUT_PS
      INTEGER,             INTENT (IN)    :: IPANEL, ISHAPE,
     +                                       KCOLOR(NKCOL), KTIC,
     +                                       NTFONT, NXFONT, NYFIG,
     +                                       NYFONT, NZFIG  
      INTEGER,             INTENT (INOUT) :: ICOLOR
      DOUBLE PRECISION,    INTENT (IN)    :: DRAGTI, DRAGXL, DRAGYL,
     +                                       DRAGZL
      DOUBLE PRECISION,    INTENT (IN)    :: THEIGHT, XA, XB, XCLIP(2),
     +                                       XEND, XHEIGHT, XPT, XPX,
     +                                       XPY, XSTART, YA, YB,
     +                                       Y_SCALE, YTIC, YXJUMP
      CHARACTER (LEN = *), INTENT (IN)    :: ARRAYQ, ARRAYT, ARRAYX,
     +                                       ARRAYY, ARRAYZ, PTITLE,
     +                                       QTITLE, XTITLE, YTITLE, 
     +                                       ZTITLE
      LOGICAL,             INTENT (IN)    :: CENTRE, HARD_COPY, HPGL,
     +                                       MONO, PANEL, PLOT_TITLE,
     +                                       PS, SIDE, SWAP_YZ
C
C Locals
C
      INTEGER    N0, N1, N4, N8
      PARAMETER (N0 = 0, N1 = 1, N4 = 4, N8 = 8)
      INTEGER    IFONT, ITYPE, NFONT_PS, NTFONT_PS
      DOUBLE PRECISION WGBCFG$
      DOUBLE PRECISION ANGLE, DSHIFT, SLANT, XBEGIN, YBEGIN
      DOUBLE PRECISION TSIZE, XSIZE, YSIZE, ZSIZE
      DOUBLE PRECISION T_MOVE, X_MOVE, Y_MOVE, Z_MOVE
C
C Parameters
C
      DOUBLE PRECISION ONE, TWO, THREE, ZERO, NINETY, SIXTY
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, THREE = 3.0D+00,
     +           ZERO = 0.0D+00, NINETY = 90.0D+00, SIXTY = 60.0D+00)
      DOUBLE PRECISION FOUR, SIX, EIGHT, NINE
      PARAMETER (FOUR = 4.0D+00, SIX = 6.0D+00, EIGHT = 8.0D+00,
     +           NINE = 9.0D+00)
      CHARACTER  TYPE2*2
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      LOGICAL    ROTATE_Z
      LOGICAL    STORE
      PARAMETER (STORE = .FALSE.)
C
C Externals
C
      EXTERNAL   PLTSTR$, WGBCFG$, WGBFNT$, FSIZES$, FSIZE1$, SAVLGL$
      EXTERNAL   TXYZ_FACTORS
      INTRINSIC  MIN, DBLE
C
C Get the fudge factors to compensate for X_SVG > 1 or Y_SVG > 1
C      
      CALL TXYZ_FACTORS (T_MOVE, X_MOVE, Y_MOVE, Z_MOVE)
      T_MOVE = 0.85D+00*T_MOVE
      Y_MOVE = 1.65d+00*Y_MOVE
C
C Calculate DSHIFT and NFONT_PS
C
      DSHIFT = WGBCFG$(N4)
      IF (DSHIFT.GT.ONE) THEN
         DSHIFT = TWO*(DSHIFT - ONE)*YTIC
      ELSE
         DSHIFT = ZERO
      ENDIF
      CALL WGBFNT$(IFONT, NFONT_PS,
     +             SLANT)
      IF (NFONT_PS.EQ.2 .OR. NFONT_PS.EQ.4  .OR. NFONT_PS.EQ.6  .OR.
     +    NFONT_PS.EQ.8 .OR. NFONT_PS.EQ.10 .OR. NFONT_PS.EQ.12 .OR.
     +    NFONT_PS.EQ.13) THEN
          NTFONT_PS = NFONT_PS
      ELSE
         NTFONT_PS = NFONT_PS + N1
      ENDIF
C
C Draw the Plot Title ..................................................
C
      IF (PLOT_TITLE .AND. PTITLE .NE. BLANK) THEN
         ITYPE = 1
         CALL FSIZES$(ITYPE,
     +                TSIZE,
     +                STORE)
         CALL FSIZE1$(ITYPE,
     +                TSIZE,
     +                PTITLE)          
         IF (PS) WRITE (NOUT_PS,100) TSIZE
         IF (.NOT.MONO) ICOLOR = KCOLOR(1)
         IF (CENTRE) THEN
            XBEGIN = (XCLIP(1) + XCLIP(2))/TWO
         ELSE
            XBEGIN = (XA + XB)/TWO
         ENDIF

         IF (ISHAPE.LT.4) THEN
            YBEGIN = ONE - THEIGHT - THEIGHT/TWO
         ELSE
            YBEGIN = ONE - THEIGHT - THEIGHT/TWO - ONE/EIGHT
         ENDIF
C
C Adjust the vertical displacement by DSHIFT and DRAGTI
C
         YBEGIN = YBEGIN - DSHIFT
         YBEGIN = YBEGIN + DRAGTI
         YBEGIN = YBEGIN - T_MOVE
         CALL PLTSTR$(ICOLOR, NTFONT, NTFONT_PS, N0, NOUT_PS,
     +                ZERO, TSIZE*XPT, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                BLANK, PTITLE, ARRAYT, 'ti',
     +                HARD_COPY, HPGL, PS)
         IF (PS) WRITE (NOUT_PS,100) ONE/TSIZE
         IF (QTITLE.NE.BLANK) THEN
            ITYPE = 12
            CALL FSIZES$(ITYPE,
     +                   TSIZE,
     +                   STORE)
            CALL FSIZE1$(ITYPE,
     +                   TSIZE,
     +                   QTITLE)  
            IF (PS) WRITE (NOUT_PS,100) TSIZE
            IF (.NOT.MONO) ICOLOR = KCOLOR(9)  
            YBEGIN = YBEGIN - THEIGHT - THEIGHT/FOUR
            YBEGIN = YBEGIN - T_MOVE
            CALL PLTSTR$(ICOLOR, NTFONT, NTFONT_PS, N0, NOUT_PS,
     +                   ZERO, TSIZE*XPT, SLANT, XBEGIN, YBEGIN,
     +                   Y_SCALE,
     +                   BLANK, QTITLE, ARRAYQ, 'ti',
     +                   HARD_COPY, HPGL, PS)
            IF (PS) WRITE (NOUT_PS,100) ONE/TSIZE
         ENDIF
      ENDIF
C
C Draw the X-axis legend ..............................................
C
      IF (XTITLE .NE. BLANK) THEN
         ITYPE = 2
         CALL FSIZES$(ITYPE,
     +                XSIZE,
     +                STORE)
         CALL FSIZE1$(ITYPE,
     +                XSIZE,
     +                XTITLE)  
         IF (PS) WRITE (NOUT_PS,200) XSIZE
         IF (.NOT.MONO) ICOLOR = KCOLOR(4)
         YBEGIN = XHEIGHT - YTIC!fine adjustment 25/03/2019
         IF (ISHAPE.EQ.4) YBEGIN = YBEGIN + ONE/NINE
C
C Adjust the vertical displacement by DSHIFT and DRAGXL
C
         YBEGIN = YBEGIN - DSHIFT
         YBEGIN = YBEGIN + DRAGXL
         IF (PANEL.AND..NOT.SIDE) THEN
            IF (IPANEL.LE.3) THEN
               YBEGIN = YBEGIN + YXJUMP/TWO
            ELSE
               YBEGIN = YBEGIN + YXJUMP - 0.01D+00
            ENDIF
         ENDIF
         XBEGIN = (XA + XB)/TWO

         YBEGIN = YBEGIN + Y_MOVE
         CALL PLTSTR$(ICOLOR, NXFONT, NFONT_PS, N0, NOUT_PS,
     +                ZERO, XSIZE*XPX, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                BLANK, XTITLE, ARRAYX, 'xl',
     +                HARD_COPY, HPGL, PS)
         IF (PS) WRITE (NOUT_PS,200) ONE/XSIZE
      ENDIF
C
C Draw the Y-axis legend ...............................................
C
      IF (YTITLE .NE. BLANK) THEN
         ITYPE = 3
         CALL FSIZES$(ITYPE,
     +                YSIZE,
     +                STORE)
         CALL FSIZE1$(ITYPE,
     +                YSIZE,
     +                YTITLE)  
         IF (PS) WRITE (NOUT_PS,300) YSIZE
         IF (.NOT.MONO) ICOLOR = KCOLOR(4)
         IF (SWAP_YZ) THEN
            XBEGIN = XEND + DBLE(NYFIG + N1)/SIXTY + YTIC
C
C Adjust the horizontal displacement by DSHIFT and DRAGYL
C
            XBEGIN = XBEGIN - DSHIFT
            XBEGIN = XBEGIN + DRAGYL
            IF (KTIC.EQ.1) XBEGIN = XBEGIN + YTIC
            XBEGIN = XBEGIN + THREE*YTIC  
            YBEGIN = (YA + YB)/TWO 
            ANGLE = NINETY
            XBEGIN = XBEGIN + X_MOVE
            CALL PLTSTR$(ICOLOR, NYFONT, NFONT_PS, N0, NOUT_PS,
     +                   ANGLE, YSIZE*XPY, SLANT, XBEGIN, YBEGIN,
     +                   Y_SCALE,
     +                   BLANK, YTITLE, ARRAYY, 'yl',
     +                   HARD_COPY, HPGL, PS)
         ELSE
            XBEGIN = XSTART - MIN(DBLE(NYFIG + N1), SIX)/SIXTY - 3*YTIC
C
C Adjust the horizontal displacement by DSHIFT and DRAGYL
C
            XBEGIN = XBEGIN - DSHIFT
            XBEGIN = XBEGIN + DRAGYL
            IF (NYFIG.EQ.1) XBEGIN = XBEGIN - YTIC
            IF (KTIC.EQ.1) XBEGIN = XBEGIN - YTIC
            YBEGIN = (YA + YB)/TWO
            XBEGIN = XBEGIN + X_MOVE
            CALL PLTSTR$(ICOLOR, NYFONT, NFONT_PS, N0, NOUT_PS,
     +                   NINETY, YSIZE*XPY, SLANT, XBEGIN, YBEGIN,
     +                   Y_SCALE,
     +                   BLANK, YTITLE, ARRAYY, 'yl',
     +                   HARD_COPY, HPGL, PS)
         ENDIF
         IF (PS) WRITE (NOUT_PS,300) ONE/YSIZE
      ENDIF
C
C Draw the Z-axis legend ...............................................
C
      IF (ZTITLE .NE. BLANK) THEN
         CALL SAVLGL$(N8,
     +                ROTATE_Z,
     +                STORE)         
         ITYPE = 4
         CALL FSIZES$(ITYPE,
     +                ZSIZE,
     +                STORE)
         CALL FSIZE1$(ITYPE,
     +                ZSIZE,
     +                ZTITLE)  
         IF (.NOT.MONO) ICOLOR = KCOLOR(4)
         XBEGIN = XEND + DBLE(NZFIG + N1)/SIXTY + YTIC
C
C Adjust the horizontal displacement by DSHIFT and DRAGZL
C
         XBEGIN = XBEGIN + DSHIFT
         XBEGIN = XBEGIN + DRAGZL
         IF (KTIC.EQ.1) XBEGIN = XBEGIN + YTIC
         YBEGIN = (YA + YB)/TWO
         IF (ROTATE_Z) THEN
            IF (PS) WRITE (NOUT_PS,400) ZSIZE
            ANGLE = - NINETY
            TYPE2 = 'zl'
         ELSE
            IF (PS) WRITE (NOUT_PS,300) ZSIZE
            ANGLE = NINETY
            TYPE2 = 'yl'
            XBEGIN = XBEGIN + THREE*YTIC
         ENDIF    
         XBEGIN = XBEGIN - Z_MOVE  
         CALL PLTSTR$(ICOLOR, NYFONT, NFONT_PS, N0, NOUT_PS,
     +                ANGLE, ZSIZE*XPY, SLANT, XBEGIN, YBEGIN, Y_SCALE,
     +                BLANK, ZTITLE, ARRAYZ, TYPE2,
     +                HARD_COPY, HPGL, PS)
         IF (PS) THEN
            IF (ROTATE_Z) THEN
               WRITE (NOUT_PS,400) ONE/ZSIZE
            ELSE   
               WRITE (NOUT_PS,300) ONE/ZSIZE
            ENDIF
         ENDIF     
      ENDIF          
C
C These format statements must NOT be edited
C
  100 FORMAT ('/ti-size ti-size',1X,f7.3,1X,'mul def')
  200 FORMAT ('/xl-size xl-size',1X,f7.3,1X,'mul def')
  300 FORMAT ('/yl-size yl-size',1X,f7.3,1X,'mul def')
  400 FORMAT ('/zl-size zl-size',1X,f7.3,1X,'mul def')
      END
C
C
      subroutine txyz_factors (t_move, x_move, y_move, z_move)
      implicit none
c
c arguments
c     
      
      double precision, intent (out) :: t_move, x_move, y_move, z_move 
c
c locals 
c 
      integer    mtrans, nfig, nsig 
      integer    isend, jsend
      parameter (isend = 0,jsend = 3)
      double precision x_svg, y_svg
      double precision const1, const2, exp1, exp2
      parameter (const1 = 0.0625d+00, exp1 = 0.325d+00)
      parameter (const2 = 0.0925d+00, exp2 = 0.309d+00)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      logical    active_svg
      logical    store
      parameter (store = .false.)
      external   svgpar, grfsig$, savetr$
      intrinsic  exp
      t_move = zero
      x_move = zero
      y_move = zero
      z_move = zero
      call svgpar (isend, 
     +             x_svg, y_svg,
     +             active_svg)
      if (active_svg) then
         if (x_svg.gt.one) then
            call savetr$(mtrans,
     +                   store)
            call grfsig$(jsend, mtrans, nfig, nsig,
     +                   'Y') 
            if (nsig.le.2) then  
               x_move = const1*(one - exp(-exp1*x_svg))
            else   
               x_move = const2*(one - exp(-exp2*x_svg)) 
            endif   
            z_move = x_move   
         elseif (y_svg.gt.one) then
            y_move = const1*(one - exp(-exp1*y_svg))
            t_move = y_move  
         endif       
      endif
      end
c
c        