C
C
      SUBROUTINE TRNLAB$(MTRANS, N, NT, NWMAX, NWORDS,
     +                   ASYMP, X, XT, Y, YT,
     +                   WORDX, WORDY, STRNG1, VECTOR,
     +                   NATLOG, PLOTX)
C
C ACTION : SUPPLY  N, ASYMP, X, Y then derive transforms as selected
C          NT = NT + N1 only if transformation can be done
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          10/08/2001 derived from GKSTRN$
C          17/07/2005 added PLOTX 
C          07/05/2007 added INTENTS     
C      
C
C          MTRANS: (input/unchanged) transformation number
C               N: (input/unchanged) dimension
C              NT: (output) number of labels for plotting
C           NWMAX: (input/unchanged) dimension
C          NWORDS: (input/unchanged) dimension
C           ASYMP: (input/unchanged) asymptote for Hill plot transform
C               X: (input/unchanged) original data
C              XT: (output) transformed coordinates
C               Y: (input/unchanged) original data
C              YT: (output) transformed coordinates
C           WORDX: (input/unchanged) original label
C           WORDY: (input/unchanged) original template
C          STRNG1: (output) label for plotting at (XT,YT)
C          VECTOR: (output) template for plotting at (XT,YT)
C          NATLOG: (input/unchanged) correction for log base
C           PLOTX: (input/unchanged) attempt to plot WORDX(i) if PLOTX(i) = .TRUE.
C
C
C          original 0:    x,     1/y
C          ======== 1:   1/x,      y
C                   2:   1/x,    1/y
C                   3:     y,    y/x
C                   4:   y/x,      y
C                   5:    /x,    x/y
C                   6:  logx,      y
C                   7:     x,   logy
C                   8:  logx,   logy
C                   9:  logx,   log[y/(A-y)]
C                  10:     x,      y
C
C               new 0:    x,       y
C               === 1:    y,       x
C                   2:    x,     1/y
C                   3:   1/x,      y
C                   4:   1/x,    1/y
C                   5:     y,    y/x
C                   6:   y/x,      y
C                   7:     x,    x/y
C                   8:  logx,      y
C                   9:     x,   logy
C                  10:  logx,   logy
C                  11:  logx,   log[y/(A-y)]
C                  12:  log[1/x],  y
C                  13:  logy       x
C                  14:     y    logx
C                  15:  logy    logx
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)  :: MTRANS, N, NWORDS, NWMAX 
      INTEGER,             INTENT (OUT) :: NT
      DOUBLE PRECISION,    INTENT (IN)  :: ASYMP, X(N), Y(N)
      DOUBLE PRECISION,    INTENT (OUT) :: XT(N), YT(N)  
      CHARACTER (LEN = *), INTENT (IN)  :: WORDX(NWORDS), WORDY(NWORDS)
      CHARACTER (LEN = *), INTENT (OUT) :: STRNG1(NWMAX), VECTOR(NWMAX)
      LOGICAL,             INTENT (IN)  :: NATLOG(11), PLOTX(NWORDS)
C
C Locals
C
      INTEGER    N0, N1, N2, N7, N9
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N7 = 7, N9 = 9)
      INTEGER    I, NTSAV
      DOUBLE PRECISION ABSXI, ABSYI
      DOUBLE PRECISION RTOL, X02AME$
      DOUBLE PRECISION BLOG, TEMP
      DOUBLE PRECISION ONE, TEN
      PARAMETER (ONE = 1.0D+00, TEN = 10.0D+00)
      LOGICAL    AGAIN
      EXTERNAL   X02AME$, PUTFAT$
      INTRINSIC  LOG, ABS, DBLE
C
C Check MTRANS
C
      IF (MTRANS.LT.0 .OR. MTRANS.GT.15) THEN
         CALL PUTFAT$('MTRANS out of range in call to GKSTRN')
         RETURN
      ENDIF
C
C Initialise
C
      RTOL = 1.0D+09*X02AME$()
      IF (MTRANS.GT.N7) THEN
C
C Define BLOG = 1/log(base) if log transform required
C
         IF (NATLOG(1)) THEN
            BLOG = ONE
         ELSEIF (NATLOG(10)) THEN
            BLOG = ONE/LOG(TEN)
         ELSE
            AGAIN = .TRUE.
            DO I = N2, N9
               IF (AGAIN) THEN
                  IF (NATLOG(I)) THEN
                     AGAIN = .FALSE.
                     BLOG = ONE/LOG(DBLE(I))
                  ENDIF
               ENDIF
            ENDDO
         ENDIF
      ENDIF
C
C Transform if possible
C
      NT = N0
      DO I = N1, N
         IF (PLOTX(I)) THEN
            NTSAV = NT
            ABSXI = ABS(X(I))
            ABSYI = ABS(Y(I))
            IF (MTRANS.EQ.0) THEN
               NT = NT + N1
               XT(NT) = X(I)
               YT(NT) = Y(I)
            ELSEIF (MTRANS.EQ.1) THEN
               NT = NT + N1
               XT(NT) = Y(I)
               YT(NT) = X(I)
            ELSEIF (MTRANS.EQ.2) THEN
               IF (ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = X(I)
                  YT(NT) = ONE/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.3) THEN
               IF (ABSXI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = ONE/X(I)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.4) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = ONE/X(I)
                  YT(NT) = ONE/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.5) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)
                  YT(NT) = Y(I)/X(I)
               ENDIF
            ELSEIF (MTRANS.EQ.6) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)/X(I)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.7) THEN
               IF (ABSXI.GT.RTOL .AND. ABSYI.GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = X(I)
                  YT(NT) = X(I)/Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.8) THEN
              IF (X(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(X(I))
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.9) THEN
               IF (Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = X(I)
                  YT(NT) = BLOG*LOG(Y(I))
               ENDIF
            ELSEIF (MTRANS.EQ.10) THEN
               IF (X(I).GT.RTOL .AND. Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(X(I))
                  YT(NT) = BLOG*LOG(Y(I))
               ENDIF
            ELSEIF (MTRANS.EQ.11) THEN
               TEMP = ASYMP - Y(I)
               IF (TEMP.GT.RTOL) THEN
                  TEMP = Y(I)/TEMP
                  IF (TEMP.GT.RTOL .AND. X(I).GT.RTOL) THEN
                     NT = NT + N1
                     XT(NT) = BLOG*LOG(X(I))
                     YT(NT) = BLOG*LOG(TEMP)
                  ENDIF
               ENDIF
            ELSEIF (MTRANS.EQ.12) THEN
               TEMP = X(I)
               IF (TEMP.GT.RTOL .AND. TEMP.LE.ONE) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(ONE/TEMP)
                  YT(NT) = Y(I)
               ENDIF
            ELSEIF (MTRANS.EQ.13) THEN
               IF (Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(Y(I))
                  YT(NT) = X(I)
               ENDIF
            ELSEIF (MTRANS.EQ.14) THEN
               IF (X(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = Y(I)
                  YT(NT) = BLOG*LOG(X(I))
               ENDIF
            ELSEIF (MTRANS.EQ.15) THEN
               IF (X(I).GT.RTOL .AND. Y(I).GT.RTOL) THEN
                  NT = NT + N1
                  XT(NT) = BLOG*LOG(Y(I))
                  YT(NT) = BLOG*LOG(X(I))
               ENDIF
            ENDIF
C
C If successful transform copy WORDX and WORDY
C
            IF (NT.GT.NTSAV) THEN
               STRNG1(NT) = WORDX(I)
               VECTOR(NT) = WORDY(I)
            ENDIF
         ENDIF
C
C Check that maximum dimension has not been exceeded
C
         IF (NT.EQ.NWORDS .OR. NT.EQ.NWMAX) RETURN
      ENDDO
      END
C
C
