c
c
      subroutine tsizes (itype,
     +                   fsize,
     +                   store)
c
c action: call fsizes$ to change text sizes
c author: w.g.bardsley, university of manchester, u.k. 14/02/2011
c
c itype: (input/unchanged) type of font required as follows:
c        itype =  1: title (main)
c        itype =  2: x-legend
c        itype =  3: y-legend
c        itype =  4: z-legend
c        itype =  5: x-text-labels
c        itype =  6: y-text-labels 
c        itype =  7: z-text-labels 
c        itype =  8: bar chart labels
c        itype =  9: pie chart labels
c        itype = 10: panel labels
c        itype = 11: data point labels
c        itype = 12: title (extra)
c        itype = 13: x-axis numbers
c        itype = 14: y-axis numbers
c        itype = 15: z-axis numbers
c fsize: (input/output) font size
c        store = .true. then install
c        store = .false. then just return the stored value
c store: (input/unchanged) type of action required as above
c
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: itype
      double precision, intent (inout) :: fsize
      logical,          intent (in)    :: store
c
c locals
c      
      integer    jtype
      integer    nmax
      parameter (nmax = 15)
      double precision one, fmin, fmax
      parameter (one = 1.0d+00, fmin = 0.2d+00, fmax = 5.0d+00)
      character (len = 100) line
      intrinsic  abs
      external   fsizes$, putfat$
c
c define jtype than check itype
c      
      jtype = abs(itype)
      if (jtype.lt.1 .or. jtype.gt.nmax) then
         write (line,100) nmax
         call putfat$ (line)
         if (.not.store) fsize = one
         return
      endif 
c
c check fsize if supplied
c     
      if (store) then
         if (fsize.lt.fmin .or. fsize.gt.fmax) then
            write (line,200) fmin, fmax
            call putfat$ (line)
            return
         endif   
         jtype = -jtype
      endif  
      call fsizes$ (jtype,
     +              fsize,
     +              store)
c
c format statements
c     
  100 format ('tsizes must be called with 1 =< |itype| =<',i3)           
  200 format ('tsizes must be called with',f4.1,' =< fsize =< ',f4.1)           
      end
c
c    