c
c
      subroutine tsplot$(isend, lvec, mvec, nvec,
     +                   delta, error1, error2, start, xvec,
     +                   ptitle, xtitle, ytitle)
c
c action: time series plots
c author: w.g.bardsley, university of manchester, u.k., 28/05/2001 
c         22/06/2006 introduced allocatable arrays
c         07/05/2007 added intents
c                                                 
c
c Note: the arguments are not changed by this routine
c
c         isend = 1: ask for delta, start, then time series type plot
c                    this line-joins y = xvec at chosen intervals
c         isend = 2: assign delta, start, then time series type plot
c                    this line-joins y = xvec at specified intervals
c         isend = 3: ask for delta, start, then rod type plot
c                    this plots y = xvec as rods at chosen intervals
c         isend = 4: delta, start defaults, then rod type plot
c                    this plots y = xvec as rods at specified intervals
c         isend = 5: delta, start defaults, then autocorrelation type plot
c                    the zero point is added
c         isend = 6: delta, start defaults, then autocorrelations plus errors
c                    the zero point is added
c         lvec = linetype
c         mvec = symbol type
c         nvec = no. xvec values
c         delta = increment (only used if isend = 2)
c         error1, error2 = error limits (only used if isend = 6)
c         start = start value (only used if isend = 2)
c         xvec = values (isend = 1, 2) or correlations (isend = 3)
c         ptitle = plot title
c         xtitle = x legend
c         ytitle = y legend
c
      implicit   none 
c
c arguments
c      
      integer,             intent (in) :: isend, lvec, mvec, nvec 
      double precision,    intent (in) :: delta, error1(nvec),
     +                                    error2(nvec), start,
     +                                    xvec(nvec)
      character (len = *), intent (in) :: ptitle, xtitle, ytitle
c
c local allocatable workspaces
c                      
      double precision, allocatable :: x1(:), x2(:), x3(:),
     +                                 y1(:), y2(:), y3(:) 
c
c locals
c       
      integer    i, ierr, j, l1, l2, l3, l4, n1, n2, n3, n4, m1, m2, m3,
     +           m4
      integer    nmax, nmax1
      double precision delta1, start1, xdiff, xstart
      double precision x4(2), y4(2)
      double precision epsi, zero, one
      parameter (epsi = 1.0d-10, zero = 0.0d+00, one = 1.0d+00)
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   putfat$, getd01, gks004, getdge
      intrinsic  min, dble
      save       start1, delta1
      data       start1, delta1 / one, one / 
c
c check nvec and isend then define nmax and nmax1
c      
      if (nvec.lt.1) return
      if (isend.ge.1 .and. isend.le.2) then
         nmax = nvec + 1
         nmax1 = 2
      elseif (isend.ge.3 .and. isend.le.5) then   
         nmax = 3*nvec + 1
         nmax1 = 2
      elseif (isend.eq.6) then
         nmax = 3*nvec + 1
         nmax1 = nvec + 1   
      else   
         call putfat$('ISEND out of range in call to TSPLOT$')
         return        
      endif   
c
c define the line types, etc.
c
      l1 = lvec
      l2 = 0
      l3 = 0
      l4 = 0
      m1 = mvec
      m2 = 0
      m3 = 0
      m4 = 0
      n2 = 0
      n3 = 0
      n4 = 0
c
c use isend to define n1, xdiff and xstart
c
      if (isend.eq.1) then
         n1 = min(nvec, nmax)
         if (n1.le.60) m1 = 1
         call getd01 (start1, 'starting value for x-axis')
         call getdge (delta1, epsi, 'increment value for x-axis')
         xstart = start1
         xdiff = delta1
      elseif (isend.eq.2) then
         n1 = min(nvec, nmax)
         if (n1.le.60) m1 = 1
         xstart = start
         xdiff = delta
      elseif (isend.eq.3) then
         n1 = min(3*nvec, nmax)
         call getd01 (start1, 'starting value for x-axis')
         call getdge (delta1, epsi, 'increment value for x-axis')
         xstart = start1
         xdiff = delta1
      elseif (isend.eq.4) then
         n1 = min(3*nvec, nmax)
         xstart = start
         xdiff = delta
      elseif (isend.eq.5) then
         n1 = min(3*nvec + 1, nmax)
         xstart = zero
         xdiff = one
      elseif (isend.eq.6) then
         n1 = min(3*nvec + 1, nmax)
         xstart = zero
         xdiff = one
         l2 = 2
         l3 = 2
         n2 = min(nvec, nmax1)
         n3 = n2
      endif
c
c allocate workspaces
c                               
      
      ierr = 0
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(x2)) deallocate(x2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x3)) deallocate(x3, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y2)) deallocate(y2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y3)) deallocate(y3, stat = ierr)
      if (ierr.ne.0) return           
      allocate(x1(nmax), stat = ierr)
      if (ierr.ne.0) return 
      allocate(y1(nmax), stat = ierr)
      if (ierr.ne.0) return 
      allocate(x2(nmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x3(nmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y2(nmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y3(nmax1), stat = ierr)
      if (ierr.ne.0) return
c
c create the arrays for plotting
c
      if (isend.lt.3) then
         do i = 1, n1
            x1(i) = xstart + dble(i - 1)*xdiff
            y1(i) = xvec(i)
         enddo
      elseif (isend.lt.5) then
         j = 0
         do i = 1, n1/3
            j = j + 1
            x1(j) = xstart + dble(i - 1)*xdiff
            y1(j) = zero
            j = j + 1
            x1(j) = x1(j - 1)
            y1(j) = xvec(i)
            j = j + 1
            x1(j) = x1(j - 1)
            y1(j) = zero
         enddo
      else
         j = 1
         x1(j) = xstart
         y1(j) = zero
         do i = 1, (n1 - 1)/3
            j = j + 1
            x1(j) = xstart + dble(i)*xdiff
            y1(j) = zero
            j = j + 1
            x1(j) = x1(j - 1)
            y1(j) = xvec(i)
            j = j + 1
            x1(j) = x1(j - 1)
            y1(j) = zero
         enddo
         if (isend.eq.6) then
            j = 2
            do i = 1, n2
               x2(i) = x1(j)
               x3(i) = x2(i)
               y2(i) = error1(i)
               y3(i) = error2(i)
               j = j + 3
            enddo
         endif
      endif
      call gks004 (l1, l2, l3, l4, m1, m2, m3, m4, n1, n2, n3, n4,
     +             x1, x2, x3, x4, y1, y2, y3, y4,
     +             ptitle, xtitle, ytitle,
     +             axes, gsave)
      end
c
c
