

c
c
      subroutine ttype1$(icolor, nfont, ngks, nout_ps,
     +                   angle, sizes, slant, x, y,
     +                   font, strng, symbol, type1,
     +                   hpgl, ps)
c
c action : Plot a text string using True_Type fonts
c author : W.G.Bardsley, University of Manchester, U.K., 08/11/2000
c          Derived from pltstr$ 
c          20/03/2007 edited for w_clearwin.dll 
c          22/05/2007 added intents
C          23/12/2013 added FUDGE_FACTOR ... Note: this must be the same as in PSFILE$ 
c          08/04/2018 passed single character string if symbol does not have font change instructions
c          24/04/2018 added imaths
c          17/03/2020 added done, checkit, icount, nstart, nstop, to plot mixed strings but also
c                     provided the option to switch to 1 character at a a time if abs(theta) > 1 
c                     This version: lines 406 - 410 uncommented => 1 to 1 if abs(theta) > 1  
c          28/04/2020 added a return statement after the execution of the PostScript section  
c
c          type1 = 'free' then use all arguments o/w use defaults
c          Text handling is the same as with psword$
c
c          icolor  = colour of text
c          ifont   = screen font (hershey)
c          nfont   = number of font for Postscript (if 'free')
c          ngks    = number of gks transformation
c          nout_ps = unit connected for PostScript
c          angle   = angle of rotation (if 'free')
c          sizes   = size of letters
c          slant   = italics parameter, kept in for possible future use
c          x, y    = coordinates for string
c          font    = specially defined font if outside default range
c          strng   = string to plot
c          symbol  = index to accompany string
c          type1   = e.g. 'free', 'tl', etc.
c          hpgl    = logical set in DLL (not set up correctly in this version)
c          ps      = logical set in dll
c
      implicit   none
c
c arguments
c      
      integer,             intent (in)    :: nfont, ngks, nout_ps 
      integer,             intent (inout) :: icolor
      double precision,    intent (in)    :: angle, sizes, slant, x, y 
      character (len = *), intent (in)    :: font, strng, symbol, type1
c
c locals
c      
      integer    imaths, jcolor, len200, ltemp, numrgb$
      integer    ii1, ii2, ii3, ii4
      integer    i, iadd1, ix, ixtemp, iy, iytemp, j, k, l, l1, l2
      integer    ih, ih_end, isub, isuper, iv, iv_end, ivert, length
      integer    itype, iadd2x, iadd2y
      integer    n0, n1, n2, n3, n4, n5, n13, nmax
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n5 = 5,
     +           n13 = 13, nmax = 100)
      integer    icount, m, nstart(nmax), nstop(nmax)
      integer    isend, ncolor
      parameter (isend = 4, ncolor = 16)
      integer    ix_s, iy_s
      double precision size1, size2, size3, theta, xbegin, ybegin
c*****parameter (size2 = 180.0d+00/1.15d+00)
c*****correction to make default font = x-label font size
      parameter (size2 = (180.0d+00*170.0d+00)/(1.15d+00*188.0d+00))
      double precision factor, fscale
      parameter (factor = 1.10d+00, fscale = 0.925d+00)
      double precision zero, one, forty_five, sixty, seventy_five, 
     +                 ninety
      parameter (zero = 0.0d+00, one = 1.0d+00, forty_five = 45.0d+00,
     +           sixty = 60.0d+00, seventy_five = 75.0d+00,
     +           ninety = 90.0d+00)
      double precision degrad, two, four, rsub, rsuper, xsub, xsuper,
     +                 ysub, ysuper
      parameter (degrad = 3.1415927d+00/180.0d+00, two = 2.0d+00,
     +           four = 4.0d+00)
      double precision fudge_factor
      parameter (fudge_factor = 0.85d+00)
      double precision c_scale, dd1, dd2, dd3, dd4
      double precision blue(ncolor), green(ncolor), red(ncolor)
      double precision wgbcfg$
      character  string_1*80, symbol_1*80
      character  c1*1, dfolt(13)*22, font1*40, font2*40, k1*1
      character  blank
      parameter (blank = ' ')
      logical    do_loop, done, checkit(nmax)
      logical    hpgl, ps
      logical    ll1, ll2, ll3, ll4, ll5, ll6
      logical    use_gdiplus, store
      parameter (store = .false.)
      external   psword$, gselnt$, gksr2i$, putfat$, getdef$,
     +           pscolr$, slashb$, wgbcfg$, numrgb$
      external   len200, triml1
      external   ttype2$, ttype3$, ttype4$    
      external   get_text_size, select_font, scale_font, rotate_font, 
     +           draw_characters
      external   use_gdiplus
      intrinsic  nint, sin, cos, dble, max, char, abs
      data       dfolt / '/Times-Roman',
     +                   '/Times-Bold',
     +                   '/Times-Italic',
     +                   '/Times-BoldItalic',
     +                   '/Helvetica',
     +                   '/Helvetica-Bold',
     +                   '/Helvetica-Oblique',
     +                   '/Helvetica-BoldOblique',
     +                   '/Courier',
     +                   '/Courier-Bold',
     +                   '/Courier-Oblique',
     +                   '/Courier-BoldOblique',
     +                   '/Symbol' /
c
c Check the parameters supplied
c
      size3 = slant!to silence ftn95
      if (strng.eq.blank) return
      if (icolor.lt.0 .or. icolor.gt.71) then
         if (ps) call putfat$(
     +      'ttype1$ must be called with 0 =< icolor =< 71')
         return
      endif
c
c Use the parameters supplied so original arguments are unchanged
c
      ltemp = ngks
      call gselnt$(ltemp)
      if (ps) then
c
c natural scaling for PS
c
         size1 = fudge_factor*sizes*wgbcfg$(n4)
      elseif (nfont.gt.8) then
c
c expand Courier and Symbol font
c
         size1 = factor*sizes*wgbcfg$(n4)
      else
c
c contract Times and Helvetica font
c
         if (use_gdiplus(store)) then
            size1 = fscale*sizes*wgbcfg$(n4)
         else  
            size1 = 0.833d+00*sizes*wgbcfg$(n4)
c            size1 = 0.75d+00*sizes*wgbcfg$(n4)
         endif  
      endif
      if (type1.eq.'ti' .or. type1.eq.'xl' .or. type1.eq.'tc' .or.
     +    type1.eq.'tl' .or. type1.eq.'tr' .or. type1.eq.'ty') then
         itype = n1
         theta = zero
      elseif (type1.eq.'yl' .or. type1.eq.'tu') then
         itype = n2
         theta = ninety
      elseif (type1.eq.'zl') then
         itype = n3
         theta = - ninety
      elseif (type1.eq.'td') then
         itype = n4
         theta = - ninety
      elseif (type1.eq.'re45') then
         itype = n5
         theta = forty_five
      elseif (type1.eq.'re60') then
         itype = n5
         theta = sixty
      elseif (type1.eq.'re75') then
         itype = n5
         theta = seventy_five
      elseif (type1.eq.'ro45') then
         itype = n5
         theta = - forty_five
      elseif (type1.eq.'ro60') then
         itype = n5
         theta = - sixty
      elseif (type1.eq.'ro75') then
         itype = n5
         theta = - seventy_five
      else
         itype = n5
         theta = angle
      endif
      if (theta.lt.-360.0d+00 .or. theta.gt.360.0d+00) theta = zero
      if (theta.ge.-one .and. theta.le.one) theta = zero   
      xbegin = x
      ybegin = y

c
c Map the real/external coordinates into integers (pixels)
c
      call gksr2i$(ix_s, iy_s, xbegin, ybegin)
      ix = ix_s
      iy = iy_s
c
c Take separate action with ps (from everything else)
c
      if (ps) then
c
c PostScript ..........................................................
c
         call pscolr$(isend, icolor, nout_ps, blue, green, red)
         string_1 = strng
         symbol_1 = symbol
c
c Requires special action if type = 'free'
c
         if (type1.eq.'free') then
            if (nfont.ge.1 .and. nfont.le.13) then
               font1 = dfolt(nfont)
            else
               font2 = font
               call triml1 (font2)
               if (font2(1:1).eq.'\') then
                  font1 = font2
               else
                  font1 = '\'//font2(1:39)
               endif
            endif
            l = len200(font1)
            write (nout_ps,100) font1(n1:l), nint(size1*size2),
     +                          ix, iy, nint(theta)
         endif
         call psword$(icolor, xbegin, ybegin, string_1, symbol_1, type1)
         return
      else
c
c ps = .false. so select screen/pcl/bmp........................................................
c
         jcolor = numrgb$(icolor)
         string_1 = strng
         call slashb$(string_1)
         l1 = len200(string_1)
         call triml1 (string_1)
         l2 = len200(string_1)
         l = len200(symbol)
         symbol_1 = symbol(n1 + l1 - l2:l)
         call getdef$(ii1, ii2, ii3, ii4, dd1, dd2, dd3, dd4, ll1,
     +                ll2, ll3, ll4, ll5, ll6)
         c_scale = dd1
         size1 = c_scale*size1
c
c Use ttype2$ to find the coordinate details
c
         ih = ix
         iv = iy
         l1 = n1
         l2 = len200(string_1)
         call ttype2$(nfont)
         call scale_font (size1)
         call get_text_size (string_1(l1:l2), length, ivert)
         isub = nint(0.25d+00*dble(ivert))
         isuper = nint(0.50d+00*dble(ivert))
c
c Adjust ix and iy as required
c
         if (type1.eq.'ti' .or. type1.eq.'xl') then
c
c Centralise the title or x-legend
c
            ix = ix - length/n2
         elseif (type1.eq.'yl') then
c
c Centralise the y-legend
c
            iy = iy + length/n2
         elseif (type1.eq.'zl') then
c
c Centralise the z-legend
c
            iy = iy - length/n2
         elseif (type1.eq.'tr') then
c
c Right justification
c
            ix = ix - length
         elseif (type1.eq.'td') then
c
c Text pointing down
c
            ix = ix - ivert/n2
         elseif (type1.eq.'tu') then
c
c Text pointing up
c
            ix = ix + ivert/n2
            iy = iy + length
         elseif (type1.eq.'tc') then
c
c Text centralised
c
            ix = ix - length/n2
         elseif (type1.eq.'ty') then
c
c Text as for annotation of y-axis
c
            ix = ix - length
            iy = iy + ivert/n3
         elseif (type1.eq.'tz') then
c
c Text as for annotation of z-axis
c
            iy = iy + ivert/n3
         else
            if (type1(1:2).eq.'re') then
c
c Text reversed
c
               if (type1.eq.'re45') then
                  ix = ix - nint(0.707d+00*length) + ivert/n2
                  iy = iy + nint(0.707d+00*length) + ivert/n2
               elseif (type1.eq.'re60') then
                  ix = ix - nint(0.500d+00*length) + ivert/n2
                  iy = iy + nint(0.866d+00*length) + ivert/n2
               elseif (type1.eq.'re75') then
                  ix = ix - nint(0.259d+00*length) + ivert/n2
                  iy = iy + nint(0.966d+00*length) + ivert/n4
               endif
            elseif (type1(1:2).eq.'ro') then
c
c Text rotated
c
               ix = ix - ivert/n2
               if (type1.eq.'ro45') then
                  iy = iy + ivert/n2
               elseif (type1.eq.'ro60') then
                  iy = iy + ivert/n3
               elseif (type1.eq.'ro75') then
                  iy = iy + ivert/n4
               endif
            endif
c
c Rotated text ... longhand for clarity
c
            rsub = dble(ivert)/four
            xsub = rsub*sin(theta*degrad)
            ysub = rsub*cos(theta*degrad)
            rsuper = dble(ivert)/two
            xsuper = rsuper*sin(theta*degrad)
            ysuper = rsuper*cos(theta*degrad)
         endif
      endif   
c
c***********************************
c check for font changes and accents
c***********************************
c
      icount = 0
      do i = 1, nmax
         nstart(i) = 0
         nstop(i) = 0
         checkit(i) = .false.
      enddo   
      do_loop = .false.
      k = len_trim(symbol)
      do j = 1, k
         i = ichar(symbol(j:j))
         if (i.ge.49 .and. i.le.57  .or.
     +       i.ge.65 .and. i.le.76) then
            do_loop = .true.
         else
            checkit(j) = .true.
         endif   
      enddo 
      
      icount = 0 
      if (do_loop) then
         icount = 0
         done = .false.
         do i = 1, k
            if (checkit(i)) then
               if (.not.done)  then
                 icount = icount + 1
                 nstart(icount) = i
                 nstop(icount) = i
                 done = .true.
              else
                 nstop(icount) = nstop(icount) + 1
              endif      
            else
               done = .false.
            endif
         enddo          
      endif
      
c
c****************************************************************
c If there are no accent/maths characters rotate/draw then return
c****************************************************************
c            
      if (.not.do_loop) then
         call rotate_font (theta)
         call draw_characters (string_1, ix, iy, jcolor)
         return
      else  
c
c******************************************************************************************
c There is at least one accented/maths character so draw the text string ... piece by piece
c******************************************************************************************
c
c At this stage the situation is as follows.
c 1) There are icount distinct words with no maths/accents
c 2) The words start at nstart(icount) and stop at nstop(icount)
c 3) All characters outside this range are single accented characters
c 4) If theta is not zero then cancel the effect of checkit
c 
      if (abs(theta).gt.one) then
         do i = 1, nmax
           checkit(i) = .false.
         enddo
      endif     
      m = 1
      ih_end = ix
      iv_end = iy
      do i = l1, l2
        
         if (checkit(i)) then
            ih = ih_end
            iv = iv_end
            if (i.ge.nstart(m) .and. i.le.nstop(m)) then
               if (i.eq.nstop(m)) then
                  call ttype2$ (nfont)
                  call scale_font (size1)
                  call rotate_font (theta)
                  call draw_characters (string_1(nstart(m):nstop(m)),
     +                                  ih, iv, jcolor)
                  call get_text_size (
     +                 string_1(nstart(m):nstop(m))//char(0), 
     +                          length, ivert)
                  m = m + 1
                  if (itype.eq.n5) then
                     ixtemp = length
                     ih_end = ih + nint(dble(ixtemp)*cos(theta*degrad))
                     iv_end = iv - nint(dble(ixtemp)*sin(theta*degrad))
                  else   
                     ih_end = ih + length
                     iv_end = iv     
                  endif   
               endif   
            endif
            
         else  
c
c Select the character
c
            c1 = string_1(i:i)
            k1 = symbol_1(i:i)
            ih = ih_end
            iv = iv_end
c
c Adjust for subscript and superscript if required
c
            if (k1.eq.'1' .or. k1.eq.'4') then
                size3 = 0.75d+00*size1
               if (itype.eq.n1) then
                  iv = iv + isub
               elseif (itype.eq.n2) then
                  ih = ih + isub
               elseif (itype.eq.n3) then
                  ih = ih - isub
               elseif (itype.eq.n4) then
                  ih = ih - isub
               elseif (itype.eq.n5) then
                  iadd2X = nint(xsub)
                  iadd2y = nint(ysub)
                  ih = ih + iadd2X
                  iv = iv + iadd2Y
               endif
            elseif (k1.eq.'2' .or. k1.eq.'5') then
                size3 = 0.75d+00*size1
               if (itype.eq.n1) then
                  iv = iv - isuper
               elseif (itype.eq.n2) then
                  ih = ih - isuper
               elseif (itype.eq.n3) then
                  ih = ih + isuper
               elseif (itype.eq.n4) then
                  ih = ih + isuper
               elseif (itype.eq.n5) then
                  iadd2X = - nint(xsuper)
                  iadd2y = - nint(ysuper)
                  ih = ih + iadd2x
                  iv = iv + iadd2y
               endif
            else
                size3 = size1
            endif
            imaths = n0
            if (k1.eq.'3' .or. k1.eq.'4' .or. k1.eq.'5' .or.
     +          k1.eq.'6' .or. k1.eq.'G' .or. k1.eq.'H' .or.
     +          k1.eq.'I' .or. k1.eq.'J') then
c
c Maths font including pound substitution
c
               imaths = nint(0.025d+00*dble(ivert))
               if (c1.eq.'$') then
                  call ttype2$(nfont)
                  c1 = char(163)
               else
                  call ttype2$(n13)
                  size3 = 1.25d+00*size3
                  call ttype3$(c1)
               endif
            elseif (k1.eq.'K' .or. k1.eq.'L') then
c
c Symbol or bold Symbol
c
               imaths = nint(0.025d+00*dble(ivert))
               call ttype2$(n13)
               size3 = 1.25d+00*size3
            elseif (k1.eq.'7') then
               call select_font ('WingDings')
            elseif (k1.eq.'9') then
               call select_font ('Webdings')
            else
c
c Install any other font
c
               call ttype2$(nfont)
            endif
c
c Scale font then output
c
            call scale_font (size3)
            call get_text_size (c1, ixtemp, iytemp)
            call rotate_font (theta)
            call draw_characters (c1, ih, iv + imaths, jcolor)
            if (k1.eq.'6' .or. k1.eq.'I' .or. k1.eq.'J' .or.
     +          k1.eq.'L') then
c
c Poor man's bold
c
               iadd1 = max(n1,ixtemp/10)
               call draw_characters (
     +c1, ih, iv + iadd1 + imaths, jcolor)
               call draw_characters (
     +c1, ih + iadd1, iv + imaths, jcolor)
               call draw_characters (
     +c1, ih + iadd1, iv + iadd1 + imaths, jcolor)
            endif
c
c Calculate ih_end and iv_end
c
            if (itype.eq.n1) then
               ih_end = ih + ixtemp
               iv_end = iv
            elseif (itype.eq.n2) then
               ih_end = ih
               iv_end = iv - ixtemp
            elseif (itype.eq.n3) then
               ih_end = ih
               iv_end = iv + ixtemp
            elseif (itype.eq.n4) then
               ih_end = ih
               iv_end = iv + ixtemp
            elseif (itype.eq.n5) then
               ih_end = ih + nint(dble(ixtemp)*cos(theta*degrad))
               iv_end = iv - nint(dble(ixtemp)*sin(theta*degrad))
            endif

c
c Add any accents as required
c
            call ttype4$(jcolor, ih, iv, ixtemp, iytemp, nfont,
     +                   size1, theta, c1, k1, hpgl)
c
c Re-adjust dimensions if required
c
            if (k1.eq.'1' .or. k1.eq.'4') then
               if (itype.eq.n1) then
                  iv_end = iv_end - isub
               elseif (itype.eq.n2) then
                  ih_end = ih_end - isub
               elseif (itype.eq.n3) then
                  ih_end = ih_end + isub
               elseif (itype.eq.n4) then
                  ih_end = ih_end + isub
               elseif (itype.eq.n5) then
                  ih_end = ih_end - iadd2x
                  iv_end = iv_end - iadd2y
               endif
            elseif (k1.eq.'2' .or. k1.eq.'5') then
               if (itype.eq.n1) then
                  iv_end = iv_end + isuper
               elseif (itype.eq.n2) then
                  ih_end = ih_end + isuper
               elseif (itype.eq.n3) then
                  ih_end = ih_end - isuper
               elseif (itype.eq.n4) then
                  ih_end = ih_end - isuper
               elseif (itype.eq.n5) then
                  ih_end = ih_end - iadd2x
                  iv_end = iv_end - iadd2y
               endif
            endif
            endif
         enddo
      endif     
c
c format statement (MUST NOT BE EDITED)
c      
  100 Format ('/font ',A,' D /size ',I5,' D'
     +/'GS font F size S ',2I6,' M ',I4,' rotate%#string')
      end
c
c