c
c
      subroutine ttype4$(icolor, ih, iv, ixtemp, iytemp, nfont,
     +                   size1, theta,
     +                   c1, k1,
     +                   hpgl)
c
c action : Plot an accent
c author : w.g.bardsley, university of manchester, u.k., 10/11/2000
c          derived from pltacc$
c          20/03/2007 edited for w_clearwin.dll            
c          22/05/2007 added intents
c
      implicit   none
c
c arguments
c      
      integer,             intent (in)    :: ih, iv, ixtemp, iytemp,
     +                                       nfont 
      integer,             intent (inout) :: icolor 
      double precision,    intent (in)    :: size1, theta  
      character (len = 1), intent (in)    :: c1, k1 
      logical,             intent (in)    :: hpgl
c
c locals
c      
      integer    iaddy, isuby, iwidea, iwidec, ix, iy, l
      integer    n2
      parameter (n2 = 2)
      double precision degrad
      parameter (degrad = 3.1415927d+00/180.0d+00)
      double precision r, phi, theta1, x, y
      double precision f90, f180, f270, f360, one, two, zero
      parameter (f90 = 90.0d+00, f180 = 180.0d+00, f270 = 270.0d+00,
     +           f360 = 360.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           zero = 0.0d+00)
      character  c*1
      external   ttype2$  
      external   scale_font, select_font, get_text_size, rotate_font,
     +           draw_characters 
      intrinsic  abs, sqrt, nint, atan, sin, cos, ichar, dble, char
c
c Return if k1 is not in range
c
      if (k1.eq.'A') then
c...grave
         c = '`'
         isuby = nint(0.4d+00*dble(iytemp))
      elseif (k1.eq.'B') then
c...acute
         c = char(180)
         isuby = nint(0.4d+00*dble(iytemp))
      elseif (k1.eq.'C') then
c...circumflex
         c = '^'
         isuby = nint(0.05d+00*dble(iytemp))
      elseif (k1.eq.'D') then
c...tilde
         c = '~'
         isuby = 0
      elseif (k1.eq.'E') then
c...macron
         c = '_'
         isuby = - nint(0.3d+00*dble(iytemp))
      elseif (k1.eq.'F') then
c...dieresis
         c = '"'
         isuby = nint(0.1d+00*dble(iytemp))
      elseif (k1.eq.'G') then
c...greek-hat
         c = '^'
         isuby = nint(0.1d+00*dble(iytemp))
      elseif (k1.eq.'H') then
c...greek-bar
         c = '_'
         isuby = - nint(0.3d+00*dble(iytemp))
      elseif (k1.eq.'I') then
c...greek-hat
         c = '^'
         isuby = nint(0.2d+00*dble(iytemp))
      elseif (k1.eq.'J') then
c...greek-bar
         c = '_'
         isuby = - nint(0.3d+00*dble(iytemp))
      else
        return
      endif
      l = ichar(c1)
      if (l.ge.97 .and. l.le.122) then
         if (nfont.eq.13) then
            if (l.ne.98 .and. l.ne.100 .and. l.ne.108 .and.
     +          l.ne.113) then
               iaddy = nint(0.5d+00*dble(iytemp))
            else
               iaddy = nint(0.75*dble(iytemp))
            endif
         else
            if (c1.ne.'b' .and. c1.ne.'d' .and. c1.ne.'f' .and.
     +          c1.ne.'h' .and. c1.ne.'k' .and. c1.ne.'l' .and.
     +          c1.ne.'t') then
               iaddy = nint(0.5d+00*dble(iytemp))
            else
               iaddy = nint(0.75d+00*dble(iytemp))
            endif
         endif
      else
         iaddy = nint(0.75d+00*dble(iytemp))
      endif
      iaddy = iaddy - isuby
c
c adjust the font size then define theta1
c
      if (nfont.eq.13) then
         call select_font ('Arial')
      else
         call ttype2$(nfont)
      endif
      if (k1.eq.'A' .or. k1.eq.'B' .or. k1.eq.'I' .or. k1.eq.'J') then
         phi = size1
      else
         phi = 0.65d+00*size1
      endif
      call scale_font (phi)
      theta1 = theta
c
c Find the width of the accent
c
      call get_text_size (c//char(0), ix, iy)
      iwidea = ix
c
c Find the width of the letter
c
      iwidec = ixtemp
      if (abs(theta1 - one).le.one .or. abs(theta1 - f360).le.one) then
c
c theta = 0 or 360
c
         ix = ih - (iwidea - iwidec)/n2
         if (hpgl) then
            iy = iv + iaddy
         else
            iy = iv - iaddy
         endif
      elseif (abs(theta1 - f90).le.one .or. abs(theta1 + f270).le.one)
     +                                                           then
c
c theta = 90 or - 270
c
         ix = ih - iaddy
         if (hpgl) then
            iy = iv - (iwidea - iwidec)/n2
         else
            iy = iv + (iwidea - iwidec)/n2
         endif
      elseif (abs(theta1 + f90).le.one .or. abs(theta1 - f270).le.one)
     +                                                           then
c
c theta = - 90 or 270
c
         ix = ih + iaddy
         if (hpgl) then
            iy = iv + (iwidea - iwidec)/n2
         else
            iy = iv - (iwidea - iwidec)/n2
         endif
      else
c
c theta is not a multiple of half pi
c
         if (iwidea.eq.iwidec) then
            phi = f90*degrad
            x = zero
            y = dble(iaddy)
         elseif (iwidea.gt.iwidec) then
            x = dble(iwidea - iwidec)/two
            y = dble(iaddy)
            phi = f180*degrad - atan(y/x)
         else
            x = dble(iwidec - iwidea)/two
            y = dble(iaddy)
            phi = atan(y/x)
         endif
         r = sqrt(x**2 + y**2)
         ix = ih + nint(r*cos(theta1*degrad + phi))
         if (hpgl) then
            iy = iv + nint(r*sin(theta1*degrad + phi))
         else
            iy = iv - nint(r*sin(theta1*degrad + phi))
         endif
      endif
      call rotate_font (theta)
      call draw_characters (c, ix, iy, icolor)
      end
c
c
