c
c
      subroutine txtkey (labels, panels, wordy,
     +                   store)
c
c action: store/retrieve main character plotting keys (see subroutine labels)
c author: w.g.bardsley, university of manchester, u.k., 28/12/2010
c         12/07/2011 added wordy to arguments   
c
c Character keys control the way accents and non standard ASCII text 
c characters (ichar > 127) are plotted, e.g.
c 0: standard font
c 1: subscript
c 2: superscript
c 3: maths
c ...
c ...
c 8: ISOLatin1
c ...
c ...
c L: Bold Symbol font
c Full details in the documents w_manual.pdf and pscodes.pdf
c
c labels: keys for labels 1 to 20
c panels: keys for panels 1 to 20
c  wordy: keys for wordx 1 to 20
c  store: either store or retrieve the keys
c
c Advice about keys in subroutines deflab, deflbl, defkey, and txtkey 
c -------------------------------------------------------------------
c deflab ... Re-initialises changes made to the keys by
c            any previous calls to defkey for n =< 20 then
c            passes the new values on to deflbl.
c            Note that deflab cancels any existing changes made by defkey
c deflbl ... Passively writes the arguments supplied to the configuration
c            file w_labels.cfg. 
c defkey ... Overwrites current keys but has lower priority than deflab.
c            Note that in normal use then defkey will override default keys
c            but calls to deflab take priority and will re-initialise keys.
c            So calls to defkey made after calls to deflab will change the
c            current keys but not the defaults.
c txtkey ... This uses keys altered by defkey after calls to deflab to 
c            temporarily override the defaults. 
c     
      implicit none
c
c arguments
c   
      character (len = *), intent (inout) :: labels(20), panels(20),
     +                                       wordy(20)
      logical,             intent (in)    :: store
      external txtkey$
      call txtkey$ (labels, panels, wordy,
     +              store)
      end
c
c              