C
C
      SUBROUTINE TYPEGK$(IFILL, IHUE, ISEND, NIN, NMAX, NPTS,
     +                   NTYPE, NWORDS,
     +                   FACTOR,
     +                   X, XH, XL, Y, YH, YL, YMAX3, YMAX4, YMIN3,
     +                   YMIN4,
     +                   FNAME, TITLE,
     +                   ABORT, BAR_CHART, VECTOR_FIELD)
C
C ACTION : Analyse typed in data files
C          ISEND = 1 : check and read in data
C          ISEND = ? : no action ... use GKSFIL$
C          NIN = UNIT number for file opening
C          NMAX = max. dimension for arrays
C          NPTS = no. of points accepted
C          NTYPE = 1 : 2 columns X = XH = XL, Y = YH = YL
C          NTYPE = 2 : 4 columns X = XH = XL then YL, Y, YH
C          NTYPE = 3 : 9 columns for a bar chart
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          11/10/1998 Derived from GKSFIL$
C          29/11/2001 added VU2CHK
C          04/06/2002 added FNAME to CHKFIL and suppressed VU2CHK
C          13/05/2007 added INTENTS
C
      IMPLICIT   NONE  
C
C Arguments
C      
      INTEGER,            INTENT (IN)    :: ISEND, NIN, NMAX, NWORDS
      INTEGER,            INTENT (INOUT) :: IFILL(NWORDS), IHUE(NWORDS),
     +                                      NPTS, NTYPE 
      DOUBLE PRECISION,   INTENT (INOUT) :: FACTOR(NWORDS)
      DOUBLE PRECISION,   INTENT (INOUT) :: X(NMAX), XH(NMAX), XL(NMAX)
      DOUBLE PRECISION,   INTENT (INOUT) :: Y(NMAX), YH(NMAX), YL(NMAX)
      DOUBLE PRECISION,   INTENT (INOUT) :: YMAX3, YMAX4, YMIN3, YMIN4 
      CHARACTER (LEN= *), INTENT (INOUT) :: FNAME, TITLE
      LOGICAL,            INTENT (IN)    :: BAR_CHART, VECTOR_FIELD 
      LOGICAL,            INTENT (OUT)   :: ABORT
C
C Locals
C     
      INTEGER    N0, N1, N10, N71
      PARAMETER (N0 = 0, N1 = 1, N10 = 10, N71 = 71)
      INTEGER    I, J, NCOL, NROW
      INTEGER    ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      DOUBLE PRECISION A, B, C, D, E, F, G, H, RTOL, TEMP, X02AME$, Z
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   CHKFIL
      EXTERNAL   PUTFAT$, X02AME$
      INTRINSIC  ABS, NINT
      NPTS = 0
      RTOL = 1.0D+09*X02AME$()
      ABORT = .TRUE.
      IF (ISEND.EQ.1) THEN
C
C Check file that has been typed in
C
         CLOSE (UNIT = NIN)
         OPEN (UNIT = NIN, FILE = FNAME)
         IF (BAR_CHART) THEN
            NCBOT = 9
            NCTOP = 9
         ELSE
            NCBOT = 2
            NCTOP = 4
         ENDIF
         NCMID = - 1
         NRBOT = 1
         NRMID = - 1
         NRTOP = NMAX
         ICOUNT = 1
         READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) GOTO 20
         ICOUNT = 2
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
         IF (IOS.NE.0) GOTO 20
         NCMID = J
         NRMID = I
         NCOL = J
         NROW = I
         IF (NROW.LT.1 .OR. NROW.GT.NMAX) GOTO 20
         IF (NCOL.LT.2 .OR. NCOL.EQ.5 .OR. NCOL.EQ.6 .OR. NCOL.EQ.7 .OR.
     +       NCOL.EQ.8 .OR. NCOL.GT.9) THEN
             GOTO 20
         ENDIF
         IF (NCOL.EQ.9 .AND. .NOT.BAR_CHART) GOTO 20
         IF (NCOL.EQ.2 .OR. NCOL.EQ.3) THEN
            NTYPE = 1
            DO I = 1, NROW
               ICOUNT = ICOUNT + 1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B
               IF (IOS.NE.0) GOTO 20
               NPTS = NPTS + 1
               X(NPTS) = A
               Y(NPTS) = B
               IF (ABS(A).GT.RTOL) THEN
                  TEMP = B/A
                  IF (TEMP.GT.YMAX3) YMAX3 = TEMP
                  IF (TEMP.LT.YMIN3) YMIN3 = TEMP
               ENDIF
               IF (ABS(B).GT.RTOL) THEN
                  TEMP = A/B
                  IF (TEMP.GT.YMAX4) YMAX4 = TEMP
                  IF (TEMP.LT.YMIN4) YMIN4 = TEMP
               ENDIF
            ENDDO
         ELSEIF (NCOL.EQ.4) THEN
            NTYPE = 2
            DO I = 1, NROW
               ICOUNT = ICOUNT + 1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D
               IF (IOS.NE.0) GOTO 20
               IF (VECTOR_FIELD) THEN
C
C Do not check A, B, C, D if a vector field type file is expected
C
                  IOS = 0!to silence ftn95...originally CONTINUE
               ELSE
                  IF (B.GT.C .OR. C.GT.D) GOTO 20
               ENDIF
               NPTS = NPTS + 1
               X(NPTS) = A
               XH(NPTS) = A
               XL(NPTS) = A
               YL(NPTS) = B
               Y(NPTS) = C
               YH(NPTS) = D
               IF (ABS(A).GT.RTOL) THEN
                  TEMP = B/A
                  IF (TEMP.LT.YMIN3) YMIN3 = TEMP
                  TEMP = D/A
                  IF (TEMP.GT.YMAX3) YMAX3 = TEMP
               ENDIF
               IF (ABS(B).GT.RTOL) THEN
                  TEMP = A/B
                  IF (TEMP.GT.YMAX4) YMAX4 = TEMP
               ENDIF
               IF (ABS(D).GT.RTOL) THEN
                  TEMP = A/D
                  IF (TEMP.LT.YMIN4) YMIN4 = TEMP
               ENDIF
            ENDDO
         ELSEIF (NCOL.EQ.9) THEN
            NTYPE = 3
            DO I = 1, NROW
               ICOUNT = ICOUNT + 1
               READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D, E, F,
     +                                               G, H, Z
               IF (IOS.NE.0) GOTO 20
               IF (I.GT.1) THEN
                  IF (A.LT.X(I - 1)) THEN
                     CALL PUTFAT$(
     +              'X must be in non-decreasing order for a bar chart')
                     GOTO 20
                  ENDIF
               ENDIF
               NPTS = NPTS + 1
               X(NPTS) = A
               XL(NPTS) = B
               XH(NPTS) = C
               YL(NPTS) = D
               Y(NPTS) = E
               YH(NPTS) = F
               IFILL(NPTS) = NINT(G)
               FACTOR(NPTS) = H
               IHUE(NPTS) = NINT(Z)
C
C Check that bar-chart parameters make sense
C
               IF (IFILL(NPTS).LT.N0 .OR. IFILL(NPTS).GT.N10)
     +             IFILL(NPTS) = N1
               IF (FACTOR(NPTS).LT.ZERO .OR. FACTOR(NPTS).GT.ONE)
     +             FACTOR(NPTS) = ONE
               IF (IHUE(NPTS).LT.N0 .OR. IHUE(NPTS).GT.N71)
     +             IHUE(NPTS) = N0
            ENDDO
         ENDIF
      ELSE
         CALL PUTFAT$('ISEND error in TYPEGK$')
         ABORT = .TRUE.
         RETURN
      ENDIF
      ABORT = .FALSE.
      CLOSE (UNIT = NIN)
      RETURN
C
C Here if a crash has occurred
C
   20 CONTINUE
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      IF (ISEND.EQ.1) THEN
         CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +                NRTOP,
     +                FNAME, TITLE)
      ENDIF
      END
C
C
