C
C
      SUBROUTINE TYPEIN$ (NGROUP,
     +                    FNAME,
     +                    ABORT, BAR_CHART, PIE_CHART)
C
C ACTION: Create a plotting file interactively
C ACTION: Type in plotting data
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 10/10/98
C         08/04/1999 Adjusted bar and piechart for maximum dimensions
C                    and allowed a vector for piecharts and matrix for barcharts
C                    Also added NGROUP to argument list
C         13/05/2007 added INTENTS
C         14/06/2010 replaced getim1 by getjm1 and gettxt by getstr
C         01/12/2010 added PANEL1 to argument list to LABELS
C         23/04/2011 increased dimension to 20 in call to labels
C
C         Errors are reported as follows:
C         NERRB  = no. error bar errors
C         NERRF  = no. bar errors
C         NERRS  = no. segment errors
C         NERRX  = no. X errors
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (OUT) :: NGROUP
      CHARACTER (LEN = *), INTENT (OUT) :: FNAME 
      LOGICAL,             INTENT (OUT) :: ABORT, BAR_CHART, PIE_CHART
C
C Locals
C      
      INTEGER    NBMAX, NCMAX, NRMAX
      PARAMETER (NBMAX = 20, NCMAX = 6, NRMAX = 100)
      INTEGER    ICOLOR, IX, IY, LSHADE, NSTART, NTEXT, NUMOPT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, LSHADE = 1)
      INTEGER    ISEND, N0, N1, N4, N5, N20
      PARAMETER (ISEND = 1, N0 = 0, N1 = 1, N4 = 4, N5 = 5, N20 = 20)
      INTEGER    JCOLOR(NBMAX), JFILL(NBMAX)
      INTEGER    NUMBLD(N20), NUMPOS(N5)
      INTEGER    NCOLS, NROWS, NTYPE
      INTEGER    I, J, L, LEN200, NERRB, NERRF, NERRS, NERRX, NOUT,
     +           NUMDEC
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION DELTA, E(NRMAX,NCMAX), X(NRMAX,NCMAX), Y(NBMAX)
      CHARACTER  LINE*100, TEXT(30)*80, TITLE*80
      CHARACTER  LABEL1(NBMAX)*40, PANEL1(NBMAX)*40, WORDX(NBMAX)*40,
     +           VECTORS(60)*40
      CHARACTER  DOT*1
      PARAMETER (DOT = '.')
      LOGICAL    ERRBAR, NORMAL
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, GETMAT, GETNOU, GETSTR$, OFILES, GETJM1,
     +           LEN200, PUTADV, PUTWAR, LABELS, GETVEC
      INTRINSIC  MIN, SQRT, ABS
      SAVE       TITLE
      SAVE       NCOLS, NROWS
      DATA       NUMBLD / N20*0 /
      DATA       NUMPOS / N5*1 /
      DATA       TITLE / 'Typed-in data' /
      DATA       NCOLS, NROWS / 2, 5 /
C
C Initialise
C
      ABORT = .TRUE.
      BAR_CHART = .FALSE.
      ERRBAR = .FALSE.
      NORMAL = .FALSE.
      PIE_CHART = .FALSE.
      NERRB = N0
      NERRF = N0
      NERRS = N0
      NERRX = N0
      NGROUP = N1
C
C Decision
C
      WRITE (TEXT,100)
      NUMBLD(1) = N4
      NSTART = 13
      NUMOPT = N5  
      NTEXT = NSTART + NUMOPT - N1
      NUMDEC = NUMOPT
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +             NUMPOS, NSTART, NTEXT,
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (NUMDEC.LT.NUMOPT) THEN
C
C Open a file and get the data title
C
         CALL GETNOU (NOUT)
         CALL OFILES (ISEND, NOUT,
     +                FNAME,
     +                ABORT)
         IF (ABORT) THEN
            CLOSE (UNIT = NOUT)
            RETURN
         ENDIF
         L = MIN(LEN200(FNAME),40)
         LINE = 'A sensible title for this plotting data'
         CALL GETSTR$ (LINE, TITLE)
      ELSE
C
C o/w return
C
         ABORT = .TRUE.
         RETURN
      ENDIF
C
C Get the number of rows required then call GETMAT or GETVEC
C
      IF (NUMDEC.EQ.1) THEN
C
C x,y plot
C
         IF (NROWS.GT.NRMAX) NROWS = NRMAX  
         LINE = 'The number of x-values required'
         CALL GETJM1 (N1, NROWS, NRMAX,
     +                LINE)
         NORMAL = .TRUE.
         LINE = FNAME(N1:L)//' ... 1=x,2=y'
         NCOLS = 2
      ELSEIF (NUMDEC.EQ.2) THEN
C
C Error bar plot
C
         IF (NROWS.GT.NRMAX) NROWS = NRMAX  
         LINE = 'The number of x-values required'
         CALL GETJM1 (N1, NROWS, NRMAX, 
     +                LINE)
         ERRBAR = .TRUE.
         LINE = FNAME(N1:L)//' ... 1=x,2=le,3=y,4=he'
         NCOLS = 4
      ELSEIF (NUMDEC.EQ.3) THEN
C
C Bar chart
C
         WRITE (TEXT,200)
         NUMBLD(1) = N4
         NSTART = 18
         NUMOPT = N4  
         NTEXT = NSTART + NUMOPT - N1
         NTYPE = 1
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NTYPE, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         DELTA = - ONE
         CALL LABELS (N1, JCOLOR, JFILL,
     +                LABEL1, PANEL1, WORDX, VECTORS)
         IF (NROWS.GT.NBMAX) NROWS = NBMAX
         LINE =
     +   'The number of groups of bars required (i.e. matrix rows)'
         CALL GETJM1 (N1, NROWS, NBMAX, 
     +                LINE)
         IF (NGROUP.GT.NBMAX/2) NGROUP = NBMAX/2
         LINE =
     +   'The number of bars per group required (i.e. matrix columns)'
         CALL GETJM1 (N1, NGROUP, NBMAX/2, 
     +                LINE)
         NCOLS = NGROUP
         LINE = FNAME(N1:L)//' ... Input nonnegative matrix values'
         BAR_CHART = .TRUE.
      ELSEIF (NUMDEC.EQ.4) THEN
C
C Pie chart
C
         CALL LABELS (N1, JCOLOR, JFILL,
     +                LABEL1, PANEL1, WORDX, VECTORS)
         IF (NROWS.GT.NBMAX) NROWS = NBMAX
         LINE = 'The number of piechart segments required'
         CALL GETJM1 (N1, NROWS, NBMAX,
     +                LINE)
         PIE_CHART = .TRUE.
         LINE = FNAME(N1:L)//' ... Input nonnegative segment values'
         NCOLS = 1
      ENDIF
C
C Create the data matrix
C
      IF (PIE_CHART) THEN
         CALL GETVEC (NROWS, 
     +                Y,
     +                LINE)
      ELSE
         CALL GETMAT (NCOLS, NRMAX, NROWS,
     +                X,
     +                LINE)
      ENDIF
C
C Special action is required for bar chart errors
C
      IF (BAR_CHART) THEN
C
C Define the error matrix
C
         IF (NTYPE.EQ.1) THEN
            DO J = N1, NCOLS
               DO I = N1, NROWS
                  E(I,J) = ZERO
               ENDDO
            ENDDO
         ELSEIF (NTYPE.EQ.2) THEN
            DO J = N1, NCOLS
               DO I = N1, NROWS
                  E(I,J) = SQRT(ABS(X(I,J)))
               ENDDO
            ENDDO
         ELSEIF (NTYPE.EQ.3) THEN
            DO J = N1, NCOLS
               DO I = N1, NROWS
                  E(I,J) = TWO*SQRT(ABS(X(I,J)))
               ENDDO
            ENDDO
         ELSEIF (NTYPE.EQ.4) THEN
            LINE = 'Input the matrix of errors to be added'
            CALL GETMAT (NCOLS, NRMAX, NROWS,
     +                   E,
     +                   LINE)
            DO J = N1, NCOLS
               DO I = N1, NROWS
                  IF (E(I,J).LT.ZERO) THEN
                     NERRB = NERRB + N1
                     E(I,J) = ZERO
                  ENDIF
               ENDDO
            ENDDO
         ENDIF
      ENDIF
C
C Write the output file adjusting NCOLS then checking for bad data
C
      WRITE (NOUT,'(A)') TITLE
      IF (PIE_CHART) THEN
         NCOLS = 4
      ELSEIF (BAR_CHART) THEN
         NCOLS = 9
      ENDIF
      IF (BAR_CHART) THEN
         WRITE (NOUT,'(2I6)') NROWS*NGROUP, NCOLS
      ELSE
         WRITE (NOUT,'(2I6)') NROWS, NCOLS
      ENDIF
      DO I = N1, NROWS
         IF (NORMAL) THEN
            WRITE (NOUT,'(1P,2E11.3)') X(I,1), X(I,2)
         ELSEIF (ERRBAR) THEN
            IF (X(I,2).GT.X(I,3)) THEN
               NERRB = NERRB + N1
               X(I,2) = X(I,3)
            ENDIF
            IF (X(I,3).GT.X(I,4)) THEN
               NERRB = NERRB + N1
               X(I,4) = X(I,3)
            ENDIF
            WRITE (NOUT,'(1P,4E11.3)') X(I,1), X(I,2), X(I,3), X(I,4)
         ELSEIF (BAR_CHART) THEN
            DELTA = DELTA + ONE
            DO J = N1, NGROUP
               DELTA = DELTA + ONE
               IF (X(I,J).GE.ZERO) THEN
                  WRITE (NOUT,'(4F5.1,1P,2E9.2,I4,0P,F5.1,I4)') DELTA,
     +                   ZERO, ZERO, ZERO, X(I,J), X(I,J) + E(I,J),
     +                   JFILL(J), ONE, JCOLOR(J)
               ELSE
                  WRITE (NOUT,'(4F5.1,1P,2E9.2,I4,0P,F5.1,I4)') DELTA,
     +                   X(I,J) - E(I,J), X(I,J), ZERO, ZERO, ZERO,
     +                   JFILL(J), ONE, JCOLOR(J)
               ENDIF
            ENDDO
         ELSEIF (PIE_CHART) THEN
            IF (Y(I).LE.ZERO) THEN
               NERRS = NERRS + N1
               Y(I) = ONE
            ENDIF
            WRITE (NOUT,'(1P,E11.3,I6,F8.4,I6)')
     +             Y(I), JFILL(I), ZERO, JCOLOR(I)
         ENDIF
      ENDDO
      IF (NORMAL .OR. ERRBAR) THEN
         IF (NROWS.GT.N1) THEN
            DO I = 1, NROWS - N1
               IF (X(I,1).GT.X(I + 1,1)) NERRX = NERRX + N1
            ENDDO
         ENDIF
      ENDIF
      IF (BAR_CHART) THEN
         WRITE (NOUT,'(I6)') NROWS*NGROUP
         DO I = N1, NROWS
            WRITE (NOUT,'(A)') LABEL1(I)
         ENDDO
         DO I = NROWS + N1, NROWS*NGROUP
            WRITE (NOUT,'(A)') DOT
         ENDDO
      ELSEIF (PIE_CHART) THEN
         WRITE (NOUT,'(I6)') NROWS + N1
         DO I = 1, NROWS
            WRITE (NOUT,'(A)') LABEL1(I)
         ENDDO
      ELSE
         WRITE (NOUT,'(I6)') N1
         WRITE (NOUT,'(A)') 'Default line'
      ENDIF
      CLOSE (UNIT = NOUT)
      IF (NERRB.GT.N0) THEN
         IF (NERRB.EQ.N1) THEN
            WRITE (LINE,300) NERRB, 'error bar has'
         ELSE
            WRITE (LINE,300) NERRB, 'error bars have'
         ENDIF
         CALL PUTWAR (LINE)
      ENDIF
      IF (NERRF.GT.N0) THEN
         IF (NERRF.EQ.N1) THEN
            WRITE (LINE,300) NERRF, 'bar height has'
         ELSE
            WRITE (LINE,300) NERRF, 'bar heights have'
         ENDIF
         CALL PUTWAR (LINE)
      ENDIF
      IF (NERRS.GT.N0) THEN
         IF (NERRS.EQ.N1) THEN
            WRITE (LINE,300) NERRS, 'segment value has'
         ELSE
            WRITE (LINE,300) NERRS, 'segments values have'
         ENDIF
         CALL PUTWAR (LINE)
      ENDIF
      IF (NERRX.GT.N0) THEN
         IF (NERRX.EQ.N1) THEN
            WRITE (LINE,400) NERRX, ' x-value is'
         ELSE
            WRITE (LINE,400) NERRX, ' x-values are'
         ENDIF
         CALL PUTADV (LINE)
      ENDIF
      ABORT = .FALSE.   
C
C Format statements
C      
  100 FORMAT (
     + 'Creating a plot interactively'
     +/
     +/'You can now type in data to create a data file containing your'
     +/'coordinates for plotting. When the file is completed you can'
     +/'use the Data option on the plot to do further editing where'
     +/'you can observe the results of your editing. After editing you'
     +/'can use the same option to save the edited file for re-use.'
     +/'Note that this is a very simple interface to SIMPLOT and more'
     +/'experienced users will create data files, configuration files'
     +/'and library files to faciltate use of the advanced plotting'
     +/'options from elsewhere in SIMFIT.'
     +/
     +/'Simple x,y plot (n by 2 x,y-matrix)'
     +/'Error bar plot (n by 4 x,yl,y,yh-matrix)'
     +/'Bar chart (n-cases by m-variables matrix)'
     +/'Pie chart (n by 1 x-vector (x > 0))'
     +/'Cancel')
  200 FORMAT (
     + 'Methods for adding error bars to the barchart'
     +/
     +/'If you select no error bars you can still edit your data to'
     +/'add individual error bars from the [Data] option if required'
     +/
     +/'If the data are Poisson counts you can add 1 or 2 square roots'
     +/'of the values to generate error bars. Adding 2*sqrt(X) to X'
     +/'gives an approx. 95% conf. limit for many counting processes,'
     +/'e.g. if X is the no. of cells in apoptosis in a section.'
     +/
     +/'You can also use the values estimated by SIMFIT. For example,'
     +/'if you have means and variance estimates, you can put mean'
     +/'values in a first matrix and error bar estimates (such as a'
     +/'t-percent(nu)*standard-error-of-mean, for instance) in a second'
     +/'matrix, so that error bars can be created by adding elements'
     +/'of the second matrix to elements of the first matrix.'
     +/
     +/'No error bars'
     +/'Add 1*sqrt(X)'
     +/'Add 2*sqrt(X)'
     +/'A second matrix')
  300 FORMAT (I3,
     +' faulty ',A,' been corrected  ...  Check/Edit data ?')
  400 FORMAT (I3,A,
     +' not in increasing order ... Check/Edit data ?')
      END
C 
C