C
C
      SUBROUTINE TYPEPC$(IFILL, IHUE, NIN, NMAX, NPTS, NWORDS,
     +                   FACTOR, X,
     +                   FNAME, LABELS, TITLE,
     +                   ABORT)
C
C ACTION : Check file for PIE CHART
C          NIN = UNIT number for file opening
C          NMAX = max. dimension for arrays
C          NPTS = no. of points accepted
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          18/07/1995 Derived from GKSFIL$ 
C          06/09/1996 Added CHKFIL
C          14/07/1997 win32 version
C          11/10/1998 Derived from PIEFIL$
C          29/11/2001 added VU2CHK
C          04/06/2002 added FNAME to CHKFIL and suppressed VU2CHK
C          13/05/2007 added INTENTS and GETWRD
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NIN, NMAX, NWORDS
      INTEGER,             INTENT (OUT)   :: NPTS
      INTEGER,             INTENT (INOUT) :: IFILL(NWORDS), IHUE(NWORDS) 
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NWORDS), X(NMAX) 
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
      CHARACTER (LEN = *), INTENT (INOUT) :: LABELS(NWORDS), TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Locals
C      
      INTEGER    I, J, NCOL, NROW
      INTEGER    N0, N1, N2, N4, N10, N71
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N4 = 4, N10 = 10, N71 = 71)
      INTEGER    IOS
      INTEGER    ICOUNT, NCBOT, NCMID, NCTOP, NRBOT, NRMID, NRTOP
      DOUBLE PRECISION A, B, C, D, XSUM
      DOUBLE PRECISION EPSI, ONE, ZERO
      PARAMETER (EPSI = 1.0D-10, ONE = 1.0D+00, ZERO = 0.0D+00)
      EXTERNAL   CHKFIL, GETWRD
      EXTERNAL   OFILES$, PUTFAT$
      INTRINSIC  NINT
      NPTS = N0
      ABORT = .TRUE.
      CLOSE (UNIT = NIN)
      CALL OFILES$(N4, NIN,
     +             FNAME,
     +             ABORT)
      IF (ABORT) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF
      ABORT = .TRUE.
      NCBOT = N4
      NCTOP = N4
      NCMID = - N1
      NRBOT = N1
      NRTOP = NMAX
      NRMID = - N1
      ICOUNT = N1
      READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) TITLE
      IF (IOS.NE.0) GOTO 20
      ICOUNT = N2
      READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I, J
      IF (IOS.NE.0) GOTO 20
      NCMID = J
      NRMID = I
      NCOL = J
      NROW = I
      IF (NROW.LT.1 .OR. NROW.GT.NMAX) GOTO 20
      IF (NCOL.NE.N4) GOTO 20
      J = N2
      DO I = N1, NROW
         ICOUNT = ICOUNT + N1
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) A, B, C, D
         IF (IOS.NE.N0) GOTO 20
         NPTS = NPTS + N1
         X(NPTS) = A
         IFILL(NPTS) = NINT(B)
         FACTOR(NPTS) = C
         IHUE(NPTS) = NINT(D)
C
C Check that PIE-chart parameters make sense
C
         IF (IFILL(NPTS).LT.N0 .OR. IFILL(NPTS).GT.N10)
     +       IFILL(NPTS) = N1
         IF (FACTOR(NPTS).LT.ZERO .OR. FACTOR(NPTS).GT.ONE)
     +       FACTOR(NPTS) = ONE
         IF (IHUE(NPTS).LT.N0 .OR. IHUE(NPTS).GT. N71)
     +       IHUE(NPTS) = N0
      ENDDO
      ICOUNT = ICOUNT + N1
      CLOSE (UNIT = NIN)
      CALL GETWRD (N1, NCOL, NIN, NPTS, NWORDS,
     +             FNAME, LABELS)
      CLOSE (UNIT = NIN) 
      J = NPTS
      NPTS = N0
      XSUM = ZERO
      DO I = N1, J
         IF (X(I).GT.EPSI) THEN
            NPTS = NPTS + N1
            X(NPTS) = X(I)
            XSUM = XSUM + X(NPTS)
            IFILL(NPTS) = IFILL(I)
            FACTOR(NPTS) = FACTOR(I)
            IHUE(NPTS) = IHUE(I)
            LABELS(NPTS) = LABELS(I)
         ENDIF
      ENDDO
      IF (XSUM.LE.EPSI .OR. NPTS.LT.N2) THEN
         CALL PUTFAT$('Insufficient data for a pie chart')
         ABORT = .TRUE.
      ELSE
         DO I = N1, NPTS
            X(I) = X(I)/XSUM
         ENDDO
         ABORT = .FALSE.
      ENDIF
      RETURN
   20 CONTINUE 
      CLOSE (UNIT = NIN)
      ABORT = .TRUE.
      CALL CHKFIL (ICOUNT, IOS, NCBOT, NCMID, NCTOP, NRBOT, NRMID,
     +             NRTOP,
     +             FNAME, TITLE)
      END
C  
C