C
C
      SUBROUTINE TYPEPF$(IFILL, IHUE, L, M,
     +                   NFILES, NGRAFS, NIN, NMAX, NPTS, NSAV,
     +                   NTYPE, NTYPE1, NTYPE2, NTYPE3, NWORDS, NY, NZ,
     +                   FACTOR,
     +                   X, XH, XL, XMAX, XMIN, Y, YH, YL, YMAX,
     +                   YMAX3, YMAX4, YMIN, YMIN3, YMIN4, ZMAX, ZMIN,
     +                   FNAME, FSAV, LABELS, TITLE, TSAV,
     +                   ABORT, BARCAP, BAR_CHART, LOWER,
     +                   UPPER, VECTOR_FIELD, YAXIS)
C
C ACTION : input plotting files
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 7/6/95
C          28/11/1997 win32 version
C          04/02/1998 Added NFILES in argument list to GKSFIL to switch off
C                     OFILES 1st time after LIBFIL has failed
C          09/03/1998 Added VECTOR_FIELD
C          11/10/1998 derived from PFILES$
C          13/12/1998 removed KLINES, NUMSET, NMARK from argument list
C          30/03/1999 removed NLINES from argument list
C
      IMPLICIT   NONE
C
C Argument list
C
      INTEGER,             INTENT (IN)    :: NGRAFS, NIN, NMAX, NWORDS
      INTEGER,             INTENT (INOUT) :: IFILL(NWORDS),
     +                                       IHUE(NWORDS),
     +                                       L(NGRAFS), M(NGRAFS),
     +                                       NFILES, NPTS, NSAV(NGRAFS),
     +                                       NTYPE, NTYPE1, NTYPE2,
     +                                       NTYPE3, NY, NZ
      DOUBLE PRECISION,    INTENT (INOUT) :: FACTOR(NWORDS)
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), XH(NMAX),
     +                                       XL(NMAX), Y(NMAX),
     +                                       YH(NMAX), YL(NMAX),
     +                                       XMAX, XMIN, YMAX, YMAX3,
     +                                       YMAX4, YMIN, YMIN3, YMIN4,
     +                                       ZMAX, ZMIN
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME, FSAV(NGRAFS), 
     +                                       LABELS(NWORDS),
     +                                       TITLE, TSAV(NGRAFS)
      LOGICAL,             INTENT (INOUT) :: ABORT, BARCAP(NGRAFS),
     +                                       BAR_CHART, LOWER(NGRAFS),
     +                                       UPPER(NGRAFS),
     +                                       VECTOR_FIELD,
     +                                       YAXIS(NGRAFS)
C
C Locals
C
      INTEGER    K0, K1
      PARAMETER (K0 = 0, K1 = 1)
      INTEGER    I, ISEND, IOS
      LOGICAL    FIRSTY, FIRSTZ
      EXTERNAL   MAXMIN$, TYPEGK$, PUTFAT$
      ISEND = 1
      CLOSE (UNIT = NIN)
      CALL TYPEGK$(IFILL, IHUE, ISEND, NIN, NMAX, NPTS, NTYPE, NWORDS,
     +             FACTOR, X, XH, XL, Y, YH, YL,
     +             YMAX3, YMAX4, YMIN3, YMIN4,
     +             FNAME, TITLE,
     +             ABORT, BAR_CHART, VECTOR_FIELD)
      CLOSE (UNIT = NIN)
      IF (NPTS.LT.1) ABORT = .TRUE.
      IF (ABORT) RETURN
C
C File accepted so set NFILES and default line and marker types .......
C
         NFILES = 1
         YAXIS(NFILES) = .TRUE.
         FIRSTY = .FALSE.
         FIRSTZ = .FALSE.
         IF (YAXIS(NFILES)) THEN
            NY = NY + 1
            IF (NY.EQ.1) FIRSTY = .TRUE.
         ELSE
            NZ = NZ + 1
            IF (NZ.EQ.1) FIRSTZ = .TRUE.
         ENDIF
         IF (NTYPE.EQ.1) THEN
            NTYPE1 = NTYPE1 + 1
            IF (NPTS.GE.60) THEN
               M(NFILES) = 0
            ELSE
               L(NFILES) = 0
            ENDIF
            BARCAP(NFILES) = .FALSE.
            LOWER(NFILES) = .FALSE.
            UPPER(NFILES) = .FALSE.
         ELSEIF (NTYPE.EQ.2) THEN
            NTYPE2 = NTYPE2 + 1
            L(NFILES) = 0
            BARCAP(NFILES) = .TRUE.
            LOWER(NFILES) = .TRUE.
            UPPER(NFILES) = .TRUE.
         ELSEIF (NTYPE.EQ.3) THEN
            NTYPE3 = NTYPE3 + 1
            M(NFILES) = 0
            BARCAP(NFILES) = .FALSE.
            LOWER(NFILES) = .FALSE.
            UPPER(NFILES) = .FALSE.
         ENDIF
         NSAV(NFILES) = NTYPE
         FSAV(NFILES) = FNAME
         TSAV(NFILES) = TITLE
C
C Find the minimum and maximum of the current X and Y Values ..........
C
         IF (NFILES.EQ.1) THEN
            IF (.NOT.BAR_CHART) CALL MAXMIN$(K0, NPTS, X, XMAX, XMIN)
         ELSE
            IF (.NOT.BAR_CHART) CALL MAXMIN$(K1, NPTS, X, XMAX, XMIN)
         ENDIF
         IF (FIRSTY) THEN
            CALL MAXMIN$(K0, NPTS, Y, YMAX, YMIN)
         ELSEIF (FIRSTZ) THEN
            CALL MAXMIN$(K0, NPTS, Y, ZMAX, ZMIN)
         ELSEIF (YAXIS(NFILES)) THEN
            CALL MAXMIN$(K1, NPTS, Y, YMAX, YMIN)
         ELSE
            CALL MAXMIN$(K1, NPTS, Y, ZMAX, ZMIN)
         ENDIF
         IF (NTYPE.EQ.2) THEN
            IF (VECTOR_FIELD) THEN
               CALL MAXMIN$(K1, NPTS, YL, XMAX, XMIN)
               CALL MAXMIN$(K1, NPTS, YH, YMAX, YMIN)
            ELSE
               IF (.NOT.BAR_CHART) CALL MAXMIN$(K1, NPTS, XH, XMAX,
     +                                          XMIN)
               IF (.NOT.BAR_CHART) CALL MAXMIN$(K1, NPTS, XL, XMAX,
     +                                          XMIN)
               IF (YAXIS(NFILES)) THEN
                  CALL MAXMIN$(K1, NPTS, YH, YMAX, YMIN)
                  CALL MAXMIN$(K1, NPTS, YL, YMAX, YMIN)
               ELSE
                  CALL MAXMIN$(K1, NPTS, YH, ZMAX, ZMIN)
                  CALL MAXMIN$(K1, NPTS, YL, ZMAX, ZMIN)
               ENDIF
            ENDIF
         ELSEIF (NTYPE.EQ.3) THEN
            CALL MAXMIN$(K1, NPTS, XH, YMAX, YMIN)
            CALL MAXMIN$(K1, NPTS, XL, YMAX, YMIN)
            CALL MAXMIN$(K1, NPTS, YH, YMAX, YMIN)
            CALL MAXMIN$(K1, NPTS, YL, YMAX, YMIN)
         ENDIF
C
C Read labels if BAR_CHART
C
      IF (NFILES.EQ.1 .AND. BAR_CHART .AND. NTYPE.EQ.3) THEN
         OPEN (UNIT = NIN, FILE = FNAME)
         DO I = 1, NPTS + 2
            READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LABELS(1)
            IF (IOS.NE.0) GOTO 20
         ENDDO
         READ (NIN,*,END=20,ERR=20,IOSTAT=IOS) I
         IF (IOS.NE.0) GOTO 20
         IF (I.GE.NPTS) THEN
            DO I = 1, NPTS
               READ (NIN,'(A)',END=20,ERR=20,IOSTAT=IOS) LABELS(I)
               IF (IOS.NE.0) GOTO 20
            ENDDO
         ELSE
            DO I = 1, NPTS
               WRITE (LABELS(I),'(I4)') I
            ENDDO
         ENDIF
      ENDIF
      RETURN
C
C Crash
C
   20 CONTINUE
      CLOSE (UNIT = NIN)
      CALL PUTFAT$('Bar chart file should end with the labels')
      NFILES = 0
      END
C
C