C
C
      SUBROUTINE VFPLOT$(IARROW, IKOLOR, JARROW, LCTEMP, NGKS, NMAX1,
     +                   HEAD, XMAX, XMIN, X1, X2, YMAX, YMIN, Y1, Y2)
C
C ACTION  : Call LOOPD4$ to draw vector field arrows (e.g. a biplot)
C
C           Arguments are all (input/unchanged) as follows:
C   
C           IARROW : type   (vector as in GKSVF1)
C           IKOLOR : colour (vector as in GKSVF1)
C           JARROW : no. of arrows
C           LCTEMP : backgound colour
C           NGKS   : the current transformation (not default 0 as in GKSVF1)
C           NMAX1  : array dimension
C           HEAD   : size   (vector as in GKSVF1)
C           X1     : head coordinate (in external coordinates)
C           X2     : tail coordinate (in external coordinates) 
C           Y1     : head coordinate (in external coordinates)
C           Y2     : tail coordinate (in external coordinates)
C
C AUTHOR  : W. G. BARDSLEY, UNIVERSITY OF MANCHESTER, U.K. 
C           14/09/2006 derived from VFIELD$ 
C           07/05/2007 added INTENTS 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: JARROW, NMAX1 
      INTEGER,          INTENT (IN) :: IARROW(JARROW), IKOLOR(JARROW),
     +                                 LCTEMP, NGKS
      DOUBLE PRECISION, INTENT (IN) :: HEAD(JARROW),
     +                                 XMAX, XMIN, X1(NMAX1), X2(NMAX1),
     +                                 YMAX, YMIN, Y1(NMAX1), Y2(NMAX1)
C
C Local allocatable arrays
C                         
      DOUBLE PRECISION, ALLOCATABLE :: XX1(:), XX2(:), YY1(:), YY2(:)
C
C Locals
C
      INTEGER    K0
      PARAMETER (K0 = 0)
      INTEGER    I, IERR, N
      EXTERNAL   WGB_ARROW$, GSELNT$, GKSD2D$
      INTRINSIC  MIN
C
C Check, initialise, allocate, then find the minimum and maximum of the X and Y values
C
      N = MIN(JARROW,NMAX1)
      IF (N.LE.K0) RETURN
      IERR = K0
      IF (ALLOCATED(XX1)) DEALLOCATE(XX1, STAT = IERR)
      IF (IERR.NE.K0) RETURN  
      IF (ALLOCATED(XX2)) DEALLOCATE(XX2, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(YY1)) DEALLOCATE(YY1, STAT = IERR)
      IF (IERR.NE.K0) RETURN
      IF (ALLOCATED(YY2)) DEALLOCATE(YY2, STAT = IERR)
      IF (IERR.NE.K0) RETURN            
      ALLOCATE(XX1(N), STAT = IERR)
      IF (IERR.NE.K0) RETURN 
      ALLOCATE(XX2(N), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(YY1(N), STAT = IERR)
      IF (IERR.NE.K0) RETURN
      ALLOCATE(YY2(N), STAT = IERR)
      IF (IERR.NE.K0) RETURN
C
C Transform into standard coordinates before calling arrows
C
      CALL GSELNT$(NGKS)
C
C Now map into (0,1) type space to agree with NGKS = ? in GSELNT$(NGKS)
C
      DO I = 1, N
         CALL GKSD2D$(X1(I), XX1(I), Y1(I), YY1(I))
         CALL GKSD2D$(X2(I), XX2(I), Y2(I), YY2(I))
      ENDDO
C
C Create the vector field
C
      CALL GSELNT$(K0)
      DO I = 1, N
         IF (X1(I).GE.XMIN .AND. X1(I).LE.XMAX .AND.
     +       X2(I).GE.XMIN .AND. X2(I).LE.XMAX .AND.
     +       Y1(I).GE.YMIN .AND. Y1(I).LE.YMAX .AND.
     +       Y2(I).GE.YMIN .AND. Y2(I).LE.YMAX) THEN
            CALL WGB_ARROW$(IARROW(I), IKOLOR(I), LCTEMP, 
     +                      HEAD(I), XX1(I), XX2(I), YY1(I), YY2(I))
         ENDIF
      ENDDO
C
C Restore the current transformation then deallocate
C
      CALL GSELNT$(NGKS)
      DEALLOCATE(XX1, STAT = IERR) 
      DEALLOCATE(XX2, STAT = IERR)
      DEALLOCATE(YY1, STAT = IERR)
      DEALLOCATE(YY2, STAT = IERR)
      END
C
C
