C
C
      SUBROUTINE WGB2PS$(IFAIL, NOUT,
     +                   XCLIP, YCLIP, 
     +                   CIPHER, FNAME)
C
C ACTION : Use SIMFIT pseudo GKS to drive PS output
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 22/11/94
C          21/08/1995 Changed to 16 colours
C          04/11/1996 Introduced XCLIP, YCLIP
C          25/02/1997 Added ATTRIB$
C          28/02/1997 Added _T and _D for temporary and default
C          23/06/1997 Added call to w_config
C          02/12/1997 Adjusted colours 0 and 15 and renamed ps_cfg as w_ps.cfg
C          27/12/1997 Added /b to end of copy command
C          23/01/1998 Made sure PSCOLR is called to initialise R, B, G
C          29/03/1998 Introduced DELEET and FPRINT to use REDPR.EXE
C          18/11/1998 Added direct call to GSVIEW
C          03/12/1999 replaced start_process by winxec
C          04/12/1999 restored start_process
C          22/02/2000 added SIZE to W_PS.CFG and call to WGBCFG$
C          29/11/2000 increased no. of colours to 64
C          10/12/2000 called WPSCFG$
C          16/12/2000 increased no. of colours to 72
C          03/09/2001 introduced PSSPEC$
C          08/02/2002 deleted LPT4 and the /b in copy /b
C          12/06/2002 wrapped up filename in " for call to gsview
C          28/11/2002 added call to PS_STRETCH and STRETCH
C          20/08/2003 added call to DOTEPS
C          17/11/2003 simplified and replaced call to startp by run_gsview
C          31/12/2006 replaced call to GETTMP by tempfile.eps and deleted DELEET
C          23/04/2007 added INTENTS
C          01/04/2010 added ISPSOK$
C          26/12/2010 added USE_GSVIEW_2_PRINT to force use of PSviewer for printing 
C          01/04/2011 now creates tempfile.eps in the usr folder
C          15/06/2011 suppressed the option to select LPT1/LPT2/NONE
C          26/09/2013 added call to EPSPDF to call RUN_ACROBAT 
C          20/10/2013 corrected error displaying current line thickness
C          27/07/2015 added calls to WGB2PS_X and X_OKCVAL
C          09/05/2017 added logical argument in call to X_OKCVAL
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)    :: NOUT  
      INTEGER,             INTENT (INOUT) :: IFAIL 
      DOUBLE PRECISION,    INTENT (INOUT) :: XCLIP(2), YCLIP(2)
      CHARACTER (LEN = *), INTENT (IN)    :: CIPHER
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME
C
C Locals
C      
      INTEGER    IDEV, IVAL, NCOLOR, NFONT
      INTEGER    IDEV_D, IVAL_D, NCOLOR_D, NFONT_D
      INTEGER    I, L
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N7, N8, N9, N10, N11, N12,
     +           N13, N14, N20, N72
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N7 = 7, N8 = 8, N9 = 9, N10 = 10, N11 = 11, N12 = 12,
     +           N13 = 13, N14 = 14, N20 = 20, N72 = 72)
      INTEGER    NUMDEC
      INTEGER    ICOLOR, ISEND, IX, IY, NMAX
      PARAMETER (ICOLOR = 3, ISEND = 1, IX = 4, IY = 4, NMAX = 20)
      INTEGER    NUMHDR, NUMOPT
      INTEGER    NUMBLD(NMAX), NUMPOS(NMAX)
      DOUBLE PRECISION ZERO, NINETY
      PARAMETER (ZERO = 0.0D+00, NINETY = 90.0D+00)
      DOUBLE PRECISION SCALE_1, THETA, THICK, XOFF, YOFF
      DOUBLE PRECISION SIZE_1, SIZE_D
      DOUBLE PRECISION THICK_D
      DOUBLE PRECISION XINCH(0:1), YINCH(0:1), ZSCALE(0:1)
      DOUBLE PRECISION XINCH_D(0:1), YINCH_D(0:1), ZSCALE_D(0:1)
      DOUBLE PRECISION BLUE(N72), GREEN(N72), RED(N72)
      DOUBLE PRECISION BLUE_D(N72), GREEN_D(N72), RED_D(N72)
      DOUBLE PRECISION XBIG, XBOT, XTOP
      DOUBLE PRECISION WGBCFG$
      CHARACTER (LEN = 1024) USRDIR
      CHARACTER (LEN = 100 ) LINE
      CHARACTER (LEN = 80  ) HEADER(NMAX), OPTION(NMAX)
      CHARACTER (LEN = 21  ) FONT
      CHARACTER (LEN = 20  ) CLIPIT
      CHARACTER (LEN = 12  ) TEMPFILE
      CHARACTER (LEN = 10  ) CIPHER_1
      CHARACTER (LEN = 9   ) ORIENT
      CHARACTER (LEN = 7   ) LABEL(5)
      PARAMETER (TEMPFILE = 'tempfile.eps')
      LOGICAL    ABORT, OK, STRETCH
      LOGICAL    ACROBAT, FILE, GSVIEW
      EXTERNAL   GETD01$, OFILES$, PUTFAT$, WPSCFG$, ISPSOK$,
     +           PUTADV$, PSFILE$, WGBTRN$, WGBCFG$, GETDM1$, PSSPEC$
      EXTERNAL   PS_STRETCH
      EXTERNAL   TITLE1, LCASE1, TRIML1, LBOX02, DOTEPS, EPSPDF
      EXTERNAL   RUN_GSVIEW, X_USRDIR, X_OKCVAL
      SAVE       STRETCH
      SAVE       IDEV, IVAL, NCOLOR, NFONT
      SAVE       SCALE_1, SIZE_1, THETA, THICK, XINCH, XOFF, YINCH,
     +           YOFF, ZSCALE
      SAVE       ACROBAT, FILE, GSVIEW
      DATA       STRETCH / .FALSE. /
      DATA       NUMBLD  / NMAX*0 /
      DATA       NUMPOS  / NMAX*1 /
      DATA       ACROBAT, FILE, GSVIEW / .FALSE., .TRUE., .FALSE. /

C
C PART 1 ... do this on every call .....................................
C ======================================================================
C

C
C Define NUMBLD
C
      NUMBLD(1) = N1
C
C Check CIPHER and set IFAIL = 0 or 1
C
      CIPHER_1 = CIPHER
      CALL LCASE1 (CIPHER_1)
      CALL TRIML1 (CIPHER_1)
      IF (CIPHER_1.EQ.'start' .OR. CIPHER_1.EQ.'stop'  .OR.
     +    CIPHER_1.EQ.'open'  .OR. CIPHER_1.EQ.'close') THEN
          IFAIL = N0
      ELSE
         CALL PUTFAT$('CIPHER must be start or stop in WGBPS')
         IFAIL = N1
         RETURN
      ENDIF

C
C PART 2  ... If 'start' or 'open' attempt to read parameters off ps.cfg
C ======================================================================
C

      IF (CIPHER_1.EQ.'start' .OR. CIPHER_1.EQ.'open') THEN
C
C Read parameters off w_ps.cfg
C
         CALL WPSCFG$(N0, N72,
     +                IDEV, IVAL, THICK, SIZE_1, XINCH, YINCH,
     +                ZSCALE, NFONT, NCOLOR, RED, GREEN, BLUE)
C
C Get the defaults
C
         CALL WPSCFG$(N3, N72,
     +                IDEV_D, IVAL_D, THICK_D, SIZE_D, XINCH_D, YINCH_D,
     +                ZSCALE_D, NFONT_D, NCOLOR_D, RED_D, GREEN_D,
     +                BLUE_D)
      ENDIF

C
C PART 3 ... Split at this point depending on the value of CIPHER_1....
C =====================================================================
C

      IF (CIPHER_1.EQ.'start' .OR. CIPHER_1.EQ.'open') THEN
   40    CONTINUE
C
C The main menu is set up from this point
C
         IF (IVAL.EQ.N0) THEN
            ORIENT = 'Portrait'
            THETA = ZERO
         ELSE
            IVAL = N1
            ORIENT = 'Landscape'
            THETA = NINETY
         ENDIF
         SCALE_1 = ZSCALE(IVAL)
         IF (STRETCH) THEN
            CLIPIT = 'Installed'
         ELSE
            CLIPIT = 'Suppressed'
         ENDIF
         IF (NFONT.EQ.N1) THEN
            FONT = 'Times-Roman'
         ELSEIF (NFONT.EQ.N2) THEN
            FONT = 'Times-Bold'
         ELSEIF (NFONT.EQ.N3) THEN
            FONT = 'Times-Italic'
         ELSEIF (NFONT.EQ.N4) THEN
            FONT = 'Times-BoldItalic'
         ELSEIF (NFONT.EQ.N5) THEN
            FONT = 'Helvetica'
         ELSEIF (NFONT.EQ.N6) THEN
            FONT = 'Helvetica-Bold'
         ELSEIF (NFONT.EQ.N7) THEN
            FONT = 'Helvetica-Oblique'
         ELSEIF (NFONT.EQ.N8) THEN
            FONT = 'Helvetica-BoldOblique'
         ELSEIF (NFONT.EQ.N9) THEN
            FONT = 'Courier'
         ELSEIF (NFONT.EQ.N10) THEN
            FONT = 'Courier-Bold'
         ELSEIF (NFONT.EQ.N11) THEN
            FONT = 'Courier-Oblique'
         ELSEIF (NFONT.EQ.N12) THEN
            FONT = 'Courier-BoldOblique'
         ELSEIF (NFONT.EQ.N13) THEN
            FONT = 'Symbol'
         ENDIF
         XOFF = XINCH(IVAL)
         YOFF = YINCH(IVAL)
         WRITE (LABEL(1),'(F7.2)') SIZE_1
         WRITE (LABEL(2),'(F7.2)') SCALE_1
         WRITE (LABEL(3),'(F7.2)') THICK
         WRITE (LABEL(4),'(F7.2)') XOFF
         WRITE (LABEL(5),'(F7.2)') YOFF
         DO I = N1, N5
            CALL TRIML1 (LABEL(I))
         ENDDO
C
C Check for default configuration
C
         CALL ISPSOK$(ZSCALE_D(IVAL), SCALE_1, SIZE_D, SIZE_1, THICK_D,
     +                THICK, XINCH_D(IVAL), XOFF, YINCH_D(IVAL), YOFF,
     +                CLIPIT, FONT, ORIENT)   
C
C The main menu
C
         WRITE (HEADER,100) ORIENT, CLIPIT, NCOLOR, FONT,
     +                      LABEL(1), LABEL(2), LABEL(3),
     +                      LABEL(4), LABEL(5)
         WRITE (OPTION,200)
         NUMDEC = N9
         NUMHDR = N20
         NUMOPT = NUMDEC
         CALL TITLE1 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT,
     +                NUMPOS,
     +                HEADER, OPTION)
         IF (NUMDEC.GE.N6 .AND. NUMDEC.LE.N9) THEN
C
C Write current parameters to the configuration file w_ps.cfg
C
            CALL WPSCFG$(N1, N72,
     +                   IDEV, IVAL, THICK, SIZE_1, XINCH, YINCH,
     +                   ZSCALE, NFONT, NCOLOR, RED, GREEN, BLUE)
C
C Call WGBCFG$ to re-set the new parameters
C
            XBIG = WGBCFG$(N0)
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C NUMDEC = 1: Portrait (0) or Landscape (1)
C
            WRITE (HEADER,500)
            WRITE (OPTION,600)
            NUMDEC = N1
            NUMHDR = N8
            NUMOPT = N4
            NUMPOS(3) = 2
            NUMPOS(4)= 2
            CALL TITLE1 (ICOLOR, NUMBLD, NUMDEC, NUMHDR, NUMOPT,
     +                   NUMPOS,
     +                   HEADER, OPTION)
            NUMPOS(3) = 1
            NUMPOS(4) = 1
            IF (NUMDEC.EQ.N1) THEN
               IVAL = N0
               STRETCH = .FALSE.
            ELSEIF (NUMDEC.EQ.N2) THEN
               IVAL = N1
               STRETCH = .FALSE.
            ELSEIF (NUMDEC.EQ.N3) THEN
               IVAL = N0
               STRETCH = .TRUE.
            ELSE
               IVAL = N1
               STRETCH = .TRUE.
            ENDIF
            GOTO 40
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C NUMDEC = 2: Offset
C
            IF (IVAL.EQ.N0) THEN
               WRITE (LINE,700) XINCH(IVAL), XINCH_D(IVAL)
               XBIG = XINCH_D(IVAL)
               CALL GETD01$(XBIG, LINE)
               XINCH(IVAL) = XBIG
               WRITE (LINE,800) YINCH(IVAL), YINCH_D(IVAL)
               XBIG = YINCH_D(IVAL)
               CALL GETD01$(XBIG, LINE)
               YINCH(IVAL) = XBIG
            ELSE
               WRITE (LINE,900) XINCH(IVAL), XINCH_D(IVAL)
               XBIG = XINCH_D(IVAL)
               CALL GETD01$(XBIG, LINE)
               XINCH(IVAL) = XBIG
               WRITE (LINE,1000) YINCH(IVAL), YINCH_D(IVAL)
               XBIG = YINCH_D(IVAL)
               CALL GETD01$(XBIG, LINE)
               YINCH(IVAL) = XBIG
            ENDIF
            GOTO 40
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C NUMDEC = 3: Scaling
C
            WRITE (LINE,1100) ZSCALE(IVAL), ZSCALE_D(IVAL)
            XBIG = ZSCALE_D(IVAL)
            CALL GETD01$(XBIG, LINE)
            IF (XBIG.LT.1.0D-02) XBIG = 1.0D-02
            IF (XBIG.GT.1.0D+02) XBIG = 1.0D+02
            ZSCALE(IVAL) = XBIG
            GOTO 40
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C NUMDEC = 4: line width
C         
            CALL PUTADV$(
     +'Sets overall (not relative) line width in PostScript units')
            XBOT = 0.25D+00
            XTOP = 5.0D+00
            IF (THICK.LT.XBOT) THEN
               THICK = XBOT
            ELSEIF (THICK.GT.XTOP) THEN
               THICK = XTOP
            ENDIF      
            WRITE (LINE,1200) THICK, THICK_D
            CALL GETDM1$(XBOT, THICK, XTOP,
     +                   LINE)
            GOTO 40
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C NUMDEC = 5: Fonts
C
C********** WRITE (HEADER,1300)
            WRITE (OPTION,1400)
            NUMDEC = NFONT
            NUMOPT = N14
            CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                   OPTION)
            IF (NUMDEC.LE.N13) THEN
               NFONT = NUMDEC
C
C NUMDEC = 6: Scale fonts
C
               WRITE (LINE,1500) SIZE_1, SIZE_D
               XBOT = 0.25D+00
               XTOP = 2.50D+00
               IF (SIZE_1.LT.XBOT) THEN
                  SIZE_1 = XBOT
               ELSEIF (SIZE_1.GT.XTOP) THEN
                  SIZE_1 = XTOP
               ENDIF      
               CALL GETDM1$(XBOT, SIZE_1, XTOP, 
     +                      LINE)
            ELSE
               CALL PSSPEC$(N1, N2)
            ENDIF
            GOTO 40
         ELSEIF (NUMDEC.EQ.N6 .OR. NUMDEC.EQ.N7 .OR. NUMDEC.EQ.N8) THEN
C
C NUMDEC = 6, 7, or 8: Check then finally open file as required and return
C

c            IF (NUMDEC.EQ.N7 .OR. NUMDEC.EQ.N8) THEN
C
C Check for ghostscript ... Noisy exit if ABORT then attempt correction
C              
c               CALL WGB2PS_X (N8, N1, 
c     +                        ABORT)
c               IF (ABORT) THEN
c                  CALL X_OKCVAL (N8,
c     +                           ABORT)             
c                  CALL WGB2PS_X (N8, N0, 
c     +                           ABORT)
c                  IF (ABORT) GOTO 40
c               ENDIF    
c            ENDIF   
c            IF (NUMDEC.EQ.N7) THEN
C
C Check for PS driver ... Silent exit if ABORT but change NUMDEC to N8
C              
c                CALL WGB2PS_X (N10, N0,
c     +                         ABORT)
c                IF (ABORT) NUMDEC = N8
c            ENDIF
c            IF (NUMDEC.EQ.N8) THEN
C
C Check for PDF reader ... Noisy exit if ABORT then attempt correction 
C
c               CALL WGB2PS_X (N11, N1,
c     +                        ABORT)
c               IF (ABORT) THEN
c                  CALL WGB2PS_X (N11, N0, 
c     +                           ABORT)
c                  IF (ABORT) GOTO 40
c               ENDIF                                                        
c            ENDIF     
            
            IF (NUMDEC.EQ.N6) THEN
               ACROBAT = .FALSE.
               FILE = .TRUE.
               GSVIEW = .FALSE.
               CALL OFILES$(ISEND, NOUT,
     +                      FNAME,
     +                      ABORT)
               IF (.NOT.ABORT) CALL DOTEPS (FNAME,
     +                                      ABORT)
               IF (ABORT) THEN
                 CLOSE (UNIT = NOUT)
                 GOTO 40
               ENDIF  
            ELSEIF (NUMDEC.EQ.N7) THEN
               ACROBAT = .FALSE.
               FILE = .FALSE.
               GSVIEW = .TRUE.
               CALL X_USRDIR (L,
     +                        USRDIR)               
               FNAME = USRDIR(1:L)//TEMPFILE
               ABORT = .FALSE.
            ELSEIF (NUMDEC.EQ.N8) THEN
               ACROBAT = .TRUE.
               FILE = .FALSE.
               GSVIEW = .FALSE.
               CALL X_USRDIR (L,
     +                        USRDIR)               
               FNAME = USRDIR(1:L)//TEMPFILE
               ABORT = .FALSE.
            ENDIF   
            CLOSE (UNIT = NOUT)
            CALL PSFILE$(NFONT, NOUT,
     +                   SCALE_1, THETA, THICK, XOFF, YOFF,  XCLIP,
     +                   YCLIP, 
     +                   'OPEN', FNAME)
            RETURN
C        
         ELSEIF (NUMDEC.EQ.N9) THEN
C
C NUMDEC = 9: set IFAIL = 1 then return with no action
C
            IFAIL = N1
            RETURN
         ENDIF
C
C PART 4 ...  Close down PS functions
C =====================================================================
C
      ELSE
         CALL PSFILE$(NFONT, NOUT,
     +                SCALE_1, THETA, THICK, XOFF, YOFF, XCLIP,
     +                YCLIP,
     +                'CLOSE', FNAME)
         IF (STRETCH) CALL PS_STRETCH (ISEND,
     +                                 FNAME,
     +                                 ABORT)
         CLOSE (UNIT = NOUT)
         IF (ACROBAT) THEN
C
C Transform tempfile.EPS to tempfile.PDF then pass on to PDF reader
C           
            CALL EPSPDF (FNAME)
         ELSEIF (FILE) THEN  
C
C Save As ... *.EPS then transform if required
C         
            CALL WGBTRN$(FNAME)    
         ELSEIF (GSVIEW) THEN
C
C Pass tempfile.eps on to PS reader
C         
            CALL X_OKCVAL (N10,
     +                     OK)
            IF (OK) THEN
               CALL RUN_GSVIEW (FNAME)
            ELSE
               CALL EPSPDF (FNAME)
            ENDIF      
         ENDIF
      ENDIF  
C
C Format statements
C      
  100 FORMAT (
     + 'The SIMFIT PostScript driver'
     +/
     +/'Orientation         `',A
     +/'Stretch/clip/slide  `',A
     +/'Number of colours   `',I3
     +/'Font type           `',A
     +/'Font size           `',A
     +/'(x,y) scaling       `',A
     +/'Line width          `',A
     +/'x-axis-offset       `',A
     +/'y-axis-offset       `',A
     +/
     +/'[SAVE] means Save As ... *.eps file and make'
     +/'bmp/jpg/pcx/pdf/png/tif/svg files if required.'
     +/
     +/'[EPS] means view source code to see how to change'
     +/'title, legends, symbols, etc., in your text editor'
     +/
     +/'[PDF] means transform into *.pdf then use your'
     +/'PDF-reader to view, print, or Save As ... *.pdf')
  200 FORMAT (
     + 'Rotate'
     +/'X,Y offset'
     +/'Axes scale'
     +/'Line width'
     +/'Font'
     +/'SAVE'
     +/'EPS'
     +/'PDF'
     +/'Quit')
  500 FORMAT (
     + 'Select the orientation required'
     +/
     +/'The extra plus sign (+) also installs the'
     +/'stretch/clip/slide procedure which is useful'
     +/'for stretching crowded plots with overlapping'
     +/'symbols/labels, etc. and to make sub-graphs' 
     +/'by clipping. Note that choosing Landscape'
     +/'format creates rotated graphs.')
  600 FORMAT (
     + 'Portrait'
     +/'Landscape'
     +/'Portrait +'
     +/'Landscape +')
  700 FORMAT (
     +'X-offset ( Left hand margin: Current =',F5.2,
     +                          ',  Default =',F5.2,' inches )')
  800 FORMAT (
     +'Y-offset ( Bottom margin: Current =',F5.2,
     +                       ',  Default =',F5.2,' inches )')
  900 FORMAT (
     +'X-offset ( Left margin BEFORE rotation: Current =',F5.2,
     +                            ',  Default =',F5.2,' inches )')
 1000 FORMAT (
     +'Y-offset ( Bottom margin BEFORE rotation: Current =',F5.2,
     +                            ',  Default =',F5.2,' inches )')
 1100 FORMAT (
     +'Overall plot scaling factor required ( Current =',F5.2,
     +                                    ',  Default =',F5.2,' )')
 1200 FORMAT (
     +'PostScript line width required ( Current =',F5.2,
     +                              ',  Default =',F5.2,' )')
C****1300 FORMAT ('Select a font for the title/legends')
 1400 FORMAT (
     + 'Times-Roman'
     +/'Times-Bold'
     +/'Times-Italic'
     +/'Times-BoldItalic'
     +/'Helvetica'
     +/'Helvetica-Bold'
     +/'Helvetica-Oblique'
     +/'Helvetica-BoldOblique'
     +/'Courier'
     +/'Courier-Bold'
     +/'Courier-Oblique'
     +/'Courier-BoldOblique'
     +/'Symbol'
     +/'Install a PostScript special')
 1500 FORMAT (
     +'Overall font size factor required ( Current =',F5.2,
     +                                 ',  Default =',F5.2,' )')
      END
C  
C
